/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "AddContactViewController.h"
#import "SDKManager.h"
#import "NotificationHelper.h"

@interface AddContactViewController ()

@end

@implementation AddContactViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.saveBtnLabel.attributedTitle];
    titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.saveBtnLabel.attributedTitle = formattedTitle;
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}

- (IBAction)saveBtn:(id)sender {
    
    CSContactService *contactService = nil;
    for (CSUser *user in [SDKManager getInstance].users) {
        
        if (user.contactService) {
            
            contactService = user.contactService;
            break;
        }
    }
    
    CSEditableContact *contact = [contactService createEditableContact];
    
    contact.firstName.fieldValue = self.firstName.stringValue;
    contact.lastName.fieldValue = self.lastName.stringValue;
    
    CSEditableContactEmailAddressField *emailField = [CSEditableContactEmailAddressField new];
    emailField.emailAddressType = CSContactEmailAddressTypeWork;
    emailField.address = self.workEmail.stringValue;
    //[emailField setDefaultEmailAddress: YES];
    [contact.emailAddresses addItem:emailField];
    
    CSEditableContactPhoneField *phoneField = [CSEditableContactPhoneField new];
    phoneField.phoneNumber = self.workNumber.stringValue;
    phoneField.defaultPhoneNumber = YES;
    phoneField.phoneNumberType = CSContactPhoneNumberTypeWork;
    contact.phoneNumbers.values = @[phoneField];
    
    [contactService addContact:contact completionHandler:^(CSContact *contact, BOOL contactWasMerged, NSError *error) {
        
        if (error) {
            
            NSLog(@"%s Error while adding contact. Error code [%ld] - %@", __PRETTY_FUNCTION__, error.code, error.localizedDescription);
            [NotificationHelper displayMessageToUser: [NSString stringWithFormat:@"Error while adding contact. Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG:__PRETTY_FUNCTION__];
        } else {
            
            NSLog(@"%s Contact added successfully, contact [%@]", __PRETTY_FUNCTION__, contact);
            
            [[NSNotificationCenter defaultCenter] postNotificationName:kRefreshContactListNotification object:nil];
        }
    }];
    
    [self dismissController:self];
}
@end
