/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "CallServiceViewController.h"
#import "SDKManager.h"
#import "ActiveCallViewController.h"
#import "NotificationHelper.h"

@interface CallServiceViewController ()

@property (nonatomic, strong) CSCall *currentCall;

@end

@implementation CallServiceViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    for (CSUser *user in [SDKManager getInstance].users) {
        
        if (user.callService) {
            
            self.callService = user.callService;
            self.callFeatureService = user.callFeatureService;
            break;
        }
    }
    
    // Check if video capability is present for currently registered user
    self.makeVideoCallLabel.hidden = !self.callService.videoCapability.allowed;
    
    // Check if voip calling capability is present for currently registered user
    self.makeAudioCallLabel.hidden = !self.callService.voipCallingCapability.allowed;
    
    // Check if Send All Calls feature is configured on the extension
    if ([self.callFeatureService sendAllCallsCapability].allowed) {
        
        self.sendAllCallsLabel.title = self.callFeatureService.sendAllCallsEnabled ? @"ON" : @"OFF";
    } else {
        
        // Send All Calls is not configured for extension
        NSLog(@"%s Send All Calls is not configured for extension", __PRETTY_FUNCTION__);
        self.sendAllCallsLabel.enabled = NO;
    }
}

- (IBAction)sendAllCallsBtn:(id)sender {
    
    if (self.callFeatureService.isSendAllCallsEnabled) {
        
        [self.callFeatureService setSendAllCallsEnabled:NO completionHandler: ^(NSError *error) {
            
            if (error) {
                
                NSLog(@"%s Cannot disable Send All Calls, Error code [%ld] - %@",__PRETTY_FUNCTION__ , (long)error.code, error.localizedDescription);
                [NotificationHelper displayMessageToUser: [NSString stringWithFormat:@"Cannot disable Send All Calls, Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
                self.sendAllCallsLabel.title = @"ON";
            } else {
                
                NSLog(@"%s Successfully disabled Send All Calls", __PRETTY_FUNCTION__);
                self.sendAllCallsLabel.title = @"OFF";
            }
        }];
    } else {
        
        [self.callFeatureService setSendAllCallsEnabled:YES completionHandler: ^(NSError *error) {
            
            if (error) {
                
                NSLog(@"%s Cannot enable Send All Calls, Error code [%ld] - %@",__PRETTY_FUNCTION__ , (long)error.code, error.localizedDescription);
                [NotificationHelper displayMessageToUser: [NSString stringWithFormat:@"Cannot enable Send All Calls, Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
                self.sendAllCallsLabel.title = @"OFF";
            } else {
                
                NSLog(@"%s Successfully enabled Send All Calls", __PRETTY_FUNCTION__);
                self.sendAllCallsLabel.title = @"ON";
            }
        }];
    }
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}

- (void)prepareForSegue:(NSStoryboardSegue *)segue sender:(id)sender {
    
    ActiveCallViewController *transferViewController = segue.destinationController;
    
    if ([segue.identifier isEqualToString:@"audioCallSegue"]) {
        
        [self audioCall];
        NSLog(@"%s Perform Audio call segue", __PRETTY_FUNCTION__);
        NSLog(@"%s currentCall = [%@]", __PRETTY_FUNCTION__, self.currentCall);
        transferViewController.currentCall = self.currentCall;
    } else if ([segue.identifier isEqualToString:@"videoCallSegue"]) {
        
        [self videoCall];
        NSLog(@"%s Perform Video call segue", __PRETTY_FUNCTION__);
        NSLog(@"%s currentCall = [%@]", __PRETTY_FUNCTION__, self.currentCall);
        transferViewController.currentCall = self.currentCall;
    }
}

- (void)audioCall {
    
    NSString *callingNumber = [self.numberToCall stringValue];
    
    NSLog(@"%s- audio calling number: [%@]", __PRETTY_FUNCTION__, callingNumber);
    
    CSCall *call = [self.callService createCall];
    
    call.remoteAddress = callingNumber;
    [call start];
    
    // Save the current call's object for operations
    self.currentCall = call;
    NSLog(@"%s audio call: [%@] currentCall: [%@]", __PRETTY_FUNCTION__, call, self.currentCall);
}

- (void)videoCall {
    
    NSString *callingNumber = [self.numberToCall stringValue];
    NSLog(@"%s- video calling number: %@", __PRETTY_FUNCTION__, callingNumber);
    
    CSCall *call = [self.callService createCall];
    call.remoteAddress = callingNumber;
    
    [[SDKManager getInstance].mediaManager configureVideoForOutgoingCall:call withVideoMode:CSVideoModeSendReceive];
    
    [call start];
    
    // Save the current call's object for operations
    self.currentCall = call;
    NSLog(@"%s video call: [%@] currentCall: [%@]", __PRETTY_FUNCTION__, call, self.currentCall);
}

@end
