/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "ConferenceControlViewController.h"
#import "NotificationHelper.h"

@interface ConferenceControlViewController ()

@end

@implementation ConferenceControlViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    // Update button label as per status of conference
    self.lockMeetingBtnLabel.title = self.conferenceCall.isLocked ? @"Unlock Meeting" : @"Lock Meeting";
    
    // Update UI as per capability
    self.lockMeetingBtnLabel.enabled = self.conferenceCall.updateLockCapability.allowed;
    self.muteAllBtnLabel.enabled = self.conferenceCall.muteAllParticipantsCapability.allowed;
    self.unMuteAllBtnLabel.enabled = self.conferenceCall.unmuteAllParticipantsCapability.allowed;
}

- (IBAction)lockMeetingBtn:(id)sender {
    
    if (self.conferenceCall.isLocked) {
        
        [self.conferenceCall setLocked:NO completionHandler:^(NSError *error) {
            
            if (error) {
                
                [NotificationHelper displayMessageToUser:[NSString stringWithFormat:@"Error while unlocking confernce, Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
            } else {
                
                NSLog(@"%s Conference unlocked successfully", __PRETTY_FUNCTION__);
                self.lockMeetingBtnLabel.title = @"Lock Meeting";
            }
        }];
    } else {
        
        [self.conferenceCall setLocked:YES completionHandler:^(NSError *error) {
            
            if (error) {
                
                [NotificationHelper displayMessageToUser:[NSString stringWithFormat:@"Error while locking confernce, Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
            } else {
                
                NSLog(@"%s Conference Locked successfully", __PRETTY_FUNCTION__);
                self.lockMeetingBtnLabel.title = @"Unlock Meeting";
            }
        }];
    }
    
    [self dismissController:self];
}

- (IBAction)muteAllBtn:(id)sender {
    
    [self.conferenceCall muteAllParticipantsWithCompletionHandler:^(NSError *error) {
        
        if (error) {
            
            [NotificationHelper displayMessageToUser:[NSString stringWithFormat:@"Error while muting Audio of the conference, Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
        } else {
            
            NSLog(@"%s All participants muted", __PRETTY_FUNCTION__);
        }
    }];
    
    [self dismissController:self];
}

- (IBAction)unMuteAllBtn:(id)sender {
    
    [self.conferenceCall unmuteAllParticipantsWithCompletionHandler:^(NSError *error) {
        
        if (error) {
            
            [NotificationHelper displayMessageToUser:[NSString stringWithFormat:@"Error while unmuting Audio of the conference, Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
        } else {
            
            NSLog(@"%s All participants unmuted", __PRETTY_FUNCTION__);
        }
    }];
    
    [self dismissController:self];
}

@end
