//
//  CSScreenCapturerOSX.h
//  scpmedia
//
//  Created by David McGarry on 3/28/16.
//  Copyright (c) 2016 Avaya. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CSVideoCommon.h"

extern NSString* const CSScreenCapturerErrorDomain;

@interface CSScreenCapturerOSX : NSObject <CSVideoSource>

@property (atomic, strong) id<CSVideoSink> videoSink;
@property (atomic, strong) id<CSVideoSink> localVideoSink;

@property (nonatomic, assign) uint32_t frameRate;
@property (nonatomic, assign) CGRect captureRect;

/**
 * Sets the list of process identifiers for capturing windows.
 * @param pids The list of process identifiers.
 * @param count The number of process identifiers in the list. Passing a count
 *				of zero implies capturing windows of all processes.
 */
- (void) setCapturePIDs:(const pid_t*)pids count:(size_t)count;

- (NSError*) startCapturing;
- (NSError*) stopCapturing;

@end
