/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>
#import "CSFeatureStatusParameters.h"

/**
 * This class represents the details about the crisis alert raised in the system.
 * @see CSCallFeatureService::crisisAlert
 * @see CSCallFeatureServiceDelegate::callFeatureService:didChangeCrisisAlertStatus:
 */
@interface CSCrisisAlert : NSObject

/**
 * The feature type associated with the crisis alert.
 */
@property (nonatomic, readonly) CSFeatureType featureType;

/**
 * The status of the feature (on or off).
 */
@property (nonatomic, readonly) CSFeatureStatus status;

/**
 * Represents name of the user who initiated the crisis alert.
 */
@property (nonatomic, readonly) NSString *userName;

/**
 * Represents extension of the user who initiated the crisis alert.
 */
@property (nonatomic, readonly) NSString *userExtension;

/**
 * Represents date and time when the crisis alert is raised.
 */
@property (nonatomic, readonly) NSDate *startDateTime;

/**
 * Represents location of the user who initiated the crisis alert.
 */
@property (nonatomic, readonly) NSString *userLocation;

/**
 * Represents room of the user who initiated the crisis alert.
 */
@property (nonatomic, readonly) NSString *userRoom;

/**
 * Represents floor of the user who initiated the crisis alert.
 */
@property (nonatomic, readonly) NSString *userFloor;

/**
 * Represents building of the user who initiated the crisis alert.
 */
@property (nonatomic, readonly) NSString *userBuilding;

@end
