/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>
#import <QuartzCore/QuartzCore.h>
#import <AppKit/AppKit.h>
#import "CSSlide.h"
#import "CSView.h"

@class CSSharingBlock;

#if MAC_OS_X_VERSION_MAX_ALLOWED >= 101200
@interface CSPresentationSlidesListener  : NSObject <CALayerDelegate, CSSlideDelegate>
#else
@interface CSPresentationSlidesListener  : NSObject <CSSlideDelegate>
#endif

@property (nonatomic, strong) CALayer *drawingLayer;

/**
 * A view, that a drawingLayer is assigned as content.
 * Here, it's used to apply any sharing screen viewport size changes
 */
@property (nonatomic, strong) CSView *drawingView;

/**
 * Implementation of informal CALayer drawing protocol. It puts content on layer.
 * It is called, when needsDisplay is set on CALayer that this class' object is delegate of
 */
- (void)displayLayer:(CALayer *)layer;

/**
 * Puts a slide received frow WCS on a Layer
 */
- (void)drawSlideOnLayer:(CSSharingBlock *)bitmapBlock;

/**
 * Init object with some default frame
 */
- (instancetype)initWithFrame:(CGRect)frame NS_DESIGNATED_INITIALIZER;

/**
 *
 */
- (void)receiveData:(CSRenderingBlock *)data withError:(NSError *)error;

/**
 * After finished presentation sharing use this method to clear the canvas
 */
- (void)clearLayer;

@end
