/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import <Cocoa/Cocoa.h>
#import <AvayaClientServices/AvayaClientServices.h>
#import "MediaManager.h"
#import "ContentSharingViewController.h"

@interface ActiveCallViewController : NSViewController <NSTextFieldDelegate>

@property (nonatomic, weak) IBOutlet NSTextField *callDuration;
@property (nonatomic, weak) IBOutlet NSTextField *callState;
@property (nonatomic, weak) IBOutlet NSTextField *dtmf;
@property (nonatomic, weak) IBOutlet NSTextField *participantList;
@property (nonatomic, weak) IBOutlet NSButton *mute;
@property (nonatomic, weak) IBOutlet NSView *remoteVideoView;
@property (nonatomic, weak) IBOutlet NSView *localVideoView;
@property (nonatomic, weak) IBOutlet NSTextField *remoteVideoLabel;
@property (nonatomic, weak) IBOutlet NSTextField *localVideoLabel;
@property (nonatomic, weak) IBOutlet NSButton *conferenceControlBtn;
@property (nonatomic, weak) IBOutlet NSButton *shareDesktopBtnLabel;
@property (nonatomic, weak) IBOutlet NSButton *collaborationBtnLabel;

- (IBAction)endCallBtn:(id)sender;
- (IBAction)muteCallBtn:(id)sender;
- (IBAction)shareDesktopBtn:(id)sender;
- (IBAction)collaborationBtn:(id)sender;

@property (nonatomic, weak) CSCall *currentCall;

@end
