/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "MessagingServiceConversationMediaOperationViewController.h"
#import "NotificationHelper.h"
#import "SDKManager.h"

@interface MessagingServiceConversationMediaOperationViewController ()

@property (nonatomic, weak) NSURL *saveLocation;

@end

@implementation MessagingServiceConversationMediaOperationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.downloadBtnLabel.attributedTitle];
    titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.downloadBtnLabel.attributedTitle = formattedTitle;
    
    NSLog(@"%s Selected attachment: [%@]", __PRETTY_FUNCTION__, self.selectedAttachment);
    
    // Set delegate for the attachment to get status change updates
    self.selectedAttachment.delegate = [SDKManager getInstance].messagingServiceManager;
    
    NSString *status = @"";
    
    switch (self.selectedAttachment.status) {
        case CSMessagingAttachmentStatusDraft:
            status = @"Draft";
            break;
        case CSMessagingAttachmentStatusOpened:
            status = @"Opened";
            break;
        case CSMessagingAttachmentStatusSending:
            status = @"Sending";
            break;
        case CSMessagingAttachmentStatusDraftError:
            status = @"DraftError";
            break;
        case CSMessagingAttachmentStatusDownloading:
            status = @"Downloading";
            break;
        case CSMessagingAttachmentStatusReadyToOpen:
            status = @"ReadyToOpen";
            break;
        case CSMessagingAttachmentStatusReadyToDownload:
            status = @"ReadyToDownload";
            break;
        case CSMessagingAttachmentStatusDraftRemoving:
            status = @"DraftRemoving";
            break;
        default:
            break;
    }
    
    self.attachmentStatus.stringValue = status;
    
    self.downloadBtnLabel.enabled = self.selectedAttachment.downloadCapability.allowed;
}

- (void)viewWillDisappear {
    [super viewWillDisappear];
    
    // Remove delegate for the attachment status change updates
    self.selectedAttachment.delegate = nil;
}

- (IBAction)downloadBtn:(id)sender {
    
    NSSavePanel *saveDialog = [NSSavePanel savePanel];
    saveDialog.nameFieldStringValue = self.selectedAttachment.name;
    
    // Display the dialog. If OK is pressed process the files
    [saveDialog beginWithCompletionHandler:^(NSInteger result) {
        
        if (result == NSFileHandlingPanelOKButton) {
            
            self.saveLocation = saveDialog.URL;
            NSLog(@"%s saveLocation: [%@]", __PRETTY_FUNCTION__, self.saveLocation.path);
            [self.selectedAttachment download:self.saveLocation.path completionHandler:^(NSError *error) {
                
                if (error) {
                    
                    NSLog(@"%s Error while downloading attachment. Error [%ld] - %@", __PRETTY_FUNCTION__, (long)error.code, error.localizedDescription);
                    [NotificationHelper displayMessageToUser: [NSString stringWithFormat:@"Error while downloading attachment. Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
                } else {
                    
                    NSLog(@"%s Successfully downloaded attachment", __PRETTY_FUNCTION__);
                    [NotificationHelper displayMessageToUser:@"Successfully saved the file" TAG: __PRETTY_FUNCTION__];
                }
            }];
        }
    }];
    
    [self dismissController:self];
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}
@end
