/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "NotificationHelper.h"
#import "AppDelegate.h"

@implementation NotificationHelper

+ (void) displayMessageToUser: (NSString *) msg TAG:(const char[])tag {
    
    NSLog(@"%s ATTENTION: %@", tag, msg);
    
    NSAlert *alert = [[NSAlert alloc] init];
    
    // Display an Alert dialog
    [alert addButtonWithTitle:@"OK"];
    alert.messageText = @"Attention";
    alert.informativeText = msg;
    alert.alertStyle = NSWarningAlertStyle;
    
    [alert runModal];
}

+ (void) displayToastToUser: (NSString *) msg {
    
    NSLog(@"Toast: %@", msg);
    
    // Display in Notification center
    NSUserNotification *notification = [[NSUserNotification alloc] init];
    notification.title = @"Attention";
    notification.informativeText = msg;
    notification.deliveryDate = [NSDate date];
    notification.soundName = NSUserNotificationDefaultSoundName;
    
    NSUserNotificationCenter *center = [NSUserNotificationCenter defaultUserNotificationCenter];
    [center scheduleNotification:notification];
}

@end
