//
//  CSVideoCapturerOSX.h
//  scpmedia
//
//  Created by David McGarry on 2/1/16.
//  Copyright (c) 2016 Avaya. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

#import "CSVideoCommon.h"
#import "CSVideoCaptureDevice.h"
#import "CSVideoCaptureFormat.h"
#import "CSVirtualBackgroundListener.h"

extern NSString* const CSVideoCapturerErrorDomain;

typedef NS_ENUM(NSInteger, CSVideoCapturerErrorCode)
{
	CSVideoCapturerErrorCode_RuntimeError = 1,
	CSVideoCapturerErrorCode_DeviceNotFound,
	CSVideoCapturerErrorCode_DeviceInUse,
	CSVideoCapturerErrorCode_FormatNotFound,
	CSVideoCapturerErrorCode_UnknownError,
	CSVideoCapturerErrorCode_UnsupportedInput,
	CSVideoCapturerErrorCode_UnsupportedOutput,
	CSVideoCapturerErrorCode_ApplicationIsNotAuthorizedToUseDevice,
};

typedef NS_ENUM(NSInteger, CSVirtualBackgroundFileLoadResult)
{
	/**
	 * The file was fully processed
	 */
	CSVirtualBackgroundFileLoadResult_Success,
	/**
	 * File is continuous and will be processed further, however a error in the file can be encountered
	 */
	CSVirtualBackgroundFileLoadResult_Processing,
	/**
	 * Error happened and the file isn't going to be processed further
	 */
	CSVirtualBackgroundFileLoadResult_ErrorUnknown,
};

typedef NS_ENUM(NSInteger, CSVirtualBackgroundMode)
{
    CSVirtualBackgroundMode_Off,
    CSVirtualBackgroundMode_Blur,
    CSVirtualBackgroundMode_Image,
};

typedef NS_ENUM(NSInteger, CSVirtualBackgroundLoadFileResult)
{
    CSVirtualBackgroundLoadFileResultSuccess,
    CSVirtualBackgroundLoadFileResultErrorUnknown
};

@protocol CSVideoCapturerDelegate <NSObject>

- (void) videoCapturerRuntimeError:(NSError *)error;

@end


@interface CSVideoCapturerOSX : NSObject <CSVideoSource>

@property (atomic, strong) id<CSVideoSink> videoSink;
@property (atomic, strong) id<CSVideoSink> localVideoSink;
@property (nonatomic, weak) id<CSVideoCapturerDelegate> delegate;

/**
 * NSArray containing instances of CSVideoCaptureDevice.
 * This property is observable and will be updated when
 * a video capture device is either connected or disconnected.
 */
@property (nonatomic, readonly) NSArray* availableDevices;

- (void) openVideoCaptureDevice:(CSVideoCaptureDevice*)videoCaptureDevice
					 withFormat:(CSVideoCaptureFormat*)videoCaptureFormat
				 withCompletion:(void (^)(NSError* error))completion;
- (void) closeVideoCaptureDeviceWithCompletion:(dispatch_block_t)completion;
- (BOOL) isVirtualBackgroundSupported;

- (BOOL) setVirtualBackgroundMode:(CSVirtualBackgroundMode)mode;
- (CSVirtualBackgroundMode) getVirtualBackgroundMode;

- (BOOL) setVirtualBackgroundBlurSize:(NSUInteger)size;
- (NSUInteger) getVirtualBackgroundBlurSize;

- (void) virtualBackgroundLoadFile: (NSString*)path
                    withCompletion: (void (^)(CSVirtualBackgroundFileLoadResult result))completion;

@property (atomic, strong) id<CSVirtualBackgroundListener> virtualBackgroundListener;

@end
