/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "AboutViewController.h"
#import "SDKManager.h"

@interface AboutViewController ()

@end

@implementation AboutViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    self.appVersionLabel.stringValue = [NSString stringWithFormat:@"%@ Build %@", [SDKManager applicationVersion], [SDKManager applicationBuildNumber]];
    self.appBuildDateLabel.stringValue = [SDKManager applicationBuildDate];
    self.sdkVersionLabel.stringValue = [CSClient versionString];
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}
@end
