/* Copyright Avaya LLC. */

#import <Cocoa/Cocoa.h>
#import "CSScreenSharingView.h"

/**
 * CSOSXScreenSharingView subclasses NSScrollView and provides scrolling
 * behavior for screen sharing content displayed on CSScreenSharingView.
 * In case received content is smaller then size of CSOSXScreenSharingView 
 * displayed content is placed in center of CSOSXScreenSharingView.
 */
@interface CSOSXScreenSharingView : NSScrollView

/**
 * CSScreenSharingView object responsible for displaying received sharing content.
 */
@property (strong, readonly) CSScreenSharingView *renderingCanvas;

/**
 * CSScreenSharingListener object used by renderingCanvas and can be set using 
 * this method instead of setter for property contentSharingDelegate of renderingCanvas.
 *
 * @param delegate CSScreenSharingListener object to be set for renderingCanvas
 *
 * @see CSScreenSharingView::contentSharingDelegate
 * @see CSContentSharingDelegate
 */
- (void)setContentSharingDelegate:(CSScreenSharingListener *)delegate;

@end
