/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

#if __has_warning("-Wobjc-property-assign-on-object-type")
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wobjc-property-assign-on-object-type"
#import <AvayaClientMedia/CSLayer2PriorityMarking.h>
#pragma clang diagnostic pop
#else
#import <AvayaClientMedia/CSLayer2PriorityMarking.h>
#endif

/**
 * Data that is common for a SIP Client
 *
 */
@interface CSSIPClientConfiguration : NSObject

/**
 * The layer 3 Differentiated Services (DiffServ) Code Point for signaling frames generated by the endpoint.
 *
 * Default is 24 - Class Selector 3 (CS3)
 *
 */
@property (nonatomic, assign) NSUInteger signalingDSCP;

/**
 * Default registration timeout (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger registrationTimeout;

/**
 * Default subscription timeout (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger subscriptionTimeout;

/**
 * Default publish timeout (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger publishTimeout;

/**
 * Default session refresh time (in seconds)
 * It is not recommended to enable this feature in Avaya (Aura, IPO) deployment.
 * If session refresh is enabled, active call might be ended automatically without media preservation in case session expires due to refresh failure.
 * Default value 0 means Session Timer is disabled.
 * Session refresh timeout have to be equal or more than 90 seconds. Otherwise user creation will be failed.
 *
 */
@property (nonatomic, assign) NSUInteger sessionRefreshTimeout;

/**
 * Max forward limit indicated in Max-Forward SIP header
 *
 */
@property (nonatomic, assign) NSUInteger maxForwardLimit;

/**
 * Default time to re-transmit 180 Ringing while in alerting state (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger periodicRingbackTimeout;

/**
 * Maximum default time that an incoming session stays in alerting state (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger totalRingbackTimeout;

/**
 * Maximum wait time for completion of call cancellation (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger waitTimeForCallCancel;

/**
 * Maximum wait time for completion of call transfer with 200 OK sipfrag notify
 * after REFER is accepted (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger transferCompletionTimeout;

/**
 * Local video response timeout (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger localVideoResponseTimeout;

/**
 * Line reservation time during which line stays reserved (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger lineReservationTimeout;

/**
 * How long to wait for a provisional response on INVITE requests (in seconds)
 *
 */
@property (nonatomic, assign) NSUInteger fastResponseTimeout;

/**
 * Controls whether the codec selection on the answerer side is done based on the codec preferences of
 * the calling UA or the answering UA. By default, a common codec is selected based on the preferences of the
 * calling UA.
 *
 */
@property (nonatomic, assign) BOOL selectCodecBasedOnCallerPreferences;

/**
 * <p>Controls whether coupling of SIPS and SRTP is enabled.</p>
 *
 * The SIPS mechanism is used to secure the signaling, while SRTP is used to secure the media.
 *
 * If enabled...
 *  - Do not offer secure media (SRTP) for a SIP URI request over TLS.
 *    For example, once we learn that the far-end is a SIP contact address (not SIPS), we would provide
 *    an offer with clear RTP only for mid-call operations (even though TLS is being used). This allows
 *    us to get around an existing CM issue (to have clients work correctly in CM SRTP environment).
 *    The CM issue will be addressed in the 7.0 timeframe.
 *
 * If disabled...
 *  - Follow Refarch recommendations to allow best effort media security for a SIP URI request over TLS.
 *    For details see Refarch section 15.4.1.1.6.
 *
 * @deprecated Use CSSIPUserConfiguration::useSIPSURIOverTLS property instead. Starting with Client SDK 3.1.
 */
@property (nonatomic, assign, getter=isSIPSAndSRTPCouplingEnabled) BOOL SIPSAndSRTPCouplingEnabled DEPRECATED_ATTRIBUTE;

/**
 * <p>Enable or disable support for reliable provisional responses (defined in RFC 3262).</p>
 *
 * If enabled...
 *  - Outgoing requests support reliable provisional responses. This gives the far-end the
 *    option of using reliable provisional responses if desired, and we handle these responses
 *    per RFC 3262.
 *  - Provisional responses to an incoming request are sent reliably, if supported (or required)
 *    by the request. We expect the far-end to handle our reliable provisional responses per RFC 3262.
 *
 * If disabled...
 *  - Outgoing requests will not support reliable provisional responses.
 *      - If the far-end requires reliable provisional responses they should reject our request with a
 *        420 (Bad Extension) and include an Unsupported header field containing the 100rel tag.
 *  - Provisional responses to an incoming request are not sent reliably, regardless if supported by
 *    the request.
 *  - If an incoming request requires reliable provisional responses we reject the request with a 420
 *    (Bad Extension) and include an Unsupported header field containing the 100rel tag.
 *
 * Background:
 *  - A request that supports reliable provisional responses will include the 100rel tag in the Supported
 *    header.
 *  - A request that requires reliable provisional responses will include the 100rel tag in the Require
 *    header.
 *  - A reliable provisional response (or provisional response sent reliably) will include the 100rel tag
 *    in the Require header.
 *      - A 100 Trying provisional response is never sent reliably.
 *
 */
@property (nonatomic, assign, getter=isReliableProvisionalResponsesEnabled) BOOL reliableProvisionalResponsesEnabled;


/**
 *  The number of seconds that the telephone will
 *  wait  after a digit is dialed before sending a SIP INVITE.
 *  Valid values are 1 through 10 seconds; the default value is 5 seconds.
 */
@property (nonatomic, assign) NSUInteger interDigitTimeout;

/**
 * The number of seconds that the telephone will
 * wait for a digit to be dialed after going off-hook before generating a warning
 * tone.
 * Valid values are 1 through 60 seconds; the default value is 99 seconds.
 */
@property (nonatomic, assign) NSUInteger noDigitTimeout;

/**
 * Used for SIP domain comparison.
 *
 * In case Avaya Aura servers have deployed a non split horizon DNS, the small difference in domain names of caller and user can be observed:
 * Ex.: 123456\@sbc.avaya.com and 654321\@avaya.com.
 * To support cases where split-horizon DNS is not being used and cases when SM hosted at other domains than SBC, this new setting is used to control how SIP domain names will be compared.
 * When this property is set to false, the comparison of different domains is considered to be a match when one of the domains is the root domain of the other.
 * For example, userid\@domain.com and userid\@sbc.domain.com are considered to be matching domains even though the exact string comparison is not a match.
 * The default value is true (the exact SIP domain comparison is enabled)
 */
@property (nonatomic, assign) BOOL useExactSIPDomainComparison;

/**
 * The number of seconds the session line appearance will be displayed
 * after an invalid extension has been dialed if the user does not press the End Call softkey.
 * Valid values are 5 through 99; the default value is 15.
 */
@property (nonatomic, assign) NSUInteger failedSessionRemovalTimeout;

@end
