/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

/**
 * Statistics data resource type.
 */
typedef NS_ENUM(NSUInteger, CSStatisticsDataResourceType) {
	CSStatisticsDataResourceTypeUndefined,

	/**
	 * Provides agents with their own statistics or statistics about the skills the agent logs in to.
	 * For example, the total number of calls that an agent has answered since login, the average
	 * time that the agent has spent on ACD calls, the number of agents available to receive calls
	 * for a skill, and the percent of calls within the acceptable service levels.
	 */
	CSStatisticsDataResourceTypeAgent,

	/**
	 * Provides supervisors with statistics about agents or the skills that the agents log in to.
	 * For example, the number of ACD calls answered by specific agent, the average ACD talk time,
	 * auxiliary work mode time by reason code for an agent, the average talk time for ACD calls for
	 * a specific agent during the administered period and the number of staffed agents currently
	 * available to receive ACD calls for a specific skill.
	 */
	CSStatisticsDataResourceTypeAgentExtension,

	/**
	 * Provides statistics about a specific skill. For example, skill description and performance
	 * information, such as Average Speed of Answer (ASA), number of calls in a queue, and number of
	 * calls abandoned. It can also provide the acceptable service levels or percent of calls answered within
	 * the acceptable service levels for a skill.
	 */
	CSStatisticsDataResourceTypeSkill,

	/**
	 * Provides statistics about a specific trunk group. For example, trunk group name and number,
	 * the average holding time for an incoming or outgoing trunk calls, the number of trunks in a
	 * specified trunk group and the percent of time all the trunks in a specified trunk group were
	 * busy during a specified period/day.
	 */
	CSStatisticsDataResourceTypeTrunkGroup,

	/**
	 * Provides statistics about a specific Vector Directory Number (VDN). For example, VDN name
	 * and extension, the total time agents spent talking on skill calls and direct agent calls,
	 * the number of calls that have encountered a VDN, but have not been answered, abandoned, or
	 * outflowed and the time the oldest call has been waiting in the VDN.
	 */
	CSStatisticsDataResourceTypeVectorDirectoryNumber
};

/**
 * Represents VuStats statistics data gathered from the server.
 */
@interface CSStatisticsData : NSObject

/**
 * Represents the VuStats feature button number on the application.
 */
@property (nonatomic, readonly) NSInteger buttonNumber;
/**
 * Indicates the display format number associated with the VuStats button.
 * An administrator can create up to 50 different display formats on CM for VuStats.
 */
@property (nonatomic, readonly) NSInteger formatNumber;
/**
 * Indicates whether any view statistics threshold has been reached.
 */
@property (nonatomic, readonly, getter=isThresholdReached) BOOL thresholdReached;
/**
 * Indicates if the server is set up to provide periodical updates automatically for this entity.
 * The corresponding button should be displayed in Active state.
 */
@property (nonatomic, readonly, getter=isStatusMonitoringActive) BOOL statusMonitoringActive;
/**
 * Represents the statistics data to display on the application.
 */
@property (nonatomic, readonly) NSString *displayText;
/**
 * Represents the resource type that is associated with the view statistics button.
 */
@property (nonatomic, readonly) CSStatisticsDataResourceType resourceType;
/**
 * Represents the resource id associated with the button. It can be a skill (1-8000),
 * a trunk (1 - 2000), a VDN or an agent id (extension).
 */
@property (nonatomic, readonly) NSString *resourceId;

@end
