/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "ContentSharingViewController.h"
#import "SDKManager.h"

@interface ContentSharingViewController()

@property (nonatomic, strong) CSScreenSharingListener *screenSharingListener;

@end

@implementation ContentSharingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    NSLog(@"%s contentSharing object received: [%@]", __PRETTY_FUNCTION__, self.contentSharing);
    
    [self setupContentSharing];
}

- (void)dealloc {
    
    self.contentSharing.delegate = nil;
}

- (void) setupContentSharing {
    
    if (self.sharingView) {
        
        self.sharingView = [[CSScreenSharingView alloc] initWithFrame:self.contentSharing.sharingFrame];
        self.screenSharingListener= [[CSScreenSharingListener alloc] initWithFrame:self.contentSharing.sharingFrame];
        self.contentSharing.screenSharingListener = self.screenSharingListener;
        [self.sharingView setContentSharingDelegate:self.screenSharingListener];
        self.contentSharing.delegate = (id<CSContentSharingDelegate>)[SDKManager getInstance];
        self.sharingView.wantsLayer = YES;
        [self.sharingView display];
        self.sharingView.pauseImage = [NSImage imageNamed:@"pause_icon.png"];
        
        [self.view addSubview:self.scrollView];
        self.scrollView.contentView.bounds = self.sharingView.frame;
        [self.scrollView.documentView addSubview:self.sharingView];
        self.scrollView.scrollerStyle = NSScrollerStyleLegacy;
    }
}

@end
