/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import "MessagingServiceCreateConversationViewController.h"
#import "MessagingServiceConversationViewController.h"
#import "SDKManager.h"
#import "NotificationHelper.h"

@interface MessagingServiceCreateConversationViewController ()

@end

@implementation MessagingServiceCreateConversationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // Change window background to white
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    
    NSColor *color = [NSColor blueColor];
    NSMutableAttributedString *formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.backBtnLabel.attributedTitle];
    NSRange titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.backBtnLabel.attributedTitle = formattedTitle;
    
    formattedTitle = [[NSMutableAttributedString alloc] initWithAttributedString:self.createConversationLabel.attributedTitle];
    titleRange = NSMakeRange(0,formattedTitle.length);
    [formattedTitle addAttribute:NSForegroundColorAttributeName value:color range:titleRange];
    self.createConversationLabel.attributedTitle = formattedTitle;
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(openConversation:) name:kOpenConversationNotification object:nil];
    
    self.createConversationLabel.enabled = [[[[SDKManager getInstance] users].firstObject messagingService] createConversationCapability].allowed;
}

- (void) dealloc {
    
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kOpenConversationNotification object:nil];
}

- (IBAction)backBtn:(id)sender {
    
    [self dismissController:self];
}

- (IBAction)createConversationBtn:(id)sender {
    
    CSMessagingConversation *conversation = [[[[SDKManager getInstance] users].firstObject messagingService] createConversation];
    NSLog(@"%s createdConversation: [%@]", __PRETTY_FUNCTION__, conversation);
    
    CSMessagingConversation *msg = conversation;
    [conversation addParticipantAddresses:[NSArray arrayWithObject:self.contactName.stringValue] completionHandler:^(NSArray *participants, NSError *error) {
        
        if (error) {
            
            NSLog(@"%s Error while creating conversation. Error [%ld] - %@", __PRETTY_FUNCTION__, (long)error.code, error.localizedDescription);
            [NotificationHelper displayMessageToUser: [NSString stringWithFormat:@" Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
        } else {
            
            NSLog(@"%s Successfully created conversation", __PRETTY_FUNCTION__);
            [msg startWithCompletionHandler:^(NSError *error) {
                
                if (error) {
                    
                    NSLog(@"%s Error while starting conversation. Error [%ld] - %@", __PRETTY_FUNCTION__, (long)error.code, error.localizedDescription);
                    [NotificationHelper displayMessageToUser: [NSString stringWithFormat:@" Error code [%ld] - %@", (long)error.code, error.localizedDescription] TAG: __PRETTY_FUNCTION__];
                } else {
                    
                    NSLog(@"%s Successfully started conversation", __PRETTY_FUNCTION__);
                    self.createdConversation = msg;
                    [[NSNotificationCenter defaultCenter] postNotificationName:kRefreshConversationListNotification object:nil];
                    [[NSNotificationCenter defaultCenter] postNotificationName:kOpenConversationNotification object:nil];
                }
            }];
        }
    }];
}


- (void)openConversation:(NSNotification *)notification {
    
    NSLog(@"%s", __PRETTY_FUNCTION__);
    
    NSStoryboard *mainStoryBoard = [NSStoryboard storyboardWithName:@"Main" bundle:nil];
    MessagingServiceConversationViewController *vc = (MessagingServiceConversationViewController *)[mainStoryBoard instantiateControllerWithIdentifier:@"ConversationDetailsScreen"];
    vc.selectedConversation = self.createdConversation;
    [self presentViewControllerAsSheet:vc];
}

@end
