/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import <Foundation/Foundation.h>
#import <AvayaClientServices/AvayaClientServices.h>
#import "Constants.h"

@interface MessagingServiceManager : NSObject
<CSMessagingAttachmentDelegate,
CSMessageDelegate,
CSMessagingConversationDelegate,
CSMessagingComposingParticipantsWatcherDelegate,
CSMessagingServiceDelegate,
CSDataRetrievalWatcherDelegate>

- (instancetype)init __unavailable;
- (instancetype)initWithUser:(CSUser *)user;

@property (nonatomic, readonly) CSDataRetrievalWatcher *conversationsWatcher;
@property (nonatomic, strong) NSMutableDictionary *messages;
@property (nonatomic, strong) NSMutableDictionary *conversations;

- (CSDataRetrievalWatcher *)messagesWatcherForConversationId:(NSString *)conversationId;
- (void)addMessageObject:(CSMessage *)message;
- (void)addConversationObject:(CSMessagingConversation *)conversation;
- (void)removeMessageObject:(CSMessage *)object;
- (void)removeConversationObject:(CSMessagingConversation *)object;

@end
