/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#import <Foundation/Foundation.h>
#import <AvayaClientServices/AvayaClientServices.h>
#import "MediaManager.h"
#import "Constants.h"

@interface SDKManager : NSObject

@property (nonatomic, strong) CSClient *client;

@property (nonatomic, strong) CSUser *user;
@property (nonatomic, readonly) CSCall *activeCall;
@property (nonatomic, strong) CSDataRetrievalWatcher *contactsRetrievalWatcher;

@property (nonatomic, strong) MediaManager *mediaManager;

+ (instancetype)getInstance;
- (void)setupClient;

+ (NSString *)applicationVersion;
+ (NSString *)applicationBuildDate;
+ (NSString *)applicationBuildNumber;

@end
