/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/

#ifndef clientsdk_CSVirtualBackgroundListener_h
#define clientsdk_CSVirtualBackgroundListener_h
#import <Foundation/Foundation.h>

/**
 * Virtual Background fail reasons
 */
typedef NS_ENUM(NSInteger, CSVirtualBackgroundFailReason)
{
    CSVirtualBackgroundFailReasonUnknown
};

/**
 * Audio Tones playable by the CSAudioFilePlayer.
 * Resources for these tones must be available at CSVoIPConfigurationAudio toneFilePath.
 */
typedef NS_ENUM(NSInteger, CSVirtualBackgroundPerformance)
{
    CSVirtualBackgroundPerformanceSlow,
    CSVirtualBackgroundPerformanceBad
};

/**
 * Background replacement notification mechanism
 */
@protocol CSVirtualBackgroundListener

/**
 * Notifies that something went wrong
 */
- (void)onFailed:(CSVirtualBackgroundFailReason)reason;

/**
 * Notifies that camera blur low performance is detected
 */
- (void)onVirtualBackgroundPerformance:(CSVirtualBackgroundPerformance)performance;

/**
 * Notifies about appearing or disappering a person
 * @param isPersonPresent indicated whether a person is present
 */
- (void)onPersonDetected:(BOOL)isPersonPresent;

@end


#endif // clientsdk_CSVirtualBackgroundListener_h
