/* Copyright Avaya LLC. */

#import <Foundation/Foundation.h>

/**
 * CSSharingApplicationWindow object provides set of information about window
 * which can be shared using CSContentSharing::startSharingApplicationWindowWithWindow:completionHandler.
 *
 * @see CSContentSharing::startSharingApplicationWindowWithWindow:completionHandler
 */
@interface CSSharingApplicationWindow : NSObject

/**
 * Enum indicating state of the shared application window.
 * Used by contentSharing:didChangeApplicationWindowState:.
 *
 * @see CSContentSharingDelegate::contentSharing:didChangeApplicationWindowState:
 */
typedef NS_ENUM(NSInteger, CSSharingApplicationWindowState) {
	CSSharingApplicationWindowStateUnknown, /**< State of the window is unknown. */
	CSSharingApplicationWindowStateMinimized, /**< Window is minimized. Sharing is paused internally by Client SDK while in this state. */
	CSSharingApplicationWindowStateRestored, /**< Window is restored (state of the window after minimization). No action on Client SDK side. */
	CSSharingApplicationWindowStateDestroyed /**< Window is destroyed (e.g. window was closed or application was terminated). Sharing is paused internally by Client SDK while in this state. */
};

/**
 * Unique ID associated with the application window
 */
@property (nonatomic, readonly) NSUInteger winId;

/**
 * Title of the window.
 */
@property (nonatomic, readonly) NSString *title;

/**
 * Full title of the application associated with the window.
 */
@property (nonatomic, readonly) NSString *fullTitle;

/**
 * Name of the application associated with the window.
 */
@property (nonatomic, readonly) NSString *applicationName;

/**
 * Icon of the application associated with the window.
 * Can be nil in case when window is closed between retrieving window id and retrieving 
 * window icon from system.
 */
@property (nonatomic, readonly) NSImage *windowIcon;

@end
