﻿/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/
using System;
using System.Collections.Generic;
using System.Linq;
using Avaya.ClientServices;

namespace CommunicationSampleApp.Classes
{
    class CallLogManager
    {
        public static CallLogService CallLogServiceInstance;
        public static CallLogOperationStatusArgs CallLogStatus;
        public static IEnumerable<CallLogItem> CallLogItem;
        public static CallLogManager CallLogManagerInstance;
        public static CallLogManager GetInstance()
        {
            if (CallLogManagerInstance == null)
            {
                CallLogManagerInstance = new CallLogManager();
            }
            return CallLogManagerInstance;
        }
        /// <summary>
        /// Add event handlers to handle CallLogService related events of user
        /// </summary>
        /// <param name="callLogservice"></param>
        public void AddCallLogServiceEvents(CallLogService callLogservice)
        {
            callLogservice.CallLogsAdded += CallLogsAdded;
            callLogservice.CallLogsLoaded += CallLogsLoaded;
            callLogservice.CallLogsRemoved += CallLogsRemoved;
            callLogservice.CallLogsUpdated += CallLogsUpdated;
        }
        /// <summary>
        /// Removes event handlers from CallLogService of user
        /// </summary>
        /// <param name="callLogservice"></param>
        public void RemoveCallLogServiceEvents(CallLogService callLogservice)
        {
            callLogservice.CallLogsAdded -= CallLogsAdded;
            callLogservice.CallLogsLoaded -= CallLogsLoaded;
            callLogservice.CallLogsRemoved -= CallLogsRemoved;
            callLogservice.CallLogsUpdated -= CallLogsUpdated;
        }
#region Event handlers related to Call Log Service 
        public void CallLogsAdded(object sender, CallLogServiceEventArgs e)
        {
            CallLogManager calllogmgr = CallLogManager.GetInstance();
            calllogmgr.GetCallLog();
        }
        public void CallLogsLoaded(object sender, CallLogServiceEventArgs e)
        {
            CallLogManager calllogmgr = CallLogManager.GetInstance();
            calllogmgr.GetCallLog();
        }
        public void CallLogsRemoved(object sender, CallLogServiceEventArgs e)
        {
            CallLogManager calllogmgr = CallLogManager.GetInstance();
            calllogmgr.GetCallLog();
        }
        public void CallLogsUpdated(object sender, CallLogServiceEventArgs e)
        {
            CallLogManager calllogmgr = CallLogManager.GetInstance();
            calllogmgr.GetCallLog();
        }
#endregion
        /// <summary>
        /// Retrieves the local call logs and resynchronize callLog items
        /// </summary>
        public void GetCallLog()
        {
            CallLogServiceInstance.ResynchronizeCallLogItems((logStatus) =>
            {
                CallLogStatus = logStatus;
            });
            CallLogItem = CallLogServiceInstance.CallLogs.Reverse();    
        }
    }
}
