﻿/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/
using Avaya.ClientServices;
using System;

namespace SampleConferenceApp.SDK
{
    class CredentialProvider : ICredentialProvider
    {
        public CredentialProvider(String username, String password, String domain = "")
        {
            Username = username;
            Password = password;
            Domain = domain;
        }
        public void OnAuthenticationChallenge(Challenge challenge, CredentialCallback credentialCallback)
        {
            if (challenge.FailureCount > 0)
            {
                // This is credential request after login failure.
                // Do not return the same wrong credentials again.
                // Return null credential instead.               
                credentialCallback(null);
                return;
            }

            //Create the credential based on Username and Password
            UserCredential credential = new UserCredential(Username, Password, Domain, "");
            credentialCallback(credential);

        }
        public void OnCredentialAccepted(Challenge challenge)
        {
        }
        public void OnAuthenticationChallengeCancelled(Challenge challenge)
        {
        }

        public bool SupportsPreEmptiveChallenge()
        {
            return false;
        }

        /// <summary>
        /// The username for the credential.
        /// </summary>
        public String Username;

        /// <summary>
        /// The password for the credential.
        /// </summary>
        public String Password;

        /// <summary>
        /// The domain for the credential.
        /// </summary>
        public String Domain;
    }
}
