﻿using System.Windows;
using CommunicationSampleApp.Classes;
using System;
using System.Media;

namespace CommunicationSampleApp
{
    /// <summary>
    /// Interaction logic for AcceptPopup.xaml
    /// </summary>
    public partial class AcceptPopup : Window
    {
        public static AcceptPopup AcceptPopupInstance;
        private SoundPlayer soundPlayer = new SoundPlayer(CommunicationSampleApp.Properties.Resources.ringinside);
        public AcceptPopup()
        {
            InitializeComponent();
            if (CallManager.GetInstance().IncomingCall != null)
            {
                incommingCallDialogBoxLabel.Content = "Incomming call" + System.Environment.NewLine + CallManager.GetInstance().IncomingCall.RemoteDisplayName + System.Environment.NewLine + CallManager.GetInstance().IncomingCall.RemoteNumber;
            }
            StartRinging();
            CallManager callManager = CallManager.GetInstance();
            callManager.CallEstablishedEvent += HandleCallEstablishedEvent;
            callManager.CallIgnoredEvent += HandleCallIgnoredEvent;
            callManager.CallEndedEvent += HandleCallEndedEvent;
        }

        public void HandleCallEndedEvent(object sender, EventArgs e)
        {
            StopRinging();
            this.Close();
        }
        public void HandleCallEstablishedEvent(object sender, EventArgs e)
        {
            this.Close();
        }
        public void HandleCallIgnoredEvent(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btn_accept_Click(object sender, RoutedEventArgs e)
        {
            StopRinging();
            CallManager callmanager = CallManager.GetInstance();
            callmanager.AcceptCall();
            this.Close();
        }

        private void btn_endcall_Click(object sender, RoutedEventArgs e)
        {
            StopRinging();
            CallManager callmanager = CallManager.GetInstance();
            callmanager.IgnoreIncomingCall();
        }
        public void StartRinging()
        {
            soundPlayer.PlayLooping();
        }

        public void StopRinging()
        {
            soundPlayer.Stop();
        }
    }
}
