﻿/******************************************************************************/
/*                                                                            */
/* Copyright Avaya LLC.                                                       */
/*                                                                            */
/******************************************************************************/
using System;
using Avaya.ClientServices;

namespace CommunicationSampleApp.Classes
{
    class CallFeatureManager
    {
        public static CallFeatureService CallFeatureServiceInstance;
        public static CallFeatureManager CallFeatureManagerInstance;
        public event EventHandler UpdateSACUIEvent;

        public static CallFeatureManager GetInstance()
        {
            if (CallFeatureManagerInstance == null)
            {
                CallFeatureManagerInstance = new CallFeatureManager();
            }
            return CallFeatureManagerInstance;
        }
        public void SendAllCalls()
        {
            if (CallFeatureServiceInstance.SendAllCallsCapability.Allowed)
            {
                if (CallFeatureServiceInstance.SendAllCallsEnabled)
                {
                    CallFeatureServiceInstance.EnableSendAllCalls(false, (exception) => 
                    {
                    });
                }
                else
                {
                    CallFeatureServiceInstance.EnableSendAllCalls(true, (exception) =>
                    {
                    });
                }
            }
            else
            {
                NotificationHelper.ShowNotification("Send all calls not allowed");
            }
        }
      
        /// <summary>
        /// Add event handlers to handle CallFeatureService related events of user
        /// </summary>
        public void RegisterForCallFeatureServiceEvents()
        {
            CallFeatureServiceInstance.CallFeatureServiceAvailable += CallFeatureServiceAvailable;
            CallFeatureServiceInstance.CallFeatureServiceUnavailable += CallFeatureServiceUnavailable;
            CallFeatureServiceInstance.SendAllCallsStatusChanged += SendAllCallsStatusChanged;
        }

        /// <summary>
        /// Unregister event handlers from CallFeatureService of user
        /// </summary>
        public void UnregisterFromCallFeatureServiceEvents()
        {
            CallFeatureServiceInstance.CallFeatureServiceAvailable -= CallFeatureServiceAvailable;
            CallFeatureServiceInstance.CallFeatureServiceUnavailable -= CallFeatureServiceUnavailable;
            CallFeatureServiceInstance.SendAllCallsStatusChanged -= SendAllCallsStatusChanged;
        }
        

#region Event Handlers related to CallFeatureService 
        public static void CallFeatureServiceAvailable(object sender, EventArgs e)
        {
            Console.Write("CallFeature Service Available");
        }
        public static void CallFeatureServiceUnavailable(object sender, EventArgs e)
        {
            Console.Write("CallFeature Service Unavailable");
            NotificationHelper.ShowNotification("CallFeature Service Unavailable");
        }
        public void SendAllCallsStatusChanged(object sender, ExtensionToggleFeatureEventArgs e)
        {
            if (UpdateSACUIEvent != null)
            {
                UpdateSACUIEvent(this, EventArgs.Empty);
            }
        }
#endregion
    }
}
