﻿using CommunicationSampleApp.Classes;
using System.ComponentModel;
using System.Windows;


namespace CommunicationSampleApp
{
    /// <summary>
    /// Interaction logic for ConferenceControlsWindow.xaml
    /// </summary>
    public partial class ConferenceControlsWindow : Window, INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;
        private bool isLockConferenceBtnEnabled;
        private bool isMuteAllBtnEnabled;
        private bool isUnmuteAllBtnEnabled;
        public void OnPropertyChanged(string propertyName)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
                handler(this, new PropertyChangedEventArgs(propertyName));
        }
        public bool IsLockConferenceBtnEnabled
        {
            get { return isLockConferenceBtnEnabled; }
            set
            {
                if (isLockConferenceBtnEnabled != value)
                {
                    isLockConferenceBtnEnabled = value;
                    OnPropertyChanged("IsLockConferenceBtnEnabled");  // To notify when the property is changed
                }
            }
        }
        public bool IsMuteAllBtnEnabled
        {
            get { return isMuteAllBtnEnabled; }
            set
            {
                if (isMuteAllBtnEnabled != value)
                {
                    isMuteAllBtnEnabled = value;
                    OnPropertyChanged("IsMuteAllBtnEnabled");  // To notify when the property is changed
                }
            }
        }
        public bool IsUnmuteAllBtnEnabled
        {
            get { return isUnmuteAllBtnEnabled; }
            set
            {
                if (isUnmuteAllBtnEnabled != value)
                {
                    isUnmuteAllBtnEnabled = value;
                    OnPropertyChanged("IsUnmuteAllBtnEnabled");  // To notify when the property is changed
                }
            }
        }
        public ConferenceControlsWindow()
        {
            InitializeComponent();
            IsUnmuteAllBtnEnabled = false;
            if (CallManager.ConferenceInstance != null)
            {
                if (CallManager.ConferenceInstance.MuteAllParticipantsCapability.Allowed)
                {
                    IsMuteAllBtnEnabled = true;
                }
                else
                {
                    IsMuteAllBtnEnabled = false;
                }
                if (CallManager.ConferenceInstance.UnmuteAllParticipantsCapability.Allowed)
                {
                    IsUnmuteAllBtnEnabled = true;
                }
                else
                {
                    IsUnmuteAllBtnEnabled = false;
                }
                if (CallManager.ConferenceInstance.SetLockStatusCapability.Allowed)
                {
                    IsLockConferenceBtnEnabled = true;
                    if (CallManager.ConferenceInstance.IsLocked)
                    {
                        lockConferenceBtn.Content = "Unlock";
                    }
                    else
                    {
                        lockConferenceBtn.Content = "Lock";
                    }
                }
                else
                {
                    IsLockConferenceBtnEnabled = false;
                }
            }
        }

        private void cancelConferenceControlsWindowBtn_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void muteAllBtn_Click(object sender, RoutedEventArgs e)
        {
            CallManager.GetInstance().MuteAll();
            this.Close();
        }

        private void unmuteAllBtn_Click(object sender, RoutedEventArgs e)
        {
            CallManager.GetInstance().UnmuteAll();
            this.Close();
        }

        private void lockConferenceBtn_Click(object sender, RoutedEventArgs e)
        {
            CallManager.GetInstance().LockConference();
            this.Close();
        }
    }
}
