﻿using SampleConferenceApp.SDK;
using System.ComponentModel;
using System.Windows;


namespace SampleConferenceApp
{
    /// <summary>
    /// Interaction logic for ConferenceControlsWindow.xaml
    /// </summary>
    public partial class ConferenceControlsWindow : Window, INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;
        private bool isLockConferenceBtnEnabled;
        private bool isMuteAllBtnEnabled;
        private bool isUnmuteAllBtnEnabled;

        public void OnPropertyChanged(string propertyName)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
                handler(this, new PropertyChangedEventArgs(propertyName));
        }

        public bool IsLockConferenceBtnEnabled
        {
            get { return isLockConferenceBtnEnabled; }
            set
            {
                if (isLockConferenceBtnEnabled != value)
                {
                    isLockConferenceBtnEnabled = value;
                    OnPropertyChanged("IsLockConferenceBtnEnabled");  // To notify when the property is changed
                }
            }
        }

        public bool IsMuteAllBtnEnabled
        {
            get { return isMuteAllBtnEnabled; }
            set
            {
                if (isMuteAllBtnEnabled != value)
                {
                    isMuteAllBtnEnabled = value;
                    OnPropertyChanged("IsMuteAllBtnEnabled");  // To notify when the property is changed
                }
            }
        }

        public bool IsUnmuteAllBtnEnabled
        {
            get { return isUnmuteAllBtnEnabled; }
            set
            {
                if (isUnmuteAllBtnEnabled != value)
                {
                    isUnmuteAllBtnEnabled = value;
                    OnPropertyChanged("IsUnmuteAllBtnEnabled");  // To notify when the property is changed
                }
            }
        }

        public ConferenceControlsWindow()
        {
            InitializeComponent();
            if (CallManager.ConferenceInstance != null)
            {
                IsMuteAllBtnEnabled = CallManager.ConferenceInstance.MuteAllParticipantsCapability.Allowed;
                IsUnmuteAllBtnEnabled = CallManager.ConferenceInstance.UnmuteAllParticipantsCapability.Allowed;
                IsLockConferenceBtnEnabled = CallManager.ConferenceInstance.SetLockStatusCapability.Allowed;
                lockConferenceBtn.Content = CallManager.ConferenceInstance.IsLocked ? "Unlock" : "Lock";
            }
        }

        private void cancelConferenceControlsWindowBtn_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void muteAllBtn_Click(object sender, RoutedEventArgs e)
        {
            CallManager.GetInstance().MuteAll();
            Close();
        }

        private void unmuteAllBtn_Click(object sender, RoutedEventArgs e)
        {
            CallManager.GetInstance().UnmuteAll();
            Close();
        }

        private void lockConferenceBtn_Click(object sender, RoutedEventArgs e)
        {
            CallManager.GetInstance().LockConference();
            Close();
        }
    }
}
