(function () {

    'use strict';

    function ContentSharingView (template) {
        BaseView.apply(this);

        this.template = template;

        this.controls = this.template.find('#contentSharingControls');
        this.outgoingStream = this.template.find('#contentSharingOutgoingStream').get(0);
    }

    ContentSharingView.prototype = Object.create(BaseView.prototype);

    /**
     * Updates thumbnail of shared content presented by current user.
     *
     * @param {MediaStream} [videoStream]
     */
    ContentSharingView.prototype.setOutgoingStream = function (videoStream) {
        if (videoStream !== undefined) {
            this.outgoingStream.srcObject = videoStream;
            
            this.controls.show();
        }
    }

    /**
     * Hides controls when sharing has ended.
     */
    ContentSharingView.prototype.onEnded = function () {
        this.controls.hide();
    };

    window.ContentSharingView = ContentSharingView;

})();