(function (window, $) {
    'use strict';

    function CollaborationView(template, handlers) {
        this._template = template;

        this.screenSharingBtn = this._template.find(".screenSharingBtn");
        this.endSharingBtn = this._template.find(".endSharingBtn");

        this.callsServiceTab = $("#callsServiceTab");
        this.collaborationServiceTab = $("#collaborationServiceTab");
        this.collaborationService = $("#collaborationService");

        this.collaborationError = this._template.find(".collaborationError");

        this.collaborationCanvas = this._template.find(".collaborationCanvas");

        this.callId = this._template.find(".callId");

        this.screenSharingBtn.on('click', function () {
            handlers.handleScreenSharing();
        }.bind(this));

        this.endSharingBtn.on('click', function () {
            handlers.handleEndSharing();
        }.bind(this));
    }

    CollaborationView.prototype = {
        /**
         * Function show collaboration module.
         */
        showCollaborationModule: function () {
            this.collaborationServiceTab.show();
        },

        /**
         * Function hide collaboration module.
         */
        hideCollaborationModule: function () {
            if(this._getCountCollaborations() === 0){
                this.collaborationServiceTab.hide();
            }

            if (this.collaborationService.hasClass('active')) {
                this.callsServiceTab.click();
            }
        },

        /**
         * Function hide start application window and full window sharing buttons and show end screen sharing button.
         */
        hideScreenSharingButtons: function () {
            this.screenSharingBtn.hide();
            this.endSharingBtn.show();
        },

        /**
         * Function show start application window and full window sharing buttons and hide end screen sharing button.
         */
        showScreenSharingButtons: function () {
            this.screenSharingBtn.show();
            this.endSharingBtn.hide();
        },

        /**
         * Function display problems messages with screen sharing.
         *
         * @param {String} message
         */
        showCollaborationErrorMsg: function (message) {
            this.collaborationError.text(message);
        },

        setCollaborationCanvasId: function(canvasId){
            this.collaborationCanvas.attr('id', canvasId);
        },

        setCallId: function(callId){
            this.callId.text(callId);
        },

        _getCountCollaborations: function () {
            return this.collaborationService.find('.collaborationView').length;
        }
    };

    window.CollaborationView = CollaborationView;

})
(window, jQuery);
