# How to use the sample app

1. Deploy to a server (e.g. Tomcat, Apache, etc.).
2. Open the index page.
3. Click the "Settings" icon in the top-right corner.
4. Enter the address/FQDN of the node/cluster that hosts the AgentControllerService.

To enable authorization, you will need to adjust the grants available to the ContextStoreRest service in SMGR. You can do this as follows:
1. Log into System Manager.
2. Open the "Elements" menu and click on "Avaya Breeze".
3. In the left-hand menu panel, expand "Configuration".
4. Click "Authorization".
5. Select "CSRest" and click "Edit Grants".
6. If there are no grants available, click "New". Use the following details:
* ResourceName: CSRest (or the name of the cluster)
* ResourceCluster: The cluster that hosts ContextStoreRest
* Feature: standard
* Values: any combination of create/read/update/delete

Once you have done that:
1. Click the "Enable Authorization" box.
2. Enter the address/FQDN of the node/cluster that hosts the ContextStoreRest service
3. Enter the scope (standard or privileged). It must match the Feature entry above.
4. Enter the username and password.
5. Click "Generate Token".


The sample app will use the generated token in each request. 

## Troubleshooting

### General
1. Make sure that either Breeze allows Cross-Origin Resource Sharing from all domains, or add a CORS plugin/addon to your browser.
2. If the request still fails, try visiting the URL in your browser to work around certificate/TLS issues.

### ContextStoreRest service rejects token request with HTTP 503.
If this happens, then you will need to set the authorisation attributes for this service, reinstall, and then adjust the grants again.