/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (window) {
    'use strict';

    /**
    *
    * Initializes AvayaCustomerInteractionUtilitiesClient
    *
    * @class
    * @memberOf window
    * @define AvayaCustomerInteractionUtilitiesClient
    */
    function AvayaCustomerInteractionUtilitiesClient() {
        /**
        * @private
        * @type {Object}
        */        
        this.CustomerInteractionUtilitiesService = null;
    }	

    AvayaCustomerInteractionUtilitiesClient.prototype =
    /** @lends AvayaCustomerInteractionUtilitiesClient.prototype **/
    {
       
        /**
         * Register a JavaScript logger
         * @public
         * @param logger Javascript logger utility, default window.console
         */
        registerlogger: function (logger) {
            AvayaCustomerInteractionUtilitiesClient.Base.Logger.addlogger(logger);
        },

        /**
         * Create an object of agent controller session
         * @public
         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfiguration Required for agent controller Session
         * @returns {AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController}
         */
        createCustomerInteractionUtilitiesService: function (acConfiguration) {

            if(! acConfiguration){
                throw "agent controller configuration is not defined.";
            }
            if (!this.CustomerInteractionUtilitiesService && acConfiguration.enabled) {    
                this.CustomerInteractionUtilitiesService=new AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController(acConfiguration);
            }	
            return this.CustomerInteractionUtilitiesService;	
        }
    };	
	
    window.AvayaCustomerInteractionUtilitiesClient = AvayaCustomerInteractionUtilitiesClient;

})(window);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * AvayaCustomerInteractionUtilitiesClient.Base contains all classes that are common to all AvayaCustomerInteractionUtilitiesClient SDK modules.
     * @namespace AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base
     */
    (function(AvayaCustomerInteractionUtilitiesClient){
        AvayaCustomerInteractionUtilitiesClient.Base = AvayaCustomerInteractionUtilitiesClient.Base || {};
    })(AvayaCustomerInteractionUtilitiesClient);
	
    /**
     * AvayaCustomerInteractionUtilitiesClient.Config contains prototypes of config objects which are necessary to provide connection with various servers used by AvayaCustomerInteractionUtilitiesClient SDK.
     * @namespace AvayaCustomerInteractionUtilitiesClient.Config
     * @define AvayaCustomerInteractionUtilitiesClient.Config
     */
    (function(AvayaCustomerInteractionUtilitiesClient){
        AvayaCustomerInteractionUtilitiesClient.Config = AvayaCustomerInteractionUtilitiesClient.Config || {};
    })(AvayaCustomerInteractionUtilitiesClient);
	
    /**
     * @namespace AvayaCustomerInteractionUtilitiesClient.Services
     * @define AvayaCustomerInteractionUtilitiesClient.Services
     */
    (function(AvayaCustomerInteractionUtilitiesClient){
        AvayaCustomerInteractionUtilitiesClient.Services = AvayaCustomerInteractionUtilitiesClient.Services || {};
    })(AvayaCustomerInteractionUtilitiesClient);
	
    /**
     * @namespace AvayaCustomerInteractionUtilitiesClient.Services.AgentController
     * @define AvayaCustomerInteractionUtilitiesClient.Services.AgentController
     */
    (function(AvayaCustomerInteractionUtilitiesClient){
        AvayaCustomerInteractionUtilitiesClient.Services.AgentController = AvayaCustomerInteractionUtilitiesClient.Services.AgentController || {};
    })(AvayaCustomerInteractionUtilitiesClient);

    /**
     * @desc Contains prototypes of objects which are necessary to provide connection with various servers used by AvayaCustomerInteractionUtilitiesClient SDK.
     * @namespace AvayaCustomerInteractionUtilitiesClient.Config
     * @memberOf AvayaCustomerInteractionUtilitiesClient
     * @define 	 AvayaCustomerInteractionUtilitiesClient.Config
     */
    (function (AvayaCustomerInteractionUtilitiesClient) {
        AvayaCustomerInteractionUtilitiesClient.Config = AvayaCustomerInteractionUtilitiesClient.Config || {};
    })(AvayaCustomerInteractionUtilitiesClient);


})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';
	
    /**
     * @namespace AvayaCustomerInteractionUtilitiesClient.Providers
     */
    (function(AvayaCustomerInteractionUtilitiesClient){
        AvayaCustomerInteractionUtilitiesClient.Providers = AvayaCustomerInteractionUtilitiesClient.Providers || {};
    })(AvayaCustomerInteractionUtilitiesClient);
	
    /**
     * @namespace AvayaCustomerInteractionUtilitiesClient.Providers.AgentController
     */
    (function(AvayaCustomerInteractionUtilitiesClient){
        AvayaCustomerInteractionUtilitiesClient.Providers.AgentController = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController || {};
    })(AvayaCustomerInteractionUtilitiesClient);

 
})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';
    /**
    * Class extending JavaScript Error object.
    * @group Constructor
    * @function AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError
    * @define AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError
    * @extends Error
    * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
    * @param {string} errorCode
    * @param {string} reason
    * @param {string} message
    * @constructor
    */
     
    function AgentControllerError(errorCode, reason, message) {
        Error.call(this, message);

       
        this._errorCode=errorCode;
        this._reason = reason;
        this._message = message;
    }
    
    AgentControllerError.prototype = Object.create(Error.prototype);

    /**
    * Returns Error Code related with error.    
    *
    * @public
    * @function AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError#getErrorCode
    * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError#
    * @returns {string}
    */
    AgentControllerError.prototype.getErrorCode = function () {
        return this._errorCode;
    };
    /**
    * Returns Error Reason related with error.    
    *
    * @public
    * @function AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError#getReason
    * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError#
    * @returns {string}
    */
    AgentControllerError.prototype.getReason = function () {
        return this._reason;
    };

    /**
    * Returns message related with error.    
    *
    * @public
    * @function AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError#getMessage
    * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError#
    * @returns {string}
    */
    AgentControllerError.prototype.getMessage = function () {
        return this._message;
    };

    AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError = AgentControllerError;

})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * NOTE: This class does nothing!
 * It is only use to document jQuery AgentControllerPromise object in order to provide syntax completion.
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';
    /**
     * jQuery promise, created from jQuery.Deferred object. See jQuery docs for more detailed information.
     * AgentControllerPromised are used to resolve server responses to requests performed by AvayaCustomerInteractionUtilitiesClient.
     *
     * See {@tutorial async} for more information.
     *
     * Note that since all AgentControllerPromise methods return themselves, the methods can be easily chained.
     *
     * @example <caption>Adding participants to a conversation</caption>
     * var successCallback = function(){
     *      AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("Something happened!");
     * };
     * var failCallback = function(){
     *      AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("Error");
     * };
     * AgentController.doSomething(arguments).then(successCallback, failCallback);
     * // do something else...
     * // when the AgentControllerPromise is resolved, AvayaCustomerInteractionUtilitiesClient.Base.Logger will print "Something happened!"
     *
     * @example <caption>Chaining methods</caption>
     * AgentController.doSomething(arguments).done(doOneThing).done(doOther).done(doAnother).fail(onError);
     *
     *
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise
     */
    function AgentControllerPromise() {
        /**
         * NOTE: This class does nothing!
         * It is only use to document jQuery AgentControllerPromise object in order to provide syntax completion.
         */
    }

    AgentControllerPromise.prototype =
    /** @lends AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise.prototype **/
    {
        /**
         * Determine the current state of a Deferred object.
         *
         * @public
         * @returns {String}
         */
        state: function(){},

        /**
         * Add handlers to be called when the Deferred object is either resolved or rejected.
         *
         * @param {function} alwaysCallback A function, or array of functions, that is called when the Deferred is resolved or rejected.
         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
         */
        always : function(alwaysCallback){
            if (typeof alwaysCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("alwaysCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is resolved.
         *
         * @example
         * AgentController.doSomething(arguments).done(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * });
         *
         * @param {function} doneCallback A function, or array of functions, that are called when the Deferred is resolved.
         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
         */
        done: function(doneCallback){
            if (typeof doneCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("doneCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is rejected.
         *
         * @example
         * AgentController.doSomething(arguments).fail(function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * });
         *
         * @public
         * @param {function} failCallback A function, or array of functions, that are called when the Deferred is rejected.
         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
         */
        fail: function(failCallback){
            if (typeof failCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("failCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object generates progress notifications. Please note that not every AgentControllerPromise
         * creates progress notifications.
         *
         * @example
         * AgentController.doSomething(arguments).progress(function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} progressCallback A function, or array of functions, to be called when the Deferred generates progress notifications.
         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
         */
        progress: function(progressCallback){
             if (typeof progressCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("progressCallback is not a function");
            }
        },

        /**
         * Add handlers to be called for the Deferred object. Combines functionality of .done(), .fail() and .progress().
         *
         * @example
         * AgentController.doSomething(arguments).then(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * }, function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * }, function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} doneCallback A function that is called when the Deferred is resolved.
         * @param {function} [failCallback] A function that is called when the Deferred is rejected.
         * @param {function} [progressCallback] A function that is called when the Deferred generates progress notifications.
         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
         */
        then: function(doneCallback, failCallback, progressCallback){
             if (typeof doneCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("doneCallback is not a function");
            }
            else if(typeof failCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("failCallback is not a function");
            }
            else if(typeof progressCallback !== 'function'){
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn("progressCallback is not a function");
            }
        }
    };

    AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise = AgentControllerPromise;

})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient, $) {
    'use strict';

    /**
     * Capability object.
     *
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base.Capability
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.CapabilityDenialReason} reason
     */
    function Capability(reason) {

        /**
         * Determines whether the action is allowed or not.
         *
         * @public
         * @type {Boolean}
         */
        this.isAllowed = reason === AvayaCustomerInteractionUtilitiesClient.Base.CapabilityDenialReason.CAPABILITY_NOT_DENIED;

        /**
         * If action is denied, contains the reason of denial.
         *
         * @public
         * @type {String}
         */
        this.denialReason = reason;

        /**
         * @private
         */
        this._onChangedCallbacks = $.Callbacks();
    }

    Capability.prototype = {
        /**
         * Interface for callback function to be invoked when capability changed.
         *
         * @callback AvayaCustomerInteractionUtilitiesClient.Base.Capability~onChangedCallbacks
         * @returns {void}
         */
        /**
         * Add new onChangedCallback.
         *
         * @public
         * @group Managing callbacks
         * @param {AvayaCustomerInteractionUtilitiesClient.Base.Capability~onChangedCallbacks} callback
         * @returns {void}
         */
        addOnChangedCallback: function (callback) {
            this._onChangedCallbacks.add(callback);
        },
        /**
         * Remove onChangedCallback.
         *
         * @public
         * @group Managing callbacks
         * @param {AvayaCustomerInteractionUtilitiesClient.Base.Capability~onChangedCallbacks} callback
         * @returns {void}
         */
        removeOnChangedCallback: function (callback) {
            this._onChangedCallbacks.remove(callback);
        },
        /**
         * If necessary, update capability and fire callbacks.
         * @param {Boolean} isAllowed
         * @param {AvayaCustomerInteractionUtilitiesClient.Base.CapabilityDenialReason} denialReason
         * @private
         */
        _updateIfChanged: function (isAllowed, denialReason) {
            if ((this.isAllowed !== isAllowed) || (this.denialReason !== denialReason)) {
                this.isAllowed = isAllowed;
                this.denialReason = denialReason;
                this._onChangedCallbacks.fire(this);
            }
        }
    };

    AvayaCustomerInteractionUtilitiesClient.Base.Capability = Capability;

})(AvayaCustomerInteractionUtilitiesClient, jQuery);


/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */


(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * Denial reasons for capabilities.
     *
     * @readonly
     * @enum {String}
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base.CapabilityDenialReason
     */
    var CapabilityDenialReason = {
        CAPABILITY_NOT_DENIED: 'CAPABILITY_NOT_DENIED',
        CAPABILITY_INVALID_STATE: 'CAPABILITY_INVALID_STATE',
        CAPABILITY_NOT_SUPPORTED: 'CAPABILITY_NOT_SUPPORTED',
        CAPABILITY_CALL_IS_REMOTE: 'CAPABILITY_CALL_IS_REMOTE',
        CAPABILITY_CALL_IS_NOT_REMOTE: 'CAPABILITY_CALL_IS_NOT_REMOTE',
        CAPABILITY_CALL_HAS_NO_AUDIO: 'CAPABILITY_CALL_HAS_NO_AUDIO',
        CAPABILITY_CALL_HAS_NO_VIDEO: 'CAPABILITY_CALL_HAS_NO_VIDEO',
        CAPABILITY_NOT_ALLOWED: 'CAPABILITY_NOT_ALLOWED',
        CAPABILITY_NEED_SIGNIN: 'CAPABILITY_NEED_SIGNIN',
        CAPABILITY_NEED_MODERATOR: 'CAPABILITY_NEED_MODERATOR',
        CAPABILITY_NEED_SIGNIN_OR_MODERATOR: 'CAPABILITY_NEED_SIGNIN_OR_MODERATOR'
    };

    AvayaCustomerInteractionUtilitiesClient.Base.CapabilityDenialReason = CapabilityDenialReason;

})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Data set object
 *
 * @author Pawel Mazur
 *   AvayaCustomerInteractionUtilitiesClient.Base
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * @description
     *
     * Description is mandatory
     * @todo implement! document!
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base.DataRetrieval
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet} newDataSet
     */
    function DataRetrieval(newDataSet) {
        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
         */
        this.dataSet = newDataSet;
        /**
         * @public
         */
        this.dataRetrievalProgress = $.Callbacks();

        /**
         * @public
         */
        this.dataRetrievalDone = $.Callbacks();

        /**
         * @public
         */
        this.dataRetrievalFailed = $.Callbacks();

    }

    DataRetrieval.prototype =
    /** @lends AvayaCustomerInteractionUtilitiesClient.Base.DataRetrieval.prototype **/
    {
        /**
         * @function
         * @public
         * @return {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
         */
        getDataSet: function () {
            return this.dataSet;
        },

        //Progress
        /**
         * @function
         * @public
         * @param {function} callback
         */
        addOnDataRetrievalProgressCallback: function (callback) {
            this.dataRetrievalProgress.add(callback);
        },

        /**
         * @function
         * @public
         * @param {function} callback
         */
        removeOnDataRetrievalProgressCallback: function (callback) {
            this.dataRetrievalProgress.remove(callback);
        },

        /**
         * @function
         * @public
         * @param determinateness
         * @param {Number} progress
         * @param {Number} total
         */
        onDataRetrievalProgress: function (determinateness, progress, total) {
            this.dataRetrievalProgress.fire(this, arguments);
        },

        //Done
        /**
         * @function
         * @public
         * @param {function} callback
         */
        addOnDataRetrievalDoneCallback: function (callback) {
            this.dataRetrievalDone.add(callback);
        },

        /**
         * @function
         * @public
         * @param {function} callback
         */
        removeOnDataRetrievalDoneCallback: function (callback) {
            this.dataRetrievalDone.remove(callback);
        },

        /**
         * @function
         * @public
         */
        onDataRetrievalDone: function () {
            this.dataRetrievalDone.fire(this, arguments);
        },

        // Failed
        /**
         * @function
         * @public
         * @param {function} callback
         */
        addOnDataRetrievalFailedCallback: function (callback) {
            this.dataRetrievalFailed.add(callback);
        },

        /**
         * @function
         * @public
         * @param {function} callback
         */
        removeOnDataRetrievalFailedCallback: function (callback) {
            this.dataRetrievalFailed.remove(callback);
        },

        /**
         * @function
         * @public
         * @param {String} failureReason
         */
        onDataRetrievalFailed: function (failureReason) {
            this.dataRetrievalFailed.fireWith(this, arguments);
        }
    };

    AvayaCustomerInteractionUtilitiesClient.Base.DataRetrieval = DataRetrieval;

})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient, $) {
    'use strict';

    /**
     * DataSet object. For more information, see {@tutorial dataSet}.
     *
     *
     * @class
     * @define AvayaCustomerInteractionUtilitiesClient.Base.DataSet
     * @extends Array
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     */
    function DataSet() {
        /**
         * @private
         */
        this.dataSetChangeCallbacks = $.Callbacks();

        /**
         * @private
         */
        this.dataSetInvalidatedCallbacks = $.Callbacks();
    }

    DataSet.prototype = Object.create(Array.prototype);

    /**
     * Add new onDataSetChangedCallback.
     *
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.DataSet#addOnDataSetChangedCallback
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.DataSet#
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet~onDataSetChangedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.addOnDataSetChangedCallback = function (callback) {
        this.dataSetChangeCallbacks.add(callback);
    };
    /**
     * Remove existing onDataSetChangedCallback.
     *
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.DataSet#removeOnDataSetChangedCallback
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.DataSet#
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet~onDataSetChangedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.removeOnDataSetChangedCallback = function (callback) {
        this.dataSetChangeCallbacks.remove(callback);
    };

    /**
     * @private
     * @function AvayaCustomerInteractionUtilitiesClient.Base.DataSet#onDataSetChanged
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.DataSet#
     * @returns {void}
     */
    DataSet.prototype.onDataSetChanged = function () {
        this.dataSetChangeCallbacks.fire(this);
    };

    /**
     * Add new onDataSetChangedCallback.
     *
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.DataSet#addOnDataSetInvalidatedCallback
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.DataSet#
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet~onDataSetInvalidatedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.addOnDataSetInvalidatedCallback = function (callback) {
        this.dataSetInvalidatedCallbacks.add(callback);
    };

    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.DataSet#removeOnDataSetInvalidatedCallback
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.DataSet#
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet~onDataSetInvalidatedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.removeOnDataSetInvalidatedCallback = function (callback) {
        this.dataSetInvalidatedCallbacks.remove(callback);
    };
    /**
     * @private
     * @function AvayaCustomerInteractionUtilitiesClient.Base.DataSet#onDataSetInvalidated
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.DataSet#
     * @returns {void}
     */
    DataSet.prototype.onDataSetInvalidated = function () {
        this.dataSetInvalidatedCallbacks.fire(this);
    };

    /**
     * Interface for callback function to be invoked when DataSet changes.
     *
     * @callback AvayaCustomerInteractionUtilitiesClient.Base.DataSet~onDataSetChangedCallback
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet} dataSet - instance of DataSet that has changed
     * @returns {void}
     */

    /**
     * Interface for callback function to be invoked when DataSet is invalidated.
     *
     * @callback AvayaCustomerInteractionUtilitiesClient.Base.DataSet~onDataSetInvalidatedCallback
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.DataSet} dataSet - instance of DataSet that has been invalidated
     * @returns {void}
     */


    AvayaCustomerInteractionUtilitiesClient.Base.DataSet = DataSet;

})(AvayaCustomerInteractionUtilitiesClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function () {
    'use strict';

    var loggers = [];

    function standardLog(logger, level, message, meta) {
        if (typeof meta !== 'undefined') {
            logger[level](message, meta);
        } else {
            logger[level](message);
        }
    }

    function externalLog(logger, level, message, meta) {
        if (typeof meta !== 'undefined') {
            logger.log(level, message, meta);
        } else {
            logger.log(level, message);
        }
    }


    /**
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base.logger
     */
    AvayaCustomerInteractionUtilitiesClient.Base.Logger = {

        /**
         * @public
         * @function
         * @param {string} level
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        log: function (level, message, meta) {
            loggers.forEach(function (logger) {
                externalLog(logger, level, message, meta);
            });
        },

        /**
         *
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        info: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.info === 'function') {
                    standardLog(logger, 'info', message, meta);
                } else {
                    externalLog(logger, 'info', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        error: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.error === 'function') {
                    standardLog(logger, 'error', message, meta);
                } else {
                    externalLog(logger, 'error', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        fatal: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.fatal === 'function') {
                    standardLog(logger, 'fatal', message, meta);
                } else {
                    externalLog(logger, 'fatal', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        debug: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.debug === 'function') {
                    standardLog(logger, 'debug', message, meta);
                } else {
                    externalLog(logger, 'debug', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        trace: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.trace === 'function') {
                    standardLog(logger, 'trace', message, meta);
                } else {
                    externalLog(logger, 'trace', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        warn: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.warn === 'function') {
                    standardLog(logger, 'warn', message, meta);
                } else {
                    externalLog(logger, 'warn', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {Object} logger
         * @returns {void}
         */
        addlogger: function (logger) {
            if (!logger || typeof logger.log === 'undefined') {
                throw new TypeError('logger should implement log method.');
            }
            loggers.push(logger);
        },

        /**
         * @public
         * @function
         * @param {Object} logger
         * @returns {void}
         */
        removelogger: function (logger) {
            var index = loggers.indexOf(logger);
            if (index === -1) {
                throw new Error('Specified error does not exist.');
            }
            loggers.splice(index, 1);
        }

    };
})();

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * @abstract
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @define AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider
     */
    function AbstractNetworkProvider() {
        /**
         * @protected
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.ServerInfo}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         */
        this._config = {};
        /**
         * @protected
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.CredentialProvider}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         */
        this._credentialProvider = {};
    }

    AbstractNetworkProvider.prototype =
    /**
     * @lends AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider.prototype
     */
    {
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#send
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         * @param {JSON} message
         * @param {JSON} options
         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.CobrowsePromise}
         */
        send: function (message, options) {
            if(options){
                 AvayaCustomerInteractionUtilitiesClient.Base.Logger.info(options);
            }
            if(message){
                 AvayaCustomerInteractionUtilitiesClient.Base.Logger.info(message);
            }
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#_onCredentialsRequired
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         * @param {JSON} data
         */
        _onCredentialsRequired: function (data) {
            if(data){
                 AvayaCustomerInteractionUtilitiesClient.Base.Logger.info(data);
            }
        },

        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#onClose
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         */
        onClose: function () {
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#onMessage
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         * @param {JSON|String[]} message
         */
        onMessage: function (message) {
            if(message){
                 AvayaCustomerInteractionUtilitiesClient.Base.Logger.info(message);
            }
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#onError
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider#
         * @param {JSON|String[]} error
         */
        onError: function (error) {
                 AvayaCustomerInteractionUtilitiesClient.Base.Logger.error(error); 
        }
    };

    AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider = AbstractNetworkProvider;
})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient, $) {
    'use strict';

    /**
     * @requires AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider
     * @extends AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider
     * @define AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base
     * @constructor
     */
    function RESTProvider() {
        AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider.apply(this);
        /**
         * @private
         * @type {Array}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#
         */
        this._xhrPool = [];
    }

    RESTProvider.prototype = Object.create(AvayaCustomerInteractionUtilitiesClient.Base.AbstractNetworkProvider.prototype);

    /**
     * @public
     * @property AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#defaultOptions
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#
     */
    RESTProvider.prototype.defaultOptions = {
        url: undefined,
        processData: true,
    };

    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#generateToken
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#
     * @param {JSON} data
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} options
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    RESTProvider.prototype.generateToken = function (options) {

        var opts = $.extend({}, this.defaultOptions, options);
        var url = this._getServerURL(opts, true);
        var finalOptions = {
            url: url,
            type: opts.sendType,
            dataType: opts.dataType,
            headers: opts.headers,
            processData: opts.processData,
            success: function (response) {
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("token request successful");
                return response;
            },
            error: function (req, status, err) {
                AvayaCustomerInteractionUtilitiesClient.Base.Logger.error('Error! token could not be generated', err);
                return err;
            },
            beforeSend: function (jqXHR) {
                this._xhrPool.push(jqXHR);
            }.bind(this)
        };
        if (opts.crossDomain && opts.crossDomain === true) {
            finalOptions.xhrFields = {
                withCredentials: true
            };
            finalOptions.crossDomain = true;
        }

        return $.ajax(finalOptions);
    };


    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#delete
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} opts
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    RESTProvider.prototype.delete = function (opts) {
        var url = this._getServerURL(opts);
        var settings = {
            url: url,
            type: 'DELETE',
            async: false

        };

        return  $.ajax(settings)
            .then(function (data, statusText, xhr) {
                var status = xhr.status;
                console.log('RestProvider status: ' + status);
                return status;
            }.bind(this), function (error) {
                console.log("ERROR: "+error.statusText);
                this.onError(error.statusText);
                return error.statusText;
            }.bind(this));
    };



    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#send
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#
     * @param {JSON} data
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} opts
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    RESTProvider.prototype.send = function (data, opts, isGuest) {
        var url = this._getServerURL(opts);
        var finalOptions = {
            url: url,
            type: opts.sendType,
            headers: opts.headers,
            dataType: opts.dataType,
            contentType: opts.contentType,
            processData: opts.processData,
            beforeSend: function (jqXHR) {
                this._xhrPool.push(jqXHR);
            }.bind(this)
        };

        if (data) {
            finalOptions.data = data;
        }
        if (opts.crossDomain && opts.crossDomain === true) {
            finalOptions.xhrFields = {
                withCredentials: true
            };
            finalOptions.crossDomain = true;
        }

        return $.ajax(isGuest === true ? finalOptions : this.buildAuthorizationHeader(finalOptions))
                .then(function (data, textStatus, jqXHR) {
                    this._xhrPool.splice(this._xhrPool.indexOf(jqXHR), 1);
                    this.onMessage(data.responseText, jqXHR);
                    return data;
                }.bind(this), function (error) {
                    this.onError(error.responseText);
                    return error;
                }.bind(this));
    };


    function setStatus(id, acResponse, message) {
        if (acResponse.status === 200) {
            $("#" + id).removeClass("waiting failure").addClass("success");
            $("#data-" + id).text(message);
        } else {
            $("#" + id).removeClass("waiting failure").addClass("failure");
            $("#data-" + id).text(acResponse.responseMessage + "\n" + acResponse.responseText);
        }
    }

    /**
     * @function AvayaCustomerInteractionUtilitiesClient.Base.Providers.RESTProvider#buildAuthorizationHeader
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.Providers.RESTProvider
     * @desc Build specified headers for HTTP request
     * @private
     * @param {Object} opts - jQuery ajax options object
     * @returns {Object}
     */
    RESTProvider.prototype.buildAuthorizationHeader = function (opts) {
        var bearer = this._config.token;
        var fullToken = 'Bearer ' + bearer;
        
        opts.headers = opts.headers || {};
        opts.headers.Authorization = fullToken;        
        return opts;
    };

    /**
     * @private
     * @param {JSON} options
     * @param {Boolean} forAuth - if true, this is used specifically for the authorisation request
     * @function AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#_getServerURL
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider#
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} options
     * @returns string
     */
    RESTProvider.prototype._getServerURL = function (options, forAuth) {
        var url = '';
        if (typeof forAuth === 'undefined') {
            forAuth = false;
        }
        if (typeof options.url !== 'undefined') {
            url = options.url;
        } else {
            url += this._config.isSecure ? 'https://' : 'http://';
            url += forAuth ? this._config.authorisationHost : this._config.hostName;
            url += options.urlSuffix;
        }

        console.log(url);

        return url;
    };

    AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider = RESTProvider;
})(AvayaCustomerInteractionUtilitiesClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * @define AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Config
     * @description Configuration information for Agent Controller. This class provides the configuration data that allows a connection and access to be made to a  Agent Controller Server
     * @constructor
     */
    function AcConfiguration() {
        /**
         * @description A Boolean value indicating whether the  Agent Controller Provider is enabled.
         * @public
         * @type {boolean}       
         */
        this.enabled = false;
		
        /**
         * @description A Boolean value indicating whether the user Agent Controller is a Guest and thus, authorization isn't required
         * @public
         * @type {boolean}       
         */
        this.isGuest = true;
		
        /**
         * @public
         * @description A ServerInfo value indicating the server to connect with for  Agent Controller Service.
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.ServerInfo}       
         */
        this.serverInfo = new AvayaCustomerInteractionUtilitiesClient.Config.ServerInfo();
        /**
         * @public
         * @description Value of sockjs connection retry with  Agent Controller server.
         * @type {number}        
         */
        this.maxConnectionErrorCount=5;
       
    }

    AcConfiguration.prototype = {};

    AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration = AcConfiguration;
})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * Agent Controller server information
     * @define AvayaCustomerInteractionUtilitiesClient.Config.ServerInfo
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Config
     * @constructor
     */
    function ServerInfo() {
        /**
         * @public
         * @description The server's host name. This may by a fully qualified domain name or an IP address.
         * @type {string}
        
         */
        this.hostName = '';
        
        /**
         * @public
         * @description The cluster that hosts the Breeze AuthorizationService. This may by a fully qualified domain name or an IP address.
         */
        this.authorisationHost = '';
        
        /**
         * @public
         * @description Used to determine if security is to be used for the connection to the server. Returns true is the connection is secured, otherwise false.
         * @type {boolean}
        
         */
        this.isSecure = false;
    }

    ServerInfo.prototype = {};

    AvayaCustomerInteractionUtilitiesClient.Config.ServerInfo = ServerInfo;
	
})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController
     * @define AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions
     * @property AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions#
     */
    var AgentControllerNetworkOptions =  {
        url: undefined,
        sendType: undefined,
        urlSuffix: '/services/AgentControllerService/gila/api',
		contentType: "application/json; charset=UTF-8",
        dataType: undefined,
        timeout: 2000,
        processData: true
    };	
    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions = AgentControllerNetworkOptions;

})(AvayaCustomerInteractionUtilitiesClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController
     * @define AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider
     * @param {AvayaCustomerInteractionUtilitiesClient.Base.SockJSNetworkProvider} restProvider
     * @constructor
     */

    function AgentControllerNetworkProvider(restProvider) {

        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
         */
        this._restProvider = restProvider;

        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.serverInfo}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
         */
        this._config = undefined;

    }

    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#init
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
     * @param {AvayaCustomerInteractionUtilitiesClient.Config.ServerInfo} serverConfig
     * @returns {void}
     */
    AgentControllerNetworkProvider.prototype.init = function (serverConfig) {
        this._config = serverConfig;
        if (!this._restProvider) {
            this._restProvider = new AvayaCustomerInteractionUtilitiesClient.Base.RESTProvider();
        }

        this._restProvider._config = this._config;
    };

    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#send
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
     * @param {JSON} data
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} options
     * @returns {*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    AgentControllerNetworkProvider.prototype.send = function (data, options, isGuest) {
        return this._restProvider.send(data, options, isGuest).then(
                function (response) {
                    AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("successfully processed request for:" + options.urlSuffix);
                    return response;
                }, function (error) {
            AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("error in processing request for:" + options.urlSuffix);
            return this._handleError(error);
        }.bind(this));
    };

   

    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#delete
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} options
     * @returns {*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    AgentControllerNetworkProvider.prototype.delete = function (options) {
        return this._restProvider.delete(options);

    };

    /**
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#generateToken
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
     * @param {JSON} data
     * @param {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions} options
     * @returns {*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    AgentControllerNetworkProvider.prototype.generateToken = function (options) {
        return this._restProvider.generateToken(options).then(
                function (token) {
                    AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("token generated");
                    return token;
                }, function (error) {
            AvayaCustomerInteractionUtilitiesClient.Base.Logger.log("error in rest sending");
            return this._handleError(error);
        }.bind(this));
    };

    /**
     * Converts AgentController JSON error response to {@link AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError} and returns it.
     *
     * @private
     * @function AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#_handleError
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider#
     * @param {{errorCode:string, reason:string, message:string}} json
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError}
     */
    AgentControllerNetworkProvider.prototype._handleError = function (error) {
        var errorCode = error.status;
        var reason = error.statusText;
        var message = error.responseText;
        if (!error) {
            return new AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError(errorCode, reason, message);
        } else {
            reason = error;
        }
        if (error.errorMessage) {
            message = error.errorMessage;
            if (error.errorCode) {
                errorCode = error.errorCode;
            }
        } else if (error.data) {
            var eData = error.data.split("::");
            if (eData.length > 1) {
                message = eData[1];
                errorCode = eData[0];
            }
        }
        AvayaCustomerInteractionUtilitiesClient.Base.Logger.warn(JSON.stringify(error));
        return new AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError(errorCode, reason, message);
    };

    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider = AgentControllerNetworkProvider;

})(AvayaCustomerInteractionUtilitiesClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * @description
     * Agent Controller Provider to connect from service to network layer
     * @define AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController
     * @constructor
     */
    function AgentControllerProvider() {
        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider#
         */
        this._acNetworkProvider = new AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkProvider();
        /**
         *
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider#
         */
        this.acConfig = null;
    }

    AgentControllerProvider.prototype =
            /** @lends AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider.prototype **/
                    {
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#generateToken
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        generateToken: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var scope = requestData.scope;
                            var username = requestData.username;
                            var password = requestData.password;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GENERATETOKENURL;
                            
                            var USERNAMESUFFIX = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.USERNAMESUFFIX;
                            var SCOPESUFFIX = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.SCOPESUFFIX;
                            
                            if (typeof scope !== 'undefined' && typeof username !== 'undefined') {
                                options.urlSuffix += USERNAMESUFFIX + SCOPESUFFIX;
                                options.headers = {'scope': scope, 'username': username, 'password': password};
                            } else if (typeof scope !== 'undefined') {
                                options.urlSuffix += SCOPESUFFIX;
                                options.headers = {'scope': scope};
                            } else if (typeof username !== 'undefined') {
                                options.urlSuffix += USERNAMESUFFIX;
                                options.headers = {'username': username, 'password': password};
                            }
                            options.sendType = 'GET';
                            options.crossDomain = 'TRUE';
                            return this._acNetworkProvider.generateToken(options);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getCustomerHistoryByTranscriptId
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getCustomerHistoryByTranscriptId: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var transcriptId = requestData.transcriptId;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.CUSTOMERHISTORYURL + transcriptId;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getCustomerDetails
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getCustomerDetails: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var customerId = requestData.customerId;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.CUSTOMERDETAILSURL + customerId;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getCustomerHistoryByUserDetails
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getCustomerHistoryByUserDetails: function (acConfig, requestData) {

                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);

                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.CUSTOMERHISTORYSEARCHURL;
                            options.sendType = 'POST';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            var json = JSON.stringify(requestData);

                            return this._acNetworkProvider.send(json, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getCustomerSearchResult
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getCustomerSearchResult: function (acConfig, requestData) {

                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);

                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GETCUSTOMERSEARCHURL;
                            options.sendType = 'POST';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            var json = JSON.stringify(requestData);

                            return this._acNetworkProvider.send(json, options, this.acConfig.isGuest);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getContactDetails
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getContactDetails: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var contactId = requestData.contactId;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GETCONTACTDETAILSURL + contactId;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getAllTemplates
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getAllTemplates: function (acConfig) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);                           
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GETALLTEMPLATE ;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';
                           
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getTemplateById
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getTemplateById: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var templateID = requestData.templateID;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GETTEMPLATEBYID + templateID;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getTemplateAttachmentById
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getTemplateAttachmentById: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var attachmentID = requestData.attachmentID;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GETTEMPLATEATTACHMENTBYID + attachmentID;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getTemplateAttachmentById
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        insertTemplateAttachments: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var templateID = requestData.templateID;
                        	var workRequestID	 = requestData.workRequestID;
                        	var interactionID = requestData.interactionID;
                        	
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GETTEMPLATEBYID + 
                            		AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.WORKREQUESTS + workRequestID +
                            		AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.INTERACTIONS + interactionID +
                            		AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.TEMPLATES + templateID;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#getUploadAttachmentsByWorkrequestIdInteractionIdLocale
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        getUploadAttachmentsByWorkrequestIdInteractionIdLocale: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var workRequestId = requestData.workRequestId;
                            var interactionId = requestData.interactionId;
                            var locale = requestData.locale;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.UPLOADURL +
                                    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.WORKREQUESTPARAM + workRequestId +
                                    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.INTERACTIONPARAM + interactionId +
                                    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.LOCALEPARAM + locale;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};
                            options.dataType = 'json';
                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },

                        getUploadAttachmentsByWorkrequestIdInteractionIdLocaleDev: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var workRequestId = requestData.workRequestId;
                            var interactionId = requestData.interactionId;
                            var locale = requestData.locale;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.UPLOADURLDEV +
                                    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.WORKREQUESTPARAM + workRequestId +
                                    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.INTERACTIONPARAM + interactionId +
                                    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.LOCALEPARAM + locale;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'text/html'};
                            options.dataType = 'html';
                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#deleteAttachmentByWorkRequestIdInteractionId
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @param {type} requestData
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        deleteAttachmentByWorkRequestIdInteractionId: function (acConfig, requestData) {

                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var workRequestId = requestData.workRequestId;
                            var interactionId = requestData.interactionId;
                            var attachmentId = requestData.attachmentId;
                            var acProviderURL = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;

                            options.urlSuffix = acProviderURL.REMOVE_ATTACHMENT_URL +
                                    workRequestId +
                                    acProviderURL.INTERACTION_SUFFIX +
                                    interactionId +
                                    acProviderURL.ATTACHMENT_SUFFIX +
                                    "/" +
                                    attachmentId;


                            return this._acNetworkProvider.delete(options);

                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#cancelEmailWithAttachmentByWorkRequestIdInteractionId
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @param {type} requestData
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        cancelEmailWithAttachmentByWorkRequestIdInteractionId: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var workRequestId = requestData.workRequestId;
                            var interactionId = requestData.interactionId;
                            var acProviderURL = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;

                            options.urlSuffix = acProviderURL.REMOVE_ATTACHMENT_URL +
                                    workRequestId +
                                    acProviderURL.INTERACTION_SUFFIX +
                                    interactionId +
                                    acProviderURL.ATTACHMENT_SUFFIX;

                            return this._acNetworkProvider.delete(options);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#uploadEmailSignatureImage
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        uploadEmailSignatureImage: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.EMAILSIGNATUREURL;
                            options.sendType = 'POST';
                            options.headers = {'Content-Type':'application/json'};  
                            options.dataType = 'text';

                            var data = {
                                name: requestData.image.name,
                                type: requestData.image.type,
                                size: requestData.image.size,
                                attachment: requestData.image.data,
                                guid: requestData.guId
                            };

                            return this._acNetworkProvider.send(JSON.stringify(data), options, this.acConfig.isGuest);
                        },
       
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#retrieveEmailSignatureImages
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        retrieveEmailSignatureImages: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var guId = requestData.guId;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.EMAILSIGNATUREURL +
                                                AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GUIDPARAM + guId;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type':'application/json'};  
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#retrieveEmailSignatureImage
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        retrieveEmailSignatureImage: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var hash = requestData.hash;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.EMAILSIGNATUREURL +
                                                AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.HASHPARAM + hash;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type':'application/json'};  
                            options.dataType = 'json';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#deleteEmailSignatureImages
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        deleteEmailSignatureImages: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var guId = requestData.guId;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.EMAILSIGNATUREURL +
                                                AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GUIDPARAM + guId;
                            options.sendType = 'DELETE';
                            options.headers = {'Content-Type':'application/json'};  
                            options.dataType = 'text';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },

                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#deleteEmailSignatureImage
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        deleteEmailSignatureImage: function (acConfig, requestData) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            var guId = requestData.guId;
                            var hash = requestData.hash;
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.EMAILSIGNATUREURL +
                                                AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.GUIDPARAM + guId +
                                                AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.EXTRAHASHPARAM + hash;
                            options.sendType = 'DELETE';
                            options.headers = {'Content-Type':'application/json'};  
                            options.dataType = 'text';

                            options = addQueryParams(requestData, options);
                            return this._acNetworkProvider.send({}, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#uploadAttachment
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @param {String} workRequestId WorkRequestID for the contact
                         * @param {String} interactionId InteractionId for the contact
                         * @param {Array} files An array of Files
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        uploadAttachment: function(acConfig, workRequestId, interactionId, files) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);
                            
                            var formData = new FormData();
                            for (var i = 0; i < files.length; i++) {
                                var key = "file-" + i;
                                formData.append(key, files[i], files[i].name);
                            }
                            
                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.UPLOADURL + 
                                        "?workRequestId=" +workRequestId + "&interactionId=" + interactionId;
                            options.sendType = 'POST';
                            
                            // this is required so jQuery doesn't alter the headers or data
                            // the last line in particular is required to prevent previous requests from overwriting the headers
                            options.processData = false;
                            options.contentType = false;
                            options.dataType = 'text';
                            options.headers = {};

                            options = addQueryParams(formData, options);
                            return this._acNetworkProvider.send(formData, options, this.acConfig.isGuest);
                        },
                        
                        /**
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#requestMaxFileSize
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration#
                         * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
                         * @param {String} workRequestId
                         * @param {String} interactionId
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.Promise|*|*|AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         */
                        requestMaxFileSize: function(acConfig, workRequestId, interactionId) {
                            this.acConfig = acConfig;
                            this._acNetworkProvider.init(this.acConfig.serverInfo);

                            var options = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerNetworkOptions;
                            options.urlSuffix = AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.UPLOADURL + 
                                        "?workRequestId=" +workRequestId + "&interactionId=" + interactionId;
                            options.sendType = 'GET';
                            options.headers = {'Content-Type': 'application/json'};

                            return this._acNetworkProvider.send('', options, this.acConfig.isGuest);
                        }

                    };


            function addQueryParams(requestData, options) {
                return addQueryParamsWithRulesAndShortId(requestData, options, '', '');
            }

            function addQueryParamsWithRulesAndShortId(requestData, options, rules, shortId) {
                if (typeof requestData.sid !== "undefined" && requestData.sid !== '') {
                    options.urlSuffix += AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.SIDPARAM + requestData.sid;
                }
                if (typeof requestData.rid !== "undefined" && requestData.rid !== '') {
                    options.urlSuffix += AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.RIDPARAM + requestData.rid;
                }
                if (typeof requestData.touchpoint !== "undefined" && requestData.touchpoint !== '') {
                    options.urlSuffix += AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.TOUCHPOINTPARAM + requestData.touchpoint;
                }
                if (typeof requestData.lease !== "undefined" && requestData.lease !== '') {
                    options.urlSuffix += AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.LEASEPARAM + requestData.lease;
                }
                if (rules !== '') {
                    options.urlSuffix += AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.RULESPARAM + requestData.rules;
                }
                if (shortId !== '') {
                    options.urlSuffix += AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL.SHORTIDPARAM + requestData.shortId;
                }

                options.urlSuffix = checkQueryParamsFormat(options.urlSuffix);

                return options;
            }

            function checkQueryParamsFormat(urlSuffix) {
                if (!(urlSuffix.includes('?'))) {
                    urlSuffix = urlSuffix.replace(/\&+?/, "\/?");
                }
                return urlSuffix;
            }

            AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider = AgentControllerProvider;

        })(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Providers.AgentController
     * @define AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL
     * @property AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL#
     */
    var AgentControllerProviderURL = {
        CUSTOMERHISTORYURL: "/services/AgentControllerService/gila/api/customerhistory/",
        CUSTOMERDETAILSURL: "/services/OCPDataServices/api/customer/details/",
        CUSTOMERHISTORYSEARCHURL: "/services/OCPDataServices/api/customerhistory",
        CUSTOMERHISTORYSEARCHURLDEV: ":8082/OCPDataServices/api/customerhistory",
        GETCONTACTDETAILSURL: "/services/OCPDataServices/api/customer/history/detail/",
        GETCUSTOMERSEARCHURL: "/services/OCPDataServices/api/customer/search/",
        GETCONTACTDETAILSURLDEV: ":8082/OCPDataServices/api/customer/history/detail/",
        UPLOADURL: "/services/AgentControllerService/upload",
        EMAILSIGNATUREURL: "/services/OCPDataServices/api/signatures/images",
        CUSTOMERHISTORYURLDEV: "/AgentControllerWeb/gila/api/customerhistory/",
        UPLOADURLDEV: "/AgentControllerWeb/upload",
        GENERATETOKENURL: "/services/ContextStoreRest/cs/contexts/token",
        REMOVE_ATTACHMENT_URL: "/services/AgentControllerService/gila/api/email/workrequests/",
        GETALLTEMPLATE: "/services/OCPDataServices/aot/v1/templates",
        GETTEMPLATEBYID: "/services/OCPDataServices/aot/v1/templates/",
        GETTEMPLATEATTACHMENTBYID: "/services/OCPDataServices/aot/v1/templates/attachments/",
        WORKREQUESTS : "workrequests/",
        INTERACTIONS : "/interactions/",
        TEMPLATES : "/templates/",
        INTERACTION_SUFFIX: "/interactions/",
        ATTACHMENT_SUFFIX: "/attachments",
        KEYSSUFFIX: "/keys/",
        ALIASESSUFFIX: "/aliases",
        ALIASSUFFIX: "/alias/",
        SCOPESUFFIX: "/scope",
        USERNAMESUFFIX: "/username",
        ALIASPARAM: "/?alias=",
        WORKREQUESTPARAM: "?workRequestId=",
        INTERACTIONPARAM: "&interactionId=",
        LOCALEPARAM: "&locale=",
        EXTRAALIASPARAM: "&alias=",
        SIDPARAM: "&sid=",
        RIDPARAM: "&rid=",
        TOUCHPOINTPARAM: "&touchpoint=",
        LEASEPARAM: "&lease=",
        RULESPARAM: "&rules=",
        SHORTIDPARAM: "&shortid=",
        GUIDPARAM: "?guid=",
        HASHPARAM: "?hash=",
        EXTRAHASHPARAM: "&hash="
    };

    AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProviderURL = AgentControllerProviderURL;


})(AvayaCustomerInteractionUtilitiesClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description agent controller api prototype
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient, $) {
    'use strict';

    /**
     *   AgentController API
     * @class
     * @define AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController
     * @param {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration} acConfig
     * @constructor
     */
    function AgentController(acConfig) {

        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#
         */
        this._acConfig = acConfig;

        /**
         *  Object of agent controller
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#
         */
        this._AgentControllerService = new AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService(this);

    }

    AgentController.prototype =
            /** @lends AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController.prototype **/
                    {
                        /**
                         * request to generate Token.
                         * @param {String} scope - can either be standard or privileged.
                         * @param {String} username - the agent's LDAP username
                         * @param {String} password - the agent's LDAP password
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#generateToken
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#   
                         * @returns {AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
                         * On error the promise will be rejected with an {@link AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError}.
                         */
                        generateToken: function (scope, username, password) {
                            if (!this._acConfig) {
                                var dfd = $.Deferred();
                                dfd.reject("agent controller configuration is not defined.");
                                return dfd.promise();
                            }
                            return this._AgentControllerService.generateToken(this._acConfig, {scope: scope, username: username, password: password}).then(function (token) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.info('Successfully Generated Token');
                                return token;
                            }.bind(this), function (error) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.error(error);
                                return error;
                            });
                        },
                        /**
                         * Get CustomerHistory from Agent Controller via Action Id
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getCustomerHistoryByTranscriptId
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {Integer} Action id
                         * @returns {Object} response 
                         */
                        getCustomerHistoryByTranscriptId: function (transcriptId) {
                            return this._AgentControllerService.getCustomerHistoryByTranscriptId(this._acConfig, {transcriptId: transcriptId})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! CustomerHistory could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('CustomerHistory: %o:', response);
                            });
                        },
                        
                        /**
                         * Get CustomerDetails from Data Service via Customer Id
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getCustomerDetails
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {Integer} Action id
                         * @returns {Object} response 
                         */
                        getCustomerDetails: function (customerId) {
                            return this._AgentControllerService.getCustomerDetails(this._acConfig, {customerId: customerId})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! CustomerDetails could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('CustomerDetails: %o:', response);
                            });
                        },
                        
                        /**
                         * Get CustomerHistory from Data Services using any combination of email, toAddress, startDate, endDate or keyword. 
                         * 
                         * Search parameters can be included or omitted as desired. When using date range searches you should include
                         * both the startDate and endDate parameters.
                         * 
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getCustomerHistoryByUserDetails
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {Object} userInput (email, toAddress, startDate, endDate, keyword, phoneNumber)
                         * @param {String} userInput.email Search for emails sent from the email address.
                         * @param {String} userInput.toAddress Search for emails sent to the email address.
                         * @param {String} userInput.startDate Inclusive, search for history entries from the specified start date.
                         * @param {String} userInput.endDate Inclusive, search for history entries before the specified end date.
                         * @param {String} userInput.keyword Can be used to search for a keyword contained within the subject line of an email.
						 * @param {String} userInput.phoneNumber Search for contacts with the customerId belogning to this phoneNumber.
                         * @param {Object} criteria Currently unused.
                         * @param {Integer} offset Can be used to page results, if there is more available than the value set in the size parameter.
                         * @param {Integer} size Maximum number of results to return from the request.
                         * @returns {Object} response 
                         */
                        getCustomerHistoryByUserDetails: function (userInput, criteria, offset, size) {
                            var request = {};
                            $.extend(request, userInput);
                            request.criteria = criteria;
                            request.offset = offset;
                            request.size = size;
                            return this._AgentControllerService.getCustomerHistoryByUserDetails(this._acConfig, request)
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! CustomerHistory could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('CustomerHistory: %o:', response);
                            });
                        },
                        
                        /**
                         * Get Customer Search Result from Data Services
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getCustomerSearchResult
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {Object} userInput (JSON)
                         * @returns {Object} response 
                         */
                        getCustomerSearchResult: function (userInput) {
                            var request = {};
                            $.extend(request, userInput);
                            return this._AgentControllerService.getCustomerSearchResult(this._acConfig, request)
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! CustomerSearch could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('CustomerSearchResult: %o:', response);
                            });
                        },
                        /**
                         * Get Contact Details from Data Services via Action Id
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getContactDetails
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {Integer} Contact id
                         * @returns {Object} response 
                         */
                        getContactDetails: function (contactId) {
                            return this._AgentControllerService.getContactDetails(this._acConfig, {contactId: contactId})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! ContactDetails could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ContactDetails: %o:', response);
                            });
                        },                        
                        /**
                         * Get All Email Templates from OCP Data Service
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getAllTemplates
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @returns {Object} response 
                         */
                        getAllTemplates: function () {
                            return this._AgentControllerService.getAllTemplates(this._acConfig)
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! GetAllTemplates could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('GetAllTemplates: %o:', response);
                            });
                        },
                        /**
                         * Get Template details from Data Services using Template Id
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getTemplateById
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} TemplateID Specify ID of template to retrieve content. 
                         * @returns {Object} response 
                         */
                        getTemplateById: function (templateID) {
                            return this._AgentControllerService.getTemplateById(this._acConfig, {templateID: templateID})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! GetTemplateByID could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('GetTemplateByID: %o:', response);
                            });
                        },
                        /**
                         * Upload template attachment via WorkRequest Id and Interaction Id and Template Id 
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#insertTemplateAttachments
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController# 
                         * @param {String} WorkRequestId Specify work request ID.
                         * @param {String} InteractionId Specify interaction ID.
                         * @param {String} TemplateID Specify template ID. 
                         * @returns {Object} response 
                         */
                        insertTemplateAttachments: function (workRequestID, interactionID, templateID) {
                            return this._AgentControllerService.insertTemplateAttachments(this._acConfig, {workRequestID : workRequestID, interactionID : interactionID, templateID: templateID})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! InsertTemplateAttachments could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('InsertTemplateAttachments: %o:', response);
                            });
                        },
                        /**
                         * Get Template attachment details from Data Services using attachment Id
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getTemplateAttachmentById
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} AttachmentID Specify ID of attachment to retrieve content of attachment.
                         * @returns {Object} response 
                         */
                        getTemplateAttachmentById: function (attachmentID) {
                            return this._AgentControllerService.getTemplateAttachmentById(this._acConfig, {attachmentID: attachmentID})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! GetTemplateAttachmentByID could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('GetTemplateAttachmentByID: %o:', response);
                            });
                        },
                        /**
                         * Get UploadAttachments from Agent Controller via WorkRequest Id and Interaction Id and Locale
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getUploadAttachmentsByWorkrequestIdInteractionIdLocale
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} WorkRequest id
                         * @param {String} Interaction id
                         * @param {String} Locale
                         * @returns {Object} response 
                         */
                        getUploadAttachmentsByWorkrequestIdInteractionIdLocale: function (workRequestId, interactionId, locale) {
                            return this._AgentControllerService.getUploadAttachmentsByWorkrequestIdInteractionIdLocale(this._acConfig, {workRequestId: workRequestId, interactionId: interactionId, locale: locale})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! UploadAttachments Page could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('UploadAttachments Page: %o:', response);
                            });
                        },
                        getUploadAttachmentsByWorkrequestIdInteractionIdLocaleDev: function (workRequestId, interactionId, locale) {
                            return this._AgentControllerService.getUploadAttachmentsByWorkrequestIdInteractionIdLocaleDev(this._acConfig, {workRequestId: workRequestId, interactionId: interactionId, locale: locale})
                                    .fail(function (response) {
                                        AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! UploadAttachments Page could not be Returned: %o:', response);
                                    }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('UploadAttachments Page: %o:', response);
                            });
                        },
                        /**
                         * 
                         * Delete an email attachment by the WorkRequestId, InteractionId and the AttachmentId
                         * 
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#deleteAttachmentByWorkRequestIdInteractionId
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} workRequestId
                         * @param {String} interactionId
                         * @param {String} attachmentId 
                         * @returns {Object} response 
                         */
                        deleteAttachmentByWorkRequestIdInteractionId: function (workRequestId, interactionId, attachmentId) {
                            return this._AgentControllerService.deleteAttachmentByWorkRequestIdInteractionId(this._acConfig, {workRequestId: workRequestId, interactionId: interactionId, attachmentId: attachmentId});
                        },
                        /**
                         * 
                         * cancel an email with an attachment by using the WorkRequestId and the InteractionId
                         * 
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#cancelEmailWithAttachmentByWorkRequestIdInteractionId
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} workRequestId
                         * @param {String} interactionId
                         * @returns {Object} response 
                         */
                        cancelEmailWithAttachmentByWorkRequestIdInteractionId: function (workRequestId, interactionId) {

                            return this._AgentControllerService.cancelEmailWithAttachmentByWorkRequestIdInteractionId(this._acConfig, {workRequestId: workRequestId, interactionId: interactionId});
                        },

                        /**
                         * 
                         * Upload Email Signature Image from Agent Controller
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#uploadEmailSignatureImage
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} GUID
                         * @param {String} Image Content (Base64)
                         * @returns {Object} response 
                         */ 
                        uploadEmailSignatureImage: function (guId, image) {
                            return this._AgentControllerService.uploadEmailSignatureImage(this._acConfig, {guId:guId, image:image})
                            .fail(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                            }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                            });
                        },

                        /**
                         * Get Email Signature Images from Agent Controller via GUID
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#retrieveEmailSignatureImages
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} GUID
                         * @returns {Object} response 
                         */ 
                        retrieveEmailSignatureImages: function (guId) {
                            return this._AgentControllerService.retrieveEmailSignatureImages(this._acConfig, {guId:guId})
                                .fail(function (response) {
                                    AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                                }).done(function (response) {
                                    AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                                });
                        },

                        /**
                         * Get Email Signature Image from Agent Controller via Hash
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#retrieveEmailSignatureImage
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} Hash
                         * @returns {Object} response 
                         */ 
                        retrieveEmailSignatureImage: function (hash) {
                            return this._AgentControllerService.retrieveEmailSignatureImage(this._acConfig, {hash:hash})
                            .fail(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                            }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                            });
                        },
                        
                        /**
                         * Delete Email Signature Images from Agent Controller by GUID
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#deleteEmailSignatureImages
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} GUID
                         * @returns {Object} response 
                         */ 
                        deleteEmailSignatureImages: function (guId) {
                            return this._AgentControllerService.deleteEmailSignatureImages(this._acConfig, {guId:guId})
                            .fail(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                            }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                            });
                        },

                        /**
                         * Delete Email Signature Image from Agent Controller by GUID and Hash
                         *
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#deleteEmailSignatureImage
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#    
                         * @param {String} GUID
                         * @param {String} Hash
                         * @returns {Object} response 
                         */ 
                        deleteEmailSignatureImage: function (guId, hash) {
                            return this._AgentControllerService.deleteEmailSignatureImage(this._acConfig, {guId:guId, hash:hash})
                            .fail(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                            }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                            });
                        },
                        
                        /**
                         * Upload an attachment or transfer a file.
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#uploadAttachment
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#   
                         * @param {String} workRequestId WorkRequestID for the contact. Used to check if the contact is a valid CHAT or EMAIL contact
                         * @param {String} interactionId InteractionId for the contact. Used to check if the contact is a valid CHAT or EMAIL contact
                         * @param {Array} files An array of Files
                         * @returns {Object} response
                         */
                        uploadAttachment: function(workRequestId, interactionId, files) {
                            return this._AgentControllerService.uploadAttachment(this._acConfig, workRequestId, interactionId, files)
                            .fail(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                            }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                            });
                        },
                        
                        /**
                         * Request the maximum file size in bytes.
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#requestMaxFileSize
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#   
                         * @param {String} workRequestId Used to check if the contact type is CHAT or EMAIL
                         * @param {String} interactionId Used to check if the contact type is CHAT or EMAIL
                         * @returns {Number} the file size in bytes. Will return 0 if invalid
                         */
                        requestMaxFileSize: function(workRequestId, interactionId) {
                            return this._AgentControllerService.requestMaxFileSize(this._acConfig, workRequestId, interactionId)
                            .fail(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('ERROR! Context could not be Returned: %o:', response);
                            }).done(function (response) {
                                AvayaCustomerInteractionUtilitiesClient.Base.Logger.log('Context: %o:', response);
                            });
                        },
                        
                        /**
                         * Check the version of the SDK.
                         * @public
                         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#getVersion
                         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#   
                         * @return {String} the version of Oceana in which this was built
                         */
                        getVersion: function() {
                            return this._AgentControllerService.getVersion();
                        }

                    };
            AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController = AgentController;

        })(AvayaCustomerInteractionUtilitiesClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController
     * @define AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerConstants
     * @property AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerConstants#
     */
    var AgentControllerConstants =  {
        SUCCESSSTATUSCODE : "200",
        NOTFOUNDSTATUSCODE : "404",
        FAILSTATUSCODE : "500",
        BADREQUESTSTATUSCODE : "400",
        REDIRECTSTATUSCODE : "302",
        SUCCESSRESULT: "success"
    };

    AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerConstants = AgentControllerConstants;

})(AvayaCustomerInteractionUtilitiesClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient, $) {
    'use strict';

    var AgentControllerRequestBuilder = {
        /** @requires AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController
         /** @lends AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder.prototype **/

        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#createAgentRequestSessionArguments
         * @memberof AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#
         * @description
         * Creates agent request session argument object with default options
         * @returns {{apikey: string, extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
         */
        createRequestSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent request session.
             * @type {{apikey: string,extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
             * @private
             */
            var _defaultAgentRequestSessionArguments = {
                apikey: 'defaultapikey',
                extkey: undefined,
                name: undefined,
                autoJoin: false,
                locale: 'en_US',
                emailid: undefined
            };
            return _defaultAgentRequestSessionArguments;
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#createJoinSessionArguments
         * @memberof AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#
         * @description
         * Creates join session argument object with default options
         * @returns {{acstoken: undefined, useragent: undefined}}
         */
        createJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins session
             * @type {{acstoken: undefined, useragent: undefined}}
             * @private
             */
            var _defaultAgentJoinSessionArguments = {
                acstoken: undefined,
                useragent: undefined
            };
            return _defaultAgentJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#createLiveJoinSessionArguments
         * @memberof AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#
         * @description
         * Creates join live (created by customer) session argument object with default options
         * @returns {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
         */
        createLiveJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins Live session.
             * @type {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
             * @private
             */
            var _defaultAgentLiveJoinSessionArguments = {
                sessionkey: undefined,
                name: undefined,
                clientname: undefined,
                emailid: undefined,
                extkey: undefined
            };
            return _defaultAgentLiveJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#createStatusArguments
         * @memberof AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#
         * @description
         * Creates status session argument object with default options
         * @returns {{acstoken: undefined}|*}
         */
        createStatusArguments: function () {
            /**
             * @description
             * Default arguments for status Agent session.
             * @type {{acstoken: undefined}}
             * @private
             */
            var _defaultAgentStatusArguments = {
                acstoken: undefined
            };
            return _defaultAgentStatusArguments;
        },
        /**
         * @public
         * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#createLogoutSessionArgs
         * @memberof AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerRequestBuilder#
         * @description
         * Creates logout session argument object with default options
         * @returns {{acstoken: undefined, reason: string}}
         */
        createLogoutSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent logout session.
             * @type {{acstoken: undefined, reason: 'logout',eurl: undefined}}
             * @private
             */
            var _defaultAgentLogoutSessionArguments = {
                acstoken: undefined,
                reason: 'logout',
                eurl: undefined
            };
            return _defaultAgentLogoutSessionArguments;
        }
    };

    $.extend(AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController.prototype, AgentControllerRequestBuilder);

})(AvayaCustomerInteractionUtilitiesClient, jQuery);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaCustomerInteractionUtilitiesClient) {
    'use strict';

    /**
     * @description
     *
     * Service class to connect the AgentController api to AgentController provider
     * @class
     * @define AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController
     * @constructor
     */
    function AgentControllerService(AgentController) {

        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
         */
        this._AgentControllerProvider = new AvayaCustomerInteractionUtilitiesClient.Providers.AgentController.AgentControllerProvider();

        this._AgentController = AgentController;

        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Config.AcConfiguration}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
         */
        this._acConfig = null;

        /**
         * @private
         * @type {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
         */
        this._acDataSet = new AvayaCustomerInteractionUtilitiesClient.Base.DataSet();
        
        /**
         * @private
         * @type {String}
         * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
         */
        this._version = "3.8.1.0";
    }

    /**
     * @description
     *
     * Generate Token
     * @public
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#generateToken
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentController#
     * @returns {||AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerPromise}
     */
    AgentControllerService.prototype.generateToken = function (acConfig, requestData) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.generateToken(this._acConfig, requestData);
    };

    /**
     * @description To get dataset
     * @function AvayaCoBrowseClientServices.Services.AgentController.AgentController#getDataSet
     * @memberOf AvayaCoBrowseClientServices.Services.AgentController.AgentController#
     * @returns {AvayaCoBrowseClientServices.Base.CobrowseDataSet}
     */
    AgentControllerService.prototype.getDataSet = function () {
        return this._acDataSet;
    };


    /**
     * @description To get Customer History By Action Id
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getCustomerHistoryByTranscriptId
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getCustomerHistoryByTranscriptId = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getCustomerHistoryByTranscriptId(this._acConfig, requestdata);
    };
    
    /**
     * @description To get Customer Details By Customer Id
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getCustomerDetails
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getCustomerDetails = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getCustomerDetails(this._acConfig, requestdata);
    };

    /**
     * @description To get Customer History By User Details
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getCustomerHistoryByUserDetails
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getCustomerHistoryByUserDetails = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getCustomerHistoryByUserDetails(this._acConfig, requestdata);
    };
    
    /**
     * @description To get Customer Search Result
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getCustomerSearchResult
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getCustomerSearchResult = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getCustomerSearchResult(this._acConfig, requestdata);
    };

    /**
     * @description To get Contact details By Contact Id
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getContactDetails
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getContactDetails = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getContactDetails(this._acConfig, requestdata);
    };
    
    /**
     * @description To get all templates from Database 
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getAllTemplates
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getAllTemplates = function (acConfig) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getAllTemplates(this._acConfig);
    };
    
    /**
     * @description To get template content By Template Id
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getTemplateById
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getTemplateById = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getTemplateById(this._acConfig, requestdata);
    };
    
    /**
     * @description To get template content By Template Id
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#insertTemplateAttachments
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.insertTemplateAttachments = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.insertTemplateAttachments(this._acConfig, requestdata);
    };
    
    /**
     * @description To get attachment content of the template By Attachment Id
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getTemplateAttachmentById
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getTemplateAttachmentById = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getTemplateAttachmentById(this._acConfig, requestdata);
    };
    
    /**
     * @description To get Upload Attachments By WorkRequest Id and Interaction Id and Locale
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getUploadAttachmentsByWorkrequestIdInteractionIdLocale
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.getUploadAttachmentsByWorkrequestIdInteractionIdLocale = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getUploadAttachmentsByWorkrequestIdInteractionIdLocale(this._acConfig, requestdata);
    };

    AgentControllerService.prototype.getUploadAttachmentsByWorkrequestIdInteractionIdLocaleDev = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.getUploadAttachmentsByWorkrequestIdInteractionIdLocaleDev(this._acConfig, requestdata);
    };

    /**
     * @description To delete an email attachment by Workrequest ID, Interaction ID and Attachment ID
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#deleteAttachmentByWorkRequestIdInteractionId
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.deleteAttachmentByWorkRequestIdInteractionId = function (acConfig, requestdata) {
        this._acConfig = acConfig;

        return this._AgentControllerProvider.deleteAttachmentByWorkRequestIdInteractionId(acConfig, requestdata);

    };

    /**
     * @description To delete an email with attachments by Workrequest ID, and Interaction ID 
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#cancelEmailWithAttachmentByWorkRequestIdInteractionId
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.cancelEmailWithAttachmentByWorkRequestIdInteractionId = function (acConfig, requestdata) {
        this._acConfig = acConfig;

        return this._AgentControllerProvider.cancelEmailWithAttachmentByWorkRequestIdInteractionId(acConfig, requestdata);

    };

    /**
     * @description To upload Email Signature Image
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#uploadEmailSignatureImage
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.uploadEmailSignatureImage = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.uploadEmailSignatureImage(this._acConfig, requestdata);
    };

    /**
     * @description To get Email Signature Images By GUID
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#retrieveEmailSignatureImages
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.retrieveEmailSignatureImages = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.retrieveEmailSignatureImages(this._acConfig, requestdata);
    };

    /**
     * @description To get Email Signature Image By Hash
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#retrieveEmailSignatureImage
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.retrieveEmailSignatureImage = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.retrieveEmailSignatureImage(this._acConfig, requestdata);
    };

    /**
     * @description To delete Email Signature Images By GUID
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#deleteEmailSignatureImages
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.deleteEmailSignatureImages = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.deleteEmailSignatureImages(this._acConfig, requestdata);
    };

    /**
     * @description To delete Email Signature Image By GUID and Hash
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#deleteEmailSignatureImage
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.deleteEmailSignatureImage = function (acConfig, requestdata) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.deleteEmailSignatureImage(this._acConfig, requestdata);
    };
    
    /**
     * @description Upload attachments via a POST request.
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#uploadAttachment
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @param {type} acConfig
     * @param {String} workRequestId
     * @param {String} interactionId
     * @param {Array} files
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.uploadAttachment = function(acConfig, workRequestId, interactionId, files) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.uploadAttachment(this._acConfig, workRequestId, interactionId, files);
    };
    
    /**
     * @description request the maximum file size. Uses the workRequestId and interactionId to check if this is a chat or email contact, and to return the maximum size.
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#uploadAttachment
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @param {type} acConfig
     * @param {String} workRequestId
     * @param {String} interactionId
     * @returns {AvayaCustomerInteractionUtilitiesClient.Base.DataSet}
     */
    AgentControllerService.prototype.requestMaxFileSize = function(acConfig, workRequestId, interactionId) {
        this._acConfig = acConfig;
        return this._AgentControllerProvider.requestMaxFileSize(this._acConfig, workRequestId, interactionId);
    };

    AgentControllerService.prototype.onFailure = function (error, dfd) {
        var message = error.getMessage();
        AvayaCustomerInteractionUtilitiesClient.Base.Logger.error(error.getReason(), message);
        dfd.reject(new AvayaCustomerInteractionUtilitiesClient.Base.AgentControllerError(error.getErrorCode(), error.getReason(), message));
    };
    
    /**
     * @description request the version and sprint number.
     * @function AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#getVersion
     * @memberOf AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService#
     * @returns {String} the version of the SDK.
     */
    AgentControllerService.prototype.getVersion = function() {
        return this._version;
    };

    AvayaCustomerInteractionUtilitiesClient.Services.AgentController.AgentControllerService = AgentControllerService;

})(AvayaCustomerInteractionUtilitiesClient);