var windowWidth = 0;
var debug = false;
if (document.body && document.body.offsetWidth) {
 windowWidth = document.body.offsetWidth;
}
if (document.compatMode=='CSS1Compat' &&
    document.documentElement &&
    document.documentElement.offsetWidth ) {
 windowWidth = document.documentElement.offsetWidth;
}
if (window.innerWidth) {
 windowWidth = window.innerWidth;
}
function adjustTitleDisplay() {
  var doctitleElem = document.getElementById("doctitle");
  var doctitle;
  if (doctitleElem.innerText) {
    doctitle = doctitleElem.innerText;
  } else if (doctitleElem.text) {
    doctitle = doctitleElem.text;
  } else if (doctitleElem.textContent) {
    doctitle = doctitleElem.textContent;
  } else {
    return;
  }
  var titleCharCt = doctitle.length;
  var wrap = 'no';
  /* This algorithm compares the browser window width against the estimated
     title width. It the estimated title width is greater than the browser
     window with, the code changes the table's class to 'longtitle'. Formatting
     for both the 'longtitle' class and the default 'normaltitle' class are
     contained in headline.css. The longtitle class sets the margin-top property
     to a small negative value to provide room for a two-line title.

     If the font size is changed, the algorithms for estimating title width
     must be re-derived through trial and error. Both the coeeficient and the
     offset will change. This algorithm performs best between title lengths between
     40 and 50 characters. The performance degrades as windows get much
     wider than that. Some non-linear equation would perform better.
  */
  var estimatedTitleWidth = 0; 
  if (navigator.appName=='Netscape') {
    //Firefox and Chrome
    estimatedTitleWidth =  titleCharCt*14.4 + 70;
  } else {
    //Internet Explorer
    estimatedTitleWidth =  titleCharCt*14.5 + 60;
  }
  if (debug) {
    alert('windowWidth='+windowWidth+
          ', estimatedTitleWidth='+estimatedTitleWidth+
          ', navigator.appName='+navigator.appName); 
  }
  if (windowWidth <= (estimatedTitleWidth)) {
    wrap = 'yes';
  }
  if (wrap=='yes') {
    document.getElementById("headlinetable").setAttribute('class', 'longtitle');
  }
  return;
}
