/*
* Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
* The copyright notice above does not evidence any actual or intended publication of such source code.
* Some third-party source code components may have been modified from their original versions by Avaya.
* The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
* May not be distributed further without written permission of the Avaya owner.
*/
(function (root, factory) {
  if (root === undefined && window !== undefined) root = window;
  if (typeof define === 'function' && define.amd) {
    define(["lodash","rsvp","atmosphere","WebSocket","XMLHttpRequest"], function (a0,b1,c2,d3,e4) {
      return (root['AvayaCustomerServices'] = factory(a0,b1,c2,d3,e4));
    });
  } else if (typeof module === 'object' && module.exports) {
    module.exports = factory(require("lodash"),require("rsvp"),require("atmosphere.js"),require("ws"),require("xmlhttprequest").XMLHttpRequest);
  } else {
    root['AvayaCustomerServices'] = factory(root["_"],root["RSVP"],root["atmosphere"],root["WebSocket"],root["XMLHttpRequest"]);
  }
}(this, function (_, RSVP, atmosphere, WebSocket, XMLHttpRequest) {

/**
 * @file Lodash mixin helper functions
 * @author John Brennan [brennan5@avaya.com]
 * @version 1.0.0
 */
(function (root, factory) {
    if (root === undefined && window !== undefined) root = window;
    if (typeof define === 'function' && define.amd) {
        define(['lodash'], function (a0) {
            return (root['_'] = factory(a0));
        });
    } else if (typeof module === 'object' && module.exports) {
        module.exports = factory(require('lodash'));
    } else {
        root['_'] = factory(root['_']);
    }
}(this, function (_) {

    /**
     * @file Lodash mixin helper functions
     * @author John Brennan [brennan5@avaya.com]
     * @version 1.0.0
     */
    var toString = Object.prototype.toString;
    function getPropertyType(prop) {
        var type = toString.call(prop);
        var regex = /object\s(\w+)/;
        return regex.exec(type)[1];
    }
    function isWritable(obj, prop) {
        var descriptor = Object.getOwnPropertyDescriptor(obj, prop);
        return descriptor.writable || _.isUndefined(descriptor.writable);
    }
    function updateByDeep(destination, source) {
        _.forEach(source, function (prop, key) {
            if (_.has(destination, key) && isWritable(destination, key)) {
                if (getPropertyType(source[key]) === 'Object') {
                    updateByDeep(destination[key], source[key]);
                } else {
                    destination[key] = source[key];
                }
            }
        });
        return destination;
    }
    function assignSafe(destination, source) {
        _.forEach(source, function (prop, key) {
            if (_.has(destination, key) && !_.isUndefined(prop)) {
                destination[key] = source[key];
            }
        });
        return destination;
    }
    function mergeArrayWith(destination, source, identifier) {
        if (!_.isArray(destination) || !_.isArray(source) || !identifier) {
            return;
        }
        var criteria = {};
        _.forEach(destination, function (dest, key) {
            criteria[identifier] = dest[identifier];
            if (!_.find(source, criteria)) {
                destination.splice(key, 1);
            }
        });
        _.forEach(source, function (src) {
            criteria[identifier] = src[identifier];
            var found = _.find(destination, criteria);
            if (found) {
                _.assignIn(found, src);
            } else {
                destination.push(src);
            }
        });
        return destination;
    }
    _.mixin({'updateByDeep': updateByDeep});
    _.mixin({'assignSafe': assignSafe});
    _.mixin({'mergeArrayWith': mergeArrayWith});

    return _;

}));
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Entry point to Customer Interaction Services Package SDK
 */
(function () {
    'use strict';

    /**
     * Initializes AvayaCustomerServices
     *
     * @class
     * @memberOf window
     * @define AvayaCustomerServices
     * @param {Object} config AvayaCustomerServices configuration object
     */
    function AvayaCustomerServices(config) {
        /**
         * @private
         * @type {Object}
         */
        this._config = config;
        /**
         * @private
         * @type {AvayaCustomerServices.ClientSession}
         */
        this._clientSession = undefined;
    }

    AvayaCustomerServices.prototype =
    /** @lends AvayaCustomerServices **/
    {
        /**
         * Create a client session in AvayaCustomerServices SDK
         *
         * @public
         * @function AvayaCustomerServices#createClientSession
         * @returns {AvayaCustomerServices.ClientSession}
         */
        createClientSession: function () {
            if (!this._clientSession) {
                this._clientSession = new AvayaCustomerServices.ClientSession(this._config);
            }
            return this._clientSession;
        },
        /**
         * Removes client session in AvayaCustomerServices SDK
         *
         * @public
         * @function AvayaCustomerServices#removeClientSession
         */
        removeClientSession: function () {
            if (this._clientSession) {
                this._clientSession.stop();
                this._config = undefined;
                this._clientSession = undefined;
            }
        },
        /**
         * Register a logger with AvayaCustomerServices SDK
         *
         * @public
         * @function window.AvayaCustomerServices#registerLogger
         * @param {Function|Object} logger Logger to use for managing log messages
         */
        registerLogger: function (logger) {
            AvayaCustomerServices.Base.Logger.addLogger(logger);
        }
    };

    /**
     * Version of AvayaCustomerServices SDK
     *
     * @public
     * @readonly
     * @type {string}
     */
    Object.defineProperty(AvayaCustomerServices, 'version', {value: '3.8.1.1'});

    this.AvayaCustomerServices = AvayaCustomerServices;

}.call(this));

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines SDK API namespaces
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * AvayaCustomerServices.Config contains prototypes of config objects which are necessary to provide connection with various servers used by AvayaCustomerServices SDK.
     * @namespace AvayaCustomerServices.Config
     * @define AvayaCustomerServices.Config
     */
    AvayaCustomerServices.Config = AvayaCustomerServices.Config || {};
    /**
     * AvayaCustomerServices.Services contains all service APIs
     * @namespace AvayaCustomerServices.Services
     * @define AvayaCustomerServices.Services
     */
    AvayaCustomerServices.Services = AvayaCustomerServices.Services || {};
    /**
     * AvayaCustomerServices.Services.Agent contains all classes that belong to Agent module.
     * @namespace AvayaCustomerServices.Services.Agent
     * @define AvayaCustomerServices.Services.Agent
     */
    AvayaCustomerServices.Services.Agent = AvayaCustomerServices.Services.Agent || {};
    /**
     * AvayaCustomerServices.Services.Work contains all classes that belong to Work module.
     * @namespace AvayaCustomerServices.Services.Work
     * @define AvayaCustomerServices.Services.Work
     */
    AvayaCustomerServices.Services.Work = AvayaCustomerServices.Services.Work || {};
    /**
     * AvayaCustomerServices.Services.Team contains all classes that belong to Team module.
     * @namespace AvayaCustomerServices.Services.Team
     * @define AvayaCustomerServices.Services.Team
     */
    AvayaCustomerServices.Services.Team = AvayaCustomerServices.Services.Team || {};
    /**
     * AvayaCustomerServices.Services.Contacts contains all classes that belong to Contacts module.
     * @namespace AvayaCustomerServices.Services.Contacts
     * @define AvayaCustomerServices.Services.Contacts
     */
    AvayaCustomerServices.Services.Contacts = AvayaCustomerServices.Services.Contacts || {};
    /**
     * AvayaCustomerServices.ClientSession contains all classes that belong to ClientSession module.
     * @namespace AvayaCustomerServices.ClientSession
     * @define AvayaCustomerServices.ClientSession
     */
    AvayaCustomerServices.ClientSession = AvayaCustomerServices.ClientSession || {};

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Extended Namespaces for Client SDK
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @namespace AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base
     */
    AvayaCustomerServices.Base = AvayaCustomerServices.Base || {};
    /**
     * @namespace AvayaCustomerServices.Base.Authentication
     * @define AvayaCustomerServices.Base.Authentication
     */
    AvayaCustomerServices.Base.Authentication = AvayaCustomerServices.Base.Authentication || {};
    /**
     * @namespace AvayaCustomerServices.Base.Collections
     * @define AvayaCustomerServices.Base.Collections
     */
    AvayaCustomerServices.Base.Collections = AvayaCustomerServices.Base.Collections || {};
    /**
     * @namespace AvayaCustomerServices.Base.Network
     * @define AvayaCustomerServices.Base.Network
     */
    AvayaCustomerServices.Base.Network = AvayaCustomerServices.Base.Network || {};
    /**
     * @namespace AvayaCustomerServices.Providers
     * @define AvayaCustomerServices.Providers
     */
    AvayaCustomerServices.Providers = AvayaCustomerServices.Providers || {};
    /**
     * @namespace AvayaCustomerServices.Providers.Interfaces
     * @define AvayaCustomerServices.Providers.Interfaces
     */
    AvayaCustomerServices.Providers.Interfaces = AvayaCustomerServices.Providers.Interfaces || {};
    /**
     * @namespace AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common
     */
    AvayaCustomerServices.Providers.Common = AvayaCustomerServices.Providers.Common || {};
    /**
     * @namespace AvayaCustomerServices.Providers.UAC
     * @define AvayaCustomerServices.Providers.UAC
     */
    AvayaCustomerServices.Providers.UAC = AvayaCustomerServices.Providers.UAC || {};
    /**
     * @namespace AvayaCustomerServices.Providers.ADF
     * @define AvayaCustomerServices.Providers.ADF
     */
    AvayaCustomerServices.Providers.ADF = AvayaCustomerServices.Providers.ADF || {};
    /**
     * @namespace AvayaCustomerServices.Providers.CP
     * @define AvayaCustomerServices.Providers.CP
     */
    AvayaCustomerServices.Providers.CP = AvayaCustomerServices.Providers.CP || {};
    /**
     * @namespace AvayaCustomerServices.Providers.Kazoo
     * @define AvayaCustomerServices.Providers.Kazoo
     */
    AvayaCustomerServices.Providers.Kazoo = AvayaCustomerServices.Providers.Kazoo || {};
    /**
     * @namespace AvayaCustomerServices.Providers.Spoken
     * @define AvayaCustomerServices.Providers.Spoken
     */
    AvayaCustomerServices.Providers.Spoken = AvayaCustomerServices.Providers.Spoken || {};

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Authentication Constants
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @memberOf AvayaCustomerServices.Base.Authentication
     * @define AvayaCustomerServices.Base.Authentication.Constants
     */
    var Constants = {};
    /**
     * Lists all token types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Base.Authentication.Constants
     * @define AvayaCustomerServices.Base.Authentication.Constants.TokenTypes
     */
    Constants.TokenTypes = {
        EDP_SSO_Token: 'EDP_SSO_Token',
        UAC_Token: 'UAC_Token',
        token: 'Token'
    };
    /**
     * Lists all token headers
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Base.Authentication.Constants
     * @define AvayaCustomerServices.Base.Authentication.Constants.Headers
     */
    Constants.Headers = {
        EDP_SSO_Token: 'X-EDP_SSO_Token',
        //UAC_Token: 'X-UAC_Token',
        UAC_Token: 'AuthToken',
        Token: 'Authorization'
    };

    AvayaCustomerServices.Base.Authentication.Constants = Constants;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Token Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @class
     * @classdesc Token Provider fetches tokens from Token Collection
     * @memberOf AvayaCustomerServices.Base.Authentication
     * @define AvayaCustomerServices.Base.Authentication.TokenProvider
     *
     * @description TokenProvider Constructor function
     * @param {AvayaCustomerServices.Base.Authentication.TokenCollection} tokenCollection
     * @param {AvayaCustomerServices.Config.AuthenticationInfo} config
     */
    function TokenProvider(tokenCollection, config) {
        /**
         * @type {AvayaCustomerServices.Base.Authentication.TokenCollection}
         * @private
         */
        this._tokenCollection = tokenCollection;
        /**
         * @type {AvayaCustomerServices.Config.AuthenticationInfo}
         * @private
         */
        this._config = config;
    }

    TokenProvider.prototype =
    /** @lends AvayaCustomerServices.Base.Authentication.TokenProvider */
    {
        /**
         * Get all authentication tokens
         *
         * @public
         * @function AvayaCustomerServices.Base.Authentication.TokenProvider#getTokens
         * @returns {Object} A list of tokens for each token type
         */
        getTokens: function () {
            var tokens, header;
            var result = {};
            if (this._config && this._config.enabled) {
                tokens = this._tokenCollection.findAllByTokenTypes(this._config.tokens);
                _.forEach(tokens, function (token) {
                    header = token.getHeader();
                    result[header] = token.getValue();
                });
            }
            return result;
        }
    };

    AvayaCustomerServices.Base.Authentication.TokenProvider = TokenProvider;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Callbacks
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Manages a list of callback objects
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Callbacks
     *
     * @description Callbacks constructor function
     */
    function Callbacks() {
        /**
         * @private
         * @type {Array}
         */
        this._callbacks = [];
    }

    Callbacks.prototype =
    /** @lends AvayaCustomerServices.Base.Callbacks */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Base.Callbacks#add
         * @param {Function} callback
         */
        add: function (callback) {
            this._callbacks.push(callback);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Callbacks#fire
         */
        fire: function () {
            var callbackArgs = arguments;
            _.forEach(this._callbacks, function (callback) {
                callback.apply(null, callbackArgs);
            });
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Callbacks#remove
         * @param {Function} callback
         */
        remove: function (callback) {
            var index = _.indexOf(this._callbacks, callback);
            if (index !== -1) {
                this._callbacks.splice(index, 1);
            }
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Callbacks#empty
         */
        empty: function () {
            this._callbacks = [];
        }
    };

    AvayaCustomerServices.Base.Callbacks = Callbacks;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Generic Collection
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Collection for managing an array of {@link Model} types.
     * @define AvayaCustomerServices.Base.Collections.Collection
     * @memberOf AvayaCustomerServices.Base.Collections
     *
     * @description Constructor function for Collection
     * @param {function} model Namespace of model
     * @param {{idAttribute}} [options] Model options
     */
    function Collection(model, options) {
        /**
         * @protected
         * @type {function}
         */
        this._model = model;
        /**
         * @protected
         * @type {string}
         */
        this._modelOptions = _.assignIn({idAttribute: 'id'}, options);
        /**
         * @protected
         * @type {string}
         */
        this._modelId = this._modelOptions.idAttribute;
        /**
         * @protected
         * @type {AvayaCustomerServices.Base.Collections.Model[]}
         */
        this._collection = [];
    }

    Collection.prototype =
    /** @lends AvayaCustomerServices.Base.Collections.Collection */
    {
        /**
         * Create new Model instance and populate with param data
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#add
         * @param {Object} data Data for populating new model instance
         * @returns {AvayaCustomerServices.Base.Collections.Model}
         */
        add: function (data) {
            var model = this.find({id: data[this._modelId]});
            if (!model) {
                model = new this._model(this._modelOptions);
                model.setData(data);
                this._collection.push(model);
            }
            return model;
        },
        /**
         * Update Model with param data
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#edit
         * @param {Object} data Updated data for Model
         * @returns {AvayaCustomerServices.Base.Collections.Model}
         */
        edit: function (data) {
            var model = this.find({id: data[this._modelId]});
            if (!model) {
                return this.add(data);
            }
            model.setData(data);
            return model;
        },
        /**
         * Remove Model matching param data
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#remove
         * @param {Object} data Criteria used to find model
         * @returns {AvayaCustomerServices.Base.Collections.Model}
         */
        remove: function (data) {
            var model;
            var index = this.findIndex({id: data[this._modelId]});
            if (index !== -1) {
                model = this._collection.splice(index, 1)[0];
            }
            return model;
        },
        /**
         * Remove all models from collection
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#empty
         * @returns {AvayaCustomerServices.Base.Collections.Model[]} Collection of models
         */
        empty: function () {
            var data = this._collection;
            this._collection = [];
            return data;
        },
        /**
         * Find Model matching param criteria
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#find
         * @param {Array|Function|Object|string} criteria Criteria used to find model
         * @returns {AvayaCustomerServices.Base.Collections.Model}
         */
        find: function (criteria) {
            return _.find(this._collection, criteria);
        },
        /**
         * Find index of Model matching param criteria
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#findIndex
         * @param {Array|Function|Object|string} criteria Criteria used to find model index
         * @returns {number} index of collections array
         */
        findIndex: function (criteria) {
            var model = _.find(this._collection, criteria);
            return _.indexOf(this._collection, model);
        },
        /**
         * Find all models using param criteria
         *
         * @public
         * @function AvayaCustomerServices.Base.Collections.Collection#findAll
         * @param {Array|Function|Object|string} criteria Criteria used to find all models
         * @returns {AvayaCustomerServices.Base.Collections.Model[]}
         */
        findAll: function (criteria) {
            return _.filter(this._collection, criteria);
        }
    };

    AvayaCustomerServices.Base.Collections.Collection = Collection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Model interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Generic Model belonging to Collection.
     * @define AvayaCustomerServices.Base.Collections.Model
     * @memberOf AvayaCustomerServices.Base.Collections
     *
     * @description Constructor function for generic Model
     * @param {{idAttribute}} [options] Model options
     */
    function Model(options) {
        /**
         * A unique identifier for this model instance
         *
         * @public
         * @type {string}
         */
        this.id = undefined;
        /**
         * Flag to indicate if model instance is new
         *
         * @public
         * @type {boolean}
         */
        this.isNew = false;
        /**
         * Default options for model instance
         *
         * @ignore
         * @protected
         * @type {string}
         */
        this._options = _.assignIn({idAttribute: 'id'}, options);
        /**
         * Name of property to use as the id attribute of this model
         *
         * @ignore
         * @protected
         * @type {string}
         */
        this._id = this._options.idAttribute;
        /**
         * Generic object in which to store model data
         *
         * @public
         * @type {object}
         */
        this.data = {};
    }

    Model.prototype =
    /** @lends AvayaCustomerServices.Base.Collections.Model */
    {
        /**
         * Set model data
         *
         * @private
         * @function AvayaCustomerServices.Base.Collections.Model#setData
         * @param {Object} data Data to set
         * @returns {object} Resultant data set in model
         */
        setData: function (data) {
            if (_.isUndefined(this.id) && !_.isUndefined(data[this._id])) {
                this.id = data[this._id];
            }
            this.isNew = _.isEmpty(this.data);
            return _.assignIn(this.data, data);
        }
    };

    AvayaCustomerServices.Base.Collections.Model = Model;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Constants
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.8.1.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Constants
     */
    var Constants = {};
    /**
     * Lists all Error types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Base.Constants
     * @define AvayaCustomerServices.Base.Constants.errorType
     */
    Constants.errorType = {
        EXTERNAL_SERVICE: 'EXTERNAL_SERVICE',
        INTERNAL_SERVICE: 'INTERNAL_SERVICE',
        NOTIFICATION_PROVIDER_AS_MESSAGE: 'NOTIFICATION_PROVIDER_AS_MESSAGE',
        NOTIFICATION_PROVIDER_CONNECTION: 'NOTIFICATION_PROVIDER_CONNECTION',
        REST_PROVIDER_XHR: 'REST_PROVIDER_XHR',
    };
  
    AvayaCustomerServices.Base.Constants = Constants;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Error Class
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @class
     * @classdesc Error class
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Error
     *
     * @description Error constructor function
     */
    function Error(err) {
        /**
         * @public
         * @type {string}
         */
        this.message = err.message;
        /**
         * @public
         * @type {string}
         */
        this.reason = err.reason;
        /**
         * @public
         * @type {string}
         */
        this.status = err.status || 0;
        /**
         * @public
         * @type {string}
         */
        this.code = err.code || 0;
        /**
         * @public
         * @type {string}
         */
        this.scope = err.scope || 'AvayaCustomerServices';
        /**
         * @public
         * @type {string}
         */
        this.severity = err.severity || 'NORMAL';
        /**
         * @public
         * @type {string|null}
         */
        this.scopeId = err.scopeId || null;
        /**
         * @public
         * @type {string|null}
         */
        this.source = err.source || null;
        /**
         * @public
         * @type {object|null}
         */
        this.context = err.context || null;
        /**
         * @public
         * @type {string|null}
         */
        this.type = err.type || null;
    }

    Error.prototype =
    /** @lends AvayaCustomerServices.Base.Error */
    {

    };

    AvayaCustomerServices.Base.Error = Error;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Logger
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @private
     * @type {Object[]}
     */
    var loggers = [];

    /**
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Logger
     */
    AvayaCustomerServices.Base.Logger = {
        /**
         * Output log message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#log
         * @param {string} level Type of log message
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        log: function (level, message, meta) {
            loggers.forEach(function (logger) {
                externalLog(logger, level, message, meta);
            });
        },
        /**
         * Output info message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#info
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        info: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.info === 'function') {
                    standardLog(logger, 'info', message, meta);
                } else {
                    externalLog(logger, 'info', message, meta);
                }
            });
        },
        /**
         * Output error message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#error
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        error: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.error === 'function') {
                    standardLog(logger, 'error', message, meta);
                } else {
                    externalLog(logger, 'error', message, meta);
                }
            });
        },
        /**
         * Output fatal message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#fatal
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        fatal: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.fatal === 'function') {
                    standardLog(logger, 'fatal', message, meta);
                } else {
                    externalLog(logger, 'fatal', message, meta);
                }
            });
        },
        /**
         * Output debug message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#debug
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        debug: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.debug === 'function') {
                    standardLog(logger, 'debug', message, meta);
                } else {
                    externalLog(logger, 'debug', message, meta);
                }
            });
        },
        /**
         * Output trace message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#trace
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        trace: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.trace === 'function') {
                    standardLog(logger, 'trace', message, meta);
                } else {
                    externalLog(logger, 'trace', message, meta);
                }
            });
        },
        /**
         * Output warn message
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#warn
         * @param {string} message Message to log
         * @param {Object} [meta] Optional meta data
         */
        warn: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.warn === 'function') {
                    standardLog(logger, 'warn', message, meta);
                } else {
                    externalLog(logger, 'warn', message, meta);
                }
            });
        },
        /**
         * Add logger
         *
         * @public
         * @function AvayaCustomerServices.Base.Logger#addLogger
         * @param {Object} logger
         */
        addLogger: function (logger) {
            if (!logger || typeof logger.log === 'undefined') {
                throw new TypeError('Logger should implement log method.');
            }
            loggers.push(logger);
        },
        /**
         * Remove logger
         *
         * @public
         * @function
         * @param {Object} logger
         */
        removeLogger: function (logger) {
            var index = loggers.indexOf(logger);
            if (index === -1) {
                throw new Error('Specified error does not exist.');
            }
            loggers.splice(index, 1);
        }
    };

    /**
     * Log message to standard log
     *
     * @private
     * @function standardLog
     * @param {Object} logger Logger to use
     * @param {string} level Severity level of log message
     * @param {string} message Message to log
     * @param {string} [meta] Meta data
     */
    function standardLog(logger, level, message, meta) {
        if (_.isUndefined(meta)) {
            logger[level](message);
        } else {
            logger[level](message, meta);
        }
    }

    /**
     * Log message to external log
     *
     * @private
     * @function standardLog
     * @param {Object} logger Logger to use
     * @param {string} level Severity level of log message
     * @param {string} message Message to log
     * @param {string} [meta] Meta data
     */
    function externalLog(logger, level, message, meta) {
        if (_.isUndefined(meta)) {
            logger.log(level, message);
        } else {
            logger.log(level, message, meta);
        }
    }

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Base Mediator
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.4.0.0
 */
(function (AvayaCustomerServices, _, Promise) {
    'use strict';
    /**
     * @class
     * @classdesc This is the mediator for managing the link between services and providers.
     * Mediator sorts out what providers are needed for each service (based on user configuration).
     * This class is intended to be used internally only.
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Mediator
     *
     * @description Constructor function for Mediator
     */
    function Mediator() {
        /**
         * @private
         * @type {Object}
         */
        this._providers = {};
    }

    Mediator.prototype =
    /** @lends AvayaCustomerServices.Base.Mediator */
    {
        /**
         * @function AvayaCustomerServices.Base.Mediator#injectProvider
         * @param {AvayaCustomerServices.Base.Mediator.Provider} provider
         * @param {string} providerName
         */
        injectProvider: function (provider, providerName) {
            this._providers[providerName] = provider;
            _.forEach(Object.getPrototypeOf(provider), _.bind(bindMethods, null, this, this._providers));
        },
        /**
         * @function AvayaCustomerServices.Base.Mediator#removeProvider
         * @param {string} providerName
         */
        removeProvider: function (providerName) {
            delete this._providers[providerName];
        }
    };

    function bindMethods(mediator, providers, method, name) {
        mediator[name] = function() {
            var promises = [];
            var args = arguments;
            _.forEach(providers, function (provider) {
                if (provider[name] && _.isFunction(provider[name]) && provider.isMethodEnabled(name)) {
                    promises.push(provider[name].apply(provider, args));
                }
            });
            if (promises.length === 1) {
                return promises[0];
            }
            return Promise.all(promises);
        };
    }

    AvayaCustomerServices.Base.Mediator = Mediator;



})(AvayaCustomerServices, _, RSVP);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.4.0.0
 * @classdesc Defines Prerequisite API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for Prerequisite Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Base.Mediator
     * @define AvayaCustomerServices.Base.Mediator.Prerequisite
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     * @param {Object} [options] Model options
     */
    function Prerequisite(options) {
        AvayaCustomerServices.Base.Collections.Model.call(this, options);
    }

    Prerequisite.prototype =
    /** @lends AvayaCustomerServices.Base.Mediator.Prerequisite */
    {

    };

    _.defaults(Prerequisite.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Base.Mediator.Prerequisite = Prerequisite;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.4.0.0
 * @classdesc Collection for managing an array of {@link Prerequisite} types.
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Constructor function for Prerequisite Collection
     *
     * @class
     * @define AvayaCustomerServices.Base.Mediator.PrerequisiteCollection
     * @memberOf AvayaCustomerServices.Base.Mediator
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     */
    function PrerequisiteCollection() {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Base.Mediator.Prerequisite);
    }

    PrerequisiteCollection.prototype =
    /** @lends AvayaCustomerServices.Base.Mediator.PrerequisiteCollection */
    {
        /**
         * Fetch Model matching param criteria, create one if it does not exist
         *
         * @public
         * @function AvayaCustomerServices.Base.Mediator.PrerequisiteCollection#fetchByName
         * @param {string[]} prerequisites Array of prerequisite strings
         * @returns {Object}
         */
        fetchByName: function (prerequisites) {
            var result = {};
            _.forEach(prerequisites, _.bind(function (prerequisite) {
                var foundPrerequisite = this.find({id: prerequisite});
                if (!foundPrerequisite) {
                    var prerequisiteData = _.find(PrerequisiteCollection.Types, {key: prerequisite});
                    if (prerequisiteData) {
                        foundPrerequisite = prerequisiteData.initScript();
                        foundPrerequisite.id = prerequisite;
                        this.add(foundPrerequisite);
                    }
                }
                result[prerequisite] = foundPrerequisite;
            }, this));
            return result;
        }
    };

    PrerequisiteCollection.Types = [{
        key: 'tokenCollection',
        initScript: function () {
            return new AvayaCustomerServices.Base.Authentication.TokenCollection();
        }
    }];

    _.defaults(PrerequisiteCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Base.Mediator.PrerequisiteCollection = PrerequisiteCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.4.0.0
 * @classdesc Defines Provider API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for Provider Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Base.Mediator
     * @define AvayaCustomerServices.Base.Mediator.Provider
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     * @param {Object} [options] Model options
     */
    function Provider(options) {
        AvayaCustomerServices.Base.Collections.Model.call(this, options);
    }

    Provider.prototype =
    /** @lends AvayaCustomerServices.Base.Mediator.Provider */
    {

    };

    _.defaults(Provider.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Base.Mediator.Provider = Provider;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc HTTP Request Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc HTTPRequest manages low level XHR requests
     * @define AvayaCustomerServices.Base.Network.HTTPRequest
     * @memberOf AvayaCustomerServices.Base.Network
     *
     * @description Constructor function for HTTP Requests
     * @param {{withCredentials}} options
     */
    function HTTPRequest(options) {
        /**
         * @type {XMLHttpRequest|ActiveXObject}
         * @private
         */
        this._xhr = undefined;
        /**
         * Determine which AJAX object to use
         */
        if (XMLHttpRequest) {
            this._xhr = new XMLHttpRequest();
        } else if (ActiveXObject) {
            try {
                this._xhr = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                this._xhr = new ActiveXObject("Microsoft.XMLHTTP");
            }
        } else {
            AvayaCustomerServices.Base.Logger.error('HTTPRequest', {
                error: 'There is no XHR protocol available for HTTP Requests'
            });
            throw new Error('There is no XHR protocol available for HTTP Requests');
        }
        /**
         * {@link https://xhr.spec.whatwg.org/#the-withcredentials-attribute}
         * @type {boolean}
         */
        this._xhr.withCredentials = options.withCredentials;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-onloadstart}
         * @param {{target}} loadstart
         */
        this._xhr.onloadstart = logXHRProgress;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-onprogress}
         * @param {{target}} progress
         */
        this._xhr.onprogress = logXHRProgress;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-onabort}
         * @param {{target}} abort
         */
        this._xhr.onabort = logXHRProgress;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-onerror}
         * @param {{target}} error
         */
        this._xhr.onerror = logXHRProgress;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-onload}
         * @param {{target}} load
         */
        this._xhr.onload = logXHRProgress;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-ontimeout}
         * @param {{target}} timeout
         */
        this._xhr.ontimeout = logXHRProgress;
        /**
         * {@link https://xhr.spec.whatwg.org/#handler-xhr-onloadend}
         * @param {{target}} loadend
         */
        this._xhr.onloadend = logXHRProgress;
    }

    HTTPRequest.prototype =
    /** @lends AvayaCustomerServices.Base.Network.HTTPRequest */
    {
        /**
         * Encode data as URL query params
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#encode
         * @param {string|object} [data={}] Data to encode
         * @returns {string} payload Encoded data as URL query params
         */
        encode: function (data) {
            data = data || {};
            if (typeof data === "string") {
                return data;
            } else {
                var params = [];
                _.forEach(data, function (value, key) {
                    params.push(encodeURIComponent(key) + '=' + encodeURIComponent(value));
                });
                return params.join('&');
            }
        },
        /**
         * Set Request Header for XHR Request
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#setRequestHeader
         * @param {string} header Name of header to set
         * @param {string} content Header content to set
         */
        setRequestHeader: function (header, content) {
            this._xhr.setRequestHeader(header, content);
        },
        /**
         * Set Multiple REquest Headers for XHR Request
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#setRequestHeaders
         * @param {Object} headers List of headers to set
         */
        setRequestHeaders: function (headers) {
            var contentType = 'application/x-www-form-urlencoded';
            _.forEach(headers, _.bind(function (content, header) {
                if (header.toLowerCase() === 'content-type') {
                    contentType = content;
                } else {
                    this.setRequestHeader(header, content);
                }
            }, this));
            this.setRequestHeader('Content-Type', contentType);
        },
        /**
         * Set timeout for XHR Request
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#setTimeout
         * @param {number} timeout XHR timeout
         */
        setTimeout: function (timeout) {
            if (timeout && typeof timeout === "number") {
              this._xhr.timeout = timeout;
            }
        },
        /**
         * Open XHR Request
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#open
         * @param {string} method HTTP request method (e.g. GET, POST, etc.)
         * @param {string} url URL of the HTTP request
         * @param {boolean} async Make this call asynchronous
         */
        open: function (method, url, async) {
            this._xhr.open(method, url, async);
        },
        /**
         * Abort XHR Request
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#abort
         */
        abort: function () {
            this._xhr.abort();
        },
        /**
         * Send XHR Request
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#send
         * @param {string} data Content to send
         */
        send: function (data) {
            this._xhr.send(data);
        },
        /**
         * Add a callback to be executed on XHR Request state change
         *
         * @public
         * @function AvayaCustomerServices.Base.Network.HTTPRequest#addOnStateChangeCallback
         * @param {function} callback
         */
        addOnStateChangeCallback: function (callback) {
            this._xhr.onreadystatechange = callback;
        }
    };

    /**
     * Log XHR request progress
     *
     * @private
     * @function logXHRProgress
     * @param {{target}} data
     */
    function logXHRProgress(data) {
        var payload = data && data.target ? data.target : 'logXHRProgress';
        AvayaCustomerServices.Base.Logger.debug('HTTPRequest', payload);
    }

    AvayaCustomerServices.Base.Network.HTTPRequest = HTTPRequest;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Notification Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, Notification, _) {
    'use strict';
    /**
     * @class
     * @classdesc NotificationProvider manages asynchronous notification from remote API
     * @define AvayaCustomerServices.Base.Network.AtmosphereProvider
     * @memberOf AvayaCustomerServices.Base
     *
     * @description Constructor function for Notification Provider
     * @param {AvayaCustomerServices.Base.Authentication.TokenProvider} tokenProvider
     * @param {AvayaCustomerServices.Config.NotificationInfo} config Notification Provider Config Info
     */
    function NotificationProvider(tokenProvider, config) {
        /**
         * @type {string}
         * @public
         */
        this.name = config.name || 'NotificationProvider';
        /**
         * @type {Object}
         * @private
         */
        this._socket = Notification;
        /**
         * @type {Object}
         * @private
         */
        this._subSocket = null;
        /**
         * @type {AvayaCustomerServices.Config.NotificationInfo}
         * @private
         */
        this._config = config;
        /**
         * @type {AvayaCustomerServices.Base.Authentication.TokenProvider}
         * @private
         */
        this._tokenProvider = tokenProvider;
    }

    NotificationProvider.prototype =
    /** @lends AvayaCustomerServices.Base.Network.AtmosphereProvider */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#start
         * @returns {boolean} True if socket subscribe is successful
         */
        start: function (cid) {
            var tokens = this._tokenProvider.getTokens();
            var headers = _.assignIn({}, this._config.headers, tokens);
            var clientSessionId = cid || 0;
            if (!this._subSocket) {
                this._subSocket = this._socket.subscribe({
                    headers: headers,
                    url: this._config.broadcastUrl,
                    timeout: this._config.timeout,
                    logLevel: this._config.logLevel,
                    transport: this._config.transport,
                    fallbackTransport: this._config.fallbackTransport,
                    enableXDR: this._config.enableXDR,
                    trackMessageLength: this._config.trackMessageLength,
                    maxReconnectOnClose: this._config.maxReconnectOnClose,
                    reconnectInterval: this._config.reconnectInterval,
                    dropHeaders: this._config.dropHeaders,
                    attachHeadersAsQueryString: this._config.attachHeadersAsQueryString,
                    onOpen: this.onOpen,
                    onReconnect: this.onReconnect,
                    onReopen: this.onReopen,
                    onMessage: this.onMessage,
                    onClose: this.onClose,
                    onError: this.onError,
                    onClientTimeout: this.onClientTimeout,
                    onTransportFailure: this.onTransportFailure,
                    uuid: clientSessionId,
                    isReopen: (clientSessionId !== 0)
                });
            }

            if (this._config.onBeforeUnload) {
                this._socket.onBeforeUnload = this._config.onBeforeUnload;
            }
            return !!this._subSocket;
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#close
         */
        close: function () {
            this._subSocket = null;
            this._socket.unsubscribe(this._config.broadcastUrl);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#getConfig
         * @returns {AvayaCustomerServices.Config.NotificationInfo}
         */
        getConfig: function () {
            return this._config;
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onOpen
         */
        onOpen: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onReconnect
         */
        onReconnect: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onReopen
         */
        onReopen: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onMessage
         */
        onMessage: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onClose
         */
        onClose: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onError
         */
        onError: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onClientTimeout
         */
        onClientTimeout: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.AtmosphereProvider#onTransportFailure
         */
        onTransportFailure: function (error, req) {
            if (req.transport === 'websocket') {
                req.attachHeadersAsQueryString = ['X-Atmosphere-tracking-id', 'X-Atmosphere-Framework', 'X-Atmosphere-Transport', 'X-Atmosphere-TrackMessageSize', 'X-atmo-protocol'];
                req.dropHeaders = ['X-Atmosphere-tracking-id', 'X-Atmosphere-Framework', 'X-Atmosphere-Transport', 'X-Atmosphere-TrackMessageSize', 'X-atmo-protocol'];
            }
        }
    };

    AvayaCustomerServices.Base.Network.AtmosphereProvider = NotificationProvider;

})(AvayaCustomerServices, atmosphere, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc WebSocket Provider
 * @author Robert McNamara [mcnamara1@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc WebSocketProvider
     * @define AvayaCustomerServices.Base.Network.WebSocketProvider
     * @memberOf AvayaCustomerServices.Base
     *
     * @description Constructor function for Notification Provider
     * @param {AvayaCustomerServices.Base.Authentication.TokenProvider} tokenProvider
     * @param {AvayaCustomerServices.Config.NotificationInfo} config Notification Provider Config Info
     */
    function WebSocketProvider(tokenProvider, config) {
        /**
         * @type {string}
         * @public
         */
        this.name = config.name || 'WebSocketProvider';
        /**
         * @type {string}
         * @private
         */
        this._clientSessionId = null;
        /**
         * @type {AvayaCustomerServices.Config.NotificationInfo}
         * @private
         */
        this._config = config;
        /**
         * @type {AvayaCustomerServices.Base.Authentication.TokenProvider}
         * @private
         */
        this._tokenProvider = tokenProvider;
        /**
         * @type {WebSocket}
         * @private
         */
        this._ws = undefined;
        /**
         * The current state of the connection.
         *
         *  Value   State       Description
         *  0	    CONNECTING	Socket has been created. The connection is not yet open.
         *  1	    OPEN	    The connection is open and ready to communicate.
         *  2	    CLOSING	    The connection is in the process of closing.
         *  3	    CLOSED  	The connection is closed or couldn't be opened.
         * 
         * @type {number}
         * @private
         */
        this._readyState = undefined;
        /** 
         * The payload of the heartbeat message sent from client to server
         *
         * @type {number}
         * @private
         */
        this._heartbeatPadding = config.heartbeatPadding;
        /** 
         * The time interval (in milliseconds) between client heartbeat messages sent to server
         *
         * @type {number}
         * @private
         */
        this._clientHeartbeatInterval = config.clientHeartbeatInterval;
        /** 
         * The timeout duration (in milliseconds) client waits before regarding the websocket as stale
         *
         * @type {number}
         * @private
         */
        this._serverHeartbeatTimeout = config.serverHeartbeatTimeout;
        /**
         * Time of last sent heartbeat message to server (represented in ms since UNIX epoch)
         * 
         * @type {number}
         * @private
         */
        this._clientLastHeartbeatTime = undefined;
        /**
         * Time of last received heartbeat message from server (represented in ms since UNIX epoch)
         * 
         * @type {number}
         * @private
         */
        this._serverLastHeartbeatTime = undefined;
        /** 
         * Stored Timer ID of client heartbeat timeout (used for clearing timeouts on error / closed websocket)
         *
         * @type {number}
         * @private
         */
        this._clientHeartbeatTimer = null;
        /** 
        * Stored Timer ID of received heartbeat timeout from server (used for client timeouts on stale websocket)
        *
        * @type {number}
        * @private
        */
        this._serverHeartbeatTimer = null;
        /** 
        * Stored Timer ID used for handling reconnection attempts
        *
        * @type {number}
        * @private
        */
        this._reconnectTimer = null;
        /** 
         * Flag to determine if a normal closure was requested
         *
         * @type {boolean}
         * @private
         */
        this._isClean = false;
        /** 
         * Flag to determine if a websocket reconnect should be attempted
         *
         * @type {boolean}
         * @private
         */
        this._attemptReconnect = false;
        /** 
         * The number of attempted reconnects since starting, or the last successful connection. Read only.
         *
         * @type {number}
         * @private
         */
        this._reconnectAttempts = 0;
        /** 
         * The number of milliseconds to wait before attempting to reconnect websocket connection.
         *
         * @type {number}
         * @private
         */
        this._reconnectInterval = config.reconnectInterval;
        /**
         * The maximum number of attempts to re-establish a websocket connection.
         *
         * @public
         * @type {number}
         */
        this._maxReconnectAttempts = config.maxReconnectAttempts;
    }

    var closeEventTypes = {
        NORMAL_CLOSURE: {
            code: 1000,
            reconnect: false,
            name: 'Normal Closure',
            description: 'The connection successfully completed the purpose for which it was created.'
        },
        GOING_AWAY: {
            code: 1001,
            reconnect: false,
            name: 'Going Away',
            description: 'The endpoint is going away, either because of a server failure or because the browser is navigating away from the page that opened the connection.'
        },
        PROTOCOL_ERROR: {
            code: 1002,
            reconnect: true,
            name: 'Protocol Error',
            description: 'The endpoint is terminating the connection due to a protocol error.'
        },
        UNSUPPORTED_DATA: {
            code: 1003,
            reconnect: true,
            name: 'Unsupported Data',
            description: 'The connection is being terminated because the endpoint received data of a type it cannot accept. (For example, a text-only endpoint received binary data.)'
        },
        RESERVED: {
            code: 1004,
            reconnect: true,
            name: 'Reserved',
            description: 'A meaning might be defined in the future.'
        },
        NO_STATUS_RECEIVED: {
            code: 1005,
            reconnect: false,
            name: 'No Status Received',
            description: 'Indicates that no status code was provided even though one was expected.'
        },
        ABNORMAL_CLOSURE: {
            code: 1006,
            reconnect: true,
            name: 'Abnormal Closure',
            description: 'Indicates that a connection was closed abnormally (that is, with no close frame being sent) when a status code is expected.'
        },
        INVALID_FRAME_PAYLOAD_DATA: {
            code: 1007,
            reconnect: true,
            name: 'Invalid frame payload data',
            description: 'The endpoint is terminating the connection because a message was received that contained inconsistent data (e.g., non-UTF-8 data within a text message).'
        },
        POLICY_VIOLATION: {
            code: 1008,
            reconnect: true,
            name: 'Policy Violation',
            description: 'The endpoint is terminating the connection because it received a message that violates its policy. This is a generic status code, used when codes 1003 and 1009 are not suitable.'
        },
        MESSAGE_TOO_BIG: {
            code: 1009,
            reconnect: true,
            name: 'Message too big',
            description: 'The endpoint is terminating the connection because a data frame was received that is too large.'
        },
        MISSING_EXTENSION: {
            code: 1010,
            reconnect: true,
            name: 'Missing Extension',
            description: 'The client is terminating the connection because it expected the server to negotiate one or more extension, but the server didn\'t.'
        },
        INTERNAL_ERROR: {
            code: 1011,
            reconnect: true,
            name: 'Internal Error',
            description: 'The server is terminating the connection because it encountered an unexpected condition that prevented it from fulfilling the request.'
        },
        SERVICE_RESTART: {
            code: 1012,
            reconnect: true,
            name: 'Service Restart',
            description: 'The server is terminating the connection because it is restarting. [Ref]'
        },
        TRY_AGAIN_LATER: {
            code: 1013,
            reconnect: true,
            name: 'Try Again Later',
            description: 'The server is terminating the connection due to a temporary condition, e.g. it is overloaded and is casting off some of its clients. [Ref]'
        },
        BAD_GATEWAY: {
            code: 1014,
            reconnect: true,
            name: 'Bad Gateway',
            description: 'The server was acting as a gateway or proxy and received an invalid response from the upstream server. This is similar to 502 HTTP Status Code.'
        },
        TLS_HANDSHAKE: {
            code: 1015,
            reconnect: true,
            name: 'TLS Handshake',
            description: 'Reserved. Indicates that the connection was closed due to a failure to perform a TLS handshake (e.g., the server certificate can\'t be verified).'
        }
    };

    WebSocketProvider.prototype =
    /** @lends AvayaCustomerServices.Base.Network.WebSocketProvider */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#start
         * @param {string} [clientSessionId=0] Optional param to append to client_session query param
         * @returns {boolean} True if websocket is created successfully
         */
        start: function (clientSessionId) {
            this._isClean = false;
            this._attemptReconnect = true;

            var url = this._config.broadcastUrl.replace(/^http(s)?:\/\//, 'ws$1://');
            url += '?client=' + (clientSessionId || '0');

            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.start - Opening websocket: ' + new Date().toISOString(),
                clientSessionId: clientSessionId,
                epoch: Date.now(),
                context: { url: url, config: this._config }
            });

            this._ws = new WebSocket(url, this._config.protocols);
            if (this._ws) {
                this._ws.addEventListener('open', _.bind(handleOpen, null, this));
                this._ws.addEventListener('close', _.bind(handleClose, null, this));
                this._ws.addEventListener('message', _.bind(handleMessage, null, this));
                this._ws.addEventListener('error', _.bind(handleError, null, this));
                return true;
            }

            AvayaCustomerServices.Base.Logger.error('WebSocketProvider', {
                message: 'WebSocketProvider.start - Failed to create websocket: ' + new Date().toISOString(),
                clientSessionId: clientSessionId,
                epoch: Date.now(),
                context: { url: url, config: this._config }
            });
            return false;
        },
        /**
         * Closes the WebSocket connection or connection attempt, if any. 
         * If the connection is already CLOSED, this method does nothing
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#close
         * @param {string} [reason] Set a reason to close websocket
         */
        close: function (reason) {
            this._isClean = true;
            this._attemptReconnect = false;

            if (this._ws && this._ws.readyState === WebSocket.OPEN) {
                AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                    message: 'WebSocketProvider.close - Closing websocket: ' + new Date().toISOString(),
                    reason: reason,
                    clientSessionId: this._clientSessionId,
                    epoch: Date.now(),
                    context: { url: url, config: this._config, isClean: true }
                });
                this._ws.close(closeEventTypes.NORMAL_CLOSURE.code, reason);
            }
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#getConfig
         * @returns {AvayaCustomerServices.Config.NotificationInfo}
         */
        getConfig: function () {
            return this._config;
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onOpen
         */
        onOpen: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onFirstMessage
         */
        onFirstMessage: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onMessage
         */
        onMessage: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onClose
         */
        onClose: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onError
         */
        onError: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onClientTimeout
         */
        onClientTimeout: function () {
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.WebSocketProvider#onMaxReconnects
         */
        onMaxReconnects: function () {
        },
    };

    function handleOpen(provider, event) {
        provider._readyState = WebSocket.OPEN;
        provider._firstMessage = true;
        provider._serverLastHeartbeatTime = Date.now();
        clearTimeout(provider._reconnectTimer);
        clearTimeout(provider._serverHeartbeatTimer);
        clearInterval(provider._clientHeartbeatTimer);
        provider._clientHeartbeatTimer = setInterval(sendClientHeartbeat, provider._clientHeartbeatInterval, provider);
        provider._serverHeartbeatTimer = setTimeout(closeWebsocket, provider._serverHeartbeatTimeout, provider);
        provider.onOpen(event);
        AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
            message: 'WebSocketProvider.handleOpen - Opening websocket: ' + new Date().toISOString(),
            clientSessionId: provider._clientSessionId,
            epoch: Date.now(),
            context: { provider: provider, event: event }
        });
    }

    function handleMessage(provider, event) {
        if (event.data === provider._heartbeatPadding) {
            provider._serverLastHeartbeatTime = Date.now();
            clearTimeout(provider._serverHeartbeatTimer);
            provider._serverHeartbeatTimer = setTimeout(closeWebsocket, provider._serverHeartbeatTimeout, provider);
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.handleMessage - Received server heartbeat at: ' + new Date(provider._serverLastHeartbeatTime).toISOString(),
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, event: event }
            });
        } else if (provider._firstMessage || provider._reconnectAttempts > 0) {
            var message;
            var isReOpen = provider._reconnectAttempts > 0;
            provider._firstMessage = false;
            provider._reconnectAttempts = 0;
            try {
                message = JSON.parse(event.data);
                provider._clientSessionId = message.clientSession;
                provider.onFirstMessage(message, isReOpen);
                AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                    message: 'WebSocketProvider.handleMessage - Received first message at: ' + new Date().toISOString(),
                    clientSessionId: provider._clientSessionId,
                    epoch: Date.now(),
                    context: { provider: provider, event: event, message: message, isReOpen: isReOpen }
                });
            } catch (error) {
                AvayaCustomerServices.Base.Logger.error('WebSocketProvider', {
                    message: 'WebSocketProvider.handleMessage - Could not parse JSON: ' + new Date().toISOString(),
                    clientSessionId: provider._clientSessionId,
                    epoch: Date.now(),
                    context: { provider: provider, error: error, event: event, message: event.data, isReOpen: isReOpen }
                });
            }
        } else {
            provider.onMessage(event.data);
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.handleMessage - Received message at: ' + new Date().toISOString(),
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, event: event }
            });
        }
    }

    function handleClose(provider, event) {
        provider._readyState = WebSocket.CLOSED;
        clearInterval(provider._clientHeartbeatTimer);
        clearTimeout(provider._serverHeartbeatTimer);
        provider.onClose(event);

        var closeEventType = getCloseEventType(event.code);
        provider._attemptReconnect = closeEventType.reconnect;
        AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
            message: 'WebSocketProvider.handleClose - Websocket closed at: ' + new Date().toISOString(),
            clientSessionId: provider._clientSessionId,
            epoch: Date.now(),
            context: { provider: provider, event: event, closeEventType: closeEventType }
        });

        if (provider._ws) {
            provider._ws.removeEventListener('open', handleOpen);
            provider._ws.removeEventListener('close', handleClose);
            provider._ws.removeEventListener('message', handleMessage);
            provider._ws.removeEventListener('error', handleError);
        }

        if (provider._attemptReconnect) {
            reconnect(provider);
        }
    }

    function handleError(provider, error) {
        if (error.code === 'ECONNREFUSED') {
            reconnect(provider);
        } else {
            provider.onError(error);
        }
        AvayaCustomerServices.Base.Logger.error('WebSocketProvider', {
            message: 'WebSocketProvider.handleError - ' + error.code + ': ' + new Date().toISOString(),
            clientSessionId: provider._clientSessionId,
            epoch: Date.now(),
            context: { provider: provider, error: error }
        });
    }

    function sendClientHeartbeat(provider) {
        if (provider._ws.readyState === WebSocket.OPEN) {
            provider._ws.send(provider._heartbeatPadding);
            provider._clientLastHeartbeatTime = Date.now();
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.sendClientHeartbeat - Sending client heartbeat: ' + new Date(provider._clientLastHeartbeatTime).toISOString(),
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider }
            });
        } else {
            AvayaCustomerServices.Base.Logger.error('WebSocketProvider', {
                message: 'WebSocketProvider.sendClientHeartbeat - Client heartbeat not sent - Websocket not open: ' + new Date().toISOString(),
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, readyState: provider._ws.readyState }
            });
        }
    }

    function reconnect(provider) {
        if (!provider._attemptReconnect || provider._ws.readyState === WebSocket.CONNECTING) {
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.reconnect - Reconnect attempt not made: ' + new Date().toISOString(),
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, readyState: provider._ws.readyState }
            });
            return;
        }
        if (provider._reconnectAttempts < provider._maxReconnectAttempts) {
            provider._reconnectAttempts++;
            provider._reconnectTimer = setTimeout(_.bind(provider.start, provider), provider._reconnectInterval, provider._clientSessionId);
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.reconnect - Reconnect attempt ' + provider._reconnectAttempts,
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, reconnectAttempts: provider._reconnectAttempts }
            });
        } else {
            provider._attemptReconnect = false;
            clearTimeout(provider._reconnectTimer);
            provider.onMaxReconnects();
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', {
                message: 'WebSocketProvider.reconnect - Max reconnect attempts of ' + provider._maxReconnectAttempts + ' reached at: ' + new Date().toISOString(),
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, maxReconnectAttempts: provider._maxReconnectAttempts }
            });
        }
    }

    function closeWebsocket(provider) {
        if (provider._ws.readyState === WebSocket.OPEN) {
            provider._ws.close();
            provider._readyState = WebSocket.CLOSED;
            clearTimeout(provider._serverHeartbeatTimer);
            var serverLastHeartbeatDuration = parseInt((Date.now() - provider._serverLastHeartbeatTime) / 1000);
            var debugMessage = {
                message: 'WebSocketProvider.closeWebsocket - Server heartbeat not recieved since: ' + new Date(provider._serverLastHeartbeatTime).toISOString(),
                reason: 'Server heartbeat not recieved',
                clientSessionId: provider._clientSessionId,
                epoch: Date.now(),
                context: { provider: provider, serverLastHeartbeatDuration: serverLastHeartbeatDuration }
            };
            provider.onClientTimeout(debugMessage);
            AvayaCustomerServices.Base.Logger.debug('WebSocketProvider', debugMessage);
        }
    }

    function getCloseEventType(code) {
        return _.find(closeEventTypes, { code: code });
    }

    AvayaCustomerServices.Base.Network.WebSocketProvider = WebSocketProvider;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Enables Observable Objects
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Observable class. It handles events communication.
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Observable
     *
     * @description Observable constructor function
     */
    function Observable() {
        /**
         * @protected
         * @type {{}}
         */
        this._listeners = {};
    }

    Observable.prototype =
    /** @lends AvayaCustomerServices.Base.Observable */
    {
        /**
         * Subscribes handler to specified event
         *
         * @public
         * @function AvayaCustomerServices.Base.Observable#on
         * @this AvayaCustomerServices.Base.Observable
         * @param {string} name Name of event to subscribe to
         * @param {function} handler Handler subscribed to event
         * @returns {AvayaCustomerServices.Base.Observable}
         */
        on: function (name, handler) {
            if (typeof(handler) !== 'function') {
                return this;
            }
            else {
                this._listeners[name] = this._listeners[name] || [];
                this._listeners[name].push(handler);
            }
            return this;
        },
        /**
         * Unsubscribes handler from specified event
         *
         * @public
         * @function AvayaCustomerServices.Base.Observable#off
         * @this AvayaCustomerServices.Base.Observable
         * @param {string} name Name of event to unsubscribe from
         * @param {function} handler Handler subscribed to event
         * @returns {AvayaCustomerServices.Base.Observable}
         * @throws Will throw error if listener is not defined
         */
        off: function (name, handler) {
            if (typeof(handler) !== 'function') {
                return this;
            }
            else {
                if (this._listeners[name] === undefined) {
                    throw new Error('There is no such handler for event with name: ' + name + '.');
                }
                var index = _.indexOf(this._listeners[name], handler);
                if (index !== -1) {
                    this._listeners[name].splice(index, 1);
                } else {
                    throw new Error('There is no such handler for event with name: ' + name + '.');
                }
                if (_.size(this._listeners[name]) === 0) {
                    delete this._listeners[name];
                }
            }
            return this;
        },
        /**
         * Triggers specified event
         *
         * @public
         * @function AvayaCustomerServices.Base.Observable#trigger
         * @param {string} name Name of event to be triggered
         * @param {Array} [args=[]] Optional event callback arguments
         */
        trigger: function (name, args) {
            var listeners = this._listeners[name];
            if (listeners !== undefined) {
                args = args || [];
                _.forEach(listeners, function (listener) {
                    listener.apply(window, args);
                });
            }
        },
        /**
         * Removes [all] listeners
         *
         * @public
         * @param {string} [namespace] Only remove listeners by namespace
         * @function AvayaCustomerServices.Base.Observable#removeListeners
         */
        removeListeners: function (namespace) {
            var self = this;
            _.forEach(this._listeners, function (listener, name) {
                var removeListener = _.isUndefined(namespace);
                if (namespace) {
                    var regExp = new RegExp('^' + namespace);
                    removeListener = regExp.exec(name) !== null;
                }
                if (removeListener) {
                    _.forEach(listener, function (handler) {
                        self.off(name, handler);
                    });
                }
            });
        }
    };

    AvayaCustomerServices.Base.Observable = Observable;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Promises
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * RSVP.js provides simple tools for organizing asynchronous code.
     * Specifically, it is a tiny implementation of Promises/A+.
     * It works in node and the browser (IE6+, all the popular evergreen ones).
     *
     * See {@tutorial async} for more information.
     *
     * @example <caption>Basic Usage</caption>
     *  var promise = new RSVP.Promise(function(resolve, reject) {
     *      // succeed
     *      resolve(value);
     *      // or reject
     *      reject(error);
     *  });
     *
     *  promise.then(function(value) {
     *      // success
     *  }, function(value) {
     *      // failure
     *  });
     *
     * @class
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Promise
     * @param {function} resolver
     */
    function Promise(resolver) {
        /**
         * NOTE: This class does nothing!
         * It is only use to document RSVP Promise object in order to provide syntax completion.
         */
    }

    Promise.prototype =
    /** @lends AvayaCustomerServices.Base.Promise **/
    {
        /**
         * The primary way of interacting with a promise is through its `then` method,
         * which registers callbacks to receive either a promise's eventual value or the
         * reason why the promise cannot be fulfilled.
         *
         * @example
         *  findUser().then(function(user){
         *      // user is available
         *  }, function(reason){
         *      // user is unavailable, and you are given the reason why
         *  });
         *
         * @public
         * @param {function} onFulfillment
         * @param {function} onRejection
         * @param {string} [label] optional string for labeling the promise.
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        then: function (onFulfillment, onRejection, label) {
        },
        /**
         * `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
         * as the catch block of a try/catch statement.
         *
         * @example
         *  function findAuthor(){
         *      throw new Error("couldn't find that author");
         *  }
         *  findAuthor().catch(function(reason){
         *      // something went wrong
         *  });
         *
         * @public
         * @param {function} onRejection
         * @param {string} [label] optional string for labeling the promise.
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        catch: function (onRejection, label) {
        },
        /**
         * `finally` will be invoked regardless of the promise's fate just as native
         * try/catch/finally behaves
         *
         * @example
         *  findAuthor().catch(function(reason){
         *      return findOtherAuthor();
         *  }).finally(function(){
         *      // author was either found, or not
         *  });
         *
         * @public
         * @param {function} callback
         * @param {string} [label] optional string for labeling the promise.
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        finally: function (callback, label) {
        }
    };

    AvayaCustomerServices.Base.Promise = Promise;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Base Provider Factory
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc This is the factory for creating providers configured for services.
     * ProviderFactory sorts out what providers are needed for each service (based on user configuration).
     * This factory is intended to be used internally only.
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.ProviderFactory
     *
     * @description Constructor function for Provider Factory
     */
    function ProviderFactory() {
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Authentication.TokenCollection}
         */
        this._tokenCollection = {};
        /**
         * @private
         * @type {AvayaCustomerServices.Providers.UAC.ProviderFactory}
         */
        this._uacProviderFactory = {};
    }

    ProviderFactory.prototype =
    /** @lends AvayaCustomerServices.Base.ProviderFactory */
    {
        /**
         * Get Token Collection or create one if it does not exist.
         *
         * @public
         * @function AvayaCustomerServices.Base.ProviderFactory#getTokenCollection
         * @returns {AvayaCustomerServices.Base.Authentication.TokenCollection} tokenCollection
         */
        getTokenCollection: function () {
            if (!_.isEmpty(this._tokenCollection)) {
                return this._tokenCollection;
            }
            this._tokenCollection = new AvayaCustomerServices.Base.Authentication.TokenCollection();
            return this._tokenCollection;
        },

        /**
         * Get UAC Provider or create one if it does not exist
         *
         * @public
         * @function AvayaCustomerServices.Base.ProviderFactory#getUACProvider
         * @param {AvayaCustomerServices.Config.UACConfiguration} uacConfig
         * @param {string} service Name of service to subscribe
         * @returns {AvayaCustomerServices.Providers.UAC.Provider} uacProvider
         */
        getUACProvider: function (uacConfig, service) {
            if (_.isEmpty(this._tokenCollection)) {
                this.getTokenCollection();
            }
            if (_.isEmpty(this._uacProviderFactory)) {
                this._uacProviderFactory = new AvayaCustomerServices.Providers.UAC.ProviderFactory(this._tokenCollection);
            }
            return this._uacProviderFactory.subscribeToUACProvider(uacConfig, service);
        },
        /**
         * Remove UAC Provider if it exists
         *
         * @public
         * @function AvayaCustomerServices.Base.ProviderFactory#removeUACProvider
         * @param {string} service
         */
        removeUACProvider: function (service) {
            if (!_.isEmpty(this._uacProviderFactory)) {
                this._uacProviderFactory.unsubscribeFromUACProvider(service);
            }
        }
    };

    AvayaCustomerServices.Base.ProviderFactory = ProviderFactory;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Utilities Class
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @memberOf AvayaCustomerServices.Base
     * @define AvayaCustomerServices.Base.Utils
     */
    AvayaCustomerServices.Base.Utils = {
        /**
         * Parse JSON string or throw error
         *
         * @public
         * @function AvayaCustomerServices.Base.Utils#parseJSON
         * @param {string} data JSON string to parse
         * @returns {Object} Parsed JSON string
         */
        parseJSON: function (data) {
            data = data || "";
            try {
                return JSON.parse(data);
            } catch (error) {
                throw new AvayaCustomerServices.Base.Error({
                    type: 'JSON.parse',
                    message: error.stack,
                    reason: error.message
                });
            }
        },
        /**
         * Safely parse JSON strings (no errors)
         *
         * @public
         * @function AvayaCustomerServices.Base.Utils#parseJSON
         * @param {string} data JSON string to parse
         * @returns {Object} Parsed JSON string
         */
        toJSON: function (data) {
            data = data || "";
            try {
                return JSON.parse(data);
            } catch (error) {
                return {
                    type: 'JSON.parse',
                    message: error.stack,
                    reason: error.message
                };
            }
        },
    };

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines a list of default authentication configuration options
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Creates an instance of AuthenticationInfo that contains information for AvayaCustomerServices SDK to manage
     * authorization requirements when communicating with backend services.
     *
     * @define AvayaCustomerServices.Config.AuthenticationInfo
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function AuthenticationInfo(config) {
        /**
         * Used as a boolean flag to indicate if authentication is enabled. If enabled is true, the token provider will
         * attempt to fetch tokens (listed in this.tokens) from the token collection. These tokens are used by the rest
         * provider and notification provider to authorize requests to backend services.
         *
         * @public
         * @type {boolean}
         */
        this.enabled = config.enabled || false;
        /**
         * Contains a list of white-listed URLS. No tokens will be fetched by the rest provider or notification provider
         * to authorize a request if that request URL matches an entry in this array.
         *
         * @public
         * @type {string[]}
         */
        this.whitelist = config.whitelist || [];
        /**
         * List of tokens to use. Used by the token provider when attempting to fetch tokens from the token collection.
         *
         * @public
         * @type {string[]}
         */
        this.tokens = config.tokens || [];
    }

    AvayaCustomerServices.Config.AuthenticationInfo = AuthenticationInfo;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines a list of default client configuration options
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @type {string}
     * @private
     */
    var _id;
    /**
     * Creates an instance of ClientInfo that contains information about the client application that is consuming the
     * AvayaCustomerServices SDK.
     *
     * @define AvayaCustomerServices.Config.ClientInfo
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function ClientInfo(config) {
        /**
         * Set default value for _id
         */
        _id = config.id || "unknown";
        /**
         * Identifier used to inform the backend service what client application is consuming the AvayaCustomerServices
         * SDK
         *
         * @public
         * @type {string}
         * @name AvayaCustomerServices.Config.ClientInfo#id
         */
        Object.defineProperty(this, 'id', {
            get: function () {
                return _id;
            },
            set: function(newValue) {
                if (!!newValue) {
                    _id = newValue;
                }
            }
        });
    }

    AvayaCustomerServices.Config.ClientInfo = ClientInfo;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines a list of default HTTP request configuration options
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Creates an instance of HTTPOptions that contains default options for all
     * HTTP requests made to a backend service.
     *
     * @define AvayaCustomerServices.Config.HTTPOptions
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function HTTPOptions() {
        /**
         * Set to true for asynchronous HTTP request, false for synchronous
         *
         * @public
         * @type {boolean}
         */
        this.async = true;
        /**
         * List of additional HTTP headers to pass with every HTTP request
         *
         * @public
         * @type {object}
         */
        this.headers = {};
    }

    AvayaCustomerServices.Config.HTTPOptions = HTTPOptions;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines a list of default notification configuration options
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Creates an instance of NotificationInfo that contains information for
     * AvayaCustomerServices SDK to communicate with an asynchronous
     * notification service.
     *
     * @define AvayaCustomerServices.Config.NotificationInfo
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function NotificationInfo(config) {
        /**
         * Name of Notification Provider.
         *
         * @since 3.3.0.0
         * @public
         * @type {string}
         */
        this.name = config.name;
        /**
         * Broadcast Url for Notification Provider.
         *
         * @public
         * @type {string}
         */
        this.broadcastUrl = config.broadcastUrl || '';
        /**
         * Notification log level.
         *
         * @public
         * @type {string}
         */
        this.logLevel = config.logLevel || 'off';
        /**
         * The transport Notification will use between the client and server.
         *
         * @public
         * @type {string}
         */
        this.transport = config.transport || 'websocket';
        /**
         * If either the client or server isn't able to support the selected 'transport', the fallback value will be used.
         *
         * @since 3.2.2
         *
         * @public
         * @type {string}
         */
        this.fallbackTransport = config.fallbackTransport || 'long-polling';
        /**
         * Enable CORS Cross Origin Resource Sharing.
         *
         * @public
         * @type {boolean}
         */
        this.enableXDR = config.enableXDR || true;
        /**
         * Track the size of the received request.
         *
         * @public
         * @type {boolean}
         */
        this.trackMessageLength = config.trackMessageLength || true;
        /**
         * The maximum reconnect after a connection is marked as 'dead'.
         *
         * @public
         * @type {number}
         */
        this.maxReconnectOnClose = config.maxReconnectOnClose || 60;
        /**
         * The interval in milliseconds before an attempt to reconnect will be made.
         *
         * @public
         * @type {number}
         */
        this.reconnectInterval = config.reconnectInterval || 5000;
        /**
         * The maximum time a connection stays open
         *
         * @public
         * @type {number}
         */
        this.timeout = config.timeout || 90000;
        /**
         * A list of headers to send
         *
         * @public
         * @type {object}
         */
        this.headers = config.headers || {};
        /**
         * Attach filtered list of headers (array), no headers(false) or all headers(true) as query string
         *
         * @public
         * @type {array|boolean}
         */
        this.attachHeadersAsQueryString = config.attachHeadersAsQueryString || true;
        /**
         * Remove filtered list of headers (array), no headers(false) or all headers(true)
         *
         * @public
         * @type {array|boolean}
         */
        this.dropHeaders = config.dropHeaders || true;
        /**
         * Function to call before notification provider closes session on page unload
         *
         * @public
         * @type {function|null}
         */
        this.onBeforeUnload = config.onBeforeUnload || null;
        /**
         * Callback to handle when notification provider closes a connection
         *
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onClose = new AvayaCustomerServices.Base.Callbacks();
    }

    NotificationInfo.prototype =
    /** @lends AvayaCustomerServices.Config.NotificationInfo */
    {
        /**
         * The event data that is passed back to onClose callback
         * @typedef {Object} AvayaCustomerServices.Base.Error
         * @property {string} message Close connection message
         * @property {string} reason Reason for closing connection
         * @property {number} status Status code from server
         * @property {string} scope Where the message was fired from
         * @property {string} severity Error message severity
         * @property {string} source Source of message
         */
        /**
         * @callback AvayaCustomerServices.Config.NotificationInfo~onClose
         * @param {AvayaCustomerServices.Base.Error} message The event that is fired when notification provider closes a connection
         */
        /**
         * Adds a callback that is executed when notification provider closes a connection
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.Config.NotificationInfo#onClose
         * @param {AvayaCustomerServices.Config.NotificationInfo~onClose} callback
         */
        onClose: function (callback) {
            this._onClose.add(callback);
        }
    };

    AvayaCustomerServices.Config.NotificationInfo = NotificationInfo;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines a list of default server configuration options
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Creates an instance of ServerInfo that contains information for
     * AvayaCustomerServices SDK to connect with a backend service.
     *
     * @define AvayaCustomerServices.Config.ServerInfo
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function ServerInfo(config) {
        /**
         * Customer Interaction Services Server name
         *
         * @since 3.3.0.0
         * @public
         * @type {string}
         */
        this.name = config.name;
        /**
         * Customer Interaction Services Server endpoint URL
         *
         * @public
         * @type {string}
         */
        this.apiUrl = config.apiUrl || '';
    }

    AvayaCustomerServices.Config.ServerInfo = ServerInfo;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 * @since 3.8.1.1
 * @classdesc Defines a list of default notification configuration options
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Creates an instance of WebsocketInfo that contains information for
     * AvayaCustomerServices SDK to communicate with an asynchronous
     * notification service.
     *
     * @define AvayaCustomerServices.Config.WebsocketInfo
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function WebsocketInfo(config) {
        /**
         * Name of Notification Provider.
         *
         * @public
         * @type {string}
         */
        this.name = config.name;
        /**
         * The URL to which to connect; this should be the URL to which the WebSocket server will respond.
         *
         * @public
         * @type {string}
         */
        this.broadcastUrl = config.broadcastUrl || '';
        /**
         * Notification log level.
         *
         * @public
         * @type {string}
         */
        this.logLevel = config.logLevel || 'off';
        /** 
         * The payload of the heartbeat message sent from client to server
         *
         * @public
         * @type {number}
         */
        this.heartbeatPadding = config.heartbeatPadding || 'X';
        /** 
         * The time interval (in milliseconds) between client heartbeat messages sent to server
         *
         * @public
         * @type {number}
         */
        this.clientHeartbeatInterval = config.clientHeartbeatInterval || 10000;
        /** 
         * The timeout duration (in milliseconds) client waits before regarding the websocket as stale
         *
         * @public
         * @type {number}
         */
        this.serverHeartbeatTimeout = config.serverHeartbeatTimeout || 90000;
        /** 
         * The number of milliseconds to wait before attempting to reconnect websocket connection.
         *
         * @public
         * @type {number}
         */
        this.reconnectInterval = config.reconnectInterval || 5000;
        /**
         * The maximum number of attempts to re-establish a websocket connection.
         *
         * @public
         * @type {number}
         */
        this.maxReconnectAttempts = config.maxReconnectAttempts || 60;
        /**
         * A list of headers to send
         *
         * @public
         * @type {object}
         */
        this.headers = config.headers || {};
        /**
         * Either a single protocol string or an array of protocol strings. 
         * These strings are used to indicate sub-protocols, so that a single server can implement multiple WebSocket sub-protocols 
         *
         * @public
         * @type {string|string[]}
         */
        this.protocols = config.protocols || [];
        /**
         * Function to call before notification provider closes session on page unload
         *
         * @public
         * @type {function|null}
         */
        this.onBeforeUnload = config.onBeforeUnload || null;
        /**
         * Callback to handle when notification provider closes a connection
         *
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onClose = new AvayaCustomerServices.Base.Callbacks();
    }

    WebsocketInfo.prototype =
    /** @lends AvayaCustomerServices.Config.WebsocketInfo */
    {
        /**
         * The event data that is passed back to onClose callback
         * @typedef {Object} AvayaCustomerServices.Base.Error
         * @property {string} message Close connection message
         * @property {string} reason Reason for closing connection
         * @property {number} status Status code from server
         * @property {string} scope Where the message was fired from
         * @property {string} severity Error message severity
         * @property {string} source Source of message
         */
        /**
         * @callback AvayaCustomerServices.Config.WebsocketInfo~onClose
         * @param {AvayaCustomerServices.Base.Error} message The event that is fired when notification provider closes a connection
         */
        /**
         * Adds a callback that is executed when notification provider closes a connection
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.Config.WebsocketInfo#onClose
         * @param {AvayaCustomerServices.Config.WebsocketInfo~onClose} callback
         */
        onClose: function (callback) {
            this._onClose.add(callback);
        }
    };

    AvayaCustomerServices.Config.WebsocketInfo = WebsocketInfo;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 * @classdesc Defines a list of default ADF configuration options
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Creates an instance of ADFConfiguration that contains default settings
     * for connecting with a ADF Server
     *
     * @define AvayaCustomerServices.Config.ADFConfiguration
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function ADFConfiguration(config) {
        /**
         * Set to true if ADF provider is enabled, false if disabled
         *
         * @public
         * @type {boolean}
         */
        this.enabled = config.enabled || false;
        /**
         * Set to false if list of methods should be disabled. "disabledMethods" contains list of disabled methods
         *
         * @public
         * @type {boolean}
         */
        this.allMethodsEnabled = config.allMethodsEnabled || true;
        /**
         * List of methods to disable
         *
         * @public
         * @type {string[]}
         */
        this.disabledMethods = config.disabledMethods || ['initiate', 'accept', 'hold', 'unhold', 'end', 'transfer', 'consult', 'sendDTMF'];
        /**
         * Creates an object containing default authentication provider configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.AuthenticationInfo}
         */
        this.authenticationInfo = new AvayaCustomerServices.Config.AuthenticationInfo(config.authenticationInfo);
        /**
         * Creates an object containing default client configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.ClientInfo}
         */
        this.clientInfo = new AvayaCustomerServices.Config.ClientInfo(config.clientInfo);
        /**
         * Creates an object containing default server configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.ServerInfo}
         */
        this.serverInfo = new AvayaCustomerServices.Config.ServerInfo(_.assignIn(config.serverInfo, {name: 'ADF'}));
        /**
         * Creates an object containing default notification provider configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.WebsocketInfo}
         */
        this.websocketInfo = new AvayaCustomerServices.Config.WebsocketInfo(config.notificationInfo);
    }

    AvayaCustomerServices.Config.ADFConfiguration = ADFConfiguration;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc ADF Provider Factory
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Providers.ADF.ProviderFactory
     * @memberOf AvayaCustomerServices.Providers.ADF
     * @param {AvayaCustomerServices.Base.Authentication.TokenCollection} tokenCollection
     */
    function ProviderFactory(tokenCollection) {
        /**
         * @type {AvayaCustomerServices.Providers.ADF.Provider}
         * @private
         */
        this._adfProvider = {};
        /**
         * @type {AvayaCustomerServices.Base.Network.WebSocketProvider}
         * @private
         */
        this._webSocketProvider = {};

        /**
         * @type {AvayaCustomerServices.Base.Network.RESTProvider}
         * @private
         */
        this._requestProvider = {};
        /**
         * @type {AvayaCustomerServices.Base.Authentication.TokenCollection}
         * @private
         */
        this._tokenCollection = tokenCollection;
    }

    ProviderFactory.prototype =
    /**
     * @lends AvayaCustomerServices.Providers.ADF.ProviderFactory.prototype
     */
    {
        init: function (adfConfig) {
            if (_.isEmpty(this._adfProvider)) {
                var adfMessageParser = new AvayaCustomerServices.Providers.Common.MessageParser('ADF');
                var tokenProvider = new AvayaCustomerServices.Base.Authentication.TokenProvider(this._tokenCollection, adfConfig.authenticationInfo);
                var httpOptions = new AvayaCustomerServices.Config.HTTPOptions();
                this._requestProvider = new AvayaCustomerServices.Base.Network.RESTProvider(tokenProvider, adfConfig.serverInfo, httpOptions);
                this._webSocketProvider = new AvayaCustomerServices.Base.Network.WebSocketProvider(tokenProvider, adfConfig.websocketInfo);
                this._adfProvider = new AvayaCustomerServices.Providers.ADF.Provider(this._requestProvider, this._webSocketProvider, adfMessageParser, adfConfig);
            }
            return this._adfProvider;
        },
        /**
         * Unsubscribe from ADF base provider object.
         *
         * @public
         */
        destroy: function () {
            if (!_.isEmpty(this._adfProvider)) {
                this._websocketProvider.close();
                this._requestProvider.close();
                this._adfProvider = {};
            }
        }
    };

    AvayaCustomerServices.Providers.ADF.ProviderFactory = ProviderFactory;
})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Message Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.MessageParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function MessageParser(providerName) {
        /**
         * Name of Provider.
         *
         * @private
         * @type {string}
         */
        this._providerName = providerName;
        /**
         * Object containing registered parsers
         *       
         * @private
         * @type {Object}
         */
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.types.ACQUIRE, new AvayaCustomerServices.Providers.Common.ResourceAcquireParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.ACTIVATE, new AvayaCustomerServices.Providers.Common.AgentActivateParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.USER_STATE, new AvayaCustomerServices.Providers.Common.AgentStateParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.INTERACTION, new AvayaCustomerServices.Providers.Common.InteractionParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.INTERACTION_MEDIA, new AvayaCustomerServices.Providers.Common.InteractionMediaParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.INTERACTION_CONTEXT, new AvayaCustomerServices.Providers.Common.InteractionContextParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.DEFERRED_INTERACTION, new AvayaCustomerServices.Providers.Common.DeferredInteractionParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.TEAM, new AvayaCustomerServices.Providers.Common.TeamStateParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.TEAM_MEMBERS_DETAILS, new AvayaCustomerServices.Providers.Common.TeamMemberDetailsParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.PREFERENCES, new AvayaCustomerServices.Providers.Common.PreferencesParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.CONFIGURATION, new AvayaCustomerServices.Providers.Common.ConfigurationParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.RESOURCE_SESSION_PROPERTY, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.CLIENT_SESSION, new AvayaCustomerServices.Providers.Common.ClientSessionParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.types.ERROR, new AvayaCustomerServices.Providers.Common.ErrorParser());
    }

    MessageParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.MessageParser */
    {
        /**
         * Parse server notifications
         *
         * @param response
         * @returns {AvayaCustomerServices.Providers.Common.Message|Object}
         */
        parse: function (response) {
            var message;
            var notificationType;
            if (!response || !response.responseBody) {
                AvayaCustomerServices.Base.Logger.info(this._providerName, 'Message Parser', {
                    info: 'Empty response'
                });
                return response;
            }
            try {
                message = AvayaCustomerServices.Base.Utils.parseJSON(response.responseBody);
                AvayaCustomerServices.Base.Logger.debug(this._providerName, 'Message Parser', message);
            } catch (error) {
                AvayaCustomerServices.Base.Logger.error(this._providerName, 'Message Parser', error);
                return {
                    eventName: 'error',
                    errorType: 'JSON.parse',
                    message: response.responseBody,
                    reason: error.message,
                    severity: 'CRITICAL',
                    scope: this._providerName + ' Message Parser'
                };
            }
            if (!message.notificationType) {
                return message;
            }
            notificationType = AvayaCustomerServices.Providers.Common.Response.types[message.notificationType];
            if (this._parsers[notificationType]) {
                return this._parsers[notificationType].parse(message);
            } else {
                return message;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.MessageParser = MessageParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Generic Message Interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function Message(name) {
        /**
         * @public
         */
        this.eventName = name;
    }

    AvayaCustomerServices.Providers.Common.Message = Message;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Reason Codes Created Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ReasonCodesCreatedEvent
     */
    function ReasonCodesCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.REASON_CODES_CREATED);
        /**
         * @public
         * @type {Array}
         */
        this.reasonCodes = _.sortBy(response.newValue, function(reason) { return parseInt(reason.code); });
    }

    _.defaults(ReasonCodesCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ReasonCodesCreatedEvent = ReasonCodesCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Reason Codes Updated Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ReasonCodesUpdatedEvent
     */
    function ReasonCodesUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.REASON_CODES_UPDATED);
        /**
         * @public
         * @type {Array}
         */
        this.reasonCodes = _.sortBy(response.newValue, function(reason) { return parseInt(reason.code); });
    }

    _.defaults(ReasonCodesUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ReasonCodesUpdatedEvent = ReasonCodesUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Remove Deferred Innteraction Event
 * @author Warren Reilly [reillyw@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.RemoveDeferredInteractionEvent
     */
    function RemoveDeferredInteractionEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.DEFERRED_INTERACTION_DELETE);

        // TODO: DeferInteractionState deferInteractionState; (need to find out best way to implement this)

        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.contactId = response.newValue.contactId;
        /**
         * @public
         * @type {string}
         */
        this.channel = AvayaCustomerServices.Providers.Common.Response.channelTypes[response.newValue.channelType];
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {Object[]}
         */
        this.participant = response.newValue.participant;
        /**
         * @public
         * @type {string}
         */
        this.externalInteractionId = response.newValue.externalInteractionId;
        /**
         * @public
         * @type {string}
         */
        this.userSessionId = response.newValue.userSessionId;
        /**
         * @public
         * @type {string}
         */
        this.service = response.newValue.service;
        /**
         * @public
         * @type {dateTime}
         */
        this.deferTime = response.newValue.deferTime;
        /**
         * @public
         * @type {string}
         */
        this.routingId = response.newValue.routingId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.resourceAddress = response.newValue.resourceAddress;

    }

    _.defaults(RemoveDeferredInteractionEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.RemoveDeferredInteractionEvent = RemoveDeferredInteractionEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceAcquiredEvent
     */
    function ResourceAcquiredEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_ACQUIRED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.channel = AvayaCustomerServices.Providers.Common.Response.channelTypes[response.newValue.channelType];
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.resourceState;
        /**
         * @public
         * @type {string}
         */
        this.stationId = response.newValue.resourceAddress;
        /**
         * @public
         * @type {string}
         */
        this.agentId = response.newValue.loginAccountId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
    }

    _.defaults(ResourceAcquiredEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceAcquiredEvent = ResourceAcquiredEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceReleasedEvent
     */
    function ResourceReleasedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_RELEASED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.channel = AvayaCustomerServices.Providers.Common.Response.channelTypes[response.newValue.channelType];
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.resourceState;
        /**
         * @public
         * @type {string}
         */
        this.resourceId = response.newValue.resourceId;
        /**
         * @public
         * @type {string}
         */
        this.loginAccountId = response.newValue.loginAccountId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
    }

    _.defaults(ResourceReleasedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceReleasedEvent = ResourceReleasedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Configuration Created Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.8.1.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationCreatedEvent
     */
    function ResourceSessionPropertyConfigurationCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_CONFIGURATION_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceAddress = response.newValue.resourceAddress;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string[]}
         */
        this.channelTypes = response.newValue.channelTypes;
        /**
         * @public
         * @type {string}
         */
        this.value = response.newValue.value;
        /**
         * @public
         * @type {string}
         */
        this.propertyType = response.newValue.propertyType;
        /**
         * @public
         * @type {string}
         */
        this.propertyName = response.newValue.propertyName;
        /**
         * @public
         * @type {string}
         */
        this.propertyState = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyConfigurationCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationCreatedEvent = ResourceSessionPropertyConfigurationCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Configuration Deleted Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.8.1.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationDeletedEvent
     */
    function ResourceSessionPropertyConfigurationDeletedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_CONFIGURATION_DELETED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
    }

    _.defaults(ResourceSessionPropertyConfigurationDeletedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationDeletedEvent = ResourceSessionPropertyConfigurationDeletedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Configuration Updated Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.8.1.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationUpdatedEvent
     */
    function ResourceSessionPropertyConfigurationUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_CONFIGURATION_UPDATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceAddress = response.newValue.resourceAddress;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string[]}
         */
        this.channelTypes = response.newValue.channelTypes;
        /**
         * @public
         * @type {string}
         */
        this.value = response.newValue.value;
        /**
         * @public
         * @type {string}
         */
        this.propertyType = response.newValue.propertyType;
        /**
         * @public
         * @type {string}
         */
        this.propertyName = response.newValue.propertyName;
        /**
         * @public
         * @type {string}
         */
        this.propertyState = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyConfigurationUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationUpdatedEvent = ResourceSessionPropertyConfigurationUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Outbound Connected Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundConnectedEvent
     */
    function ResourceSessionPropertyOutboundConnectedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_OUTBOUND_CONNECTED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceSessionId = response.newValue.resourceSessionId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string}
         */
        this.channelType = response.newValue.channelType;
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.propertyState;
        /**
         * @public
         * @type {string}
         */
        this.propertyType = response.newValue.propertyType;
        /**
         * @public
         * @type {string}
         */
        this.propertyName = response.newValue.propertyName;
        /**
         * @public
         * @type {string}
         */
        this.propertyState = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyOutboundConnectedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundConnectedEvent = ResourceSessionPropertyOutboundConnectedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Outbound Deleted Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedEvent
     */
    function ResourceSessionPropertyOutboundDeletedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_OUTBOUND_DELETED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
    }

    _.defaults(ResourceSessionPropertyOutboundDeletedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedEvent = ResourceSessionPropertyOutboundDeletedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Outbound Failed Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundFailedEvent
     */
    function ResourceSessionPropertyOutboundFailedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_OUTBOUND_FAILED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceSessionId = response.newValue.resourceSessionId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string}
         */
        this.channelType = response.newValue.channelType;
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyOutboundFailedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundFailedEvent = ResourceSessionPropertyOutboundFailedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Outbound NotConnected Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundNotConnectedEvent
     */
    function ResourceSessionPropertyOutboundNotConnectedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_OUTBOUND_NOT_CONNECTED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceSessionId = response.newValue.resourceSessionId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string}
         */
        this.channelType = response.newValue.channelType;
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyOutboundNotConnectedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundNotConnectedEvent = ResourceSessionPropertyOutboundNotConnectedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property WorkMode Created Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeCreatedEvent
     */
    function ResourceSessionPropertyWorkModeCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_WORK_MODE_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceSessionId = response.newValue.resourceSessionId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string}
         */
        this.channelType = response.newValue.channelType;
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.value;
        /**
         * @public
         * @type {string}
         */
        this.propertyType = response.newValue.propertyType;
        /**
         * @public
         * @type {string}
         */
        this.propertyName = response.newValue.propertyName;
        /**
         * @public
         * @type {string}
         */
        this.propertyState = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyWorkModeCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeCreatedEvent = ResourceSessionPropertyWorkModeCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property WorkMode Deleted Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeDeletedEvent
     */
    function ResourceSessionPropertyWorkModeDeletedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_WORK_MODE_DELETED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
    }

    _.defaults(ResourceSessionPropertyWorkModeDeletedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeDeletedEvent = ResourceSessionPropertyWorkModeDeletedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property WorkMode Updated Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeUpdatedEvent
     */
    function ResourceSessionPropertyWorkModeUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.RESOURCE_SESSION_WORK_MODE_UPDATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.resourceSessionId = response.newValue.resourceSessionId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.userHandle = response.newValue.userHandle;
        /**
         * @public
         * @type {string}
         */
        this.channelType = response.newValue.channelType;
        /**
         * @public
         * @type {string}
         */
        this.state = response.newValue.value;
        /**
         * @public
         * @type {string}
         */
        this.propertyType = response.newValue.propertyType;
        /**
         * @public
         * @type {string}
         */
        this.propertyName = response.newValue.propertyName;
        /**
         * @public
         * @type {string}
         */
        this.propertyState = response.newValue.propertyState;
    }

    _.defaults(ResourceSessionPropertyWorkModeUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeUpdatedEvent = ResourceSessionPropertyWorkModeUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc System Preference Created Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
  'use strict';

  /**
   * @class
   * @extends AvayaCustomerServices.Providers.Common.Message
   * @requires AvayaCustomerServices.Providers.Common.Message
   * @memberOf AvayaCustomerServices.Providers.Common
   * @define AvayaCustomerServices.Providers.Common.SystemPreferenceCreatedEvent
   */
  function SystemPreferenceCreatedEvent(response) {
    AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.SYSTEM_PREFERENCE_CREATED);
    /**
     * @public
     * @type {string}
     */
    this.id = response.newValue.id;
    /**
     * @public
     * @type {string}
     */
    this.group = response.newValue.group;
    /**
     * @public
     * @type {string}
     */
    this.key = response.newValue.key;
    /**
     * @public
     * @type {string}
     */
    this.value = response.newValue.value;
    /**
     * @public
     * @type {string}
     */
    this.type = response.newValue.type;
  }

  _.defaults(SystemPreferenceCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

  AvayaCustomerServices.Providers.Common.SystemPreferenceCreatedEvent = SystemPreferenceCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc System Preference Deleted Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
  'use strict';

  /**
   * @class
   * @extends AvayaCustomerServices.Providers.Common.Message
   * @requires AvayaCustomerServices.Providers.Common.Message
   * @memberOf AvayaCustomerServices.Providers.Common
   * @define AvayaCustomerServices.Providers.Common.SystemPreferenceDeletedEvent
   */
  function SystemPreferenceDeletedEvent(response) {
    AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.SYSTEM_PREFERENCE_DELETED);
    /**
     * @public
     * @type {string}
     */
    this.id = response.newValue;
  }

  _.defaults(SystemPreferenceDeletedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

  AvayaCustomerServices.Providers.Common.SystemPreferenceDeletedEvent = SystemPreferenceDeletedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc System Preference Updated Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
  'use strict';

  /**
   * @class
   * @extends AvayaCustomerServices.Providers.Common.Message
   * @requires AvayaCustomerServices.Providers.Common.Message
   * @memberOf AvayaCustomerServices.Providers.Common
   * @define AvayaCustomerServices.Providers.Common.SystemPreferenceUpdatedEvent
   */
  function SystemPreferenceUpdatedEvent(response) {
    AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.SYSTEM_PREFERENCE_UPDATED);
    /**
     * @public
     * @type {string}
     */
    this.id = response.newValue.id;
    /**
     * @public
     * @type {string}
     */
    this.group = response.newValue.group;
    /**
     * @public
     * @type {string}
     */
    this.key = response.newValue.key;
    /**
     * @public
     * @type {string}
     */
    this.value = response.newValue.value;
    /**
     * @public
     * @type {string}
     */
    this.type = response.newValue.type;
  }

  _.defaults(SystemPreferenceUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

  AvayaCustomerServices.Providers.Common.SystemPreferenceUpdatedEvent = SystemPreferenceUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Team Details Updated Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.TeamMemberDetailsUpdatedEvent
     */
    function TeamMemberDetailsUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.TEAM_MEMBER_DETAILS_UPDATED);
        /**
         * @public
         * @type {Array}
         */
        this.members = response.newValue;
    }

    _.defaults(TeamMemberDetailsUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.TeamMemberDetailsUpdatedEvent = TeamMemberDetailsUpdatedEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Team State Updated Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.TeamStateUpdatedEvent
     */
    function TeamStateUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.TEAM_STATE_UPDATED);
        /**
         * @public
         * @type {string}
         */
        this.role = response.newValue.role;
        /**
         * @public
         * @type {Array}
         */
        this.members = response.newValue.members;
        /**
         * @public
         * @type {Array}
         */
        this.groups = response.newValue.groups;
    }

    _.defaults(TeamStateUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.TeamStateUpdatedEvent = TeamStateUpdatedEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.UserPreferenceCreatedEvent
     */
    function UserPreferenceCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.USER_PREFERENCE_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.group = response.newValue.group;
        /**
         * @public
         * @type {string}
         */
        this.key = response.newValue.key;
        /**
         * @public
         * @type {string}
         */
        this.value = response.newValue.value;
        /**
         * @public
         * @type {string}
         */
        this.type = response.newValue.type;
    }

    _.defaults(UserPreferenceCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.UserPreferenceCreatedEvent = UserPreferenceCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.UserPreferenceDeletedEvent
     */
    function UserPreferenceDeletedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.USER_PREFERENCE_DELETED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
    }

    _.defaults(UserPreferenceDeletedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.UserPreferenceDeletedEvent = UserPreferenceDeletedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.UserPreferenceUpdatedEvent
     */
    function UserPreferenceUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.USER_PREFERENCE_UPDATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.group = response.newValue.group;
        /**
         * @public
         * @type {string}
         */
        this.key = response.newValue.key;
        /**
         * @public
         * @type {string}
         */
        this.value = response.newValue.value;
        /**
         * @public
         * @type {string}
         */
        this.type = response.newValue.type;
    }

    _.defaults(UserPreferenceUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.UserPreferenceUpdatedEvent = UserPreferenceUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Message Types
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.MessageTypes
     */
    var MessageTypes = {};
    /**
     * Lists all Common message types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.MessageTypes
     * @define AvayaCustomerServices.Providers.Common.MessageTypes.eventName
     */
    MessageTypes.eventName = {
        RESOURCE_ACQUIRED: 'resource.acquired',
        RESOURCE_RELEASED: 'resource.released',

        RESOURCE_SESSION_OUTBOUND_CONNECTED: 'resource_session.outbound.connected',
        RESOURCE_SESSION_OUTBOUND_NOT_CONNECTED: 'resource_session.outbound.not_connected',
        RESOURCE_SESSION_OUTBOUND_FAILED: 'resource_session.outbound.failed',
        RESOURCE_SESSION_OUTBOUND_DELETED: 'resource_session.outbound.deleted',
        RESOURCE_SESSION_WORK_MODE_CREATED: 'resource_session.work_mode.created',
        RESOURCE_SESSION_WORK_MODE_UPDATED: 'resource_session.work_mode.updated',
        RESOURCE_SESSION_WORK_MODE_DELETED: 'resource_session.work_mode.deleted',
        RESOURCE_SESSION_CONFIGURATION_CREATED: 'resource_session.configuration.created',
        RESOURCE_SESSION_CONFIGURATION_UPDATED: 'resource_session.configuration.updated',
        RESOURCE_SESSION_CONFIGURATION_DELETED: 'resource_session.configuration.deleted',

        AGENT_ACTIVATED: 'agent.activated',
        AGENT_DEACTIVATED: 'agent.deactivated',
        AGENT_STATE_UNKNOWN: 'agent.state.unknown',
        AGENT_STATE_LOGIN_PENDING: 'agent.state.login_pending',
        AGENT_STATE_READY: 'agent.state.ready',
        AGENT_STATE_NOT_READY_PENDING: 'agent.state.not_ready_pending',
        AGENT_STATE_NOT_READY: 'agent.state.not_ready',
        AGENT_STATE_AFTER_CONTACT_WORK_PENDING: 'agent.state.after_contact_work_pending',
        AGENT_STATE_AFTER_CONTACT_WORK: 'agent.state.after_contact_work',
        AGENT_STATE_LOGOUT_PENDING: 'agent.state.logout_pending',
        AGENT_STATE_LOGGED_OUT: 'agent.state.logged_out',
        AGENT_STATE_COMPLETE: 'agent.state.complete',

        INTERACTION_CREATED: 'interaction.created',
        INTERACTION_ACTIVE: 'interaction.active',
        INTERACTION_HELD: 'interaction.held',
        INTERACTION_ACW: 'interaction.acw',
        INTERACTION_ACW_PENDING: 'interaction.acw_pending',
        INTERACTION_PASSIVE: 'interaction.passive',
        INTERACTION_UPDATE: 'interaction.updated',
        INTERACTION_DELETE: 'interaction.deleted',
        INTERACTION_UNKNOWN: 'interaction.unknown',

        DESTINATION_PARTICIPANT_ACCEPTED: 'interaction.destination_participant_accepted',

        INTERACTION_MEDIA_CREATED: 'interaction_media.created',
        INTERACTION_MEDIA_DELETED: 'interaction_media.deleted',
        INTERACTION_MEDIA_MESSAGE_CREATED: 'interaction_media.message.created',
        INTERACTION_MEDIA_MESSAGE_WHISPER: 'interaction_media.message.whisper',
        INTERACTION_MEDIA_MESSAGE_IS_TYPING: 'interaction_media.message.is_typing',
        INTERACTION_MEDIA_MESSAGES: 'interaction_media.messages',
        INTERACTION_MEDIA_PARTICIPANT_JOINED: 'interaction_media.participant.joined',
        INTERACTION_MEDIA_PARTICIPANT_LEFT: 'interaction_media.participant.left',
        INTERACTION_MEDIA_PARTICIPANT_LIST: 'interaction_media.participant.list',
        INTERACTION_MEDIA_TRANSFERRED_FILE: 'interaction_media.message.transferred_file',
        INTERACTION_MEDIA_CUSTOMER_DOWNLOAD_INITIATED: 'interaction_media.message.customer_download_initiated',
        INTERACTION_MEDIA_CUSTOMER_DOWNLOAD_COMPLETE: 'interaction_media.message.customer_download_complete',
        INTERACTION_MEDIA_CONNECTED: 'interaction_media.connected',
        INTERACTION_MEDIA_DISCONNECTED: 'interaction_media.disconnected',
        INTERACTION_MEDIA_LEFT: 'interaction_media.left',

        INTERACTION_MEDIA_PAGE_PUSH: 'interaction_media.page_push',
        INTERACTION_MEDIA_EMAIL_MESSAGE: 'interaction_media.email_message',
        INTERACTION_MEDIA_EMAIL_FORWARD_SENT: 'interaction_media.forward_sent',
        INTERACTION_MEDIA_EMAIL_REPLY_SENT: 'interaction_media.reply_sent',
        INTERACTION_MEDIA_EMAIL_EMAIL_FILE_LIMIT_EXCEEDED: 'interaction_media.email_file_limit_exceeded',
        INTERACTION_MEDIA_EMAIL_ATTACHMENTS_ADDED: 'interaction_media.email_attachments_added',
        INTERACTION_MEDIA_EMAIL_ATTACHMENTS_REMOVED: 'interaction_media.email_attachments_removed',

        INTERACTION_CONTEXT_CREATED: 'interaction_context.created',
        INTERACTION_CONTEXT_UPDATED: 'interaction_context.updated',
        INTERACTION_CONTEXT_DELETED: 'interaction_context.deleted',

        DEFERRED_INTERACTION: 'deferred.interaction',
        DEFERRED_INTERACTION_DELETE: 'deferred.interaction.delete',

        INITIATED_TRANSFER: 'interaction.transfer.initiated',
        ACTIVE_TRANSFER: 'interaction.transfer.active',
        COMPLETE_TRANSFER: 'interaction.transfer.complete',

        INITIATED_CONFERENCE: 'interaction.conference.initiated',
        ACTIVE_CONFERENCE: 'interaction.conference.active',

        TEAM_STATE_UPDATED: 'team.state.updated',
        TEAM_MEMBER_DETAILS_UPDATED: 'team.member.details.updated',

        USER_PREFERENCE_CREATED: 'user_preference.created',
        USER_PREFERENCE_UPDATED: 'user_preference.updated',
        USER_PREFERENCE_DELETED: 'user_preference.deleted',

        SYSTEM_PREFERENCE_UPDATED: 'system_preference.updated',
        SYSTEM_PREFERENCE_DELETED: 'system_preference.deleted',
        SYSTEM_PREFERENCE_CREATED: 'system_preference.created',

        CONFIGURATION_CREATED: 'configuration.created',
        CONFIGURATION_UPDATED: 'configuration.updated',
        CONFIGURATION_DELETED: 'configuration.deleted',

        REASON_CODES_CREATED: 'reason_codes.created',
        REASON_CODES_UPDATED: 'reason_codes.updated',

        ERROR: 'error'
    };
    /**
     * Lists all Common resource types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.MessageTypes
     * @define AvayaCustomerServices.Providers.Common.MessageTypes.resourceTypes
     */
    MessageTypes.resourceTypes = {
        VOICE: 'VOICE',
        VIDEO: 'VIDEO',
        WEBCHAT: 'WEBCHAT',
        EMAIL: 'EMAIL',
        SMS: 'SMS',
        SOCIAL: 'SOCIAL',
        OUTBOUND: 'OUTBOUND',
        PP_OUTBOUND: 'PP_OUTBOUND',
        GENERIC: 'GENERIC',
        MESSAGING: 'MESSAGING'
    };
    /**
     * Lists all Common resource states
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.MessageTypes
     * @define AvayaCustomerServices.Providers.Common.MessageTypes.resourceState
     */
    MessageTypes.resourceState = {
        READY: 'READY',
        NOT_READY_PENDING: 'NOT_READY_PENDING',
        NOT_READY: 'NOT_READY',
        AFTER_CONTACT_WORK_PENDING: 'AFTER_CONTACT_WORK_PENDING',
        AFTER_CONTACT_WORK: 'AFTER_CONTACT_WORK',
        LOGGED_OUT: 'LOGGED_OUT',
        COMPLETE: 'COMPLETE',
        UNKNOWN: 'UNKNOWN'
    };
    /**
     * Lists all Common agent states
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.MessageTypes
     * @define AvayaCustomerServices.Providers.Common.MessageTypes.agentState
     */
    MessageTypes.agentState = {
        LOGIN_PENDING: 'LOGIN_PENDING',
        READY: 'READY',
        NOT_READY: 'NOT_READY',
        NOT_READY_PENDING: 'NOT_READY_PENDING',
        AFTER_CONTACT_WORK: 'AFTER_CONTACT_WORK',
        AFTER_CONTACT_WORK_PENDING: 'AFTER_CONTACT_WORK_PENDING',
        LOGOUT_PENDING: 'LOGOUT_PENDING',
        LOGGED_OUT: 'LOGGED_OUT',
        COMPLETE: 'COMPLETE',
        UNKNOWN: 'UNKNOWN'
    };
    /**
     * Lists all Common user types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.MessageTypes
     * @define AvayaCustomerServices.Providers.Common.MessageTypes.userTypes
     */
    MessageTypes.userTypes = {
        AGENT: 'AGENT',
        SUPERVISOR: 'SUPERVISOR',
        ADMIN: 'ADMINISTRATOR'
    };

    AvayaCustomerServices.Providers.Common.MessageTypes = MessageTypes;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.AgentActivateParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function AgentActivateParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.AgentActivateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.AgentDeactivateEvent);
    }

    AgentActivateParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.AgentActivateParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[changeType]) {
                return new this._events[changeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.AgentActivateParser = AgentActivateParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent State Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.AgentStateParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function AgentStateParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.UNKNOWN, AvayaCustomerServices.Providers.Common.AgentUnknownStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.LOGIN_PENDING, AvayaCustomerServices.Providers.Common.AgentLoginPendingStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.READY, AvayaCustomerServices.Providers.Common.AgentReadyStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.NOT_READY_PENDING, AvayaCustomerServices.Providers.Common.AgentNotReadyPendingStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.NOT_READY, AvayaCustomerServices.Providers.Common.AgentNotReadyStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.AFTER_CONTACT_WORK_PENDING, AvayaCustomerServices.Providers.Common.AgentAfterContactWorkPendingStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.AFTER_CONTACT_WORK, AvayaCustomerServices.Providers.Common.AgentAfterContactWorkStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.LOGOUT_PENDING, AvayaCustomerServices.Providers.Common.AgentLogoutPendingStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.LOGGED_OUT, AvayaCustomerServices.Providers.Common.AgentLoggedOutStateEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.agentStates.COMPLETE, AvayaCustomerServices.Providers.Common.AgentCompleteStateEvent);
    }

    AgentStateParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.AgentStateParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.AgentStateMessage}
         */
        parse: function (data) {
            var currentState = AvayaCustomerServices.Providers.Common.Response.agentStates[data.newValue.currentState];
            if (this._events[currentState]) {
                return new this._events[currentState](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.AgentStateParser = AgentStateParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Client Session Parser
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ClientSessionParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ClientSessionParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.clientSessionProperties.REASON_CODES, new AvayaCustomerServices.Providers.Common.ReasonCodesParser());
    }

    ClientSessionParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ClientSessionParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var updatedProperty = AvayaCustomerServices.Providers.Common.Response.clientSessionProperties[data.updatedProperty];
            if (this._parsers[updatedProperty]) {
                return this._parsers[updatedProperty].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.ClientSessionParser = ClientSessionParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Configuration Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ConfigurationParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ConfigurationParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.ConfigurationCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, AvayaCustomerServices.Providers.Common.ConfigurationUpdatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.ConfigurationDeletedEvent);
    }

    ConfigurationParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ConfigurationParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[changeType]) {
                return new this._events[changeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.ConfigurationParser = ConfigurationParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Deferred Interaction Parser
 * @author Warren Reilly [reillyw@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.DeferredInteractionParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function DeferredInteractionParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.DeferredInteractionEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.RemoveDeferredInteractionEvent);

    }

    DeferredInteractionParser.prototype =
        /** @lends AvayaCustomerServices.Providers.Common.DeferredInteractionParser */
        {
            /**
             * @public
             * @function
             * @param data
             * @returns {AvayaCustomerServices.Providers.Common.Message}
             */
            parse: function (data) {
                var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
                if (this._events[changeType]) {
                    return new this._events[changeType](data);
                } else {
                    return data;
                }
            },
            /**
             *
             * @param {string} name
             * @param event

             */
            register: function (name, event) {
                this._events[name] = event;
            }
        };

    AvayaCustomerServices.Providers.Common.DeferredInteractionParser = DeferredInteractionParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Error Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ErrorParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ErrorParser() {}

    ErrorParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ErrorParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.ErrorEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.ErrorEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.ErrorParser = ErrorParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Active Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionActiveParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionActiveParser() { }

    InteractionActiveParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionActiveParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionActiveEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionActiveEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionActiveParser = InteractionActiveParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc ACW Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionACWParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionACWParser() { }

    InteractionACWParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionACWParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionACWEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionACWEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionACWParser = InteractionACWParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc ACW_PENDING Interaction Parser
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 * @since 3.5.0.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionACWPendingParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionACWPendingParser() { }

    InteractionACWPendingParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionACWPendingParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionACWPendingEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionACWPendingEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionACWPendingParser = InteractionACWPendingParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionAlertingParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionAlertingParser() { }

    InteractionAlertingParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionAlertingParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionUpdateEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionUpdateEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionAlertingParser = InteractionAlertingParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Context Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionContextCreatedParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionContextCreatedParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.contextUpdateTypes.INTERACTION_CONTEXT, AvayaCustomerServices.Providers.Common.InteractionContextCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.contextUpdateTypes.INTERACTION_CONTEXT_EXTRA, AvayaCustomerServices.Providers.Common.InteractionContextUpdatedEvent);
    }

    InteractionContextCreatedParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionContextCreatedParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionContextCreatedEvent}
         */
        parse: function (data) {
            var contextUpdateType = AvayaCustomerServices.Providers.Common.Response.contextUpdateTypes[data.updatedProperty];
            if (this._events[contextUpdateType]) {
                return new this._events[contextUpdateType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionContextCreatedParser = InteractionContextCreatedParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Delete Interaction Context Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionContextDeleteParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionContextDeleteParser() {}

    InteractionContextDeleteParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionContextDeleteParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionContextDeleteEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionContextDeleteEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionContextDeleteParser = InteractionContextDeleteParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionContextParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionContextParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, new AvayaCustomerServices.Providers.Common.InteractionContextCreatedParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, new AvayaCustomerServices.Providers.Common.InteractionContextDeleteParser());
    }

    InteractionContextParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionContextParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionContextMessage}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._parsers[changeType]) {
                return this._parsers[changeType].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser

         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionContextParser = InteractionContextParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc New Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionCreatedParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionCreatedParser() { }

    InteractionCreatedParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionCreatedParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionCreatedEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionCreatedEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionCreatedParser = InteractionCreatedParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Delete Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionDeleteParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionDeleteParser() {}

    InteractionDeleteParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionDeleteParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionDeleteEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionDeleteEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionDeleteParser = InteractionDeleteParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Held Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionHeldParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionHeldParser() { }

    InteractionHeldParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionHeldParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionHeldEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionHeldEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionHeldParser = InteractionHeldParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Message Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaChatMessageParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaChatMessageParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.MESSAGE, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.IS_TYPING, AvayaCustomerServices.Providers.Common.InteractionMediaMessageIsTypingEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.LEFT, AvayaCustomerServices.Providers.Common.InteractionMediaLeftEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.WHISPER, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.PAGE_PUSH, AvayaCustomerServices.Providers.Common.InteractionMediaPagePushUrlEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.TRANSFERRED_FILE, AvayaCustomerServices.Providers.Common.InteractionMediaTransferredFileEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CUSTOMER_DOWNLOAD_INITIATED, AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadInitiatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CUSTOMER_DOWNLOAD_COMPLETE, AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadCompleteEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CONNECTED, AvayaCustomerServices.Providers.Common.InteractionMediaConnectedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.DISCONNECTED, AvayaCustomerServices.Providers.Common.InteractionMediaDisconnectedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.QUERY_RESPONSE, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.WIDGET, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
    }

    InteractionMediaChatMessageParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaChatMessageParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaEventType = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes[data.newValue.chatMessageEvent.chatEventType];
            if (this._events[mediaEventType]) {
                return new this._events[mediaEventType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaChatMessageParser = InteractionMediaChatMessageParser;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc New Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaCreatedParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaCreatedParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.updatedProperties.INTERACTION_MEDIA, new AvayaCustomerServices.Providers.Common.InteractionMediaObjectParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.updatedProperties.INTERACTION_MEDIA_MESSAGE, new AvayaCustomerServices.Providers.Common.InteractionMediaMessageParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.updatedProperties.INTERACTION_MEDIA_MESSAGES, new AvayaCustomerServices.Providers.Common.InteractionMediaMessagesParser());
    }

    InteractionMediaCreatedParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaCreatedParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaUpdatedProperty = AvayaCustomerServices.Providers.Common.Response.updatedProperties[data.updatedProperty];
            if (this._parsers[mediaUpdatedProperty]) {
                return this._parsers[mediaUpdatedProperty].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser

         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaCreatedParser = InteractionMediaCreatedParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Delete Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaDeleteParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaDeleteParser() {}

    InteractionMediaDeleteParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionDeleteParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionMediaDeleteEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionMediaDeleteEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaDeleteParser = InteractionMediaDeleteParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Message Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaEmailMessageParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.MESSAGE, AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.DRAFT, AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.FORWARD_SENT, AvayaCustomerServices.Providers.Common.InteractionMediaEmailForwardSentEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.REPLY_SENT, AvayaCustomerServices.Providers.Common.InteractionMediaEmailReplySentEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.EMAIL_FILE_LIMIT_EXCEEDED, AvayaCustomerServices.Providers.Common.InteractionMediaEmailFileLimitExceededEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.OUTGOING_ATTACHMENTS_ADDED, AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsAddedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.OUTGOING_ATTACHMENTS_REMOVED, AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsRemovedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.OUTGOING_FORWARD_ATTACHMENTS_ADDED, AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsAddedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.EMAIL_APPROVAL_ATTACHMENTS_ADDED, AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsAddedEvent);
    }

    InteractionMediaEmailMessageParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaEventType = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes[data.newValue.emailMessageEvent.emailEventType];
            if (this._events[mediaEventType]) {
                return new this._events[mediaEventType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageParser = InteractionMediaEmailMessageParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc List Interaction Media Participants Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaListParticipantParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaListParticipantParser() { }

    InteractionMediaListParticipantParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaListParticipantParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionMediaParticipantListEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaListParticipantParser = InteractionMediaListParticipantParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Message Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaMessageParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaMessageParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.WEBCHAT, new AvayaCustomerServices.Providers.Common.InteractionMediaChatMessageParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.SMS, new AvayaCustomerServices.Providers.Common.InteractionMediaChatMessageParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.SOCIAL, new AvayaCustomerServices.Providers.Common.InteractionMediaChatMessageParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.EMAIL, new AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.MESSAGING, new AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaMessageParser());
    }

    InteractionMediaMessageParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaMessageParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaType = AvayaCustomerServices.Providers.Common.Response.channelTypes[data.newValue.type];
            if (this._parsers[mediaType]) {
                return this._parsers[mediaType].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaMessageParser = InteractionMediaMessageParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Messages Interaction Media Parser
 * @author Vasiliy Andreev [andreev5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaMessagesParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaMessagesParser() { }

    InteractionMediaMessagesParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaMessagesParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionMediaMessagesEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionMediaMessagesEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaMessagesParser = InteractionMediaMessagesParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Object Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaObjectParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaObjectParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.WEBCHAT, AvayaCustomerServices.Providers.Common.InteractionMediaChatCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.SMS, AvayaCustomerServices.Providers.Common.InteractionMediaChatCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.SOCIAL, AvayaCustomerServices.Providers.Common.InteractionMediaSocialCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.EMAIL, AvayaCustomerServices.Providers.Common.InteractionMediaEmailCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.channelTypes.MESSAGING, AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaCreatedEvent);
    }

    InteractionMediaObjectParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaObjectParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaType = AvayaCustomerServices.Providers.Common.Response.channelTypes[data.newValue.type];
            if (this._events[mediaType]) {
                return new this._events[mediaType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event
         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaObjectParser = InteractionMediaObjectParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Media Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, new AvayaCustomerServices.Providers.Common.InteractionMediaCreatedParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, new AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, new AvayaCustomerServices.Providers.Common.InteractionMediaDeleteParser());
    }

    InteractionMediaParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._parsers[changeType]) {
                return this._parsers[changeType].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaParser = InteractionMediaParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Message Interaction Rich Media Message Parser
 * @author Arina Tryaskova [atryaskova@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaMessageParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaRichMediaMessageParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.RICHMEDIA, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.ERROR, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.IS_TYPING, AvayaCustomerServices.Providers.Common.InteractionMediaMessageIsTypingEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.WHISPER, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.PAGE_PUSH, AvayaCustomerServices.Providers.Common.InteractionMediaPagePushUrlEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.TRANSFERRED_FILE, AvayaCustomerServices.Providers.Common.InteractionMediaTransferredFileEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CUSTOMER_DOWNLOAD_INITIATED, AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadInitiatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CUSTOMER_DOWNLOAD_COMPLETE, AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadCompleteEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CONNECTED, AvayaCustomerServices.Providers.Common.InteractionMediaConnectedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.DISCONNECTED, AvayaCustomerServices.Providers.Common.InteractionMediaDisconnectedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.QUERY_RESPONSE, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.WIDGET, AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent);
    }

    InteractionMediaRichMediaMessageParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaMessageParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaEventType = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes[data.newValue.chatMessageEvent.chatEventType];
            if (this._events[mediaEventType]) {
                return new this._events[mediaEventType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaMessageParser = InteractionMediaRichMediaMessageParser;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Media Update Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaUpdateParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.updatedProperties.INTERACTION_MEDIA, new AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParticipantParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.updatedProperties.PARTICIPANT_LIST, new AvayaCustomerServices.Providers.Common.InteractionMediaListParticipantParser());
    }

    InteractionMediaUpdateParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var updatedProperty = AvayaCustomerServices.Providers.Common.Response.updatedProperties[data.updatedProperty];
            if (this._parsers[updatedProperty]) {
                return this._parsers[updatedProperty].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParser = InteractionMediaUpdateParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Update Interaction Media Participant Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParticipantParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaUpdateParticipantParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.mediaUpdateTypes.PARTICIPANT_JOINED, AvayaCustomerServices.Providers.Common.InteractionMediaParticipantJoinedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.mediaUpdateTypes.PARTICIPANT_LEFT, AvayaCustomerServices.Providers.Common.InteractionMediaParticipantLeftEvent);
    }

    InteractionMediaUpdateParticipantParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParticipantParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var mediaUpdateType = AvayaCustomerServices.Providers.Common.Response.mediaUpdateTypes[data.newValue.mediaUpdateType];
            if (this._events[mediaUpdateType]) {
                return new this._events[mediaUpdateType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event
         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionMediaUpdateParticipantParser = InteractionMediaUpdateParticipantParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, new AvayaCustomerServices.Providers.Common.InteractionCreatedParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, new AvayaCustomerServices.Providers.Common.InteractionUpdateParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, new AvayaCustomerServices.Providers.Common.InteractionDeleteParser());
    }

    InteractionParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionMessage}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._parsers[changeType]) {
                return this._parsers[changeType].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionParser = InteractionParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Passive Interaction Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionPassiveParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionPassiveParser() { }

    InteractionPassiveParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionPassiveParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionPassiveEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionPassiveEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionPassiveParser = InteractionPassiveParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Remote Participant Accepted Interaction Parser
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionRemoteParticipantAcceptedParser() { }

    InteractionRemoteParticipantAcceptedParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedParser = InteractionRemoteParticipantAcceptedParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Unknown Parser
 * @author Novikov Mikhail [mnovikov@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionUnknownParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionUnknownParser() { }

    InteractionUnknownParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionUnknownParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionUnknownEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.InteractionUnknownEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionUnknownParser = InteractionUnknownParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Update Interaction Parser
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionUpdateParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionUpdateParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.interactionUpdatedProperties.INTERACTION, new AvayaCustomerServices.Providers.Common.InteractionUpdateStateParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionUpdatedProperties.DESTINATION_PARTICIPANT_ACCEPTED, new AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedParser());
    }

    InteractionUpdateParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionUpdateParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionMessage|AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var updatedProperty = AvayaCustomerServices.Providers.Common.Response.interactionUpdatedProperties[data.updatedProperty];
            if (this._parsers[updatedProperty]) {
                return this._parsers[updatedProperty].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionUpdateParser = InteractionUpdateParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Update Interaction State Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.InteractionUpdateStateParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionUpdateStateParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.ALERTING, new AvayaCustomerServices.Providers.Common.InteractionAlertingParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.ACTIVE, new AvayaCustomerServices.Providers.Common.InteractionActiveParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.HELD, new AvayaCustomerServices.Providers.Common.InteractionHeldParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.ACW, new AvayaCustomerServices.Providers.Common.InteractionACWParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.ACW_PENDING, new AvayaCustomerServices.Providers.Common.InteractionACWPendingParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.PASSIVE, new AvayaCustomerServices.Providers.Common.InteractionPassiveParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.interactionStates.UNKNOWN, new AvayaCustomerServices.Providers.Common.InteractionUnknownParser());
    }

    InteractionUpdateStateParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.InteractionUpdateStateParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.InteractionMessage}
         */
        parse: function (data) {
            var currentState = AvayaCustomerServices.Providers.Common.Response.interactionStates[data.newValue.currentState];
            if (this._parsers[currentState]) {
                return this._parsers[currentState].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.InteractionUpdateStateParser = InteractionUpdateStateParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Preferences Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
  'use strict';

  /**
   * @class
   * @define AvayaCustomerServices.Providers.Common.PreferencesParser
   * @memberOf AvayaCustomerServices.Providers.Common
   */
  function PreferencesParser() {
    this._parsers = {};

    this.register(AvayaCustomerServices.Providers.Common.Response.preferenceTypes.USER, new AvayaCustomerServices.Providers.Common.UserPreferencesParser());
    this.register(AvayaCustomerServices.Providers.Common.Response.preferenceTypes.SYSTEM, new AvayaCustomerServices.Providers.Common.SystemPreferencesParser());
  }

  PreferencesParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.PreferencesParser */
    {
      /**
       * @public
       * @function
       * @param data
       * @returns {AvayaCustomerServices.Providers.Common.Message}
       */
      parse: function (response) {
        var preferenceType = AvayaCustomerServices.Providers.Common.Response.preferenceTypes[response.newValue.type];
        if (this._parsers[preferenceType]) {
          return this._parsers[preferenceType].parse(response);
        } else {
          return response;
        }
      },
      /**
       *
       * @param {string} name
       * @param event
       */
      register: function (name, parser) {
        this._parsers[name] = parser;
      }
    };

  AvayaCustomerServices.Providers.Common.PreferencesParser = PreferencesParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Reason Codes Parser
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ReasonCodesParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ReasonCodesParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.ReasonCodesCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, AvayaCustomerServices.Providers.Common.ReasonCodesUpdatedEvent);
    }

    ReasonCodesParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ReasonCodesParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[changeType]) {
                return new this._events[changeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.ReasonCodesParser = ReasonCodesParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceAcquireParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceAcquireParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.ResourceAcquiredEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.ResourceReleasedEvent);
    }

    ResourceAcquireParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceAcquireParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[changeType]) {
                return new this._events[changeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event
         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceAcquireParser = ResourceAcquireParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Configuration Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.8.1.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceSessionPropertyConfigurationParser() { 
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationUpdatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationDeletedEvent);    
    }

    ResourceSessionPropertyConfigurationParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var notificationChangeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[notificationChangeType]) {
                return new this._events[notificationChangeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event
         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationParser = ResourceSessionPropertyConfigurationParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Outbound Created Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundCreatedParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceSessionPropertyOutboundCreatedParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.outboundStates.CONNECTED, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundConnectedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.outboundStates.NOT_CONNECTED, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundNotConnectedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.outboundStates.FAILED, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundFailedEvent);
    }

    ResourceSessionPropertyOutboundCreatedParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundCreatedParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var state = AvayaCustomerServices.Providers.Common.Response.outboundStates[data.newValue.value];
            if (this._events[state]) {
                return new this._events[state](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event

         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundCreatedParser = ResourceSessionPropertyOutboundCreatedParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Outbound Deleted Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceSessionPropertyOutboundDeletedParser() {}

    ResourceSessionPropertyOutboundDeletedParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedParser = ResourceSessionPropertyOutboundDeletedParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceSessionPropertyOutboundParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundCreatedParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundCreatedParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundDeletedParser());
    }

    ResourceSessionPropertyOutboundParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var notificationChangeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._parsers[notificationChangeType]) {
                return this._parsers[notificationChangeType].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundParser = ResourceSessionPropertyOutboundParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceSessionPropertyParser() {
        this._parsers = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.resourceSessionProperties.OUTBOUND_NAILUP, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyOutboundParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.resourceSessionProperties.WORK_MODE, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeParser());
        this.register(AvayaCustomerServices.Providers.Common.Response.resourceSessionProperties.CONFIGURATION, new AvayaCustomerServices.Providers.Common.ResourceSessionPropertyConfigurationParser());

    }

    ResourceSessionPropertyParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceSessionPropertyParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var updatedProperty = AvayaCustomerServices.Providers.Common.Response.resourceSessionProperties[data.updatedProperty];
            if (this._parsers[updatedProperty]) {
                return this._parsers[updatedProperty].parse(data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param parser
         */
        register: function (name, parser) {
            this._parsers[name] = parser;
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyParser = ResourceSessionPropertyParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Resource Session Property Parser
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ResourceSessionPropertyWorkModeParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeUpdatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeDeletedEvent);
    }

    ResourceSessionPropertyWorkModeParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var notificationChangeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[notificationChangeType]) {
                return new this._events[notificationChangeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event
         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.ResourceSessionPropertyWorkModeParser = ResourceSessionPropertyWorkModeParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc System Preferences Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
  'use strict';

  /**
   * @class
   * @define AvayaCustomerServices.Providers.Common.SystemPreferencesParser
   * @memberOf AvayaCustomerServices.Providers.Common
   */
  function SystemPreferencesParser() {
    this._events = {};

    this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.SystemPreferenceCreatedEvent);
    this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, AvayaCustomerServices.Providers.Common.SystemPreferenceUpdatedEvent);
    this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.SystemPreferenceDeletedEvent);
  }

  SystemPreferencesParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.SystemPreferencesParser */
    {
      /**
       * @public
       * @function
       * @param data
       * @returns {AvayaCustomerServices.Providers.Common.Message}
       */
      parse: function (data) {
        var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
        if (this._events[changeType]) {
          return new this._events[changeType](data);
        } else {
          return data;
        }
      },
      /**
       *
       * @param {string} name
       * @param event
       */
      register: function (name, event) {
        this._events[name] = event;
      }
    };

  AvayaCustomerServices.Providers.Common.SystemPreferencesParser = SystemPreferencesParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Team State Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.TeamMemberDetailsParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function TeamMemberDetailsParser() {

    }

    TeamMemberDetailsParser.prototype =
        /** @lends AvayaCustomerServices.Providers.Common.TeamMemberDetailsParser */
        {
            /**
             * @public
             * @function
             * @param data
             * @returns {AvayaCustomerServices.Providers.Common.TeamMemberDetailsUpdatedEvent}
             */
            parse: function (data) {
                return new AvayaCustomerServices.Providers.Common.TeamMemberDetailsUpdatedEvent(data);
            }
        };

    AvayaCustomerServices.Providers.Common.TeamMemberDetailsParser = TeamMemberDetailsParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Team State Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.TeamStateParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function TeamStateParser() {

    }

    TeamStateParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.TeamStateParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.TeamStateUpdatedEvent}
         */
        parse: function (data) {
            return new AvayaCustomerServices.Providers.Common.TeamStateUpdatedEvent(data);
        }
    };

    AvayaCustomerServices.Providers.Common.TeamStateParser = TeamStateParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc User Preferences Parser
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.UserPreferencesParser
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function UserPreferencesParser() {
        this._events = {};

        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.NEW, AvayaCustomerServices.Providers.Common.UserPreferenceCreatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.UPDATE, AvayaCustomerServices.Providers.Common.UserPreferenceUpdatedEvent);
        this.register(AvayaCustomerServices.Providers.Common.Response.changeTypes.DELETE, AvayaCustomerServices.Providers.Common.UserPreferenceDeletedEvent);
    }

    UserPreferencesParser.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.UserPreferencesParser */
    {
        /**
         * @public
         * @function
         * @param data
         * @returns {AvayaCustomerServices.Providers.Common.Message}
         */
        parse: function (data) {
            var changeType = AvayaCustomerServices.Providers.Common.Response.changeTypes[data.notificationChangeType];
            if (this._events[changeType]) {
                return new this._events[changeType](data);
            } else {
                return data;
            }
        },
        /**
         *
         * @param {string} name
         * @param event
         */
        register: function (name, event) {
            this._events[name] = event;
        }
    };

    AvayaCustomerServices.Providers.Common.UserPreferencesParser = UserPreferencesParser;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Common Provider Constants
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.Constants
     */
    AvayaCustomerServices.Providers.Common.Constants = {
        ACCEPT: 'accept',
        HOLD: 'hold',
        UNHOLD: 'unhold',
        DEFER: 'defer',
        DEFER_FORWARD: 'defer_forward',
        RETRIEVE: 'retrieve',
        APPLY_FORWARD: 'apply_forward',
        APPLY_APPROVAL: 'apply_approval',
        REJECTED: 'rejected',
        TRANSFER: 'transfer',
        TRANSFER_TO_USER: 'TRANSFER_TO_USER',
        CONSULT: 'consult',
        CONSULT_COMPLETE: 'consult_complete',
        AS_TRANSFER_REASON: 'transfer',
        AS_CONFERENCE_REASON: 'conference',
        LOGIN: 'login',
        LOGOUT: 'logout',
        STATE: 'state',
        READY: 'ready',
        NOT_READY: 'not_ready',
        AFTER_CONTACT_WORK: 'after_contact_work',
        DEFAULT_REASON: '0',
        ALERTING: 'alerting',
        ACTIVE: 'active',
        HELD: 'held',
        FAILED: 'failed',
        IDLE: 'idle',
        INACTIVE: 'inactive',
        UNKNOWN: 'unknown',
        EXTEND_ACW: 'extend_acw',
        COMPLETE_ACW: 'complete_acw',
        WORK_CODE: 'work_code',
        DISPOSITION_CODE: 'disposition_code',
        DTMF: 'DTMF',
        OBSERVE: 'observe',
        STOP_OBSERVE: 'stop_observe',
        COACH: 'coach',
        BARGE_IN: 'barge',
        ACTIVATION_TIMEOUT: 'client_time_out'
    };

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * Description
 *
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.Response
     */
    var Response = {};
    /**
     * Lists all Common response types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.types
     */
    Response.types = {
        ACQUIRE: 'ACQUIRE',
        ACTIVATE: 'ACTIVATE',
        USER_STATE: 'USER_STATE',
        SETTINGS: 'SETTINGS',
        INTERACTION: 'INTERACTION',
        INTERACTION_MEDIA: 'INTERACTION_MEDIA',
        INTERACTION_CONTEXT: 'INTERACTION_CONTEXT',
        DEFERRED_INTERACTION: 'DEFERRED_INTERACTION',
        TEAM: 'TEAM',
        TEAM_MEMBERS_DETAILS: 'TEAM_MEMBERS_DETAILS',
        PREFERENCES: 'PREFERENCES',
        CONFIGURATION: 'CONFIGURATION',
        RESOURCE_SESSION_PROPERTY: 'RESOURCE_SESSION_PROPERTY',
        CLIENT_SESSION: 'CLIENT_SESSION',
        ERROR: 'ERROR'
    };
    /**
     * Lists all Common response change types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.changeTypes
     */
    Response.changeTypes = {
        NEW: 'new',
        UPDATE: 'update',
        DELETE: 'delete'
    };
    /**
     * Lists all Common response interaction states
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.interactionStates
     */
    Response.interactionStates = {
        UNKNOWN: 'UNKNOWN',
        INITIATED: 'INITIATED',
        ALERTING: 'ALERTING',
        ACTIVE: 'ACTIVE',
        PASSIVE: 'PASSIVE',
        HELD: 'HELD',
        ACW: 'ACW',
        ACW_PENDING: 'ACW_PENDING',
        DELETE: 'DELETE'
    };
    /**
     * Lists all Common response deferInteraction states
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.deferInteractionStates
     */
    Response.deferInteractionStates = {
        ACTIVE: 'ACTIVE',
        COMPLETE: 'COMPLETE',
        RETRIEVING: 'RETRIEVING'
    };
    /**
     * Lists all Common response channel types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.channelTypes
     */
    Response.channelTypes = {
        NO_CHANNEL: 'NO_CHANNEL',
        VOICE: 'VOICE',
        WEBCHAT: 'WEBCHAT',
        EMAIL: 'EMAIL',
        SMS: 'SMS',
        MESSAGING: 'MESSAGING',
        FAX: 'FAX',
        SCANNED_DOCUMENTS: 'SCANNED_DOCUMENTS',
        SOCIAL: 'SOCIAL',
        VIDEO: 'VIDEO',
        CO_BROWSE: 'CO_BROWSE',
        OUTBOUND: 'OUTBOUND',
        PP_OUTBOUND: 'PP_OUTBOUND',
        WEB_VOICE: 'WEB_VOICE',
        GENERIC: 'GENERIC',
        MMS: 'MMS'
    };
    /**
     * Lists all Common agent states
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.agentStates
     */
    Response.agentStates = {
        UNKNOWN: 'UNKNOWN',
        LOGIN_PENDING: 'LOGIN_PENDING',
        READY: 'READY',
        NOT_READY_PENDING: 'NOT_READY_PENDING',
        NOT_READY: 'NOT_READY',
        AFTER_CONTACT_WORK: 'AFTER_CONTACT_WORK',
        AFTER_CONTACT_WORK_PENDING: 'AFTER_CONTACT_WORK_PENDING',
        LOGOUT_PENDING: 'LOGOUT_PENDING',
        LOGGED_OUT: 'LOGGED_OUT',
        COMPLETE: 'COMPLETE'
    };
    /**
     * Lists all Common interaction media update types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.mediaUpdateTypes
     */
    Response.mediaUpdateTypes = {
        NEW: 'NEW',
        NEW_MESSAGE: 'NEW_MESSAGE',
        PARTICIPANT_JOINED: 'PARTICIPANT_JOINED',
        PARTICIPANT_LEFT: 'PARTICIPANT_LEFT',
        PARTICIPANT_LIST: 'PARTICIPANT_LIST',
        DELETE: 'DELETE'
    };
    /**
     * Lists all Common interaction media event types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.mediaEventTypes
     */
    Response.mediaEventTypes = {
        MESSAGE: 'MESSAGE',
        RICHMEDIA: 'RICHMEDIA',
        ERROR: 'ERROR',
        DRAFT: 'DRAFT',
        JOINED: 'JOINED',
        LEFT: 'LEFT',
        CLOSED: 'CLOSED',
        FORWARD_SENT: 'FORWARD_SENT',
        REPLY_SENT: 'REPLY_SENT',
        EMAIL_FILE_LIMIT_EXCEEDED: 'EMAIL_FILE_LIMIT_EXCEEDED',
        VALIDATE: 'VALIDATE',
        SESSION: 'SESSION',
        SUBJECT_CHANGE: 'SUBJECT_CHANGE',
        START: 'START',
        IS_TYPING: 'IS_TYPING',
        PAGE_PUSH: 'PAGE_PUSH',
        OUTGOING_ATTACHMENTS_ADDED: 'OUTGOING_ATTACHMENTS_ADDED',
        OUTGOING_ATTACHMENTS_REMOVED: 'OUTGOING_ATTACHMENTS_REMOVED',
        OUTGOING_FORWARD_ATTACHMENTS_ADDED: 'OUTGOING_FORWARD_ATTACHMENTS_ADDED',
        EMAIL_APPROVAL_ATTACHMENTS_ADDED: 'EMAIL_APPROVAL_ATTACHMENTS_ADDED',
        TRANSFERRED_FILE: 'TRANSFERRED_FILE',
        CUSTOMER_DOWNLOAD_INITIATED: 'CUSTOMER_DOWNLOAD_INITIATED',
        CUSTOMER_DOWNLOAD_COMPLETE: 'CUSTOMER_DOWNLOAD_COMPLETE',
        CONNECTED: 'CONNECTED',
        DISCONNECTED: 'DISCONNECTED',
        QUERY_RESPONSE: 'QUERY_RESPONSE',
        WIDGET: 'WIDGET',
        WHISPER: 'WHISPER'
    };
    /**
     * Lists all Common interaction context update types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.contextUpdateTypes
     */
    Response.contextUpdateTypes = {
        INTERACTION_CONTEXT: 'INTERACTION_CONTEXT',
        INTERACTION_CONTEXT_EXTRA: 'INTERACTION_CONTEXT_EXTRA'
    };
    /**
     * Lists all Common interaction update types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.interactionUpdatedProperties
     */
    Response.interactionUpdatedProperties = {
        INTERACTION: 'INTERACTION',
        DESTINATION_PARTICIPANT_ACCEPTED: 'DESTINATION_PARTICIPANT_ACCEPTED'
    };
    /**
     * Lists all Common interaction media update types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.updatedProperties
     */
    Response.updatedProperties = {
        WORK_CODE: 'WORK_CODE',
        INTERACTION_MEDIA: 'INTERACTION_MEDIA',
        INTERACTION_MEDIA_MESSAGE: 'INTERACTION_MEDIA_MESSAGE',
        INTERACTION_MEDIA_MESSAGES: 'INTERACTION_MEDIA_MESSAGES',
        PARTICIPANT_LIST: 'PARTICIPANT_LIST'
    };
    /**
     * Lists all Common interaction media types
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.mediaTypes
     */
    Response.mediaTypes = {
        THREAD: 'thread'
    };
    /**
     * Lists all Common interaction state reasons
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.stateReasons
     */
    Response.stateReasons = {
        DEFAULT: 'DEFAULT',
        CONSULT_INIT: 'CONSULT_INIT',
        TRANSFER_INIT: 'TRANSFER_INIT',
        TRANSFER_COMPLETE: 'TRANSFER_COMPLETE',
        CONFERENCE_INIT: 'CONFERENCE_INIT',
        CONFERENCE_COMPLETE: 'CONFERENCE_COMPLETE'
    };
    /**
     * Lists all Common resource session properties
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.resourceSessionProperties
     */
    Response.resourceSessionProperties = {
        OUTBOUND_NAILUP: 'OUTBOUND_NAILUP',
        WORK_MODE: 'WORK_MODE',
        CONFIGURATION: 'CONFIGURATION'
    };
    /**
     * Lists all Common client session properties
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.clientSessionProperties
     */
    Response.clientSessionProperties = {
        REASON_CODES: 'REASON_CODES'
    };
    /**
     * Lists all Common resource session outbound states
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.Common.Response
     * @define AvayaCustomerServices.Providers.Common.Response.outboundStates
     */
    Response.outboundStates = {
        CONNECTED: 'CONNECTED',
        NOT_CONNECTED: 'NOT_CONNECTED',
        FAILED: 'FAILED'
    };

    Response.preferenceTypes = {
        SYSTEM: 'SYSTEM',
        USER: 'USER'
    };

    AvayaCustomerServices.Providers.Common.Response = Response;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Common URL Builder
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.UrlBuilder
     * @memberOf AvayaCustomerServices.Providers.Common
     * @param {AvayaCustomerServices.Base.Mediator.Provider} provider
     */
    function UrlBuilder(provider) {
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Mediator.Provider}
         */
        this._provider = provider;
    }

    UrlBuilder.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.UrlBuilder.prototype */
    {
        /**
         * Encode object to url query string
         *
         * Loops through an object of key:value pairs. These pairs are used to
         * construct a string in the following format, '?key1=value1&key2=value2'
         *
         * @param {Object} params Key:value pairs used to construct url string
         * @returns {string} Encoded url query string
         */
        encodeUrlParams: function (params) {
            var urlParams = '';
            for (var prop in params) {
                if (params.hasOwnProperty(prop) && params[prop]) {
                    urlParams += urlParams.length === 0 ? '?' : '&';
                    urlParams += prop + '=' + encodeURIComponent(params[prop]);
                }
            }
            return urlParams;
        },
        /**
         * Get base activate url string
         *
         * @param {string} handle Agent handle
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Activate URL to use for requests
         */
        getActivateUrl: function (handle, params) {
            var urlParams = [];
            urlParams.push('/users/', handle, '/sessions');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base user url string
         *
         * @param {string} handle Agent handle
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base User URL to use for requests
         */
        getUserUrl: function (handle, params) {
            var urlParams = [];
            urlParams.push('/users/', handle, '/sessions/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base user preference url string
         *
         * @param {string} handle Agent handle
         * @param {Object} [profileId] Optional profile ID
         * @param {Object} [accountId] Optional account ID
         * @param {Object} [clientSessionId] Optional client session ID
         * @returns {string} Base User Preference URL to use for requests
         */
        getUserPreferenceUrl: function (handle, profileId, accountId, clientSessionId) {
            var urlParams = [];
            urlParams.push('/users/', handle);
            if (clientSessionId) {
                urlParams.push('/sessions/', clientSessionId);
            }
            if (profileId) {
                urlParams.push('/profiles/', profileId);
            }
            if (accountId) {
                urlParams.push('/accounts/', accountId);
            }
            urlParams.push('/preferences');
            return urlParams.join('');
        },
        /**
         * Get base system preference url string
         *
         * @param {string} clientId Client ID
         * @returns {string} Base System Preference URL to use for requests
         */
        getSystemPreferenceUrl: function (clientId) {
            var urlParams = [];
            urlParams.push('/clients/', clientId);
            urlParams.push('/settings');
            return urlParams.join('');
        },
        /**
         * Get configuration settings url string.
         *
         * @param {string} [authServerUser] Deprecated: User's ID used during authentication
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base System Preference URL to use for requests
         */
        getConfigurationUrl: function (authServerUser, params) {
            var urlParams = [];
            if (authServerUser) {
                urlParams.push('/auth/', encodeURIComponent(authServerUser));
            }
            urlParams.push('/configuration');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base interaction url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} interactionId Id of interaction
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getInteractionUrl: function (handle, workRequestId, interactionId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            if (workRequestId) {
                urlParams.push('/workrequests/', workRequestId);
            }
            urlParams.push('/interactions');
            urlParams.push(interactionId ? '/' + interactionId : '');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base message url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} interactionId Id of interaction
         * @returns {string} Base Interaction URL to use for requests
         */
        getMessageUrl: function (handle, workRequestId, interactionId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/workrequests/', workRequestId);
            urlParams.push('/interactions/', interactionId, '/messages');
            if (params) { urlParams.push(this.encodeUrlParams(params)); }
            return urlParams.join('');
        },
        /**
         * Get base attachments url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} interactionId Id of interaction
         * @param {string} [attachmentId] Specify an attachment to remove
         * @param {string} [params] Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getAttachmentsUrl: function (handle, workRequestId, interactionId, attachmentId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/workrequests/', workRequestId);
            urlParams.push('/interactions/', interactionId, '/attachments');
            if (attachmentId) {
                urlParams.push('/', attachmentId);
            }
            if (params) { urlParams.push(this.encodeUrlParams(params)); }
            return urlParams.join('');
        },
        /**
         * Get base participants url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} interactionId Id of interaction
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getParticipantsUrl: function (handle, workRequestId, interactionId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/workrequests/', workRequestId);
            urlParams.push('/interactions/', interactionId, '/participants');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base services list
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} interactionId Id of interaction
         * @param {Object} params Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getServicesUrl: function (handle, workRequestId, interactionId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/workrequests/', workRequestId);
            urlParams.push('/interactions/', interactionId, '/services');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base users list
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} interactionId Id of interaction
         * @param {Object} params Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getUsersUrl: function (handle, workRequestId, interactionId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/workrequests/', workRequestId);
            urlParams.push('/interactions/', interactionId, '/users');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get retrieve deferred interaction url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} workRequestId Id of Work Request
         * @param {string} deferredInteractionId Id of interaction
         * @returns {string} Base Interaction URL to use for requests
         */
        getRetrieveDeferredInteractionUrl: function (handle, deferredInteractionId, params) {
            var urlParams = [];
            urlParams.push('/sessions/', handle, '/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/deferredinteractions/', deferredInteractionId);
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base team url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} [teamMemberUserHandle] Used to get team member state
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Team URL to use for requests
         */
        getTeamStateUrl: function (handle, teamMemberUserHandle, params) {
            var urlParams = [];
            urlParams.push('/users/', handle, '/sessions/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/team');
            if (params && params.monitor && teamMemberUserHandle) {
                urlParams.push('/', teamMemberUserHandle);
            }
            else if (teamMemberUserHandle) {
                urlParams.push('/', teamMemberUserHandle, '/state');
            }
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get supervisor observe url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} [teamMemberUserHandle] Used to get team member state
         * @param {string} [interactionId] Id of interaction
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getObserveUrl: function (handle, teamMemberUserHandle, interactionId, params) {
            var urlParams = [];
            urlParams.push('/users/', handle, '/sessions/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/team');
            if (teamMemberUserHandle) {
                urlParams.push('/', teamMemberUserHandle);
            }
            urlParams.push('/interactions/', interactionId);
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get base supervisor broadcast url string
         *
         * @param {string} handle Supervisor's user handle
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Supervisor Broadcast URL to use for requests
         */
        getSupervisorBroadcastUrl: function (handle, params) {
            var urlParams = [];
            urlParams.push('/users/', handle, '/sessions/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/team', '/messages');
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
        /**
         * Get supervisor end intercation url string
         *
         * @param {string} handle Agent's user handle
         * @param {string} [teamMemberUserHandle] Used to get team member state
         * @param {string} [workRequestId] Id of Work Request
         * @param {string} [interactionId] Id of interaction
         * @param {Object} [params] Additional parameters to append to url string
         * @returns {string} Base Interaction URL to use for requests
         */
        getTeamMemberEndIntreactionUrl: function (handle, teamMemberUserHandle, workRequestId, interactionId, params) {
            var urlParams = [];
            urlParams.push('/users/', handle, '/sessions/');
            urlParams.push(this._provider.clientSessionId);
            urlParams.push('/team');
            if (teamMemberUserHandle) {
                urlParams.push('/', teamMemberUserHandle);
            }
            urlParams.push('/workrequests/', workRequestId);
            urlParams.push('/interactions/', interactionId);
            urlParams.push(this.encodeUrlParams(params));
            return urlParams.join('');
        },
    };

    AvayaCustomerServices.Providers.Common.UrlBuilder = UrlBuilder;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Common Utils (sanitizer)
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
  "use strict";
  /**
   * @class
   * @define AvayaCustomerServices.Providers.Common.Utils
   * @memberOf AvayaCustomerServices.Providers.Common
   */
  AvayaCustomerServices.Providers.Common.Utils = {
    /**
     * Sanitize offered string. If string contain </style or script> enclosing tags, replace it with friendly name and log an error with payload.
     * example string with alert script on hover - style>@keyframes x{}</style><h1 style=\"animation-name:x\" onanimationend=\"alert('XSS')\"></h1>
     *
     * @param {string} message   string to sanitize
     * @param {Object} payload   message origin object
     * @param {Array}  keysArray keys that map place, where need correction
     * @returns {Object} sanitized message
     */
    sanitize: function (message, payload, keysArray) {
      var logError = false;
      if (message !== null) {
        if (/(.+)(<\/style|script>)/g.test(message)) {
          if (!logError) {
            logError = !logError;
          }
          if (!keysArray) {
            payload.body = "text." + payload.interactionMediaId;
          } else {
            payload[keysArray[0]][keysArray[1]] =
              payload.richMediaType + "." + payload.interactionMediaId;
          }
        }
      }

      if (logError) {
        AvayaCustomerServices.Base.Logger.error("Common Utils sanitizer", {
          scope: "Util - sanitizer (scripting attempt)",
          message: payload,
        });
      }
      return payload;
    },
  };
})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author Govinda Grings [ggrings@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines contact search API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for ContactSearchCriteria Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Providers.CP
     * @define AvayaCustomerServices.Providers.CP.ContactSearchCriteria
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Contact Search Criteria
     * @param {string} searchString The string to search for
     * @param {string} searchField The field in which to search
     * @param {number} maxResults The maximum number of results to return
     */
    function ContactSearchCriteria(searchString, searchField, maxResults) {
        AvayaCustomerServices.Base.Collections.Model.call(this);
        /**
         * @private
         * @type {string}
         */
        this._searchString = searchString;
        /**
         * @private
         * @type {string}
         */
        this._searchField = searchField;
        /**
         * The maximum number of results to return
         *
         * @public
         * @type {number}
         */
        this._maxResults = maxResults;
    }

    ContactSearchCriteria.prototype =
    /** @lends AvayaCustomerServices.Providers.CP.ContactSearchCriteria */
    {
        /**
         * Gets the search string
         *
         * @public
         * @function AvayaCustomerServices.Providers.CP.ContactSearchCriteria#getSearhString
         * @returns {string}
         */
        getSearchString: function () {
            return this._searchString;
        },
        /**
         * Gets the search field
         *
         * @public
         * @function AvayaCustomerServices.Providers.CP.ContactSearchCriteria#getSearhField
         * @returns {string}
         */
        getSearchField: function () {
            return this._searchField;
        },
        /**
         * Gets the maximum number of results
         *
         * @public
         * @function AvayaCustomerServices.Providers.CP.ContactSearchCriteria#getMaxResults
         * @returns {number}
         */
        getMaxResults: function () {
            return this._maxResults;
        }
    };

    _.defaults(ContactSearchCriteria.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Providers.CP.ContactSearchCriteria = ContactSearchCriteria;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Contact search fields
 * @author Govinda Grings [ggring@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Lists all fields that can be searched in a contact search
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Providers.CP.ContactSearchCriteria
     * @define AvayaCustomerServices.Providers.CP.ContactSearchCriteria.Fields
     */
    AvayaCustomerServices.Providers.CP.ContactSearchCriteria.Fields = {
        NAME: 'NAME',
        HANDLE: 'HANDLE',
        LOGIN: 'LOGIN',
        ALL: 'ALL'
    };

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author Govinda Grings [ggrings@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines contact search result update message API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for contactSearchUpdateMessage Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Providers.CP
     * @define AvayaCustomerServices.Providers.CP.ContactSearchUpdateMessage
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Contact Search Update Message Model
     * @param {Array} newContacts
     */
    function ContactSearchUpdateMessage(newContacts) {
        AvayaCustomerServices.Base.Collections.Model.call(this);
        /**
         * @private
         * @type {Array}
         */
        this._newContacts = newContacts;
    }

    ContactSearchUpdateMessage.prototype =
    /** @lends AvayaCustomerServices.Providers.CP.ContactSearchUpdateMessage */
    {
        /**
         * Gets the new contacts updated in this result
         *
         * @public
         * @function AvayaCustomerServices.Providers.CP.ContactSearchUpdateMessage#getNewContacts
         * @returns {Array}
         */
        getNewContacts: function () {
            return this._newContacts;
        }
    };

    _.defaults(ContactSearchUpdateMessage.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Providers.CP.ContactSearchUpdateMessage = ContactSearchUpdateMessage;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Abstract Provider Interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @extends AvayaCustomerServices.Base.Observable
     * @requires AvayaCustomerServices.Base.Observable
     * @memberOf AvayaCustomerServices.Providers.Interfaces
     * @define AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     */
    function AbstractProvider() {
        AvayaCustomerServices.Base.Observable.call(this);
    }

    AbstractProvider.prototype =
    /** @lends AvayaCustomerServices.Providers.Interfaces.AbstractProvider */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Providers.Interfaces.AbstractProvider#start
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        start: function () {
            throw new Error('start method must be implemented by AbstractProvider subclass!');
        },
        /**
         * @public
         * @function AvayaCustomerServices.Providers.Interfaces.AbstractProvider#stop
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stop: function () {
            throw new Error('stop method must be implemented by AbstractProvider subclass!');
        },
        /**
         * @public 
         * @since 3.8.0.1
         * @function AvayaCustomerServices.Providers.Interfaces.AbstractProvider#isMethodEnabled
         * @param {string} name Name of the method to check if it is enabled
         * @returns {boolean}
         */
        isMethodEnabled: function (name) {
            throw new Error('isMethodEnabled method must be implemented by AbstractProvider subclass!');
        }        
    };

    _.defaults(AbstractProvider.prototype, AvayaCustomerServices.Base.Observable.prototype);

    AvayaCustomerServices.Providers.Interfaces.AbstractProvider = AbstractProvider;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent Provider Interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Interface that defines the structure of an Agent Provider.
     * @extends AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     * @requires AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     * @memberOf AvayaCustomerServices.Providers.Interfaces
     * @define AvayaCustomerServices.Providers.Interfaces.AgentProvider
     */
    function AgentProvider() {
        AvayaCustomerServices.Providers.Interfaces.AbstractProvider.call(this);
    }

    AgentProvider.prototype =
    /** @lends AvayaCustomerServices.Providers.Interfaces.AgentProvider */
    {
        /**
         * Activate agent with ProfileId
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} [profileId] Profile ID to activate
         * @param {string} [extension] Agent's extension
         * @param {string} [clientSessionId] preceding clientSessionId used for resyncing sessions on refresh
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        activate: function (handle, profileId, extension, clientSessionId) {
            throw new Error('activate method must be implemented by AgentProvider subclass!');
        },
        /**
         * Deactivate agent
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deactivate: function (handle) {
            throw new Error('deactivate method must be implemented by AgentProvider subclass!');
        },
        /**
         * Login user and set state
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} [loginState] Set agent to state on login
         * @param {string} [workMode] Agent's work mode
         * @param {string} [notReadyReason] Reason for going not ready
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        login: function (handle, loginState, workMode, notReadyReason) {
            throw new Error('login method must be implemented by AgentProvider subclass!');
        },
        /**
         * Logout user
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} [logoutReason] Reason for logging out
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        logout: function (handle, logoutReason) {
            throw new Error('logout method must be implemented by AgentProvider subclass!');
        },
        /**
         * Set Agent's state to "Ready"
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goReady: function (handle) {
            throw new Error('goReady method must be implemented by AgentProvider subclass!');
        },
        /**
         * Set Agent's state to "Not Ready"
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} [notReadyReason] Reason for going not ready
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goNotReady: function (handle, notReadyReason) {
            throw new Error('goNotReady method must be implemented by AgentProvider subclass!');
        },
        /**
         * Set Agent's state to "After Contact Work"
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} [afterContactWorkReason] Reason for going after contact work
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goAfterContactWork: function (handle, afterContactWorkReason) {
            throw new Error('goAfterContactWork method must be implemented by AgentProvider subclass!');
        },
        /**
         * Create/update User Preference
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} payload JSON encoded payload
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @param {string} [clientSessionId] Client Session ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setUserPreference: function (handle, payload, profileId, accountId, clientSessionId) {
            throw new Error('setUserPreference method must be implemented by AgentProvider subclass!');
        },
        /**
         * Remove User Preference
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} payload JSON encoded payload
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeUserPreference: function (handle, payload, profileId, accountId) {
            throw new Error('removeUserPreference method must be implemented by AgentProvider subclass!');
        },
        /**
         * Create/update User Preference
         *
         * @abstract
         * @param {string} clientId Client ID
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setSystemPreference: function (clientId, payload) {
            throw new Error('setSystemPreference method must be implemented by AgentProvider subclass!');
        },
        /**
         * Remove System Preference
         *
         * @abstract
         * @param {string} clientId Client ID
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeSystemPreference: function (clientId, payload) {
            throw new Error('removeSystemPreference method must be implemented by AgentProvider subclass!');
        },
        /**
         * Get configuration settings for a user.
         *
         * @abstract
         * @param {string} [authServerUser] Deprecated: User's ID used during authentication
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getConfiguration: function (authServerUser) {
            throw new Error('getConfiguration method must be implemented by AgentProvider subclass!');
        },
        /**
         * Get client sessions for a user.
         *
         * @abstract
         * @param {string} authServerUser User's ID used during authentication
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getClientSessions: function (authServerUser) {
            throw new Error('getClientSessions method must be implemented by AgentProvider subclass!');
        }
    };

    _.defaults(AgentProvider.prototype, AvayaCustomerServices.Providers.Interfaces.AbstractProvider.prototype);

    AvayaCustomerServices.Providers.Interfaces.AgentProvider = AgentProvider;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Team Provider Interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Interface that defines the structure of a Team Provider.
     * @extends AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     * @requires AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     * @memberOf AvayaCustomerServices.Providers.Interfaces
     * @define AvayaCustomerServices.Providers.Interfaces.TeamProvider
     */
    function TeamProvider() {
        AvayaCustomerServices.Providers.Interfaces.AbstractProvider.call(this);
    }

    TeamProvider.prototype =
    /** @lends AvayaCustomerServices.Providers.Interfaces.TeamProvider */
    {
        /**
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} role User's role
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getTeamState: function (handle, role) {
            throw new Error('getTeamState method must be implemented by TeamProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle User's handle
         * @param {string} role User's role
         * @param {string} teamMemberUserHandle Agent's data to fetch
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getTeamMemberState: function (handle, role, teamMemberUserHandle) {
            throw new Error('getTeamMemberState method must be implemented by TeamProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle User's handle
         * @param {string} role User's role
         * @param {string} monitor boolean for monitoring team member updates
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setTeamMonitoring: function (handle, role, monitor) {
            throw new Error('setTeamMonitoring method must be implemented by TeamProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle User's handle
         * @param {string} role User's role
         * @param {string} teamMemberUserHandle Agent's handle to monitor
         * @param {boolean} monitor boolean for monitoring team member updates
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setTeamMemberMonitoring: function (handle, role, teamMemberUserHandle, monitor) {
            throw new Error('setTeamMonitoring method must be implemented by TeamProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @param {string} [logoutReason] Reason for logging out team member
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        logoutTeamMember: function (handle, teamMemberUserHandle, logoutReason) {
            throw new Error('logoutTeamMember method must be implemented by TeamProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goReadyTeamMember: function (handle, teamMemberUserHandle) {
            throw new Error('goReadyTeamMember method must be implemented by TeamProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @param {string} [notReadyReason] Reason for setting team member into a "Not Ready" state
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goNotReadyTeamMember: function (handle, teamMemberUserHandle, notReadyReason) {
            throw new Error('goNotReadyTeamMember method must be implemented by TeamProvider subclass!');
        },
        /**
         * Start observing team member's interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        startObserving: function (handle, workRequestId, interactionId) {
            throw new Error('startObserving method must be implemented by TeamProvider subclass!');
        },
        /**
         * Stop observing team member's interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stopObserving: function (handle, workRequestId, interactionId) {
            throw new Error('stopObserving method must be implemented by TeamProvider subclass!');
        },
        /**
         * Coach on team member's interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        coach: function (handle, workRequestId, interactionId) {
            throw new Error('coach method must be implemented by TeamProvider subclass!');
        },
        /**
         * Barge in on team member's interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        bargeIn: function (handle, workRequestId, interactionId) {
            throw new Error('bargeIn method must be implemented by TeamProvider subclass!');
        },
        /**
         * Supervisor broadcast
         *
         * @abstract
         * @param {string} handle Supervisor's handle
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        broadcast: function (handle, payload) {
            throw new Error('broadcast method must be implemented by TeamProvider subclass!');
        }
    };

    _.defaults(TeamProvider.prototype, AvayaCustomerServices.Providers.Interfaces.AbstractProvider.prototype);

    AvayaCustomerServices.Providers.Interfaces.TeamProvider = TeamProvider;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Work Provider Interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Interface that defines the structure of a Work Provider.
     * @extends AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     * @requires AvayaCustomerServices.Providers.Interfaces.AbstractProvider
     * @memberOf AvayaCustomerServices.Providers.Interfaces
     * @define AvayaCustomerServices.Providers.Interfaces.WorkProvider
     */
    function WorkProvider() {
        AvayaCustomerServices.Providers.Interfaces.AbstractProvider.call(this);
    }

    WorkProvider.prototype =
    /** @lends AvayaCustomerServices.Providers.Interfaces.WorkProvider */
    {
        /**
         * Initiate an interaction
         *
         * @abstract
         * @param {string} handle
         * @param {string} type
         * @param {string} address
         * @param {string} subType
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        initiate: function (handle, type, address, subType) {
            throw new Error('initiate method must be implemented by WorkProvider subclass!');
        },
        /**
         * Accept an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        accept: function (handle, workRequestId, interactionId) {
            throw new Error('accept method must be implemented by WorkProvider subclass!');
        },
        /**
         * Put an interaction on hold
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        hold: function (handle, workRequestId, interactionId) {
            throw new Error('hold method must be implemented by WorkProvider subclass!');
        },
        /**
         * Unhold an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        unhold: function (handle, workRequestId, interactionId) {
            throw new Error('unhold method must be implemented by WorkProvider subclass!');
        },
        /**
         * Defer an email interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        defer: function (handle, workRequestId, interactionId) {
            throw new Error('end method must be implemented by WorkProvider subclass!');
        },
        /**
         * Adds an interaction to deferred list
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deferred: function (handle, workRequestId, interactionId) {
            throw new Error('deferred method must be implemented by WorkProvider subclass!');
        },
        /**
         * End an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        end: function (handle, workRequestId, interactionId) {
            throw new Error('end method must be implemented by WorkProvider subclass!');
        },
        /**
         * Perform a single step blind transfer on an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} address Remote address to transfer interaction to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transfer: function (handle, workRequestId, interactionId, address) {
            throw new Error('transfer method must be implemented by WorkProvider subclass!');
        },
        /**
         * Perform a single step blind transfer to service on an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} serviceId id to transfer interaction to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transferToService: function (handle, workRequestId, interactionId, serviceId) {
            throw new Error('transfer method must be implemented by WorkProvider subclass!');
        },
        /**
         * Perform a single step blind transfer to service on an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} userId id to transfer interaction to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transferToUser: function (handle, workRequestId, interactionId, userId) {
          throw new Error('transfer method must be implemented by WorkProvider subclass!');
        },
        /**
         * Perform a consult to service on an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} serviceId id to consult interaction to
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultToService: function (handle, workRequestId, interactionId, serviceId, uui) {
            throw new Error('consult to service method must be implemented by WorkProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} channelType Channel Type
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getServices: function (handle, workRequestId, interactionId, channelType) {
            throw new Error('getServices method must be implemented by WorkProvider subclass!');
        },
        /**
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} searchText Search text
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getUsers: function (handle, workRequestId, interactionId, searchText) {
            throw new Error('getUsers method must be implemented by WorkProvider subclass!');
        },
        /**
         * Perform a consult action on an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} address Remote address to consult
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consult: function (handle, workRequestId, interactionId, address, uui) {
            throw new Error('consult method must be implemented by WorkProvider subclass!');
        },
        /**
         * Perform a consult to user on an interaction
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkRequest ID
         * @param {string} interactionId Interaction ID
         * @param {string} userId id to consult interaction to
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
         consultToUser: function (handle, workRequestId, interactionId, userId, uui) {
            throw new Error('consult to user method must be implemented by WorkProvider subclass!');
        },
        /**
         * End an interaction by transferring to consultative address
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultCompleteAsTransfer: function (handle, workRequestId, interactionId) {
            throw new Error('consultCompleteAsTransfer method must be implemented by WorkProvider subclass!');
        },
        /**
         * Complete an interaction by conferencing with consultative address
         *
         * @abstract
         * @param {string} handle Agent handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultCompleteAsConference: function (handle, workRequestId, interactionId) {
            throw new Error('consultCompleteAsConference method must be implemented by WorkProvider subclass!');
        },
        /**
         * Set work code on an interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} workCode Work Code to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setWorkCode: function (handle, workRequestId, interactionId, workCode) {
            throw new Error('setWorkCode method must be implemented by WorkProvider subclass!');
        },
        /**
         * Set disposition code on an interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} dispositionCode Disposition Code to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setDispositionCode: function (handle, workRequestId, interactionId, dispositionCode) {
            throw new Error('setDispositionCode method must be implemented by WorkProvider subclass!');
        },
        /**
         * Send DTMF digits to an interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} dtmf DTMF character
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendDTMF: function (handle, workRequestId, interactionId, dtmf) {
            throw new Error('sendDTMF method must be implemented by WorkProvider subclass!');
        },
        /**
         * Remove interaction media file attachments
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} [attachmentId] ID of attachment to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeAttachments: function (handle, workRequestId, interactionId, attachmentId) {
            throw new Error('removeAttachments method must be implemented by WorkProvider subclass!');
        },
        /**
         * Apply draft interaction media file attachments
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyDraftAttachments: function (handle, workRequestId, interactionId) {
            throw new Error('applyDraftAttachments method must be implemented by WorkProvider subclass!');
        },
        /**
         * Apply outgoing forward attachments
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyForwardAttachments: function (handle, workRequestId, interactionId) {
            throw new Error('applyForwardAttachments method must be implemented by WorkProvider subclass!');
        },
        /**
         * Apply outgoing forward attachments
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyApprovalAttachments: function (handle, workRequestId, interactionId) {
            throw new Error('applyApprovalAttachments method must be implemented by WorkProvider subclass!');
        },
        /**
         * Extend After Contact Work for an interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        extendACW: function (handle, workRequestId, interactionId) {
            throw new Error('extendAcw method must be implemented by WorkProvider subclass!');
        },
        /**
         * Complete After Contact Work for an interaction
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        completeACW: function (handle, workRequestId, interactionId) {
            throw new Error('extendAcw method must be implemented by WorkProvider subclass!');
        },
        /**
         * Send a message to an interaction media provider
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} channel Interaction channel
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendMessage: function (handle, workRequestId, interactionId, channel, payload) {
            throw new Error('sendMessage method must be implemented by WorkProvider subclass!');
        },
        /**
         * Add a participant to conversation
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} address Address of participant to add
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        addParticipant: function (handle, workRequestId, interactionId, address) {
            throw new Error('addParticipant method must be implemented by WorkProvider subclass!');
        },
        /**
         * Remove a participant from conversation
         *
         * @abstract
         * @param {string} handle Agent's handle
         * @param {string} workRequestId WorkReQuest ID
         * @param {string} interactionId Interaction ID
         * @param {string} participantId ID of participant to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeParticipant: function (handle, workRequestId, interactionId, participantId) {
            throw new Error('removeParticipant method must be implemented by WorkProvider subclass!');
        }
    };

    _.defaults(WorkProvider.prototype, AvayaCustomerServices.Providers.Interfaces.AbstractProvider.prototype);

    AvayaCustomerServices.Providers.Interfaces.WorkProvider = WorkProvider;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines a list of default UAC configuration options
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Creates an instance of UACConfiguration that contains default settings
     * for connecting with a UAC Server
     *
     * @define AvayaCustomerServices.Config.UACConfiguration
     * @memberOf AvayaCustomerServices.Config
     * @constructor
     */
    function UACConfiguration(config) {
        /**
         * Set to true if UAC provider is enabled, false if disabled
         *
         * @public
         * @type {boolean}
         */
        this.enabled = config.enabled || false;
        /**
         * Set to false if list of methods should be disabled. "disabledMethods" contains list of disabled methods
         *
         * @public
         * @type {boolean}
         */
        this.allMethodsEnabled = config.allMethodsEnabled || true;
        /**
         * List of methods to disable
         *
         * @public
         * @type {string[]}
         */
        this.disabledMethods = config.disabledMethods || ['initiate', 'accept', 'hold', 'unhold', 'end', 'transfer', 'consult', 'sendDTMF'];
        /**
         * Creates an object containing default authentication provider configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.AuthenticationInfo}
         */
        this.authenticationInfo = new AvayaCustomerServices.Config.AuthenticationInfo(config.authenticationInfo);
        /**
         * Creates an object containing default client configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.ClientInfo}
         */
        this.clientInfo = new AvayaCustomerServices.Config.ClientInfo(config.clientInfo);
        /**
         * Creates an object containing default server configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.ServerInfo}
         */
        this.serverInfo = new AvayaCustomerServices.Config.ServerInfo(_.assignIn(config.serverInfo, {name: 'UAC'}));
        /**
         * Creates an object containing default notification provider configuration options
         *
         * @public
         * @type {AvayaCustomerServices.Config.NotificationInfo}
         */
        this.notificationInfo = new AvayaCustomerServices.Config.NotificationInfo(_.assignIn(config.notificationInfo, {name: 'Atmosphere'}));
    }

    AvayaCustomerServices.Config.UACConfiguration = UACConfiguration;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc UAC Provider Factory
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Providers.UAC.ProviderFactory
     * @memberOf AvayaCustomerServices.Providers.UAC
     * @param {AvayaCustomerServices.Base.Authentication.TokenCollection} tokenCollection
     */
    function ProviderFactory(tokenCollection) {
        /**
         * @type {AvayaCustomerServices.Providers.UAC.Provider}
         * @private
         */
        this._uacProvider = {};
        /**
         * @type {AvayaCustomerServices.Base.Network.AtmosphereProvider}
         * @private
         */
        this._notificationProvider = {};

        /**
         * @type {AvayaCustomerServices.Base.Network.RESTProvider}
         * @private
         */
        this._requestProvider = {};
        /**
         * @type {AvayaCustomerServices.Base.Authentication.TokenCollection}
         * @private
         */
        this._tokenCollection = tokenCollection;
    }

    ProviderFactory.prototype =
    /**
     * @lends AvayaCustomerServices.Providers.UAC.ProviderFactory.prototype
     */
    {
        init: function (uacConfig) {
            if (_.isEmpty(this._uacProvider)) {
                var uacMessageParser = new AvayaCustomerServices.Providers.Common.MessageParser('UAC');
                var tokenProvider = new AvayaCustomerServices.Base.Authentication.TokenProvider(this._tokenCollection, uacConfig.authenticationInfo);
                var httpOptions = new AvayaCustomerServices.Config.HTTPOptions();
                this._requestProvider = new AvayaCustomerServices.Base.Network.RESTProvider(tokenProvider, uacConfig.serverInfo, httpOptions);
                this._notificationProvider = new AvayaCustomerServices.Base.Network.AtmosphereProvider(tokenProvider, uacConfig.notificationInfo);
                this._uacProvider = new AvayaCustomerServices.Providers.UAC.Provider(this._requestProvider, this._notificationProvider, uacMessageParser, uacConfig);
            }
            return this._uacProvider;
        },
        /**
         * Unsubscribe from UAC base provider object.
         *
         * @public
         */
        destroy: function () {
            if (!_.isEmpty(this._uacProvider)) {
                this._notificationProvider.close();
                this._requestProvider.close();
                this._uacProvider = {};
            }
        }
    };

    AvayaCustomerServices.Providers.UAC.ProviderFactory = ProviderFactory;
})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Agent API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Agent
     * @define AvayaCustomerServices.Services.Agent.Agent
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Agent Model
     * @param {AvayaCustomerServices.Services.Agent.AgentService} agentService
     */
    function Agent(agentService) {
        AvayaCustomerServices.Base.Collections.Model.call(this);
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Agent.AgentService}
         */
        this._agentService = agentService;
        /**
         * A defined list of all Agent States that can be set
         *
         * @public
         * @type {AvayaCustomerServices.Services.Agent.States}
         */
        this.states = AvayaCustomerServices.Services.Agent.States;
        /**
         * A defined list of all Agent Capabilities
         *
         * @public
         * @type {AvayaCustomerServices.Services.Agent.Capabilities}
         */
        this.capabilities = AvayaCustomerServices.Services.Agent.Capabilities;
        /**
         * An agent's current state
         *
         * @public
         * @type {string}
         */
        this.state = undefined;
        /**
         * True if agent is in a activate state, otherwise false
         *
         * @public
         * @type {boolean}
         */
        this.active = undefined;
        /**
         * An agent's role. Can be "AGENT", "SUPERVISOR" or "ADMIN"
         *
         * @public
         * @type {string}
         */
        this.role = undefined;
        /**
         * @private
         * @type {Object[]}
         */
        this._userPreferences = [];
        /**
         * @private
         * @type {Object[]}
         */
        this._systemPreferences = [];
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Agent.DeviceCollection}
         */
        this._devices = new AvayaCustomerServices.Services.Agent.DeviceCollection();
        /**
         * @private
         */
        this._onActivated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onDeactivated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateLoginPending = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateReady = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateNotReady = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateNotReadyPending = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateAfterContactWork = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateAfterContactWorkPending = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateLogoutPending = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateLoggedOut = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateUnknown = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onStateComplete = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onUserPreferenceCreated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onUserPreferenceUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onUserPreferenceDeleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onSystemPreferenceUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onSystemPreferenceCreated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onSystemPreferenceDeleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onConfigurationCreated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onConfigurationUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onConfigurationDeleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onReasonCodesUpdated = new AvayaCustomerServices.Base.Callbacks();
    }

    Agent.prototype =
    /** @lends AvayaCustomerServices.Services.Agent.Agent */
    {
        /**
         * Activates an agent. If no profile is defined, the agent will be activated using default profile.
         * Similarly, if an extension is not defined, the default extension for that agent will be used.
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#activate
         * @param {string} username Agent username
         * @param {string} [profileId] Profile ID to activate
         * @param {string} [extension] Override default extension for agent
         * @param {string} [clientSessionId] preceding clientSessionId used for resyncing sessions on refresh
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        activate: function (username, profileId, extension, clientSessionId) {
            return this._agentService.activate(username, profileId, extension, clientSessionId);
        },
        /**
         * Report about expiration of activation timeout
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#reportActivateTimeout
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        reportActivateTimeout: function () {
            return this._agentService.reportActivateTimeout();
        },
        /**
         * Deactivates an agent
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#deactivate
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        deactivate: function () {
            return this._agentService.deactivate();
        },
        /**
         * Login an agent. By logging in, an agent has indicated that they are available to receive work requests.
         * Optionally, a login state can be passed as a param to explicitly set their state.
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#login
         * @param {string} [loginState=ready] Agent's state after login
         * @param {string} [workMode] Agent's work mode
         * @param {string} [notReadyReason=0] Reason for going not ready
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        login: function (loginState, workMode, notReadyReason) {
            return this._agentService.login(loginState, workMode, notReadyReason);
        },
        /**
         * Logout an agent. By logging out, an agent has indicated that they are no longer available to receive work requests.
         * Optionally, a logout reason can be passed as a param to explicitly set their reason for logging out.
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#logout
         * @param {string} [logoutReason=0] Reason for agent logging out
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        logout: function (logoutReason) {
            return this._agentService.logout(logoutReason);
        },
        /**
         * Set Agent's state to "Ready". In this state, agents are available to be routed new work requests.
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#goReady
         * @param {string} [workMode] Agent's work mode
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        goReady: function (workMode) {
            return this._agentService.goReady(workMode);
        },
        /**
         * Set Agent's state to "Not Ready". In this state, agents are not available to be routed new work requests.
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#goNotReady
         * @param {string} [notReadyReason=0] Reason for agent going into a "Not Ready" state
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        goNotReady: function (notReadyReason) {
            return this._agentService.goNotReady(notReadyReason);
        },
        /**
         * Set Agent's state to "After Contact Work".
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#goAfterContactWork
         * @param {string} [afterContactWorkReason] Reason for agent going into an "After Contact Work" state
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        goAfterContactWork: function (afterContactWorkReason) {
            return this._agentService.goAfterContactWork(afterContactWorkReason);
        },
        /**
         * Returns true if an agent has been activated, otherwise false.
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#isActivated
         * @returns {Boolean} True if agent is activated
         */
        isActivated: function () {
            return !!this.data.isActivated;
        },
        /**
         * Return an Agent's user handle
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#getHandle
         * @returns {string} Agent's user handle
         */
        getHandle: function () {
            return this.data.handle;
        },
        /**
         * Set an Agent's user handle
         *
         * @public
         * @param handle user handle to set
         * @function AvayaCustomerServices.Services.Agent.Agent#getHandle
         * @returns {string} Agent's user handle
         */
        setHandle: function (handle) {
            this.data.handle = handle;
        },
        /**
         * Returns an agent's current profile Id
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#getProfileId
         * @returns {string} Agent's profile ID
         */
        getProfileId: function () {
            return this.data.profileId;
        },
        /**
         * Returns all User Preference data
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#getUserPreferences
         * @returns {Object[]} Array of User Preference objects
         */
        getUserPreferences: function () {
            return this._userPreferences;
        },
        /**
         * Returns an Agent's role
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#getRole
         * @returns {string} Agent's role
         */
        getRole: function () {
            return this.role;
        },
        /**
         * Create/update User Preference
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#setUserPreference
         * @param {Object|Array} preference Data to use to create/update User Preference
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @param {string} [clientSessionId] Client Session ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        setUserPreference: function (preference, profileId, accountId, clientSessionId) {
            return this._agentService.setUserPreference(preference, profileId, accountId, clientSessionId);
        },
        /**
         * Remove User Preference
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#removeUserPreference
         * @param {string|Array} preferenceId Id or array of Ids used to remove User Preferences
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        removeUserPreference: function (preferenceId, profileId, accountId) {
            return this._agentService.removeUserPreference(preferenceId, profileId, accountId);
        },
        /**
         * Set User Preference data
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#setUserPreferenceData
         * @param {Object} data User preference data to set
         * @returns {object} Agent model data
         */
        setUserPreferenceData: function (data) {
            var preference = _.find(this._userPreferences, {id: data.id});
            if (!preference) {
                return this._userPreferences.push(data);
            }
            return _.assignIn(preference, data);
        },
        /**
         * Remove User Preference data
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#removeUserPreferenceData
         * @param {Object} data User preference data to remove
         * @returns {Object|boolean} Removed object or false if could not be found/removed
         */
        removeUserPreferenceData: function (data) {
            var model = _.find(this._userPreferences, {id: data.id});
            var index = _.indexOf(this._userPreferences, model);
            if (index !== -1) {
                return this._userPreferences.splice(index, 1)[0];
            }
            return false;
        },
        /**
         * Returns all System Preference data
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#getSystemPreferences
         * @returns {Object[]} Array of System Preference objects
         */
        getSystemPreferences: function () {
            return this._systemPreferences;
        },
        /**
         * Create/update System Preference
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#setSystemPreference
         * @param {Object|Array} preference Data to use to create/update System Preference
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        setSystemPreference: function (preference) {
            return this._agentService.setSystemPreference(preference);
        },
        /**
         * Remove System Preference
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#removeSystemPreference
         * @param {string|Array} preferenceId Id or array of Ids used to remove System Preferences
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        removeSystemPreference: function (preferenceId) {
            return this._agentService.removeSystemPreference(preferenceId);
        },
        /**
         * Set System Preference data
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#setSystemPreferenceData
         * @param {Object} data System preference data to set
         * @returns {object} Agent model data
         */
        setSystemPreferenceData: function (data) {
            var preference = _.find(this._systemPreferences, {id: data.id});
            if (!preference) {
                return this._systemPreferences.push(data);
            }
            return _.assignIn(preference, data);
        },
        /**
         * Remove System Preference data
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#removeSystemPreferenceData
         * @param {Object} data System preference data to remove
         * @returns {Object|boolean} Removed object or false if could not be found/removed
         */
        removeSystemPreferenceData: function (data) {
            var model = _.find(this._systemPreferences, {id: data.id});
            var index = _.indexOf(this._systemPreferences, model);
            if (index !== -1) {
                return this._systemPreferences.splice(index, 1)[0];
            }
            return false;
        },
        /**
         * Gets client sessions for a user
         *
         * @since 3.4.0.0
         * @function AvayaCustomerServices.Services.Agent.Agent#getClientSessions
         * @param authServerUser Authorization Server User ID
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        getClientSessions: function (authServerUser) {
            return this._agentService.getClientSessions(authServerUser);
        },
        /**
         * Get devices for agent
         *
         * @since 3.4.0.0
         * @function AvayaCustomerServices.Services.Agent.Agent#getDevices
         * @returns {AvayaCustomerServices.Services.Agent.DeviceCollection}
         */
        getDevices: function () {
            return this._devices;
        },
        /**
         * @since 3.8.0.1
         * @function AvayaCustomerServices.Services.Agent.Agent#getUserAgent
         * @returns {Object}
         */
        getUserAgent: function () {
            return this._agentService.getUserAgent();
        },
        /**
         * Set Agent data.
         *
         * @private
         * @override
         * @function AvayaCustomerServices.Services.Agent.Agent#setData
         * @param {Object} data Agent model data to set
         * @returns {object} Agent model data
         */
        setData: function (data) {
            _.assignSafe(this, {
                state: data.currentState,
                capabilities: data.capabilities,
                active: data.isActivated,
                role: data.role
            });

            return _.assignIn(this.data, data);
        },
        /**
         * The event data that is passed back to onActivatedCallback
         * @typedef {Object} AgentActivateEvent
         * @property {string} id Agent's ID
         * @property {string} handle Agent's Handle
         * @property {string} role Agent's role e.g. ADMIN|SUPERVISOR|AGENT
         * @property {string} firstName Agent's first name
         * @property {string} lastName Agent's surname
         * @property {string} displayName Name to display for Agent
         * @property {string} mailboxNumber Agent's mailbox number
         * @property {string} trunkAccessCode Agent's trunk access code
         * @property {Object[]} reasonCodes List of reason codes for this Agent
         * @property {Object[]} userProfilePreferences List of user profile preferences for Agent
         * @property {Object[]} userProfileAccountPreferences List of user profile account preferences for Agent
         * @property {boolean} isActivated Flag to indicate if agent is activated
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         */
        /**
         * This callback handles the AgentActivateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onActivatedCallback
         * @param {AgentActivateEvent} message The event that is fired when an agent has been activated
         */
        /**
         * Adds a callback that is executed when an agent has been activated
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnActivatedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onActivatedCallback} callback Function that handles on activated event response
         */
        addOnActivatedCallback: function (callback) {
            this._onActivated.add(callback);
        },
        /**
         * The event data that is passed back to onDeactivatedCallback
         * @typedef {Object} AgentDeactivateEvent
         * @property {boolean} isActivated Flag to indicate if agent is activated
         * @property {string} reason Reason for agent being deactivated
         */
        /**
         * This callback handles the AgentDeactivateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onDeactivatedCallback
         * @param {AgentDeactivateEvent} message The event that is fired when an agent has been deactivated
         */
        /**
         * Adds a callback that is executed when an agent has been deactivated
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnDeactivatedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onDeactivatedCallback} callback Function that handles on deactivated event response
         */
        addOnDeactivatedCallback: function (callback) {
            this._onDeactivated.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to LOGIN_PENDING
         * @typedef {Object} AgentLoginPendingStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         */
        /**
         * This callback handles the AgentLoginPendingStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onLoginPendingCallback
         * @param {AgentLoginPendingStateEvent} message The event that is fired when an agent is in a login pending state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to login pending
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateLoginPendingCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onLoginPendingCallback} callback Function that handles on login pending event response
         */
        addOnStateLoginPendingCallback: function (callback) {
            this._onStateLoginPending.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to READY
         * @typedef {Object} AgentReadyStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         */
        /**
         * This callback handles the AgentReadyStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onReadyCallback
         * @param {AgentReadyStateEvent} message The event that is fired when an agent is in a ready state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to ready
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateReadyCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onReadyCallback} callback Function that handles on ready event response
         */
        addOnStateReadyCallback: function (callback) {
            this._onStateReady.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to NOT_READY_PENDING
         * @typedef {Object} AgentNotReadyPendingStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         * @property {string} reasonCode Not ready reason code
         */
        /**
         * This callback handles the AgentNotReadyPendingStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onNotReadyPendingCallback
         * @param {AgentNotReadyPendingStateEvent} message The event that is fired when an agent is in a not ready pending state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to not ready pending
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateNotReadyPendingCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onNotReadyPendingCallback} callback Function that handles on not ready pending event response
         */
        addOnStateNotReadyPendingCallback: function (callback) {
            this._onStateNotReadyPending.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to NOT_READY
         * @typedef {Object} AgentNotReadyStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         * @property {string} reasonCode Not ready reason code
         */
        /**
         * This callback handles the AgentNotReadyStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onNotReadyCallback
         * @param {AgentNotReadyStateEvent} message The event that is fired when an agent is in a not ready state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to not ready
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateNotReadyCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onNotReadyCallback} callback Function that handles on not ready event response
         */
        addOnStateNotReadyCallback: function (callback) {
            this._onStateNotReady.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to AFTER_CONTACT_WORK_PENDING
         * @typedef {Object} AgentAfterContactWorkPendingStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         * @property {string} reasonCode Not ready reason code
         */
        /**
         * This callback handles the AgentAfterContactWorkPendingStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onAfterContactWorkPendingCallback
         * @param {AgentAfterContactWorkPendingStateEvent} message The event that is fired when an agent is in a after contact work state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to after contact work pending
         *
         * @public
         * @since 3.4.0.1
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateAfterContactWorkPendingCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onAfterContactWorkPendingCallback} callback Function that handles on after contact work pending event response
         */
        addOnStateAfterContactWorkPendingCallback: function (callback) {
            this._onStateAfterContactWorkPending.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to AFTER_CONTACT_WORK
         * @typedef {Object} AgentAfterContactWorkStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         * @property {string} reasonCode Not ready reason code
         */
        /**
         * This callback handles the AgentAfterContactWorkStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onAfterContactWorkCallback
         * @param {AgentAfterContactWorkStateEvent} message The event that is fired when an agent is in a after contact work state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to after contact work
         *
         * @public
         * @since 3.4.0.1
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateAfterContactWorkCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onAfterContactWorkCallback} callback Function that handles on after contact work event response
         */
        addOnStateAfterContactWorkCallback: function (callback) {
            this._onStateAfterContactWork.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to LOGOUT_PENDING
         * @typedef {Object} AgentLogoutPendingStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         * @property {string} reasonCode Log out reason code
         */
        /**
         * This callback handles the AgentLogoutPendingStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onLogoutPendingCallback
         * @param {AgentLogoutPendingStateEvent} message The event that is fired when an agent is in a logout pending state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to logout pending
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateLogoutPendingCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onLogoutPendingCallback} callback Function that handles on logout pending event response
         */
        addOnStateLogoutPendingCallback: function (callback) {
            this._onStateLogoutPending.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to LOGGED_OUT
         * @typedef {Object} AgentLoggedOutStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         * @property {string} reasonCode Log out reason code
         */
        /**
         * This callback handles the AgentLoggedOutStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onLoggedOutCallback
         * @param {AgentLoggedOutStateEvent} message The event that is fired when an agent is in a logged out state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to logged out
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateLoggedOutCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onLoggedOutCallback} callback Function that handles on logged out event response
         */
        addOnStateLoggedOutCallback: function (callback) {
            this._onStateLoggedOut.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to COMPLETE
         * @typedef {Object} AgentCompleteStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         */
        /**
         * This callback handles the AgentCompleteStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onCompleteStateCallback
         * @param {AgentCompleteStateEvent} message The event that is fired when an agent is in a complete state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to complete
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateCompleteCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onCompleteStateCallback} callback Function that handles on complete event response
         */
        addOnStateCompleteCallback: function (callback) {
            this._onStateComplete.add(callback);
        },
        /**
         * The event that is fired when an agent's state has been changed to UNKNOWN
         * @typedef {Object} AgentUnknownStateEvent
         * @property {Object} resourceStates Contains information for each resource that the agent has acquired
         * @property {string} currentState Agent's current state
         * @property {string} previousState Agent's last current state
         * @property {Object} capabilities List of capabilities for this agent
         * @property {boolean} isReserveActive Flag to indicate if agent is a Reserve on any channel
         * @property {string} lastStateChangeTime Time of last state change
         */
        /**
         * This callback handles the AgentUnknownStateEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUnknownCallback
         * @param {AgentUnknownStateEvent} message The event that is fired when an agent is in a unknown state
         */
        /**
         * Adds a callback that is executed when an agent's state has been changed to unknown
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnStateUnknownCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUnknownCallback} callback Function that handles on unknown event response
         */
        addOnStateUnknownCallback: function (callback) {
            this._onStateUnknown.add(callback);
        },
        /**
         * The event that is fired when an user preference has been added
         * @typedef {Object} UserPreferenceCreatedEvent
         * @property {string} id User Preference ID
         * @property {string} group User Preference group
         * @property {string} key User Preference key
         * @property {string} value User Preference value
         * @property {string} type User Preference type
         */
        /**
         * This callback handles the UserPreferenceCreatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUserPreferenceAdded
         * @param {UserPreferenceCreatedEvent} message The event that is fired when a user preference has been added
         */
        /**
         * Adds a callback that is executed when a user preference has been added
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnUserPreferenceAddedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUserPreferenceAdded} callback Function that is executed on user preference added callback
         */
        addOnUserPreferenceAddedCallback: function (callback) {
            this._onUserPreferenceCreated.add(callback);
        },
        /**
         * The event that is fired when an system preference has been added
         * @typedef {Object} SystemPreferenceCreatedEvent
         * @property {string} id System Preference ID
         * @property {string} group System Preference group
         * @property {string} key System Preference key
         * @property {string} value System Preference value
         * @property {string} type System Preference type
         */
        /**
         * This callback handles the SystemPreferenceCreatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onSystemPreferenceAdded
         * @param {SystemPreferenceCreatedEvent} message The event that is fired when a system preference has been added
         */
        /**
         * Adds a callback that is executed when a system preference has been added
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnSystemPreferenceAddedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onSystemPreferenceAdded} callback Function that is executed on system preference added callback
         */
        addOnSystemPreferenceAddedCallback: function (callback) {
            this._onSystemPreferenceCreated.add(callback);
        },
        /**
         * The event that is fired when an user preference has been updated
         * @typedef {Object} UserPreferenceUpdatedEvent
         * @property {string} id User Preference ID
         * @property {string} group User Preference group
         * @property {string} key User Preference key
         * @property {string} value User Preference value
         * @property {string} type User Preference type
         */
        /**
         * This callback handles the UserPreferenceUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUserPreferenceUpdated
         * @param {UserPreferenceUpdatedEvent} message The event that is fired when a user preference has been updated
         */
        /**
         * Adds a callback that is executed when a user preference has been updated
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnUserPreferenceUpdatedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUserPreferenceUpdated} callback Function that is executed on user preference updated callback
         */
        addOnUserPreferenceUpdatedCallback: function (callback) {
            this._onUserPreferenceUpdated.add(callback);
        },
        /**
         * The event that is fired when an user preference has been removed
         * @typedef {Object} UserPreferenceDeletedEvent
         * @property {string} id ID of user preference to remove
         */
        /**
         * This callback handles the UserPreferenceDeletedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUserPreferenceRemoved
         * @param {UserPreferenceDeletedEvent} message The event that is fired when a user preference has been removed
         */
        /**
         * Adds a callback that is executed when a user preference has been removed
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnUserPreferenceRemovedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUserPreferenceRemoved} callback Function that is executed on preference removed callback
         */
        addOnUserPreferenceRemovedCallback: function (callback) {
            this._onUserPreferenceDeleted.add(callback);
        },
        /**
         * The event that is fired when an system preference has been removed
         * @typedef {Object} SystemPreferenceDeletedEvent
         * @property {string} id ID of system preference to remove
         */
        /**
         * This callback handles the UserPreferenceDeletedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onSystemPreferenceRemoved
         * @param {SystemPreferenceDeletedEvent} message The event that is fired when a system preference has been removed
         */
        /**
         * Adds a callback that is executed when a system preference has been removed
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnSystemPreferenceRemovedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onSystemPreferenceRemoved} callback Function that is executed on preference removed callback
         */
        addOnSystemPreferenceRemovedCallback: function (callback) {
            this._onSystemPreferenceDeleted.add(callback);
        },
        /**
         * The event that is fired when an system preference has been updated
         * @typedef {Object} SystemPreferenceUpdatedEvent
         * @property {string} id System Preference ID
         * @property {string} group System Preference group
         * @property {string} key System Preference key
         * @property {string} value System Preference value
         * @property {string} type System Preference type
         */
        /**
         * This callback handles the SystemPreferenceUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onSsytemPreferenceUpdated
         * @param {SystemPreferenceUpdatedEvent} message The event that is fired when a system preference has been updated
         */
        /**
         * Adds a callback that is executed when a system preference has been updated
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnSystemPreferenceUpdatedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onSystemPreferenceUpdated} callback Function that is executed on system preference updated callback
         */
        addOnSystemPreferenceUpdatedCallback: function (callback) {
            this._onSystemPreferenceUpdated.add(callback);
        },
        /**
         * The event that is fired when a user configuration has been added
         * @typedef {Object} ConfigurationCreatedEvent
         * @property {Object} settings List of user configuration settings
         */
        /** 
         * This callback handles the ConfigurationCreatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUserConfigurationAdded
         * @param {ConfigurationCreatedEvent} message The event that is fired when a user configuration has been added
         */
        /**
         * Adds a callback that is executed when a user configuration has been added
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnConfigurationAddedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUserConfigurationAdded} callback Function that is executed on user configuration added callback
         */
        addOnConfigurationAddedCallback: function (callback) {
            this._onConfigurationCreated.add(callback);
        },
        /**
         * The event that is fired when an user configuration has been updated
         * @typedef {Object} ConfigurationUpdatedEvent
         * @property {Object} settings List of user configuration settings
         */
        /**
         * This callback handles the ConfigurationUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUserConfigurationUpdated
         * @param {ConfigurationUpdatedEvent} message The event that is fired when a user configuration has been updated
         */
        /**
         * Adds a callback that is executed when a user configuration has been updated
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnConfigurationUpdatedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUserConfigurationUpdated} callback Function that is executed on configuration updated callback
         */
        addOnConfigurationUpdatedCallback: function (callback) {
            this._onConfigurationUpdated.add(callback);
        },
        /**
         * The event that is fired when an user configuration has been removed
         * @typedef {Object} ConfigurationDeletedEvent
         * @property {Object} settings List of user configuration settings
         */
        /**
         * This callback handles the ConfigurationDeletedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onUserConfigurationRemoved
         * @param {ConfigurationDeletedEvent} message The event that is fired when a user configuration has been removed
         */
        /**
         * Adds a callback that is executed when a user configuration has been removed
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnConfigurationRemovedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onUserConfigurationRemoved} callback Function that is executed on configuration removed callback
         */
        addOnConfigurationRemovedCallback: function (callback) {
            this._onConfigurationDeleted.add(callback);
        },
        /**
         * The event that is fired when reason codes have beed updated
         * @typedef {Object} ReasonCodesUpdatedEvent
         * @property {Array} reasonCodes List of reason codes
         */
        /**
         * This callback handles the ReasonCodesUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Agent.Agent~onReasonCodesUpdated
         * @param {ReasonCodesUpdatedEvent} message The event that is fired when reason codes have beed updated
         */
        /**
         * Adds a callback that is executed when reason codes have beed updated
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#addOnReasonCodesUpdatedCallback
         * @param {AvayaCustomerServices.Services.Agent.Agent~onReasonCodesUpdated} callback Function that is executed on reason codes updated callback
         */
        addOnReasonCodesUpdatedCallback: function (callback) {
            this._onReasonCodesUpdated.add(callback);
        },
        /**
         * Remove callbacks and stop agent service
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Agent#removeCallbacks
         */
        removeCallbacks: function () {
            this._onActivated.empty();
            this._onDeactivated.empty();
            this._onStateLoginPending.empty();
            this._onStateReady.empty();
            this._onStateNotReady.empty();
            this._onStateNotReadyPending.empty();
            this._onStateAfterContactWork.empty();
            this._onStateAfterContactWorkPending.empty();
            this._onStateLogoutPending.empty();
            this._onStateLoggedOut.empty();
            this._onStateUnknown.empty();
            this._onStateComplete.empty();
            this._onUserPreferenceCreated.empty();
            this._onUserPreferenceUpdated.empty();
            this._onUserPreferenceDeleted.empty();
            this._onSystemPreferenceUpdated.empty();
            this._onSystemPreferenceDeleted.empty();
            this._onSystemPreferenceCreated.empty();
            this._onConfigurationCreated.empty();
            this._onConfigurationUpdated.empty();
            this._onConfigurationDeleted.empty();
            this._onReasonCodesUpdated.empty();

            this._agentService.stop();
        }
    };

    _.defaults(Agent.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Agent.Agent = Agent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent Service
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Agent
     * @define AvayaCustomerServices.Services.Agent.AgentService
     * @param {AvayaCustomerServices.Providers.Interfaces.AgentProvider} agentProvider
     */
    function AgentService(agentProvider) {
        /**
         * @private
         * @type {boolean}
         */
        this._started = false;
        /**
         * @private
         * @type {AvayaCustomerServices.Providers.Interfaces.AgentProvider}
         */
        this._agentProvider = agentProvider;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Agent.Agent}
         */
        this._agent = undefined;
    }

    AgentService.prototype =
    /** @lends AvayaCustomerServices.Services.Agent.AgentService */
    {
        /**
         * Starts the agent service
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#init
         * @param {AvayaCustomerServices.Services.Agent.Agent} agent
         */
        init: function (agent) {
            this._started = true;
            this._agent = agent;

            this._agentProvider.on('agent.activated', _.bind(onAgentActivated, null, agent, this._agentProvider));
            this._agentProvider.on('agent.deactivated', _.bind(onAgentDeactivated, null, agent, this._agentProvider));

            this._agentProvider.on('agent.state.login_pending', _.bind(onAgentLoginPending, null, agent));
            this._agentProvider.on('agent.state.ready', _.bind(onAgentReady, null, agent));
            this._agentProvider.on('agent.state.not_ready_pending', _.bind(onAgentNotReadyPending, null, agent));
            this._agentProvider.on('agent.state.not_ready', _.bind(onAgentNotReady, null, agent));
            this._agentProvider.on('agent.state.after_contact_work_pending', _.bind(onAgentAfterContactWorkPending, null, agent));
            this._agentProvider.on('agent.state.after_contact_work', _.bind(onAgentAfterContactWork, null, agent));
            this._agentProvider.on('agent.state.logout_pending', _.bind(onAgentLogoutPending, null, agent));
            this._agentProvider.on('agent.state.logged_out', _.bind(onAgentLoggedOut, null, agent));
            this._agentProvider.on('agent.state.complete', _.bind(onAgentComplete, null, agent));
            this._agentProvider.on('agent.state.unknown', _.bind(onAgentUnknown, null, agent));

            this._agentProvider.on('user_preference.created', _.bind(onUserPreferenceCreated, null, agent));
            this._agentProvider.on('user_preference.updated', _.bind(onUserPreferenceUpdated, null, agent));
            this._agentProvider.on('user_preference.deleted', _.bind(onUserPreferenceDeleted, null, agent));
            this._agentProvider.on('system_preference.updated', _.bind(onSystemPreferenceUpdated, null, agent));
            this._agentProvider.on('system_preference.deleted', _.bind(onSystemPreferenceDeleted, null, agent));
            this._agentProvider.on('system_preference.created', _.bind(onSystemPreferenceCreated, null, agent));

            this._agentProvider.on('configuration.updated', _.bind(onConfigurationUpdated, null, agent));

            this._agentProvider.on('reason_codes.created', _.bind(onReasonCodesUpdated, null, agent));
            this._agentProvider.on('reason_codes.updated', _.bind(onReasonCodesUpdated, null, agent));

            this._agentProvider.on('devices.audio_input.added', _.bind(onAudioInputAdded, null, agent));
            this._agentProvider.on('devices.audio_input.removed', _.bind(onAudioInputRemoved, null, agent));
            this._agentProvider.on('devices.audio_input.unavailable', _.bind(onAudioInputUnavailable, null, agent));
            this._agentProvider.on('devices.audio_input.selected', _.bind(onAudioInputSelected, null, agent));
            this._agentProvider.on('devices.audio_input.loaded', _.bind(onAudioInputLoaded, null, agent));
            this._agentProvider.on('devices.audio_output.added', _.bind(onAudioOutputAdded, null, agent));
            this._agentProvider.on('devices.audio_output.removed', _.bind(onAudioOutputRemoved, null, agent));
            this._agentProvider.on('devices.audio_output.unavailable', _.bind(onAudioOutputUnavailable, null, agent));
            this._agentProvider.on('devices.audio_output.selected', _.bind(onAudioOutputSelected, null, agent));
            this._agentProvider.on('devices.audio_output.loaded', _.bind(onAudioOutputLoaded, null, agent));
            this._agentProvider.on('devices.video.added', _.bind(onVideoAdded, null, agent));
            this._agentProvider.on('devices.video.removed', _.bind(onVideoRemoved, null, agent));
            this._agentProvider.on('devices.video.unavailable', _.bind(onVideoUnavailable, null, agent));
            this._agentProvider.on('devices.video.selected', _.bind(onVideoSelected, null, agent));
            this._agentProvider.on('devices.video.loaded', _.bind(onVideoLoaded, null, agent));
        },
        /**
         * Stops the agent service
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#stop
         */
        stop: function () {
            this._started = false;
            this._agentProvider.removeListeners('agent');
            this._agentProvider.removeListeners('user_preference');
            this._agentProvider.removeListeners('system_preference');
            this._agentProvider.removeListeners('configuration');
            this._agentProvider.removeListeners('reason_codes');
            this._agentProvider.removeListeners('devices');
        },
        /**
         * Checked running state of agent service
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#isStarted
         * @returns {boolean}
         */
        isStarted: function () {
            return this._started;
        },
        /**
         * Activate agent
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#activate
         * @param {string} handle
         * @param {string} [profileId]
         * @param {string} [extension]
         * @param {string} [clientSessionId] preceding clientSessionId used for resyncing sessions on refresh
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        activate: function (handle, profileId, extension, clientSessionId) {
            return this._agentProvider.activate(handle, profileId, extension, clientSessionId);
        },
        /**
         * Report about expiration of activation timeout
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#reportActivateTimeout
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        reportActivateTimeout: function () {
            var handle = this._agent.getHandle();
            return this._agentProvider.reportActivateTimeout(handle);
        },
        /**
         * Deactivate agent
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#deactivate
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deactivate: function () {
            var handle = this._agent.getHandle();
            return this._agentProvider.deactivate(handle);
        },
        /**
         * Login user and set state
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#login
         * @param {string} loginState
         * @param {string} workMode
         * @param {string} [notReadyReason]
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        login: function (loginState, workMode, notReadyReason) {
            var handle = this._agent.getHandle();
            return this._agentProvider.login(handle, loginState, workMode, notReadyReason);
        },
        /**
         * Logout user
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#logout
         * @param {string} logoutReason
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        logout: function (logoutReason) {
            var handle = this._agent.getHandle();
            return this._agentProvider.logout(handle, logoutReason);
        },
        /**
         * Set Agent's state to "Ready"
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#goReady
         * @param {string} workMode
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goReady: function (workMode) {
            var handle = this._agent.getHandle();
            return this._agentProvider.goReady(handle, workMode);
        },
        /**
         * Set Agent's state to "Not Ready"
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#goNotReady
         * @param {string} notReadyReason
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goNotReady: function (notReadyReason) {
            var handle = this._agent.getHandle();
            return this._agentProvider.goNotReady(handle, notReadyReason);
        },
        /**
         * Set Agent's state to "After Contact Work"
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#goAfterContactWork
         * @param {string} afterContactWorkReason
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goAfterContactWork: function (afterContactWorkReason) {
            var handle = this._agent.getHandle();
            return this._agentProvider.goAfterContactWork(handle, afterContactWorkReason);
        },
        /**
         * Create/update User Preference
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#setUserPreference
         * @param {Object|Array} preference Data to use to create/update User Preference
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @param {string} [clientSessionId] Client Session ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setUserPreference: function (preference, profileId, accountId, clientSessionId) {
            var handle = this._agent.getHandle();
            var payload = JSON.stringify(preference);
            return this._agentProvider.setUserPreference(handle, payload, profileId, accountId, clientSessionId);
        },
        /**
         * Remove User Preference
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#removeUserPreference
         * @param {string|Array} preferenceId Id or array of Ids used to remove User Preferences
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeUserPreference: function (preferenceId, profileId, accountId) {
            var handle = this._agent.getHandle();
            var payload = JSON.stringify(preferenceId);
            return this._agentProvider.removeUserPreference(handle, payload, profileId, accountId);
        },
        /**
         * Create/update User Preference
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#setSystemPreference
         * @param {Object|Array} preference Data to use to create/update System Preference
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setSystemPreference: function (preference) {
            var clientId = 'workspaces';
            var payload = JSON.stringify(preference);
            return this._agentProvider.setSystemPreference(clientId, payload);
        },
        /**
         * Remove System Preference
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#removeSystemPreference
         * @param {string|Array} preferenceId Id or array of Ids used to remove System Preferences
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeSystemPreference: function (preferenceId) {
            var clientId = 'workspaces';
            var payload = JSON.stringify(preferenceId);
            return this._agentProvider.removeSystemPreference(clientId, payload);
        },
        /**
         * Get client Sessions for a user
         * @param username
         * @returns {Array} Client Sessions
         */
        getClientSessions: function (username) {
            return this._agentProvider.getClientSessions(username);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Agent.AgentService#getUserAgent
         * @returns {Object}
         */
        getUserAgent: function () {
            var userAgent;
            if (_.isFunction(this._agentProvider.getUserAgent)) {
                userAgent = this._agentProvider.getUserAgent();
            }
            return userAgent;
        },
    };

    /**
     * @private
     * @function onAgentActivated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {AvayaCustomerServices.Providers.Interfaces.AgentProvider} provider
     * @param {Object} message
     */
    function onAgentActivated(agent, provider, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentActivated',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onActivated.fire(message);
        provider.trigger('user.startCallService');
    }

    /**
     * @private
     * @function onAgentDeactivated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {AvayaCustomerServices.Providers.Interfaces.AgentProvider} provider
     * @param {Object} message
     */
    function onAgentDeactivated(agent, provider, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentDeactivated',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onDeactivated.fire(message);
        provider.trigger('user.stopCallService');
    }

    /**
     * @private
     * @function onAgentLoginPending
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentLoginPending(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentLoginPending',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateLoginPending.fire(message);
    }

    /**
     * @private
     * @function onAgentReady
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentReady(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentReady',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateReady.fire(message);
    }

    /**
     * @private
     * @function onAgentNotReadyPending
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentNotReadyPending(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentNotReadyPending',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateNotReadyPending.fire(message);
    }

    /**
     * @private
     * @function onAgentNotReady
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentNotReady(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentNotReady',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateNotReady.fire(message);
    }

    /**
     * @private
     * @function onAgentAfterContactWorkPending
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentAfterContactWorkPending(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentAfterContactWorkPending',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateAfterContactWorkPending.fire(message);
    }

    /**
     * @private
     * @function onAgentAfterContactWork
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentAfterContactWork(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentAfterContactWork',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateAfterContactWork.fire(message);
    }

    /**
     * @private
     * @function onAgentLogoutPending
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentLogoutPending(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentLogoutPending',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateLogoutPending.fire(message);
    }

    /**
     * @private
     * @function onAgentLoggedOut
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentLoggedOut(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentLoggedOut',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateLoggedOut.fire(message);
    }

    /**
     * @private
     * @function onAgentComplete
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentComplete(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentComplete',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateComplete.fire(message);
    }

    /**
     * @private
     * @function onAgentUnknown
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAgentUnknown(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAgentUnknown',
            message: message,
            context: { agent: agent.data }
        });
        agent.setData(message);
        agent._onStateUnknown.fire(message);
    }

    /**
     * @private
     * @function onUserPreferenceCreated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onUserPreferenceCreated(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onUserPreferenceCreated',
            message: message,
            context: { agent: agent.data }
        });
        agent.setUserPreferenceData(message);
        agent._onUserPreferenceCreated.fire(message);
    }

    /**
     * @private
     * @function onUserPreferenceUpdated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onUserPreferenceUpdated(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onUserPreferenceUpdated',
            message: message,
            context: { agent: agent.data }
        });
        agent.setUserPreferenceData(message);
        agent._onUserPreferenceUpdated.fire(message);
    }

    /**
     * @private
     * @function onUserPreferenceDeleted
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onUserPreferenceDeleted(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onUserPreferenceDeleted',
            message: message,
            context: { agent: agent.data }
        });
        agent.removeUserPreferenceData(message);
        agent._onUserPreferenceDeleted.fire(message);
    }

    /**
     * @private
     * @function onSystemPreferenceUpdated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onSystemPreferenceUpdated(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onSystemPreferenceUpdated',
            message: message,
            context: { agent: agent.data }
        });
        agent.setSystemPreferenceData(message);
        agent._onSystemPreferenceUpdated.fire(message);
    }

    /**
     * @private
     * @function onSystemPreferenceCreated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onSystemPreferenceCreated(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onSystemPreferenceCreated',
            message: message,
            context: { agent: agent.data }
        });
        agent.setSystemPreferenceData(message);
        agent._onSystemPreferenceCreated.fire(message);
    }

    /**
     * @private
     * @function onSystemPreferenceDeleted
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onSystemPreferenceDeleted(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onSystemPreferenceDeleted',
            message: message,
            context: { agent: agent.data }
        });
        agent.removeSystemPreferenceData(message);
        agent._onSystemPreferenceDeleted.fire(message);
    }

    /**
     * @private
     * @function onConfigurationUpdated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onConfigurationUpdated(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onConfigurationUpdated',
            message: message,
            context: { agent: agent.data }
        });
        agent._onConfigurationUpdated.fire(message);
    }

    /**
     * @private
     * @function onReasonCodesUpdated
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onReasonCodesUpdated(agent, message) {
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onReasonCodesUpdated',
            message: message,
            context: { agent: agent.data }
        });
        agent._onReasonCodesUpdated.fire(message);
    }

    /**
     * @private
     * @function onAudioInputAdded
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioInputAdded(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.add(device);
                agentDevices._onAudioInputAdded.fire(device);
            });
        } else if (!!message.device) {
            agentDevices.add(message.device);
            agentDevices._onAudioInputAdded.fire(message.device);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioInputAdded',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onAudioInputRemoved
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioInputRemoved(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.remove(device);
                agentDevices._onAudioInputRemoved.fire(device);
            });
        } else if (!!message.device) {
            agentDevices.remove(message.device);
            agentDevices._onAudioInputRemoved.fire(message.device);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioInputRemoved',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onAudioInputUnavailable
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioInputUnavailable(agent, message) {
        var devices = agent.getDevices();
        devices._onAudioInputUnavailable.fire(message);
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioInputUnavailable',
            message: message,
            context: { agent: agent.data, devices: devices }
        });
    }
    /**
     * @private
     * @function onAudioInputSelected
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioInputSelected(agent, message) {
        var devices = agent.getDevices();
        devices._onAudioInputSelected.fire(message);
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioInputSelected',
            message: message,
            context: { agent: agent.data, devices: devices }
        });
    }
    /**
     * @private
     * @function onAudioInputLoaded
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioInputLoaded(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.add(device);
            });
            agentDevices._onAudioInputLoaded.fire(message.devices);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioInputLoaded',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onAudioOutputAdded
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioOutputAdded(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.add(device);
                agentDevices._onAudioOutputAdded.fire(device);
            });
        } else if (!!message.device) {
            agentDevices.add(message.device);
            agentDevices._onAudioOutputAdded.fire(message.device);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioOutputAdded',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onAudioOutputRemoved
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioOutputRemoved(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.remove(device);
                agentDevices._onAudioOutputRemoved.fire(device);
            });
        } else if (!!message.device) {
            agentDevices.remove(message.device);
            agentDevices._onAudioOutputRemoved.fire(message.device);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioOutputRemoved',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onAudioOutputUnavailable
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioOutputUnavailable(agent, message) {
        var devices = agent.getDevices();
        devices._onAudioOutputUnavailable.fire(message);
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioOutputUnavailable',
            message: message,
            context: { agent: agent.data, devices: devices }
        });
    }
    /**
     * @private
     * @function onAudioOutputSelected
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioOutputSelected(agent, message) {
        var devices = agent.getDevices();
        devices._onAudioOutputSelected.fire(message);
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioOutputSelected',
            message: message,
            context: { agent: agent.data, devices: devices }
        });
    }
    /**
     * @private
     * @function onAudioOutputLoaded
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onAudioOutputLoaded(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.add(device);
            });
            agentDevices._onAudioOutputLoaded.fire(message.devices);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onAudioOutputLoaded',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onVideoAdded
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onVideoAdded(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.add(device);
                agentDevices._onVideoAdded.fire(device);
            });
        } else if (!!message.device) {
            agentDevices.add(message.device);
            agentDevices._onVideoAdded.fire(message.device);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onVideoAdded',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onVideoRemoved
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onVideoRemoved(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.remove(device);
                agentDevices._onVideoRemoved.fire(device);
            });
        } else if (!!message.device) {
            agentDevices.remove(message.device);
            agentDevices._onVideoRemoved.fire(message.device);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onVideoRemoved',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }
    /**
     * @private
     * @function onVideoUnavailable
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onVideoUnavailable(agent, message) {
        var devices = agent.getDevices();
        devices._onVideoUnavailable.fire(message);
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onVideoUnavailable',
            message: message,
            context: { agent: agent.data, devices: devices }
        });
    }
    /**
     * @private
     * @function onVideoSelected
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onVideoSelected(agent, message) {
        var devices = agent.getDevices();
        devices._onVideoSelected.fire(message);
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onVideoSelected',
            message: message,
            context: { agent: agent.data, devices: devices }
        });
    }
    /**
     * @private
     * @function onVideoLoaded
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onVideoLoaded(agent, message) {
        var agentDevices = agent.getDevices();
        if (message.devices && _.isArray(message.devices)) {
            _.forEach(message.devices, function (device) {
                agentDevices.add(device);
            });
            agentDevices._onVideoLoaded.fire(message.devices);
        }
        AvayaCustomerServices.Base.Logger.debug('Agent Service', {
            scope: 'Agent Service - onVideoLoaded',
            message: message,
            context: { agent: agent.data, devices: agentDevices }
        });
    }

    AvayaCustomerServices.Services.Agent.AgentService = AgentService;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Agent Device API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @since 3.4.0.0
     * @memberOf AvayaCustomerServices.Services.Agent
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     * @define AvayaCustomerServices.Services.Agent.Device
     * @param {{idAttribute}} [options] Model options
     */
    function Device(options) {
        AvayaCustomerServices.Base.Collections.Model.call(this, options);
    }

    Device.prototype =
    /** @lends AvayaCustomerServices.Services.Agent.Device */
    {
        /**
         * Get label for this device
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Device#getLabel
         * @returns {string}
         */
        getLabel: function () {
            return this.data._label;
        },
        /**
         * Get group ID for this device
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Device#getGroupId
         * @returns {string}
         */
        getGroupId: function () {
            return this.data._groupId;
        },
        /**
         * Get type for this device
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Device#getType
         * @returns {string}
         */
        getType: function () {
            return this.data._kind;
        }
    };

    _.defaults(Device.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Agent.Device = Device;

})(AvayaCustomerServices, _);



/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Agent DeviceCollection API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Agent
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     * @define AvayaCustomerServices.Services.Agent.DeviceCollection
     */
    function DeviceCollection() {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Services.Agent.Device, {idAttribute: '_deviceId'});
        /**
         * @private
         */
        this._onAudioInputAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioInputRemoved = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioInputUnavailable = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioInputSelected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioInputLoaded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioOutputAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioOutputRemoved = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioOutputUnavailable = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioOutputSelected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onAudioOutputLoaded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onVideoAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onVideoRemoved = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onVideoUnavailable = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onVideoSelected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onVideoLoaded = new AvayaCustomerServices.Base.Callbacks();
    }

    DeviceCollection.prototype =
    /** @lends AvayaCustomerServices.Services.Agent.Devices */
    {
        /**
         * Find all devices of type audioinput
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.DeviceCollection#getAudioInputDevices
         * @returns {AvayaCustomerServices.Services.Agent.Device[]}
         */
        getAudioInputDevices: function () {
            return this.findAll(function (device) {
                return device.getType() === AvayaCustomerServices.Services.Agent.DeviceStates.AUDIO_INPUT;
            });
        },
        /**
         * Find all devices of type audiooutput
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.DeviceCollection#getAudioOutputDevices
         * @returns {AvayaCustomerServices.Services.Agent.Device[]}
         */
        getAudioOutputDevices: function () {
            return this.findAll(function (device) {
                return device.getType() === AvayaCustomerServices.Services.Agent.DeviceStates.AUDIO_OUTPUT;
            });
        },
        /**
         * Find all devices of type videoinput
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.DeviceCollection#getVideoDevices
         * @returns {AvayaCustomerServices.Services.Agent.Device[]}
         */
        getVideoDevices: function () {
            return this.findAll(function (device) {
                return device.getType() === AvayaCustomerServices.Services.Agent.DeviceStates.VIDEO_INPUT;
            });
        },
        /**
         * This callback handles an audio input added event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioInputAddedCallback
         */
        /**
         * Adds a callback that is executed when an agent's audio input device has been added
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioInputAddedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioInputAddedCallback} callback Function that handles on audio input added event response
         */
        addOnAudioInputAddedCallback: function (callback) {
            this._onAudioInputAdded.add(callback);
        },
        /**
         * This callback handles an audio input removed event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioInputRemovedCallback
         */
        /**
         * Adds a callback that is executed when an agent's audio input device has been removed
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioInputRemovedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioInputRemovedCallback} callback Function that handles on audio input removed event response
         */
        addOnAudioInputRemovedCallback: function (callback) {
            this._onAudioInputRemoved.add(callback);
        },
        /**
         * This callback handles an audio input unavailable event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioInputUnavailableCallback
         */
        /**
         * Adds a callback that is executed when no agent's audio input devices are available
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioInputUnavailableCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioInputUnavailableCallback} callback Function that handles on audio input unavailable event response
         */
        addOnAudioInputUnavailableCallback: function (callback) {
            this._onAudioInputUnavailable.add(callback);
        },
        /**
         * This callback handles an audio input selected event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioInputSelectedCallback
         */
        /**
         * Adds a callback that is executed when agent's audio input devices has been selected
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioInputSelectedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioInputSelectedCallback} callback Function that handles on audio input selected event response
         */
        addOnAudioInputSelectedCallback: function (callback) {
            this._onAudioInputSelected.add(callback);
        },
        /**
         * This callback handles an audio input loaded event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioInputLoadedCallback
         */
        /**
         * Adds a callback that is executed when an agent's audio input devices have been loaded
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioInputLoadedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioInputLoadedCallback} callback Function that handles on audio input loaded event response
         */
        addOnAudioInputLoadedCallback: function (callback) {
            this._onAudioInputLoaded.add(callback);
        },
        /**
         * This callback handles an audio output added event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioOutputAddedCallback
         */
        /**
         * Adds a callback that is executed when an agent's audio output device has been added
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioOutputAddedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioOutputAddedCallback} callback Function that handles on audio output added event response
         */
        addOnAudioOutputAddedCallback: function (callback) {
            this._onAudioOutputAdded.add(callback);
        },
        /**
         * This callback handles an audio output removed event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioOutputRemovedCallback
         */
        /**
         * Adds a callback that is executed when an agent's audio output device has been removed
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioOutputRemovedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioOutputRemovedCallback} callback Function that handles on audio output removed event response
         */
        addOnAudioOutputRemovedCallback: function (callback) {
            this._onAudioOutputRemoved.add(callback);
        },
        /**
         * This callback handles an audio output unavailable event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioOutputUnavailableCallback
         */
        /**
         * Adds a callback that is executed when no agent's audio output devices are available
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioOutputUnavailableCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioOutputUnavailableCallback} callback Function that handles on audio output unavailable event response
         */
        addOnAudioOutputUnavailableCallback: function (callback) {
            this._onAudioOutputUnavailable.add(callback);
        },
        /**
         * This callback handles an audio output selected event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioOutputSelectedCallback
         */
        /**
         * Adds a callback that is executed when agent's audio output devices has been selected
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioOutputSelectedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioOutputSelectedCallback} callback Function that handles on audio output selected event response
         */
        addOnAudioOutputSelectedCallback: function (callback) {
            this._onAudioOutputSelected.add(callback);
        },
        /**
         * This callback handles an audio output loaded event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onAudioOutputLoadedCallback
         */
        /**
         * Adds a callback that is executed when an agent's audio output devices have been loaded
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnAudioOutputLoadedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onAudioOutputLoadedCallback} callback Function that handles on audio output loaded event response
         */
        addOnAudioOutputLoadedCallback: function (callback) {
            this._onAudioOutputLoaded.add(callback);
        },
        /**
         * This callback handles an video added event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onVideoAddedCallback
         */
        /**
         * Adds a callback that is executed when an agent's video device has been added
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnVideoAddedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onVideoAddedCallback} callback Function that handles on video added event response
         */
        addOnVideoAddedCallback: function (callback) {
            this._onVideoAdded.add(callback);
        },
        /**
         * This callback handles an video removed event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onVideoRemovedCallback
         */
        /**
         * Adds a callback that is executed when an agent's video device has been removed
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnVideoRemovedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onVideoRemovedCallback} callback Function that handles on video removed event response
         */
        addOnVideoRemovedCallback: function (callback) {
            this._onVideoRemoved.add(callback);
        },
        /**
         * This callback handles an video unavailable event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onVideoUnavailableCallback
         */
        /**
         * Adds a callback that is executed when no agent's video devices are available
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnVideoUnavailableCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onVideoUnavailableCallback} callback Function that handles on video unavailable event response
         */
        addOnVideoUnavailableCallback: function (callback) {
            this._onVideoUnavailable.add(callback);
        },
        /**
         * This callback handles an video selected event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onVideoSelectedCallback
         */
        /**
         * Adds a callback that is executed when agent's video devices has been selected
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnVideoSelectedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onVideoSelectedCallback} callback Function that handles on video selected event response
         */
        addOnVideoSelectedCallback: function (callback) {
            this._onVideoSelected.add(callback);
        },
        /**
         * This callback handles an video loaded event response
         * @callback AvayaCustomerServices.Services.Agent.Devices~onVideoLoadedCallback
         */
        /**
         * Adds a callback that is executed when an agent's video devices have been loaded
         *
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#addOnVideoLoadedCallback
         * @param {AvayaCustomerServices.Services.Agent.Devices~onVideoLoadedCallback} callback Function that handles on video loaded event response
         */
        addOnVideoLoadedCallback: function (callback) {
            this._onVideoLoaded.add(callback);
        },
        /**
         * Remove callbacks
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Agent.Devices#removeCallbacks
        */
        removeCallbacks: function () {
            this._onAudioInputAdded.empty();
            this._onAudioInputRemoved.empty();
            this._onAudioInputUnavailable.empty();
            this._onAudioInputSelected.empty();
            this._onAudioInputLoaded.empty();
            this._onAudioOutputAdded.empty();
            this._onAudioOutputRemoved.empty();
            this._onAudioOutputUnavailable.empty();
            this._onAudioOutputSelected.empty();
            this._onAudioOutputLoaded.empty();
            this._onVideoAdded.empty();
            this._onVideoRemoved.empty();
            this._onVideoUnavailable.empty();
            this._onVideoSelected.empty();
            this._onVideoLoaded.empty();
        }
    };

    _.defaults(DeviceCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Services.Agent.DeviceCollection = DeviceCollection;

})(AvayaCustomerServices, _);



/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent Capabilities
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Lists all Agent Capabilities
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Services.Agent
     * @define AvayaCustomerServices.Services.Agent.Capabilities
     */
    AvayaCustomerServices.Services.Agent.Capabilities = {
        canDeactivate: false,
        canLogin: false,
        canLogout: false,
        canSetNotReady: false,
        canSetReady: false
    };

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent State
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Lists all Agent States that can be set
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Services.Agent
     * @define AvayaCustomerServices.Services.Agent.States
     */
    AvayaCustomerServices.Services.Agent.States = {
        READY: AvayaCustomerServices.Providers.Common.Constants.READY,
        NOT_READY: AvayaCustomerServices.Providers.Common.Constants.NOT_READY
    };

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent State
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';
    /**
     * Lists all Agent States that can be set
     *
     * @readonly
     * @enum {string}
     * @memberOf AvayaCustomerServices.Services.Agent
     * @define AvayaCustomerServices.Services.Agent.States
     */
    AvayaCustomerServices.Services.Agent.DeviceStates = {
        AUDIO_INPUT: "audioinput",
        AUDIO_OUTPUT: "audiooutput",
        VIDEO_INPUT: "videoinput"
    };

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Client Session API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaCustomerServices
     * @define AvayaCustomerServices.ClientSession
     * @param {Object} config SDK configuration parameters
     */
    function ClientSession(config) {
        /**
         * @private
         * @type {object}
         */
        this._config = config;
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Mediator}
         */
        this._mediator = undefined;
        /**
         * @private
         * @type {boolean}
         */
        this._started = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Agent.Agent}
         */
        this._agent = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.Work}
         */
        this._work = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Team.Team}
         */
        this._team = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Contacts.Contacts}
         */
        this._contacts = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.ClientSession.ReasonCodeCollection}
         */
        this._reasonCodes = new AvayaCustomerServices.ClientSession.ReasonCodeCollection();
        /**
         * Client session data
         *
         * @public
         * @type {object}
         */
        this.data = {};
        /**
         * List of profiles for user
         *
         * @public
         * @type {object[]}
         */
        this.profiles = [];
        /**
         * Default profile ID for user
         *
         * @public
         * @type {string}
         */
        this.defaultProfileId = '';
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Mediator.ProviderCollection}
         */
        this._providers = new AvayaCustomerServices.Base.Mediator.ProviderCollection({ idAttribute: 'configKey' });
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Mediator.PrerequisiteCollection}
         */
        this._prerequisites = new AvayaCustomerServices.Base.Mediator.PrerequisiteCollection();
        /**
         * @private
         */
        this._onClose = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onError = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onClientSessionStarted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onClientSessionRestarted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onClientSessionClosed = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceAcquired = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceReleased = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionOutboundConnected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionOutboundNotConnected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionOutboundFailed = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionOutboundDeleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionWorkModeCreated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionWorkModeUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionWorkModeDeleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionConfigurationCreated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionConfigurationUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onResourceSessionConfigurationDeleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onUserRegistrationSuccessful = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onUserRegistrationFailed = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onDeferredInteraction = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onRemoveDeferredInteraction = new AvayaCustomerServices.Base.Callbacks();
        /**
         * Loop through each configuration and create associated providers
         */
        _.forEach(this._config, _.bind(function (config, configKey) {
            this._providers.createProvider(this._prerequisites, config, configKey);
        }, this));
    }

    ClientSession.prototype =
    /** @lends AvayaCustomerServices.ClientSession.prototype */
    {
        /**
         * Starts the client session service
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#start
         */
        start: function () {
            if (!this._started) {
                this._mediator = this._providers.getMediator();

                this._mediator.on('error', _.bind(onError, null, this));
                this._mediator.on('close', _.bind(onClose, null, this));

                this._mediator.on('clientsession.started', _.bind(onClientSessionStarted, null, this));
                this._mediator.on('clientsession.restarted', _.bind(onClientSessionRestarted, null, this));
                this._mediator.on('clientsession.closed', _.bind(onClientSessionClosed, null, this));

                this._mediator.on('resource.acquired', _.bind(onResourceAcquired, null, this));
                this._mediator.on('resource.released', _.bind(onResourceReleased, null, this));

                this._mediator.on('resource_session.outbound.connected', _.bind(onResourceSessionOutboundConnected, null, this));
                this._mediator.on('resource_session.outbound.not_connected', _.bind(onResourceSessionOutboundNotConnected, null, this));
                this._mediator.on('resource_session.outbound.failed', _.bind(onResourceSessionOutboundFailed, null, this));
                this._mediator.on('resource_session.outbound.deleted', _.bind(onResourceSessionOutboundDeleted, null, this));
                this._mediator.on('resource_session.work_mode.created', _.bind(onResourceSessionWorkModeCreated, null, this));
                this._mediator.on('resource_session.work_mode.updated', _.bind(onResourceSessionWorkModeUpdated, null, this));
                this._mediator.on('resource_session.work_mode.deleted', _.bind(onResourceSessionWorkModeDeleted, null, this));
                this._mediator.on('resource_session.configuration.created', _.bind(onResourceSessionConfigurationCreated, null, this));
                this._mediator.on('resource_session.configuration.updated', _.bind(onResourceSessionConfigurationUpdated, null, this));
                this._mediator.on('resource_session.configuration.deleted', _.bind(onResourceSessionConfigurationDeleted, null, this));

                this._mediator.on('user.registration.successful', _.bind(onUserRegistrationSuccessful, null, this));
                this._mediator.on('user.registration.failed', _.bind(onUserRegistrationFailed, null, this));

                this._mediator.on('deferred.interaction', _.bind(onDeferredInteraction, null, this));
                this._mediator.on('deferred.interaction.delete', _.bind(onRemoveDeferredInteraction, null, this));

                this._mediator.start();
                this._started = true;
            }
        },
        /**
         * Stops the client session service
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#stop
         * @param {boolean} [force] Optional param - force stop of client session
         */
        stop: function (force) {
            if (this._started && this._mediator) {
                this._mediator.stop(force);

                this._mediator.removeListeners('error');
                this._mediator.removeListeners('close');
                this._mediator.removeListeners('clientsession');
                this._mediator.removeListeners('resource');
                this._mediator.removeListeners('resource_session');
                this._mediator.removeListeners('user');
                this._mediator.removeListeners('deferred');

                this.removeContacts();
                this.removeTeam();
                this.removeWork();
                this.removeAgent();
                this.removeCallbacks();

                this._started = false;
            }
        },
        /**
         * Set tokens to token collection
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#setToken
         * @param {Object} data Data used to populate Token object
         */
        setToken: function (data) {
            var tokenCollection = this._prerequisites.find({ id: 'tokenCollection' });
            if (tokenCollection.data) {
                tokenCollection.data.edit(data);
            }
        },
        /**
         * Updates client session object with param data
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#setData
         * @param {Object} data Data used to populate ClientSession object
         * @returns {{profiles, reasonCodes, defaultProfileId}} Updated ClientSession object
         */
        setData: function (data) {
            if (data && data.reasonCodes) {
                _.forEach(data.reasonCodes, _.bind(function (reasonCode) {
                    this._reasonCodes.add(reasonCode);
                }, this));
            }
            return _.updateByDeep(this, data);
        },
        /**
         * Updates client session configuration with param data
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#setConfig
         * @param {Object} configuration Data used to configure ClientSession object
         */
        setConfig: function (configuration) {
            _.forEach(configuration, _.bind(function (config, key) {
                this._config[key] = config;
                this._providers.createProvider(this._prerequisites, config, key);
            }, this));
        },
        /**
         * Updates client session configuration with param data
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#setConfig
         * @param {Object} configuration Data used to configure ClientSession object
         */
        updateConfig: function (configuration) {
            _.forEach(configuration, _.bind(function (config, key) {
                this._providers.updateProvider(config, key);
                _.assignIn(this._config[key], config);
            }, this));
        },
        /**
         * Get configuration settings for a user.
         *
         * @public
         * @param {string} [authServerUser] Deprecated: User's ID used during authentication
         * @returns {AvayaCustomerServices.Base.Promise|boolean} Promise
         */
        getConfiguration: function (authServerUser) {
            var mediator = this._providers.getMediator();
            return mediator && mediator.getConfiguration(authServerUser);
        },

        /**
         * Creates an instance of the {@link Agent} module.
         *
         * @public
         * @param {string} [cachedHandle] Optional param - cached user handle
         * @function AvayaCustomerServices.ClientSession#createAgent
         * @returns {AvayaCustomerServices.Services.Agent.Agent} Agent API
         */
        createAgent: function (cachedHandle) {
            var agentMediator = this._providers.getMediator();
            var agentService = new AvayaCustomerServices.Services.Agent.AgentService(agentMediator);
            this._agent = new AvayaCustomerServices.Services.Agent.Agent(agentService);
            this._agent.setHandle(cachedHandle);
            agentService.init(this._agent);
            return this._agent;
        },
        /**
         * Removes instance of the {@link Agent} module.
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#removeAgent
         */
        removeAgent: function () {
            if (this._agent) {
                this._agent.removeCallbacks();
                this._agent.getDevices().removeCallbacks();
                this._agent = undefined;
            }
        },
        /**
         * Gets an instance of the {@link Agent} module.
         *
         * @public
         * @returns {AvayaCustomerServices.Services.Agent.Agent} Agent API
         */
        getAgent: function () {
            return this._agent;
        },
        /**
         * Creates an instance of the {@link Work} module.
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#createWork
         * @returns {AvayaCustomerServices.Services.Work.Work} Work API
         */
        createWork: function () {
            var workMediator = this._providers.getMediator();
            var workService = new AvayaCustomerServices.Services.Work.WorkService(workMediator, this._agent);
            var interactionCollection = new AvayaCustomerServices.Services.Work.InteractionCollection(workService);
            var workRequestCollection = new AvayaCustomerServices.Services.Work.WorkRequestCollection(interactionCollection);
            this._work = new AvayaCustomerServices.Services.Work.Work(workService, workRequestCollection, interactionCollection);
            workService.init(this._work, workRequestCollection, interactionCollection);
            return this._work;
        },
        /**
         * Removes instance of the {@link Work} module.
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#removeWork
         */
        removeWork: function () {
            if (this._work) {
                this._work.removeCallbacks();
                this._work = undefined;
            }
        },
        /**
         * Gets an instance of the {@link Work} module.
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#getWork
         * @returns {AvayaCustomerServices.Services.Work.Work} Work API
         */
        getWork: function () {
            return this._work;
        },
        /**
         * Creates an instance of the {@link Team} module.
         *
         * @function AvayaCustomerServices.ClientSession#createTeam
         * @memberOf AvayaCustomerServices.ClientSession#
         * @public
         * @returns {AvayaCustomerServices.Services.Team.Team} Team API
         */
        createTeam: function () {
            var teamMediator = this._providers.getMediator();
            var teamService = new AvayaCustomerServices.Services.Team.TeamService(teamMediator, this._agent);
            var teamCollection = new AvayaCustomerServices.Services.Team.TeamCollection(teamService);
            this._team = new AvayaCustomerServices.Services.Team.Team(teamService, teamCollection);
            teamService.init(this._team, teamCollection);
            return this._team;
        },
        /**
         * Removes instance of the {@link Team} module.
         *
         * @public
         * @function AvayaCustomerServices.ClientSession#removeTeam
         */
        removeTeam: function () {
            if (this._team) {
                this._team.removeCallbacks();
                this._team = undefined;
            }
        },
        /**
         * Gets an instance of the {@link Team} module.
         *
         * @public
         * @returns {AvayaCustomerServices.Services.Team.Team} Team API
         */
        getTeam: function () {
            return this._team;
        },
        /**
         * Creates an instance of the {@link Contacts} module.
         *
         * @since 3.6.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#createContacts
         * @returns {AvayaCustomerServices.Services.Contacts.Contacts} Contacts API
         */
        createContacts: function () {
            var contactsMediator = this._providers.getMediator();
            var contactsService = new AvayaCustomerServices.Services.Contacts.ContactsService(contactsMediator);
            this._contacts = new AvayaCustomerServices.Services.Contacts.Contacts(contactsService);
            contactsService.init(this._contacts);
            return this._contacts;
        },
        /**
         * Removes instance of the {@link Contacts} module.
         *
         * @since 3.6.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#removeContacts
         */
        removeContacts: function () {
            if (this._contacts) {
                this._contacts.removeCallbacks();
                this._contacts = undefined;
            }
        },
        /**
         * Gets an instance of the {@link Contacts} module.
         *
         * @since 3.6.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#getContacts
         * @returns {AvayaCustomerServices.Services.Contacts.Contacts} Contacts API
         */
        getContacts: function () {
            return this._contacts;
        },
        /**
         * Gets an instance of the {@link ReasonCodeCollection} module.
         *
         * @public
         * @returns {AvayaCustomerServices.ClientSession.ReasonCodeCollection} Reason codes
         */
        getReasonCodes: function () {
            return this._reasonCodes;
        },
        /**
         * The event data that is passed back to onCloseCallback
         * @typedef {Object} CloseEvent
         * @property {string} type Message type
         * @property {string} code Server message code
         * @property {string} message Description of the message
         * @property {string} severity Severity of the message
         * @property {string} scope Scope of the message
         */
        /**
         * This callback handles the CloseEvent response
         * @callback AvayaCustomerServices.ClientSession~onCloseCallback
         * @param {CloseEvent} message The event that is fired when notification provider connection has been closed
         */
        /**
         * Adds a callback that is executed when notification provider connection has been closed
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnCloseCallback
         * @param {AvayaCustomerServices.ClientSession~onCloseCallback} callback Function that handles on close event response
         */
        addOnCloseCallback: function (callback) {
            this._onClose.add(callback);
        },
        /**
         * The event data that is passed back to onErrorCallback
         * @typedef {Object} ErrorEvent
         * @property {string} type Error type
         * @property {string} code Server error code
         * @property {string} message Description of the error
         * @property {string} severity Severity of the error
         * @property {string} scope Scope of the error
         */
        /**
         * This callback handles the ErrorEvent response
         * @callback AvayaCustomerServices.ClientSession~onErrorCallback
         * @param {ErrorEvent} message The event that is fired when an error has occurred
         */
        /**
         * Adds a callback that is executed when an error has occurred
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnErrorCallback
         * @param {AvayaCustomerServices.ClientSession~onErrorCallback} callback Function that handles on error event response
         */
        addOnErrorCallback: function (callback) {
            this._onError.add(callback);
        },
        /**
         * The event data that is passed back to onClientSessionStartedCallback
         * @property {string} clientSessionId
         */
        /**
         * This callback handles the ClientSessionStartedEvent response
         * @callback AvayaCustomerServices.ClientSession~onClientSessionStartedCallback
         * @param {string} clientSessionId
         */
        /**
         * Adds a callback that is executed on notification provider's onOpen event
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnClientSessionStartedCallback
         * @param {AvayaCustomerServices.ClientSession~onClientSessionStartedCallback} callback Function that handles on open event response
         */
        addOnClientSessionStartedCallback: function (callback) {
            this._onClientSessionStarted.add(callback);
        },
        /**
         * The event data that is passed back to onClientSessionRestartedCallback
         * @property {string} clientSessionId
         */
        /**
         * This callback handles the ClientSessionRestartedEvent response
         * @callback AvayaCustomerServices.ClientSession~onClientSessionRestartedCallback
         * @param {string} clientSessionId
         */
        /**
         * Adds a callback that is executed on notification provider's onReopen event
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnClientSessionRestartedCallback
         * @param {AvayaCustomerServices.ClientSession~onClientSessionRestartedCallback} callback Function that handles on reopen event response
         */
        addOnClientSessionRestartedCallback: function (callback) {
            this._onClientSessionRestarted.add(callback);
        },
        /**
         * The event data that is passed back to onClientSessionClosedCallback
         * @property {string} clientSessionId
         */
        /**
         * This callback handles the ClientSessionClosedEvent response
         * @callback AvayaCustomerServices.ClientSession~onClientSessionClosedCallback
         * @param {string} clientSessionId
         */
        /**
         * Adds a callback that is executed on notification provider's onReopen event
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnClientSessionClosedCallback
         * @param {AvayaCustomerServices.ClientSession~onClientSessionClosedCallback} callback Function that handles on reopen event response
         */
        addOnClientSessionClosedCallback: function (callback) {
            this._onClientSessionClosed.add(callback);
        },
        /**
         * The event data that is passed back to onResourceAcquiredCallback
         * @typedef {Object} ResourceAcquiredEvent
         * @property {string} id Notification ID
         * @property {string} channel Channel type of resource
         * @property {string} state Resource state
         * @property {string} resourceId Resource ID
         * @property {string} loginAccountId Account ID for user on this resource
         * @property {string} providerId Id of resource provider
         */
        /**
         * This callback handles the ResourceAcquiredEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceAcquiredCallback
         * @param {ResourceAcquiredEvent} message The event that is fired when a resource has been acquired
         */
        /**
         * Adds a callback that is executed when a resource has been acquired
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceAcquiredCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceAcquiredCallback} callback Function that handles on resource acquired event response
         */
        addOnResourceAcquiredCallback: function (callback) {
            this._onResourceAcquired.add(callback);
        },
        /**
         * The event data that is passed back to onResourceReleasedCallback
         * @typedef {Object} ResourceReleasedEvent
         * @property {string} id Notification ID
         * @property {string} channel Channel type of resource
         * @property {string} state Resource state
         * @property {string} resourceId Resource ID
         * @property {string} loginAccountId Account ID for user on this resource
         * @property {string} providerId Id of resource provider
         */
        /**
         * This callback handles the ResourceReleasedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceReleasedCallback
         * @param {ResourceReleasedEvent} message The event that is fired when a resource has been released
         */
        /**
         * Adds a callback that is executed when a resource has been released
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceReleasedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceReleasedCallback} callback Function that handles on resource released event response
         */
        addOnResourceReleasedCallback: function (callback) {
            this._onResourceReleased.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionOutboundConnectedCallback
         * @typedef {Object} ResourceSessionOutboundConnectedEvent
         * @property {string} id Notification ID
         * @property {string} resourceSessionId Resource Session ID
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string} channelType Channel Type
         * @property {string} state State of Resource
         * @property {string} propertyType Updated Property Type
         * @property {string} propertyName Updated Property Name
         * @property {string} propertyState Updated Property State
         */
        /**
         * This callback handles the ResourceSessionOutboundConnectedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionOutboundConnectedCallback
         * @param {ResourceSessionOutboundConnectedEvent} message The event that is fired when a resource session is connected
         */
        /**
         * Adds a callback that is executed when a resource session is connected
         * @since 3.2.2.1
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionOutboundConnectedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionOutboundConnectedCallback} callback Function that handles on resource session connected event response
         */
        addOnResourceSessionOutboundConnectedCallback: function (callback) {
            this._onResourceSessionOutboundConnected.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionOutboundNotConnectedCallback
         * @typedef {Object} ResourceSessionOutboundNotConnectedEvent
         * @property {string} id Notification ID
         * @property {string} resourceSessionId Resource Session ID
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string} channelType Channel Type
         * @property {string} state State of Resource
         */
        /**
         * This callback handles the ResourceSessionOutboundNotConnectedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionOutboundNotConnectedCallback
         * @param {ResourceSessionOutboundNotConnectedEvent} message The event that is fired when a resource session is disconnected
         */
        /**
         * Adds a callback that is executed when a resource session is disconnected
         * @since 3.2.2.1
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionOutboundNotConnectedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionOutboundNotConnectedCallback} callback Function that handles on resource session not connected event response
         */
        addOnResourceSessionOutboundNotConnectedCallback: function (callback) {
            this._onResourceSessionOutboundNotConnected.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionOutboundFailedCallback
         * @typedef {Object} ResourceSessionOutboundFailedEvent
         * @property {string} id Notification ID
         * @property {string} resourceSessionId Resource Session ID
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string} channelType Channel Type
         * @property {string} state State of Resource
         */
        /**
         * This callback handles the ResourceSessionOutboundFailedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionOutboundFailedCallback
         * @param {ResourceSessionOutboundFailedEvent} message The event that is fired when a resource session has failed
         */
        /**
         * Adds a callback that is executed when a resource session has failed
         * @since 3.2.2.1
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionOutboundFailedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionOutboundFailedCallback} callback Function that handles on resource session failed event response
         */
        addOnResourceSessionOutboundFailedCallback: function (callback) {
            this._onResourceSessionOutboundFailed.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionOutboundDeletedCallback
         * @typedef {Object} ResourceSessionOutboundDeletedEvent
         * @property {string} id Notification ID
         */
        /**
         * This callback handles the ResourceSessionOutboundDeletedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionOutboundDeletedCallback
         * @param {ResourceSessionOutboundDeletedEvent} message The event that is fired when a resource session has failed
         */
        /**
         * Adds a callback that is executed when a resource session has failed
         * @since 3.2.2.1
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionOutboundDeletedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionOutboundDeletedCallback} callback Function that handles on resource session failed event response
         */
        addOnResourceSessionOutboundDeletedCallback: function (callback) {
            this._onResourceSessionOutboundDeleted.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionWorkModeCreatedCallback
         * @typedef {Object} ResourceSessionPropertyWorkModeCreatedEvent
         * @property {string} id Notification ID
         * @property {string} resourceSessionId Resource Session ID
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string} channelType Channel Type
         * @property {string} state Value of WorkMode
         * @property {string} propertyType Updated Property Type
         * @property {string} propertyName Updated Property Name
         * @property {string} propertyState Updated Property State
         */
        /**
         * This callback handles the ResourceSessionPropertyWorkModeCreatedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionWorkModeCreatedCallback
         * @param {ResourceSessionPropertyWorkModeCreatedEvent} message The event that is fired when a workMode has created
         */
        /**
         * Adds a callback that is executed when a workMode has created
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionWorkModeCreatedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionWorkModeCreatedCallback} callback Function that handles on workMode created event response
         */
        addOnResourceSessionWorkModeCreatedCallback: function (callback) {
            this._onResourceSessionWorkModeCreated.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionWorkModeUpdatedCallback
         * @typedef {Object} ResourceSessionPropertyWorkModeUpdatedEvent
         * @property {string} id Notification ID
         * @property {string} resourceSessionId Resource Session ID
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string} channelType Channel Type
         * @property {string} state Value of WorkMode
         * @property {string} propertyType Updated Property Type
         * @property {string} propertyName Updated Property Name
         * @property {string} propertyState Updated Property State
         */
        /**
         * This callback handles the ResourceSessionPropertyWorkModeUpdatedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionWorkModeUpdatedCallback
         * @param {ResourceSessionPropertyWorkModeUpdatedEvent} message The event that is fired when a workMode has updated
         */
        /**
         * Adds a callback that is executed when a workMode has updated
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionWorkModeUpdatedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionWorkModeUpdatedCallback} callback Function that handles on workMode updated event response
         */
        addOnResourceSessionWorkModeUpdatedCallback: function (callback) {
            this._onResourceSessionWorkModeUpdated.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionWorkModeDeletedCallback
         * @typedef {Object} ResourceSessionPropertyWorkModeDeletedEvent
         * @property {string} id Notification ID
         */
        /**
         * This callback handles the ResourceSessionPropertyWorkModeUpdatedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionWorkModeUpdatedCallback
         * @param {ResourceSessionPropertyWorkModeUpdatedEvent} message The event that is fired when a workMode has updated
         */
        /**
         * Adds a callback that is executed when a workMode has updated
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionWorkModeDeletedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionWorkModeDeletedCallback} callback Function that handles on workMode deleted event response
         */
        addOnResourceSessionWorkModeDeletedCallback: function (callback) {
            this._onResourceSessionWorkModeDeleted.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionConfigurationCreatedCallback
         * @typedef {Object} ResourceSessionPropertyConfigurationCreatedEvent
         * @property {string} id Notification ID
         * @property {string} resourceAddress Resource Address
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string[]} channelTypes List of Channel Types
         * @property {string} value Value of Configuration
         * @property {string} propertyType Updated Property Type
         * @property {string} propertyName Updated Property Name
         * @property {string} propertyState Updated Property State
         */
        /**
         * This callback handles the ResourceSessionPropertyConfigurationCreatedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionConfigurationCreatedCallback
         * @param {ResourceSessionPropertyConfigurationCreatedEvent} message The event that is fired when a configuration object has been created
         */
        /**
         * Adds a callback that is executed when a configuration object has been created
         * @since 3.8.1.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionConfigurationCreatedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionConfigurationCreatedCallback} callback Function that handles on Configuration object created event response
         */
        addOnResourceSessionConfigurationCreatedCallback: function (callback) {
            this._onResourceSessionConfigurationCreated.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionConfigurationUpdatedCallback
         * @typedef {Object} ResourceSessionPropertyConfigurationUpdatedEvent
         * @property {string} id Notification ID
         * @property {string} resourceAddress Resource Address
         * @property {string} providerId Provider ID
         * @property {string} userHandle Agent's user handle
         * @property {string[]} channelTypes List of Channel Types
         * @property {string} value Value of Configuration
         * @property {string} propertyType Updated Property Type
         * @property {string} propertyName Updated Property Name
         * @property {string} propertyState Updated Property State
         */
        /**
         * This callback handles the ResourceSessionPropertyConfigurationUpdatedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionConfigurationUpdatedCallback
         * @param {ResourceSessionPropertyConfigurationUpdatedEvent} message The event that is fired when a configuration object has been updated
         */
        /**
         * Adds a callback that is executed when a configuration object has been updated
         * @since 3.8.1.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionConfigurationUpdatedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionConfigurationUpdatedCallback} callback Function that handles on Configuration object updated event response
         */
        addOnResourceSessionConfigurationUpdatedCallback: function (callback) {
            this._onResourceSessionConfigurationUpdated.add(callback);
        },
        /**
         * The event data that is passed back to onResourceSessionConfigurationDeletedCallback
         * @typedef {Object} ResourceSessionPropertyConfigurationDeletedEvent
         * @property {string} id Notification ID
         */
        /**
         * This callback handles the ResourceSessionPropertyConfigurationDeletedEvent response
         * @callback AvayaCustomerServices.ClientSession~onResourceSessionConfigurationDeletedCallback
         * @param {ResourceSessionPropertyConfigurationDeletedEvent} message The event that is fired when a configuration object has been deleted
         */
        /**
         * Adds a callback that is executed when a configuration object has been deleted
         * @since 3.8.1.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnResourceSessionConfigurationDeletedCallback
         * @param {AvayaCustomerServices.ClientSession~onResourceSessionConfigurationDeletedCallback} callback Function that handles on Configuration object deleted event response
         */
        addOnResourceSessionConfigurationDeletedCallback: function (callback) {
            this._onResourceSessionConfigurationDeleted.add(callback);
        },
        /**
         * This callback handles the on user registration success response
         * @callback AvayaCustomerServices.ClientSession~onUserRegistrationSuccessfulCallback
         * @param {AvayaClientServices.User} message User session that the callback is associated with.
         */
        /**
         * Adds a callback that is executed when a user registration has been successful
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnUserRegistrationSuccessfulCallback
         * @param {AvayaCustomerServices.ClientSession~onUserRegistrationSuccessfulCallback} callback Function that handles on user registration success event response
         */
        addOnUserRegistrationSuccessfulCallback: function (callback) {
            this._onUserRegistrationSuccessful.add(callback);
        },
        /**
         * This callback handles the on user registration failed response
         * @callback AvayaCustomerServices.ClientSession~onUserRegistrationFailedCallback
         * @param {AvayaClientServices.User} message User session that the callback is associated with.
         */
        /**
         * Adds a callback that is executed when a user registration has failed
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnUserRegistrationFailedCallback
         * @param {AvayaCustomerServices.ClientSession~onUserRegistrationFailedCallback} callback Function that handles on user registration failed event response
         */
        addOnUserRegistrationFailedCallback: function (callback) {
            this._onUserRegistrationFailed.add(callback);
        },
        /**
         * Adds a callback that is executed when an interaction is moved to 'deferred'
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnDeferredInteractionCallback
         * @param {AvayaCustomerServices.ClientSession~addOnDeferredInteractionCallback} callback Function that handles on deferred interaction event response
         */
        addOnDeferredInteractionCallback: function (callback) {
            this._onDeferredInteraction.add(callback);
        },
        /**
         * Adds a callback that is executed when an a deferred interaction is successfully retrieved
         * @public
         * @function AvayaCustomerServices.ClientSession#addOnRemoveDeferredInteractionCallback
         * @param {AvayaCustomerServices.ClientSession~addOnRemoveDeferredInteractionCallback} callback Function that handles retrieved deferred interaction event response
         */
        addOnRemoveDeferredInteractionCallback: function (callback) {
            this._onRemoveDeferredInteraction.add(callback);
        },
        /**
         * Remove callbacks
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.ClientSession#removeCallbacks
         */
        removeCallbacks: function () {
            this._onClose.empty();
            this._onError.empty();
            this._onClientSessionStarted.empty();
            this._onClientSessionRestarted.empty();
            this._onClientSessionClosed.empty();
            this._onResourceAcquired.empty();
            this._onResourceReleased.empty();
            this._onResourceSessionOutboundConnected.empty();
            this._onResourceSessionOutboundNotConnected.empty();
            this._onResourceSessionOutboundFailed.empty();
            this._onResourceSessionOutboundDeleted.empty();
            this._onResourceSessionWorkModeCreated.empty();
            this._onResourceSessionWorkModeUpdated.empty();
            this._onResourceSessionWorkModeDeleted.empty();
            this._onResourceSessionConfigurationCreated.empty();
            this._onResourceSessionConfigurationUpdated.empty();
            this._onResourceSessionConfigurationDeleted.empty();
            this._onUserRegistrationSuccessful.empty();
            this._onUserRegistrationFailed.empty();
            this._onDeferredInteraction.empty();
            this._onRemoveDeferredInteraction.empty();
        }
    };

    /**
     * @private
     * @function onClose
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onClose(clientSession, message) {
        clientSession._onClose.fire(message);
    }

    /**
     * @private
     * @function onError
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onError(clientSession, message) {
        clientSession._onError.fire(message);
    }

    /**
     * @private
     * @function onClientSessionStarted
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {string} message
     */
    function onClientSessionStarted(clientSession, message) {
        clientSession._onClientSessionStarted.fire(message);
    }

    /**
     * @private
     * @function onClientSessionRestarted
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {string} message
     */
    function onClientSessionRestarted(clientSession, message) {
        clientSession._onClientSessionRestarted.fire(message);
    }

    /**
     * @private
     * @function onClientSessionClosed
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {string} message
     */
    function onClientSessionClosed(clientSession, message) {
        clientSession._onClientSessionClosed.fire(message);
    }

    /**
     * @private
     * @function onResourceAcquired
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceAcquired(clientSession, message) {
        clientSession._onResourceAcquired.fire(message);
    }

    /**
     * @private
     * @function onResourceReleased
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceReleased(clientSession, message) {
        clientSession._onResourceReleased.fire(message);
    }

    /**
     * @private
     * @function onResourceReleased
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionOutboundConnected(clientSession, message) {
        clientSession._onResourceSessionOutboundConnected.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionOutboundNotConnected
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionOutboundNotConnected(clientSession, message) {
        clientSession._onResourceSessionOutboundNotConnected.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionOutboundFailed
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionOutboundFailed(clientSession, message) {
        clientSession._onResourceSessionOutboundFailed.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionOutboundDeleted
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionOutboundDeleted(clientSession, message) {
        clientSession._onResourceSessionOutboundDeleted.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionWorkModeCreated
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionWorkModeCreated(clientSession, message) {
        clientSession._onResourceSessionWorkModeCreated.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionWorkModeUpdated
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionWorkModeUpdated(clientSession, message) {
        clientSession._onResourceSessionWorkModeUpdated.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionWorkModeDeleted
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionWorkModeDeleted(clientSession, message) {
        clientSession._onResourceSessionWorkModeDeleted.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionConfigurationCreated
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionConfigurationCreated(clientSession, message) {
        clientSession._onResourceSessionConfigurationCreated.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionConfigurationUpdated
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionConfigurationUpdated(clientSession, message) {
        clientSession._onResourceSessionConfigurationUpdated.fire(message);
    }

    /**
     * @private
     * @function onResourceSessionConfigurationDeleted
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onResourceSessionConfigurationDeleted(clientSession, message) {
        clientSession._onResourceSessionConfigurationDeleted.fire(message);
    }

    /**
     * Search for providers with isUserRegistered property exists and set to true
     * If this property is set to false for any provider (i.e. still waiting for user to complete registration), don't fire callback
     * 
     * @private
     * @function onUserRegistrationSuccessful
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onUserRegistrationSuccessful(clientSession, message) {
        var userNotRegistered = clientSession._providers.find(['isUserRegistered', false]);
        if (!userNotRegistered) {
            clientSession._onUserRegistrationSuccessful.fire(message);
        }
    }

    /**
     * @private
     * @function onUserRegistrationFailed
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onUserRegistrationFailed(clientSession, message) {
        clientSession._onUserRegistrationFailed.fire(message);
        clientSession.stop();
    }

    /**
     * @private
     * @function onDeferredInteraction
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onDeferredInteraction(clientSession, message) {
        clientSession._onDeferredInteraction.fire(message);
    }

    /**
     * @private
     * @function onDeferredInteraction
     * @param {AvayaCustomerServices.ClientSession} clientSession
     * @param {Object} message
     */
    function onRemoveDeferredInteraction(clientSession, message) {
        clientSession._onRemoveDeferredInteraction.fire(message);
    }

    AvayaCustomerServices.ClientSession = ClientSession;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines ReasonCode API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for ReasonCode Model
     *
     * @class
     * @memberOf AvayaCustomerServices.ClientSession
     * @define AvayaCustomerServices.ClientSession.ReasonCode
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     * @param {{idAttribute}} [options] Model options
     */
    function ReasonCode(options) {
        AvayaCustomerServices.Base.Collections.Model.call(this, options);
    }

    ReasonCode.prototype =
    /** @lends AvayaCustomerServices.ClientSession.ReasonCode */
    {

    };

    _.defaults(ReasonCode.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.ClientSession.ReasonCode = ReasonCode;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Collection for managing an array of {@link ReasonCode} types.
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Constructor function for ReasonCodes Collection
     *
     * @class
     * @define AvayaCustomerServices.ClientSession.ReasonCodeCollection
     * @memberOf AvayaCustomerServices.ClientSession
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     */
    function ReasonCodeCollection() {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.ClientSession.ReasonCode, {idAttribute: 'code'});
    }

    ReasonCodeCollection.prototype =
    /** @lends AvayaCustomerServices.ClientSession.ReasonCodeCollection */
    {
        /**
         * @public
         * @function AvayaCustomerServices.ClientSession.ReasonCodeCollection#findByFriendlyName
         * @param {string} friendlyName Find Reason Code matching friendly name
         * @returns {AvayaCustomerServices.ClientSession.ReasonCode} ReasonCode
         */
        findByFriendlyName: function (friendlyName) {
            return this.find(function (model) {
                return model.data.friendlyName === friendlyName;
            });
        },
        /**
         * @public
         * @function AvayaCustomerServices.ClientSession.ReasonCodeCollection#findAllByType
         * @param {string} type Find Reason Codes matching type
         * @returns {AvayaCustomerServices.ClientSession.ReasonCode[]} List of ReasonCode models
         */
        findAllByType: function (type) {
            return this.findAll(function (model) {
                return model.data.type === type;
            });
        }
    };

    _.defaults(ReasonCodeCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.ClientSession.ReasonCodeCollection = ReasonCodeCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author Robert McNamara [mcnamara1@avaya.com]
 * @since 3.6.0.0
 * @version 3.8.2.0
 * @classdesc Defines Contact API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for Contact Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Services.Contacts
     * @define AvayaCustomerServices.Services.Contacts.Contact
     * @param {Object} contactSource
     */
    function Contact(contactSource) {
        /**
         * Returns the unique ID of the contact
         * @type {string}
         */
        this.id = contactSource.getUniqueAddressForMatching();
        /**
         * Alias of the contact
         *
         * @public
         * @type {string}
         */
        this.alias = contactSource.getAlias().getValue();
        /**
         * Returns the display name of the contact
         *
         * @public
         * @type {string}
         */
        this.displayName = contactSource.getDisplayName().getValue();
        /**
         * Returns the first name of the contact
         *
         * @public
         * @type {string}
         */
        this.firstName = contactSource.getFirstName().getValue();
        /**
         * Returns the last name of the contact
         *
         * @public
         * @type {string}
         */
        this.lastName = contactSource.getLastName().getValue();
        /**
         * Returns the city
         *
         * @public
         * @type {string}
         */
        this.city = contactSource.getCity().getValue();
        /**
         * Returns the company
         *
         * @public
         * @type {string}
         */
        this.company = contactSource.getCompany().getValue();
        /**
         * Returns the country
         *
         * @public
         * @type {string}
         */
        this.country = contactSource.getCountry().getValue();
        /**
         * Returns the department
         *
         * @public
         * @type {string}
         */
        this.department = contactSource.getDepartment().getValue();
        /**
         *
         * @type {Array}
         */
        this.emailAddresses = getEmailAddresses(contactSource.getEmailAddresses().getValues());
        /**
         * Returns the preferred locale of the contact (for example, 'en_US')
         *
         * @public
         * @type {string}
         */
        this.language = contactSource.getLanguage().getValue();
        /**
         * Returns the location of the contact
         *
         * @public
         * @type {string}
         */
        this.location = contactSource.getLocation().getValue();
        /**
         * Returns the manager of the contact
         *
         * @public
         * @type {string}
         */
        this.manager = contactSource.getManager().getValue();
        /**
         *
         * @type {Array}
         */
        this.phoneNumbers = getPhoneNumbers(contactSource.getPhoneNumbers().getValues());
        /**
         * Returns the postal code of the contact
         *
         * @public
         * @type {string}
         */
        this.postalCode = contactSource.getPostalCode().getValue();
        /**
         * Returns the rank of the contact.
         * This value may be used for sorting the contacts list.
         *
         * @public
         * @type {number}
         */
        this.rank = contactSource.getRank().getValue();
        /**
         * Returns the state of the contact.
         *
         * @public
         * @type {string}
         */
        this.state = contactSource.getState().getValue();
        /**
         * Returns the street address of the contact
         *
         * @public
         * @type {string}
         */
        this.streetAddress = contactSource.getStreetAddress().getValue();
        /**
         * Returns the work room number of the contact
         *
         * @public
         * @type {string}
         */
        this.workRoomNumber = contactSource.getWorkRoomNumber().getValue();
        /**
         * Returns the favorite flag
         *
         * @public
         * @type {boolean}
         */
        this.isFavorite = contactSource.isFavorite().getValue();
    }

    Contact.prototype =
        /** @lends AvayaCustomerServices.Services.Contacts.Contact */
        {

        };

    function getPhoneNumbers(phoneNumbers) {
        var numbers = [];
        _.forEach(phoneNumbers, function (phoneNumber) {
            var alreadyExists = false;
            
            var adjustedNumber = phoneNumber.getPhoneNumber();
            
            if (adjustedNumber) {
                adjustedNumber = adjustedNumber.replace(/([0-9]+)@.*/g, '$1');
              
                for (var i = 0; i < numbers.length; ++i) {
                    if (numbers[i].number === adjustedNumber) {
                        if (phoneNumber.isDefault()) {
                            numbers[i].isDefault = true;
                        }
                        alreadyExists = true;
                        break;
                    }
                }
            }

            if (!alreadyExists) {
                numbers.push({ number: adjustedNumber, type: phoneNumber.getPhoneNumberType(), isDefault: phoneNumber.isDefault() });
            }
        });
        return numbers;
    }

     function getEmailAddresses(emailAddresses) {
         var emails = [];
         _.forEach(emailAddresses, function (emailAddress) {
             emails.push({ address: emailAddress.getAddress(), type: emailAddress.getEmailAddressType(), isDefault: emailAddress.isDefault() });
         });
         return emails;
     }

    AvayaCustomerServices.Services.Contacts.Contact = Contact;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author Robert McNamara [mcnamara1@avaya.com]
 * @version 3.8.2.0
 * @since 3.6.0.0
 * @classdesc Defines Contacts API model
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Contacts
     * @define AvayaCustomerServices.Services.Contacts.Contacts
     * @param {AvayaCustomerServices.Services.Contacts.ContactsService} contactsService
     */
    function Contacts(contactsService) {
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Contacts.ContactsService}
         */
        this._contactsService = contactsService;
        /**
         * @private
         */
        this._onContactsAvailable = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onContactsUnavailable = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onContactsSearchResultsUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onContactsSearchCompleted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onContactsSearchFailed = new AvayaCustomerServices.Base.Callbacks();
    }

    Contacts.prototype =
    /** @lends AvayaCustomerServices.Services.Contacts.Contacts */
    {
        /**
         * Callback function to be invoked when contact service is available.
         * @callback AvayaCustomerServices.Services.Contacts.Contacts~onContactsAvailable
         */
        /**
         * Adds a callback that is executed when contacts service is available
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#addOnContactsAvailableCallback
         * @param {AvayaCustomerServices.Services.Contacts.Contacts~onContactsAvailable} callback
         */
        addOnContactsAvailableCallback: function (callback) {
            this._onContactsAvailable.add(callback);
        },
        /**
         * Callback function to be invoked when contact service is unavailable.
         * @callback AvayaCustomerServices.Services.Contacts.Contacts~onContactsUnavailable
         */
        /**
         * Adds a callback that is executed when contacts service is unavailable
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#addOnContactsUnavailableCallback
         * @param {AvayaCustomerServices.Services.Contacts.Contacts~onContactsUnavailable} callback
         */
        addOnContactsUnavailableCallback: function (callback) {
            this._onContactsUnavailable.add(callback);
        },
        /**
         * Callback function to be invoked when contact search returns results
         * @callback AvayaCustomerServices.Services.Contacts.Contacts~onContactsSearchResultsUpdated
         * @param {String} searchId The ID of the search which returned these results
         * @param {ContactSearchUpdateMessage} searchUpdate The information about what was updated
         */
        /**
         * Adds a callback that is executed when a contacts search returns results
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#addOnContactsSearchResultsUpdatedCallback
         * @param {AvayaCustomerServices.Services.Contacts.Contacts~onContactsSearchResultsUpdated} callback
         */
        addOnContactsSearchResultsUpdatedCallback: function (callback) {
            this._onContactsSearchResultsUpdated.add(callback);
        },
        /**
         * Callback function to be invoked when a contact search fails
         * @callback AvayaCustomerServices.Services.Contacts.Contacts~onContactsSearchFailed
         * @param {String} searchId The ID of the search which failed
         * @param {Object} error The details of the problem which occurred
         */
        /**
         * Adds a callback that is executed when a contacts search fails
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#addOnContactsSearchFailedCallback
         * @param {AvayaCustomerServices.Services.Contacts.Contacts~onContactsSearchFailed} callback
         */
        addOnContactsSearchFailedCallback: function (callback) {
            this._onContactsSearchFailed.add(callback);
        },
        /**
         * Callback function to be invoked when a contact search completes
         * @param {String} searchId The ID of the search which completed
         * @param {Object} contacts A map of the contacts returned
         * @callback AvayaCustomerServices.Services.Contacts.Contacts~onContactsSearchCompleted
         */
        /**
         * Adds a callback that is executed when a contacts search completes
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#addOnContactsSearchCompletedCallback
         * @param {AvayaCustomerServices.Services.Contacts.Contacts~onContactsSearchCompleted} callback
         */
        addOnContactsSearchCompletedCallback: function (callback) {
            this._onContactsSearchCompleted.add(callback);
        },
        /**
         * Checks if the contacts service is currently available
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#isContactsServiceAvailable
         * @returns {Boolean} true if the contacts service is available, otherwise false
         */
        isContactsServiceAvailable: function() {
            return this._contactsService.isContactsServiceAvailable();
        },
        /**
         * Searches for the contacts with given request parameters.
         *
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#search
         * @param {string} searchString Object describing the search parameters.
         * @param {number} maxResults the maximum number of results desired
         * @returns {AvayaCustomerServices.Base.Promise} a promise which resolves to the ID of the search
         */
        search: function (searchString, maxResults) {
            return this._contactsService.search(searchString, maxResults);
        },
        /**
         * Cancels the currently active search
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#cancelSearch
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        cancelSearch: function () {
            return this._contactsService.cancelSearch();
        },
        /**
         * Remove callbacks and stop contacts service
         *
         * @public
         * @function AvayaCustomerServices.Services.Contacts.Contacts#removeCallbacks
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeCallbacks: function () {
            this._onContactsAvailable.empty();
            this._onContactsUnavailable.empty();
            this._onContactsSearchResultsUpdated.empty();
            this._onContactsSearchCompleted.empty();
            this._onContactsSearchFailed.empty();
            return this._contactsService.stop();
        }
    };

    AvayaCustomerServices.Services.Contacts.Contacts = Contacts;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author Govinda Grings [ggrings@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines contact search result update message API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for contactSearchUpdate notification model
     *
     * @class
     * @memberOf AvayaCustomerServices.Services.Contacts
     * @define AvayaCustomerServices.Services.Contacts.ContactSearchUpdate
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for contacts search update notification
     * @param {Array} newContacts an associative array holding the new contacts
     */
    function ContactSearchUpdate(newContacts) {
        AvayaCustomerServices.Base.Collections.Model.call(this);
        /**
         * @private
         * @type {Array}
         */
        this._newContacts = newContacts;
    }

    ContactSearchUpdate.prototype =
    /** @lends AvayaCustomerServices.Services.Contacts.ContactSearchUpdate */
    {
        /**
         * Gets the new contacts updated in this result
         *
         * @public
         * @function AvayaCustomerServices.Services.Contacts.ContactSearchUpdate#getNewContacts
         * @returns {Array}
         */
        getNewContacts: function () {
            return this._newContacts;
        }
    };

    _.defaults(ContactSearchUpdate.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Contacts.ContactSearchUpdate = ContactSearchUpdate;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author Robert McNamara [mcnamara1@avaya.com]
 * @version 3.8.2.0
 * @since 3.6.0.0
 * @classdesc Contacts Service
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Contacts
     * @define AvayaCustomerServices.Services.Contacts.ContactsService
     * @param {AvayaCustomerServices.Providers.CP.Provider} contactsProvider
     */
    function ContactsService(contactsProvider) {
        /**
         * @private
         * @type {boolean}
         */
        this._started = false;
        /**
         * @private
         * @type {AvayaCustomerServices.Providers.CP.Provider}
         */
        this._contactsProvider = contactsProvider;
    }

    ContactsService.prototype =
    /** @lends AvayaCustomerServices.Services.Contacts.ContactsService */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Services.Contacts.ContactsService#init
         * @param {AvayaCustomerServices.Services.Contacts.Contacts} contacts
         */
        init: function (contacts) {
            this._started = true;
            this._contactsProvider.on('contacts.service.available', _.bind(onContactsServiceAvailable, null, contacts));
            this._contactsProvider.on('contacts.service.unavailable', _.bind(onContactsServiceUnavailable, null, contacts));
            this._contactsProvider.trigger('user.startContactsService');
            this._contactsProvider.on('contacts.search.update', _.bind(onContactsSearchResultsUpdated, null, contacts));
            this._contactsProvider.on('contacts.search.failed', _.bind(onContactsSearchFailed, null, contacts));
            this._contactsProvider.on('contacts.search.complete', _.bind(onContactsSearchCompleted, null, contacts));
        },
        /**
         * Stops the contacts service
         *
         * @public
         * @function AvayaCustomerServices.Services.Contacts.ContactsService#stop
         */
        stop: function () {
            this._started = false;
            this._contactsProvider.removeListeners('contacts');
            this._contactsProvider.trigger('user.stopContactsService');
        },
        /**
         * Checks if the contacts service is currently available
         * @public
         * @function AvayaCustomerServices.Services.Contacts.ContactsService#isContactsServiceAvailable
         * @returns {Boolean} true if the contacts service is available, otherwise false
         */
        isContactsServiceAvailable: function() {
            return this._contactsProvider.isContactsServiceAvailable();
        },
        /**
         * Searches for the contacts with given request parameters.
         *
         * @public
         * @function AvayaCustomerServices.Services.Contacts.ContactsService#search
         * @param {String} searchString the string to search for
         * @param {number} maxResults the maximum number of results desired
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        search: function (searchString, maxResults) {
            var searchField = AvayaCustomerServices.Providers.CP.ContactSearchCriteria.Fields.ALL;

            var searchCriteria = new AvayaCustomerServices.Providers.CP.ContactSearchCriteria(searchString, searchField, maxResults);

            return this._contactsProvider.searchContacts(searchCriteria);
        },
        /**
         * Cancels the currently active search
         *
         * @public
         * @function AvayaCustomerServices.Services.Contacts.ContactsService#cancelSearch
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        cancelSearch: function () {
            return this._contactsProvider.cancelContactsSearch();
        }
    };

    /**
     * function invoked when the contacts service provider becomes available
     * @private
     * @param contacts the contacts provider
     */
    function onContactsServiceAvailable (contacts) {
        contacts._onContactsAvailable.fire();
    }

    /**
     * function invoked when the contacts service provider becomes unavailable
     * @private
     * @param contacts the contacts provider
     */
    function onContactsServiceUnavailable (contacts) {
        contacts._onContactsUnavailable.fire();
    }

    /**
     * function invoked when the contacts search returns an update
     * @private
     * @param contacts
     * @param searchId the ID of the search which returned an update
     * @param cpContactsUpdateMessage the information about the update
     */
    function onContactsSearchResultsUpdated(contacts, searchId, cpContactsUpdateMessage) {
        var newContacts = _mapContacts(cpContactsUpdateMessage.getNewContacts());

        var updateMessage = new AvayaCustomerServices.Services.Contacts.ContactSearchUpdate(newContacts);

        contacts._onContactsSearchResultsUpdated.fire(searchId, updateMessage);
    }

    /**
     * function invoked when the contacts search fails
     * @private
     * @param contacts the contacts provider
     * @param searchId the ID of the search which failed
     * @param error what went wrong
     */
    function onContactsSearchFailed(contacts, searchId, error) {
        contacts._onContactsSearchFailed.fire(searchId, error);
    }

    /**
     * function invoked when the contacts search completes successfully
     * @private
     * @param contacts the contacts provider
     * @param searchId the ID of the search which completed
     */
    function onContactsSearchCompleted(contacts, searchId, results) {   
        var returnedContacts = _mapContacts(results);

        contacts._onContactsSearchCompleted.fire(searchId, returnedContacts);
    }

    function _mapContacts(cpContacts) {
        var mappedContacts = [];

        for (var key in cpContacts) {
            if (cpContacts.hasOwnProperty(key)) {
                mappedContacts[key] = new AvayaCustomerServices.Services.Contacts.Contact(cpContacts[key]);
            }
        }

        return mappedContacts;
    }

    AvayaCustomerServices.Services.Contacts.ContactsService = ContactsService;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Team API model
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Team
     * @define AvayaCustomerServices.Services.Team.Team
     * @param {AvayaCustomerServices.Services.Team.TeamService} teamService
     * @param {AvayaCustomerServices.Services.Team.TeamCollection} teamCollection
     */
    function Team(teamService, teamCollection) {
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Team.TeamService}
         */
        this._teamService = teamService;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Team.TeamCollection}
         */
        this._teamCollection = teamCollection;
        /**
         * @private
         */
        this._onTeamMembersAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         */
        this._onTeamGroupsAdded = new AvayaCustomerServices.Base.Callbacks();
    }

    Team.prototype =
    /** @lends AvayaCustomerServices.Services.Team.Team */
    {
        /**
         * Search Team Collection for a Team Member. Attempts to find a Team Member using their user handle.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#getMember
         * @param {string} userHandle User Handle of team member to find
         * @returns {AvayaCustomerServices.Services.Team.TeamMember}
         */
        getMember: function (userHandle) {
            return this._teamCollection.find({ userHandle: userHandle });
        },
        /**
         * Returns all Team Members that belong to their Team Collection.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#getMembers
         * @returns {AvayaCustomerServices.Services.Team.TeamMember[]}
         */
        getMembers: function () {
            return this._teamCollection.findAll();
        },
        /**
         * Returns all Team Members that have a supervisor role and belong to their Team Collection.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#getSupervisors
         */
        getSupervisors: function () {
            return this._teamCollection.getSupervisors();
        },
        /**
         * Returns all Team Members that have an agent role and belong to their Team Collection.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#getAgents
         */
        getAgents: function () {
            return this._teamCollection.getAgents();
        },
        /**
         * Fetches a summary of each Team Member's state from backend service.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#getTeamState
         * @param {string} role Get team state based on provided role
         */
        getTeamState: function (role) {
            return this._teamService.getTeamState(role);
        },
        /**
         * Sets the monitor flag for team member details updates
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#setTeamMonitoring
         * @param {string} role Get team member updates based on provided role
         * @param {boolean|string} monitor boolean for monitoring team member updates
         */
        setTeamMonitoring: function (role, monitor) {
            return this._teamService.setTeamMonitoring(role, monitor);
        },
        /**
         * Sets the monitor flag for team member details updates
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#setTeamMonitoring
         * @param {string} teamMemberUserHandle user handle of team member to be monitored
         * @param {boolean|string} monitor boolean for monitoring team member details updates
         */
        setTeamMemberMonitoring: function (teamMemberUserHandle, monitor) {
            return this._teamService.setTeamMemberMonitoring(teamMemberUserHandle, monitor);
        },
        /**
         * Requests an observe of an interaction.
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#observeMemberInteraction
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction Team member's interaction to observe
         * @param {string} teamMemberuserHandle Team members's user handle 
         */
        observeMemberInteraction: function (interaction, teamMemberuserHandle) {
            return this._teamService.startObserving(interaction, teamMemberuserHandle);
        },
        /**
         * Ends the observe of an interaction (deprecated - use interaction.end instead)
         *
         * @since 3.2.2
         * @deprecated
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#endObserveMemberInteraction
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction Team member's interaction to stop observing
         * @param {string} teamMemberUserHandle Team members's user handle 
         */
        endObserveMemberInteraction: function (interaction, teamMemberUserHandle) {
            return this._teamService.stopObserving(interaction, teamMemberUserHandle);
        },
        /**
         * Requests a force end of an interaction.
         *
         * @since 3.7.0
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#forceEndMemberInteraction
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction Team member's interaction to end
         * @param {string} teamMemberUserHandle Team members's user handle 
         */
        forceEndMemberInteraction: function (interaction, teamMemberUserHandle) {
            return this._teamService.forceEndMemberInteraction(interaction, teamMemberUserHandle);
        },
        /**
         * Coach on a members interaction
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#coach
         * @param {object} interaction
         */
        coach: function (interaction) {
            return this._teamService.coach(interaction);
        },
        /**
         * Barge in on a members interaction
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#bargeIn
         * @param {object} interaction
         */
        bargeIn: function (interaction) {
            return this._teamService.bargeIn(interaction);
        },
        /**
         * Supervisor broadcast
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#broadcast
         * @param {object} message to broadcast
         */
        broadcast: function (message) {
            return this._teamService.broadcast(message);
        },
        /**
         * The event data that is passed back to onTeamMembersUpdatedCallback
         * @typedef {Object} TeamStateUpdatedEvent
         * @property {string} role Role of the current user
         * @property {Object[]} members Array of team members
         */
        /**
         * This callback handles the TeamStateUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Team.Team~onTeamMembersUpdatedCallback
         * @param {TeamStateUpdatedEvent} message The event that is fired when team members have been updated
         */
        /**
         * Adds a callback that is executed when team members have been updated
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#addOnTeamMembersAddedCallback
         * @param {AvayaCustomerServices.Services.Team.Team~onTeamMembersUpdatedCallback} callback Function that handles on team members updated event response
         */
        addOnTeamMembersAddedCallback: function (callback) {
            this._onTeamMembersAdded.add(callback);
        },
        /**
         * The event data that is passed back to onTeamGroupsAddedCallback
         * @typedef {Object} TeamStateUpdatedEvent
         * @property {string} role Role of the current user
         * @property {Object[]} members Array of team members
         * @property {String[]} groups Array of groups
         */
        /**
         * This callback handles the TeamStateUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Team.Team~onTeamGroupsAddedCallback
         * @param {TeamStateUpdatedEvent} message The event that is fired when team members have been updated and groups exist
         */
        /**
         * Adds a callback that is executed when team groups exist when members have been updated
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#addOnTeamGroupsAddedCallback
         * @param {AvayaCustomerServices.Services.Team.Team~onTeamGroupsAddedCallback} callback Function that handles on team members updated event response
         */
        addOnTeamGroupsAddedCallback: function (callback) {
            this._onTeamGroupsAdded.add(callback);
        },
        /**
         * Remove callbacks and stop team service
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.Team#removeCallbacks
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeCallbacks: function () {
            this._onTeamMembersAdded.empty();
            this._onTeamGroupsAdded.empty();
            return this._teamService.stop();
        }
    };

    AvayaCustomerServices.Services.Team.Team = Team;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Collection for managing an array of {@link Team} types.
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Constructor function for Team Request Collection
     *
     * @class
     * @define AvayaCustomerServices.Services.Team.TeamCollection
     * @memberOf AvayaCustomerServices.Services.Team
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     * @param {AvayaCustomerServices.Services.Team.TeamService} teamService
     */
    function TeamCollection(teamService) {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Services.Team.TeamMember);
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Team.TeamService}
         */
        this._teamService = teamService;
    }

    TeamCollection.prototype =
    /** @lends AvayaCustomerServices.Services.Team.TeamCollection */
    {
        /**
         * @public
         * @override
         * @function AvayaCustomerServices.Services.Team.TeamCollection#add
         * @param {Object} data - Data for populating new Team Member
         * @returns {AvayaCustomerServices.Services.Team.TeamMember}
         */
        add: function (data) {
            var teamMember = new this._model(this._teamService);
            teamMember.id = data.id;
            teamMember.setData(data);
            this._collection.push(teamMember);
            return teamMember;
        },
        /**
         * Find all Team Members with 'type' set to 'SUPERVISOR'
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamCollection#getAgents
         * @returns {AvayaCustomerServices.Services.Team.TeamMember[]}
         */
        getSupervisors: function () {
            return this.findAll({type: 'SUPERVISOR'});
        },
        /**
         * Find all Team Members with 'type' set to 'AGENT'
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamCollection#getAgents
         * @returns {AvayaCustomerServices.Services.Team.TeamMember[]}
         */
        getAgents: function () {
            return this.findAll({type: 'AGENT'});
        },
        /**
         * Find current User's team member entry
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamCollection#getSelf
         * @returns {AvayaCustomerServices.Services.Team.TeamMember}
         */
        getSelf: function () {
            return this.find({isSelf: true});
        }
    };

    _.defaults(TeamCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Services.Team.TeamCollection = TeamCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Team Member API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for TeamMember Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Services.Team
     * @define AvayaCustomerServices.Services.Team.TeamMember
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     * @param {AvayaCustomerServices.Services.Team.TeamService} teamService
     * @param {{idAttribute}} options TeamMember Model options
     */
    function TeamMember(teamService, options) {
        AvayaCustomerServices.Base.Collections.Model.call(this, options);
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Team.TeamService}
         */
        this._teamService = teamService;
        /**
         * Team Member's ID
         *
         * @public
         * @type {string}
         */
        this.id = undefined;
        /**
         * Team Member's display name
         *
         * @public
         * @type {string}
         */
        this.displayName = undefined;
        /**
         * Team Member's display name
         *
         * @public
         * @type {string}
         */
        this.resourceAddress = undefined;
        /**
         * Team Member's first name
         *
         * @public
         * @type {string}
         */
        this.firstName = undefined;
        /**
         * Team Member's last name
         *
         * @public
         * @type {string}
         */
        this.lastName = undefined;
        /**
         * Team Member's type. This is synonymous with Agent's role.
         *
         * @public
         * @type {string}
         */
        this.type = undefined;
        /**
         * Team Member's address.
         *
         * @public
         * @type {string}
         */
        this.address = undefined;
        /**
         * Team Member's user handle.
         *
         * @public
         * @type {string}
         */
        this.userHandle = undefined;
        /**
         * Team Member's current state.
         *
         * @public
         * @type {string}
         */
        this.state = undefined;
        /**
         * Team Member's current state reason (if in a not ready state).
         *
         * @public
         * @type {string}
         */
        this.stateReason = undefined;
        /**
         * Team Member's connection state.
         *
         * @public
         * @type {boolean}
         */
        this.isConnected = undefined;
        /**
         * Team Member's monitored state.
         *
         * @public
         * @type {boolean}
         */
        this.isMonitored = undefined;
        /**
         * Team Member's disconnection time.
         *
         * @public
         * @type {string}
         */
        this.disconnectedTime = undefined;
        /**
         * Team Member's list of channels. Only available to supervisors.
         *
         * @public
         * @type {Object[]}
         */
        this.channels = [];
        /**
         * Team Member's list of activate interactions. Only available to supervisors.
         *
         * @public
         * @type {Object[]}
         */
        this.interactions = [];
        /**
         * Team Member's list of deferred interactions. Only available to supervisors.
         *
         * @public
         * @type {Object[]}
         */
        this.deferredInteractions = [];
        /**
         * Team Member's list of capabilities. Only available to supervisors.
         *
         * @since 3.2.2
         * @public
         * @type {Object}
         */
        this.capabilities = {};
        /**
         * An array of group names that the team member belongs
         *
         * @since 3.4.0.0
         * @public
         * @type {String[]}
         */
        this.groups = null;
        /**
         * True if the Team Member is the current agent.
         *
         * @public
         * @type {boolean}
         */
        this.isSelf = undefined;
    }

    TeamMember.prototype =
    /** @lends AvayaCustomerServices.Services.Team.TeamMember */
    {
        /**
         * Start observing team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#observe
         * @param {{id}} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        observe: function (interaction) {
            return this._teamService.startObserving(interaction, this.userHandle);
        },
        /**
         * Stop observing team member's interaction (deprecated - use interaction.end instead)
         *
         * @public
         * @deprecated
         * @function AvayaCustomerServices.Services.Team.TeamMember#stopObserving
         * @param {{id}} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stopObserving: function (interaction) {
            return this._teamService.stopObserving(interaction, this.userHandle);
        },
        /**
         * Stop observing team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#bargeIn
         * @param {{id}} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        bargeIn: function (interaction) {
            return this._teamService.bargeIn(interaction);
        },
        /**
         * Find all interactions attached to this Team Member
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#getInteractions
         * @returns {AvayaCustomerServices.Services.Work.Interaction[]}
         */
        getInteractions: function () {
            return this.interactions;
        },
        /**
         * Find Team Member state
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#getState
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        getState: function () {
            return this._teamService.getState(this).then(_.bind(updateTeamMember, null, this));
        },
        /**
         * Logout Team Member
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#setState
         * @param {string} [logoutReason=998] Reason for logging out team member
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        logout: function (logoutReason) {
            return this._teamService.logout(this, logoutReason).then(_.bind(updateTeamMember, null, this));
        },
        /**
         * Set Agent's state to "Ready". In this state, agents are available to be routed new work requests.
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#goReady
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        goReady: function () {
            return this._teamService.goReady(this).then(_.bind(updateTeamMember, null, this));
        },
        /**
         * Set Agent's state to "Not Ready". In this state, agents are not available to be routed new work requests.
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#goNotReady
         * @param {string} [notReadyReason=998] Reason for setting team member into a "Not Ready" state
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        goNotReady: function (notReadyReason) {
            return this._teamService.goNotReady(this, notReadyReason).then(_.bind(updateTeamMember, null, this));
        },
        /**
         * Deactivate team member, freeing up any occupied stations used by that team member.
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#deactivate
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        deactivate: function () {
            return this._teamService.deactivate(this).then(_.bind(updateTeamMember, null, this));
        },
        /**
         * Set model data
         *
         * @private
         * @override
         * @function AvayaCustomerServices.Services.Team.TeamMember#setData
         * @param {Object} data Data to set
         * @returns {object} data
         */
        setData: function (data) {
            _.assignIn(this, {address: data.accountId});
            return _.assignSafe(this, data);
        }
    };
    /**
     * @private
     * @function updateTeamMember
     * @param {AvayaCustomerServices.Services.Team.TeamMember} teamMember
     * @param {Object} teamMemberData
     */
    function updateTeamMember(teamMember, teamMemberData) {
        var data = teamMemberData && teamMemberData.newValue && teamMemberData.newValue[0] || {};
        _.assignSafe(teamMember, {
            capabilities: data.capabilities,
            state: data.state,
            stateReason: data.stateReason,
            isConnected: data.isConnected,
            isMonitored: data.isMonitored,
            disconnectedTime: data.disconnectedTime
        });
        _.mergeArrayWith(teamMember.channels, data.channels, 'id');
        _.mergeArrayWith(teamMember.interactions, data.interactions, 'id');
        return data;
    }

    _.defaults(TeamMember.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Team.TeamMember = TeamMember;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Team Service
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Team
     * @define AvayaCustomerServices.Services.Team.TeamService
     * @param {AvayaCustomerServices.Providers.UAC.Provider} teamProvider
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     */
    function TeamService(teamProvider, agent) {
        /**
         * @private
         * @type {boolean}
         */
        this._started = false;
        /**
         * @private
         * @type {AvayaCustomerServices.Providers.UAC.Provider}
         */
        this._teamProvider = teamProvider;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Agent.Agent}
         */
        this._agent = agent;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Team.TeamCollection}
         */
        this._teamCollection = undefined;
    }

    TeamService.prototype =
    /** @lends AvayaCustomerServices.Services.Team.TeamService */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#init
         * @param {AvayaCustomerServices.Services.Team.Team} team
         * @param {AvayaCustomerServices.Services.Team.TeamCollection} teamCollection
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        init: function (team, teamCollection) {
            this._started = true;
            this._teamCollection = teamCollection;

            this._teamProvider.on('team.state.updated', _.bind(onTeamStateUpdate, null, team, teamCollection));
            this._teamProvider.on('team.member.details.updated', _.bind(onTeamStateUpdate, null, team, teamCollection));
        },
        /**
         * Stops the interactions service
         *
         * @public
         */
        stop: function () {
            this._started = false;
            this._teamProvider.removeListeners('team');
        },
        /**
         * Start observing team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#startObserving
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} teamMemberUserHandle Team Members's user handle 
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        startObserving: function (interaction, teamMemberUserHandle) {
            var handle = this._agent.getHandle();
            teamMemberUserHandle = teamMemberUserHandle || interaction.userHandle;
            return this._teamProvider.startObserving(handle, teamMemberUserHandle, interaction);
        },
        /**
         * Stop observing team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#stopObserving
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} teamMemberUserHandle Team Members's user handle 
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stopObserving: function (interaction, teamMemberUserHandle) {
            var handle = this._agent.getHandle();
            teamMemberUserHandle = teamMemberUserHandle || interaction.userHandle;
            return this._teamProvider.stopObserving(handle, teamMemberUserHandle, interaction);
        },
        /**
         * Force end team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#stopObserving
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} teamMemberUserHandle Team Members's user handle 
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        forceEndMemberInteraction: function (interaction, teamMemberUserHandle) {
            var handle = this._agent.getHandle();
            var extraParams = { forceEnd: true };
            teamMemberUserHandle = teamMemberUserHandle || interaction.userHandle;
            return this._teamProvider.endMemberInteraction(handle, teamMemberUserHandle, interaction, extraParams);
        },

        /**
         * Coach on team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#coach
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Services.Agent.Agent}
         */
        coach: function (interaction) {
            var handle = this._agent.getHandle();
            return this._teamProvider.coach(handle, interaction);
        },
        /**
         * Barge in on team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#bargeIn
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        bargeIn: function (interaction) {
            var handle = this._agent.getHandle();
            return this._teamProvider.bargeIn(handle, interaction);
        },
        /**
         * Supervisor broadcast
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#broadcast
         * @param {Object} message to broadcast
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        broadcast: function (message) {
            var handle = this._agent.getHandle();
            var payload = JSON.stringify(message);
            return this._teamProvider.broadcast(handle, payload);
        },
        /**
         * Find All Team Member's states
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#getTeamState
         * @param {string} role
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getTeamState: function (role) {
            var handle = this._agent.getHandle();
            this._teamProvider.getTeamState(handle, role);
        },
        /**
         * Find Team Member state
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#getState
         * @param {AvayaCustomerServices.Services.Team.TeamMember} teamMember
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getState: function (teamMember) {
            var handle = this._agent.getHandle();
            var role = this._agent.getRole();
            return this._teamProvider.getTeamMemberState(handle, role, teamMember.userHandle);
        },
        /**
         * Set team monitoring
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#setTeamMonitoring
         * @param {string} role
         * @param {boolean|string} monitor
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setTeamMonitoring: function (role, monitor) {
            var handle = this._agent.getHandle();
            return this._teamProvider.setTeamMonitoring(handle, role, monitor.toString());
        },
        /**
         * Set team member monitoring
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#setTeamMemberMonitoring
         * @param {string} teamMemberUserHandle
         * @param {boolean|string} monitor
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setTeamMemberMonitoring: function (teamMemberUserHandle, monitor) {
            var handle = this._agent.getHandle();
            return this._teamProvider.setTeamMemberMonitoring(handle, teamMemberUserHandle, monitor.toString());
        },
        /**
         * Logout Team Member
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamService#logout
         * @param {AvayaCustomerServices.Services.Team.TeamMember} teamMember
         * @param {string} [logoutReason] Reason for logging out team member
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        logout: function (teamMember, logoutReason) {
            var handle = this._agent.getHandle();
            return this._teamProvider.logoutTeamMember(handle, teamMember.userHandle, logoutReason);
        },
        /**
         * Set Agent's state to "Ready". In this state, agents are available to be routed new work requests.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#goReady
         * @param {AvayaCustomerServices.Services.Team.TeamMember} teamMember
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goReady: function (teamMember) {
            var handle = this._agent.getHandle();
            return this._teamProvider.goReadyTeamMember(handle, teamMember.userHandle);
        },
        /**
         * Set Agent's state to "Not Ready". In this state, agents are not available to be routed new work requests.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#goNotReady
         * @param {AvayaCustomerServices.Services.Team.TeamMember} teamMember
         * @param {string} [notReadyReason] Reason for setting team member into a "Not Ready" state
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goNotReady: function (teamMember, notReadyReason) {
            var handle = this._agent.getHandle();
            return this._teamProvider.goNotReadyTeamMember(handle, teamMember.userHandle, notReadyReason);
        },
        /**
         * Deactivate team member, freeing up any occupied stations used by that team member.
         *
         * @public
         * @function AvayaCustomerServices.Services.Team.TeamMember#deactivate
         * @param {AvayaCustomerServices.Services.Team.TeamMember} teamMember
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deactivate: function (teamMember) {
            return this._teamProvider.deactivateTeamMember(teamMember.userHandle);
        }
    };

    /**
     * Handle team state update events
     *
     * @private
     * @function onTeamStateUpdate
     * @param {AvayaCustomerServices.Services.Team.Team} team
     * @param {AvayaCustomerServices.Services.Team.TeamCollection} teamCollection
     * @param {Object} message
     */
    function onTeamStateUpdate(team, teamCollection, message) {
        var teamMembers = [];
        message = message || {};

        if (message.members && message.members.length) {
            _.forEach(message.members, function (member) {
                teamMembers.push(teamCollection.add(member));
            });
            team._onTeamMembersAdded.fire(teamMembers);

            if (message.groups) {
                team._onTeamGroupsAdded.fire({
                    role: message.role,
                    members: teamMembers,
                    groups: message.groups
                });
            }
        }
        AvayaCustomerServices.Base.Logger.debug('Team Service', {
            scope: 'Team Service - onTeamStateUpdate',
            message: message
        });
    }

    AvayaCustomerServices.Services.Team.TeamService = TeamService;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Interaction API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for Interaction Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Services.Work
     * @define AvayaCustomerServices.Services.Work.Interaction
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     * @param {AvayaCustomerServices.Services.Work.WorkService} workService
     */
    function Interaction(workService) {
        AvayaCustomerServices.Base.Collections.Model.call(this);
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.WorkService}
         */
        this._workService = workService;
        /**
         * Work Request ID for this interaction
         *
         * @public
         * @type {string}
         */
        this.workRequestId = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.InteractionContext}
         */
        this._interactionContext = undefined;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.InteractionMedia}
         */
        this._interactionMedia = undefined;
        /**
         * @private
         * @type {Object[]}
         */
        this._participants = [];
        /**
         * @private
         * @type {Object[]}
         */
        this._videoStreams = [];
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onActive = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onUnknown = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onHeld = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onUnheld = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onACW = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onACWPending = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onPassive = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onEnded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onRemoteParticipantAccepted = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onMediaAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onContextAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onContextRemoved = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onVideoUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onAudioUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onSpeakerUpdated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * Cached services request promise
         *
         * @private
         * @type {null | Promise}
         */
        this._servicesRequestCache = null;
    }

    Interaction.prototype =
    /** @lends AvayaCustomerServices.Services.Work.Interaction */
    {
        /**
         * Accepts this incoming interaction.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#accept
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        accept: function () {
            return this._workService.accept(this);
        },
        /**
         * End this interaction.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#end
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        end: function () {
            return this._workService.end(this);
        },
        /**
         * Terminate this interaction.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#end
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        forceEnd: function () {
            return this._workService.end(this, {forceEnd : true});
        },
        /**
         * Close this interaction to get requeued.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#closeContact
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        closeContact: function () {
            return this._workService.end(this, {closeContact: true});
        },
        /**
         * Defer this interaction.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#defer
         * @param {string} interval Interval to defer interaction for
         * @param {string} reason Defer reason
         * @param {object} payload Payload for draft
         * @param {object} [options] Options for draft
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        defer: function (interval, reason, payload, options) {
            return this._workService.defer(this, interval, reason, payload, options);
        },
        /**
         * Defer forward this interaction.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#defer
         * @param {string} interval Interval to defer forward interaction for
         * @param {string} reason Defer forward reason
         * @param {object} payload Payload for draft
         * @param {object} [options] Options for draft
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deferForward: function (interval, reason, payload, options) {
            return this._workService.deferForward(this, interval, reason, payload, options);
        },
        /**
         * Set this interaction on 'hold'.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#hold
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        hold: function () {
            return this._workService.hold(this);
        },
        /**
         * Set this interaction from 'hold' to 'active'.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#unhold
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        unhold: function () {
            return this._workService.unhold(this);
        },
        /**
         * Start consult interaction to remote address.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#consult
         * @param {string} remoteAddress Remote address to consult
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consult: function (remoteAddress, uui) {
            return this._workService.consult(this, remoteAddress, uui);
        },
        /**
         * Complete consult interaction as transfer.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#completeTransfer
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        completeTransfer: function () {
            return this._workService.consultCompleteAsTransfer(this);
        },
        /**
         * Complete consult interaction as conference.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#completeConference
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        completeConference: function () {
            return this._workService.consultCompleteAsConference(this);
        },
        /**
         * Extend After Contact Work
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#extendACW
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        extendACW: function () {
            return this._workService.extendACW(this);
        },
        /**
         * Complete After Call Work.
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#completeACW
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        completeACW: function () {
            return this._workService.completeACW(this);
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#isHeldRemotely
         * @returns {boolean}
         */
        isHeldRemotely: function () {
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#isRemote
         * @returns {boolean}
         */
        isRemote: function () {
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#join
         * @param id
         */
        join: function (id) {
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#reject
         */
        reject: function () {
            return this._workService.reject(this);
        },
        /**
         * Send DTMF digits to backend service to generate DTMF tones
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#sendDTMF
         * @param {string} dtmf DTMF character
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendDTMF: function (dtmf) {
            return this._workService.sendDTMF(this, dtmf);
        },
        /**
         * Set a work code for this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#setWorkCode
         * @param {string} workCode Value of work code to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setWorkCode: function (workCode) {
            return this._workService.setWorkCode(this, workCode);
        },
        /**
         * Set a disposition code for this interaction
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#setDispositionCode
         * @param {string} dispositionCode Value of disposition code to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setDispositionCode: function (dispositionCode) {
            return this._workService.setDispositionCode(this, dispositionCode);
        },
        /**
         * Performs a single step transfer on this interaction to a remote address
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#singleStepTransfer
         * @param {string} address Remote address to single step transfer to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        singleStepTransfer: function (address) {
            return this._workService.transfer(this, address);
        },
        /**
         * Performs a single step transfer on this interaction to a service
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#singleStepTransferToService
         * @param {string} serviceId ID of service to single step transfer to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        singleStepTransferToService: function (serviceId) {
            return this._workService.transferToService(this, serviceId);
        },
        /**
         * Performs a single step transfer on this interaction to a service
         *
         * @since 3.7.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#singleStepTransferToUser
         * @param {string} userId ID of service to single step transfer to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        singleStepTransferToUser: function (userId) {
            return this._workService.transferToUser(this, userId);
        },
        /**
         * Performs a consult on this interaction to a service
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#consultToService
         * @param {string} serviceId ID of service to consult to
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultToService: function (serviceId, uui) {
            return this._workService.consultToService(this, serviceId, uui);
        },
        /**
         * Performs a consult on this interaction to a user
         *
         * @since 3.8.1.1
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#consultToUser
         * @param {string} userId ID of user to consult to
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
         consultToUser: function (userId, uui) {
            return this._workService.consultToUser(this, userId, uui);
        },
        /**
         * Get list of services
         *
         * @since 3.6.0
         * @public
         * @function AvayaCustomerServices.Providers.UAC.Provider#getServices
         * @param {boolean} [useCache=false] Optional param - specifies whether to cache the request promise/re-use cached promise to prevent multiple requests
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getServices: function (useCache) {
            if (!useCache || !this._servicesRequestCache) {
                this._servicesRequestCache = this._workService.getServices(this);
            }

            return this._servicesRequestCache;
        },
        /**
        * Get list of users
        *
        * @since 3.7.0.0
        * @public
        * @function AvayaCustomerServices.Providers.UAC.Provider#getUsers
        * @param {string} searchText search text
        * @returns {AvayaCustomerServices.Base.Promise}
        */
        getUsers: function (searchText) {
            return this._workService.getUsers(this, searchText);
        },
        /**
         * Get workRequestId for this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getWorkRequestId
         * @returns {string|null} workRequestId
         */
        getWorkRequestId: function () {
            return this.data.workRequestId || null;
        },
        /**
         * Get capabilities object for this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getCapabilities
         * @returns {object} List of capabilities
         */
        getCapabilities: function () {
            return this.data.capabilities || {};
        },
        /**
         * Get interaction context object for this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getInteractionContext
         * @returns {AvayaCustomerServices.Services.Work.InteractionContext}
         */
        getInteractionContext: function () {
            return this._interactionContext;
        },
        /**
         * Get interaction media object for this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getInteractionMedia
         * @returns {AvayaCustomerServices.Services.Work.InteractionMedia}
         */
        getInteractionMedia: function () {
            return this._interactionMedia;
        },
        /**
         * Get topic for this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getTopic
         * @returns {string}
         */
        getTopic: function () {
            return this.data.topic;
        },
        /**
         * Get current state of this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getState
         * @returns {string} The current state of the interaction
         */
        getState: function () {
            return this.data.state;
        },
        /**
         * Get originating address (source) of this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getRemoteAddress
         * @returns {String} The address of the initiating party in this Interaction
         */
        getOriginatingAddress: function () {
            return this.data.originatingAddress;
        },
        /**
         * Get destination address of this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getDestinationAddress
         * @returns {String} The address of the receiving party in this Interaction
         */
        getDestinationAddress: function () {
            return this.data.destinationAddress;
        },
        /**
         * Get direction of this interaction (INCOMING or OUTGOING)
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getDirection
         * @returns {String} The direction of this Interaction
         */
        getDirection: function () {
            return this.data.direction;
        },
        /**
         * Get the remote participant (customer) belonging to this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getRemoteParticipant
         * @returns {String}
         */
        getRemoteParticipant: function () {
            if (this.isIncoming()) {
                return this.getOriginatingAddress();
            } else {
                return this.getDestinationAddress();
            }
        },
        /**
         * Get the call instance from the communication services package.
         * This function will return undefined when the communication services package is not enabled
         *
         * @public
         * @since 3.6.0.0
         * @function AvayaCustomerServices.Services.Work.Interaction#getCall
         * @returns {AvayaCustomerServices.Base.Promise|undefined}
         */
        getCall: function () {
            return this._workService.getCall(this);
        },
        /**
         * Check is this interaction is an inbound interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#isIncoming
         * @returns {boolean} True if interaction is incoming / inbound
         */
        isIncoming: function () {
            return this.data.direction === 'INCOMING';
        },
        /**
         * Check if this interaction involves a customer
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#isCustomerInteraction
         * @returns {boolean} True if interaction involves a customer
         */
        isCustomerInteraction: function () {
            return !!this.data.isCustomerInteraction;
        },
        /**
         * Get the work code associated with this interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getWorkCode
         * @returns {Object[]}
         */
        getWorkCode: function () {
            return this.data.workCode;
        },
        /**
         * Get the disposition code associated with this interaction
         *
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getDispositionCode
         * @returns {Object[]}
         */
        getDispositionCode: function () {
            return this.data.dispositionCode;
        },
        /**
         * Mute audio
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#muteAudio
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        muteAudio: function () {
            return this._workService.muteAudio(this);
        },

        /**
         * Unmute audio
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#unmuteAudio
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        unmuteAudio: function () {
            return this._workService.unmuteAudio(this);
        },

        /**
         * Mute audio
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#isAudioMuted
         * @returns {boolean} True if audio is muted
         */
        isAudioMuted: function () {
            return this.data.audioMuted;
        },

        /**
         * Set Video Mode
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#setVideoMode
         * @param {string} mode Video mode to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setVideoMode: function (mode) {
            return this._workService.setVideoMode(this, mode);
        },

        /**
         * Enable local Video
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#enableLocalVideo
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        enableLocalVideo: function () {
            return this._workService.enableLocalVideo(this);
        },

        /**
         * Disable local Video
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#disableLocalVideo
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        disableLocalVideo: function () {
            return this._workService.disableLocalVideo(this);
        },

        /**
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getLocalVideoStream
         * @returns {Object[]}
         */
        getLocalVideoStream: function () {
            return _.find(this._videoStreams, {direction: 'local'});
        },

        /**
         *
         * @since 3.4.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#getRemoteVideoStream
         * @returns {Object[]}
         */
        getRemoteVideoStream: function () {
            return _.find(this._videoStreams, {direction: 'remote'});
        },

        /**
         * Set Agent data
         *
         * @private
         * @override
         * @function AvayaCustomerServices.Services.Work.Interaction#setData
         * @param {Object} data Data to set
         * @returns {object} Resultant data set in Interaction model
         */
        setData: function (data) {
            _.assignSafe(this, {
                workRequestId: data.workRequestId,
                participants: data.participants
            });
            this.isNew = _.isEmpty(this.data);
            return _.assignIn(this.data, data);
        },
        /**
         * The event data that is passed back to onInteractionActiveCallback
         * @typedef {Object} InteractionActiveEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         * @property {string} intrinsics Intrinsics associated with Interaction
         */
        /**
         * This callback handles the InteractionActiveEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionActiveCallback
         * @param {InteractionActiveEvent} message The event that is fired when an interaction state is changed to 'active'
         */
        /**
         * Adds a callback that is executed when an interaction state is changed to 'active'
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionActiveCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionActiveCallback} callback Function that handles on active interaction event response
         */
        addOnInteractionActiveCallback: function (callback) {
            this._onActive.add(callback);
        },
        /**
         * Adds a callback that is executed when an interaction state is changed to 'unknown'
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionUnknownCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~addOnInteractionUnknownCallback} callback Function that handles on active interaction event response
         */
        addOnInteractionUnknownCallback : function (callback) {
            this._onUnknown.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionHeldCallback
         * @typedef {Object} InteractionHeldEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         * @property {string} intrinsics Intrinsics associated with Interaction
         */
        /**
         * This callback handles the InteractionHeldEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionHeldCallback
         * @param {InteractionHeldEvent} message The event that is fired when an interaction state is changed to 'held'
         */
        /**
         * Adds a callback that is executed when an interaction state is changed to 'held'
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionHeldCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionHeldCallback} callback Function that handles on held interaction event response
         */
        addOnInteractionHeldCallback: function (callback) {
            this._onHeld.add(callback);
        },
        /**
         * This callback handles the InteractionActiveEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionUnheldCallback
         * @param {InteractionActiveEvent} message The event that is fired when an interaction state is changed from 'held' to 'active'
         */
        /**
         * Adds a callback that is executed when an interaction state is changed from 'held' to 'active'
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionUnheldCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionUnheldCallback} callback Function that handles on unheld interaction event response
         */
        addOnInteractionUnheldCallback: function (callback) {
            this._onUnheld.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionACWCallback
         * @typedef {Object} InteractionACWEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         * @property {string} intrinsics Intrinsics associated with Interaction
         */
        /**
         * This callback handles the InteractionACWEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionACWCallback
         * @param {InteractionACWEvent} message The event that is fired when an interaction state is changed to 'ACW'
         */
        /**
         * Adds a callback that is executed when an interaction state is changed to 'ACW'
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionACWCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionACWCallback} callback Function that handles on ACW interaction event response
         */
        addOnInteractionACWCallback: function (callback) {
            this._onACW.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionACWPendingCallback
         * @typedef {Object} InteractionACWPendingEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         * @property {string} intrinsics Intrinsics associated with Interaction
         */
        /**
         * This callback handles the InteractionACWPendingEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionACWPendingCallback
         * @param {InteractionACWPendingEvent} message The event that is fired when an interaction state is changed to 'ACW_PENDING'
         */
        /**
         * Adds a callback that is executed when an interaction state is changed to 'ACW_PENDING'
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionACWPendingCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionACWPendingCallback} callback Function that handles on ACW_PENDING interaction event response
         */
        addOnInteractionACWPendingCallback: function (callback) {
            this._onACWPending.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionPassiveCallback
         * @typedef {Object} InteractionPassiveEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         * @property {string} intrinsics Intrinsics associated with Interaction
         */
        /**
         * This callback handles the InteractionPassiveEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionPassiveCallback
         * @param {InteractionPassiveEvent} message The event that is fired when an interaction state is changed to 'passive'
         */
        /**
         * Adds a callback that is executed when an interaction state is changed to 'passive'
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionPassiveCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionPassiveCallback} callback Function that handles on passive interaction event response
         */
        addOnInteractionPassiveCallback: function (callback) {
            this._onPassive.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionUpdatedCallback
         * @typedef {Object} InteractionUpdatedEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         * @property {string} intrinsics Intrinsics associated with Interaction
         */
        /**
         * This callback handles the InteractionUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionUpdatedCallback
         * @param {InteractionUpdatedEvent} message The event that is fired when an interaction state has changed
         */
        /**
         * Adds a callback that is executed when an interaction state has been updated
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionUpdatedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionUpdatedCallback} callback Function that handles on update interaction event response
         */
        addOnInteractionUpdatedCallback: function (callback) {
            this._onUpdated.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionEndedCallback
         * @typedef {Object} InteractionDeleteEvent
         * @property {string} id Unique identifier for Interaction
         */
        /**
         * This callback handles the InteractionDeleteEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionEndedCallback
         * @param {InteractionDeleteEvent} message The event that is fired when an interaction has ended
         */
        /**
         * Adds a callback that is executed when an interaction has ended
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionEndedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionEndedCallback} callback Function that handles on delete interaction event response
         */
        addOnInteractionEndedCallback: function (callback) {
            this._onEnded.add(callback);
        },
        /**
         * The event data that is passed back to onRemoteParticipantAcceptedCallback
         * @typedef {Object} InteractionRemoteParticipantAcceptedEvent
         * @property {string} id Unique identifier for Interaction
         */
        /**
         * This callback handles the InteractionRemoteParticipantAcceptedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onRemoteParticipantAcceptedCallback
         * @param {InteractionRemoteParticipantAcceptedEvent} message The event that is fired when remote participant has accepted interaction
         */
        /**
         * Adds a callback that is executed when remote participant has accepted interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnRemoteParticipantAcceptedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onRemoteParticipantAcceptedCallback} callback Function that handles on remote participant accepted event response
         */
        addOnRemoteParticipantAcceptedCallback: function (callback) {
            this._onRemoteParticipantAccepted.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionMediaAddedCallback
         * @typedef {Object} InteractionMediaCreatedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {string} workRequestId Work Request ID
         * @property {string} interactionId Unique identifier for Interaction
         * @property {Object[]} participants Array of participants involved in Interaction
         * @property {Object[]} messages Array of messages belonging to this Interaction Media
         */
        /**
         * This callback handles the InteractionMediaCreatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionMediaAddedCallback
         * @param {InteractionMediaCreatedEvent} message The event that is fired when interaction media has been added to an interaction
         */
        /**
         * Adds a callback that is executed when interaction media has been added to an interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionMediaAddedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionMediaAddedCallback} callback Function that handles on interaction media added event response
         */
        addOnInteractionMediaAddedCallback: function (callback) {
            this._onMediaAdded.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionContextAddedCallback
         * @typedef {Object} InteractionContextCreatedEvent
         * @property {string} id Unique identifier for Interaction Context
         * @property {string} interactionId Unique identifier for Interaction
         * @property {object[]} pagePushUrl Array of page push URLs
         * @property {object[]} suggestedPhrase Array of suggested phrases
         * @property {object[]} contextStore Array of context stores
         * @property {object[]} screenPop Array of screen pops
         * @property {object[]} cobrowse Array of cobrowse objects
         * @property {object[]} customerHistory Array of customer histories
         * @property {object[]} customerDetails Array of customer details
         * @property {object[]} clientValidation Array of client validations
         * @property {object[]} campaignScripts Array of campaign scripts
         * @property {object[]} fromAddresses Array of fromAddresses
         */
        /**
         * This callback handles the InteractionContextCreatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionContextAddedCallback
         * @param {InteractionContextCreatedEvent} message The event that is fired when interaction context has been added to an interaction
         */
        /**
         * Adds a callback that is executed when interaction context has been added to an interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionContextAddedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionContextAddedCallback} callback Function that handles on interaction context added event response
         */
        addOnInteractionContextAddedCallback: function (callback) {
            this._onContextAdded.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionContextRemovedCallback
         * @typedef {Object} InteractionContextDeletedEvent
         * @property {string} id Unique identifier for Interaction Context
         * @property {string} interactionId Unique identifier for Interaction
         * @property {object[]} pagePushUrl Array of page push URLs
         * @property {object[]} suggestedPhrase Array of suggested phrases
         * @property {object[]} contextStore Array of context stores
         * @property {object[]} screenPop Array of screen pops
         * @property {object[]} cobrowse Array of cobrowse objects
         * @property {object[]} customerHistory Array of customer histories
         * @property {object[]} customerDetails Array of customer details
         * @property {object[]} clientValidation Array of client validations
         * @property {object[]} campaignScripts Array of campaign scripts
         * @property {object[]} fromAddresses Array of fromAddresses
         */
        /**
         * This callback handles the InteractionContextDeletedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionContextRemovedCallback
         * @param {InteractionContextDeletedEvent} message The event that is fired when interaction context has been removed from an interaction
         */
        /**
         * Adds a callback that is executed when interaction context has been removed from an interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionContextRemovedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionContextRemovedCallback} callback Function that handles on interaction context removed event response
         */
        addOnInteractionContextRemovedCallback: function (callback) {
            this._onContextRemoved.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionAudioUpdatedCallback
         * @typedef {Object} InteractionAudioUpdatedEvent
         * @property {string} id Unique identifier for Interaction Media
         */
        /**
         * This callback handles the InteractionAudioUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionAudioUpdatedCallback
         * @param {InteractionAudioUpdatedEvent} message The event that is fired when interaction audio has been updated
         */
        /**
         * Adds a callback that is executed when interaction context has been removed from an interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionAudioUpdatedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionAudioUpdatedCallback} callback Function that handles on audio updated event response
         */
        addOnInteractionAudioUpdatedCallback: function (callback) {
            this._onAudioUpdated.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionSpeakerUpdatedCallback
         * @typedef {Object} InteractionSpeakerUpdatedEvent
         * @property {string} id Unique identifier for Interaction Media
         */
        /**
         * This callback handles the InteractionSpeakerUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionSpeakerUpdatedCallback
         * @param {InteractionSpeakerUpdatedEvent} message The event that is fired when interaction speaker has been updated
         */
        /**
         * Adds a callback that is executed when interaction context has been removed from an interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionSpeakerUpdatedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionSpeakerUpdatedCallback} callback Function that handles on speaker updated event response
         */
        addOnInteractionSpeakerUpdatedCallback: function (callback) {
            this._onSpeakerUpdated.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionVideoUpdatedCallback
         * @typedef {Object} InteractionVideoUpdatedEvent
         * @property {string} id Unique identifier for Interaction Media
         */
        /**
         * This callback handles the InteractionVideoUpdatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Interaction~onInteractionVideoUpdatedCallback
         * @param {InteractionVideoUpdatedEvent} message The event that is fired when interaction video has been updated
         */
        /**
         * Adds a callback that is executed when interaction context has been removed from an interaction
         * @public
         * @function AvayaCustomerServices.Services.Work.Interaction#addOnInteractionVideoUpdatedCallback
         * @param {AvayaCustomerServices.Services.Work.Interaction~onInteractionVideoUpdatedCallback} callback Function that handles on video updated event response
         */
        addOnInteractionVideoUpdatedCallback: function (callback) {
            this._onVideoUpdated.add(callback);
        }
    };

    _.defaults(Interaction.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Work.Interaction = Interaction;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Collection for managing an array of {@link Interaction} types.
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Constructor function for Interactions Collection
     *
     * @class
     * @define AvayaCustomerServices.Services.Work.InteractionCollection
     * @memberOf AvayaCustomerServices.Services.Work
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     * @param {AvayaCustomerServices.Services.Work.WorkService} workService
     */
    function InteractionCollection(workService) {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Services.Work.Interaction);
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.WorkService}
         */
        this._workService = workService;
    }

    InteractionCollection.prototype =
    /** @lends AvayaCustomerServices.Services.Work.InteractionCollection */
    {
        /**
         * @public
         * @override
         * @function AvayaCustomerServices.Services.Work.InteractionCollection#add
         * @param {Object} data - Data for populating new Interaction instance
         * @returns {AvayaCustomerServices.Services.Work.Interaction}
         */
        add: function (data) {
            var interaction = new this._model(this._workService);
            interaction.id = data.id;
            interaction.setData(data);
            this._collection.push(interaction);
            return interaction;
        }
    };

    _.defaults(InteractionCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Services.Work.InteractionCollection = InteractionCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Interaction Context API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Services.Work.InteractionContext
     * @memberOf AvayaCustomerServices.Services.Work
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Interaction Context Model
     */
    function InteractionContext() {
        AvayaCustomerServices.Base.Collections.Model.call(this);
    }

    InteractionContext.prototype =
    /** @lends AvayaCustomerServices.Services.Work.InteractionContext */
    {
        /**
         * Merge InteractionContext data
         *
         * @private
         * @function AvayaCustomerServices.Services.Work.InteractionContext#mergeData
         * @param {Object} data Data to merge
         * @returns {object} data
         */
        mergeData: function (data) {
            var self = this;
            _.forEach(data, function (contextType, key) {
                if (contextType && _.isArray(contextType) && _.has(self.data, key)) {
                    _.forEach(contextType, function (context) {
                        self.data[key].push(context);
                    });
                }
            });
            return self.data;
        },
        /**
         * Remove InteractionContext data
         *
         * @private
         * @function AvayaCustomerServices.Services.Work.InteractionContext#removeData
         * @param {Object} data Data to remove
         * @returns {object} data
         */
        removeData: function (data) {
            _.forEach(data, _.bind(function (prop, key) {
                if (prop && _.has(this.data, key) && _.isArray(this.data[key])) {
                    var model = _.find(this.data[key], prop);
                    var index = _.indexOf(this.data[key], model);
                    if (index !== -1) {
                        this.data[key].splice(index, 1);
                    }
                }
            }, this));
            return this.data;
        }
    };

    _.defaults(InteractionContext.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Work.InteractionContext = InteractionContext;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Interaction Media API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @define AvayaCustomerServices.Services.Work.InteractionMedia
     * @memberOf AvayaCustomerServices.Services.Work
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Interaction Media Model
     * @param {AvayaCustomerServices.Services.Work.WorkService} workService
     */
    function InteractionMedia(workService) {
        AvayaCustomerServices.Base.Collections.Model.call(this);
        /**
         * @type {AvayaCustomerServices.Services.Work.WorkService}
         * @private
         */
        this._workService = workService;
        /**
         * Unique identifier for Interaction
         *
         * @type {string}
         * @public
         */
        this.interactionId = undefined;
        /**
         * Array of participants involved in Interaction
         *
         * @type {object[]}
         * @public
         */
        this.participants = [];
        /**
         * Array of messages belonging to this Interaction Media
         *
         * @type {object[]}
         * @public
         */
        this.messages = [];
        /**
         * Array of notifications belonging to this Interaction Media
         *
         * @type {object[]}
         * @public
         */
        this.notifications = [];
        /**
         * Array of attachments belonging to this Interaction Media
         *
         * @type {object[]}
         * @public
         */
        this.attachments = [];
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onMessageAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onForwardSent = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onReplySent = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onMessagesAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onEmailFileLimitExceeded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onAttachmentAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onAttachmentRemoved = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onParticipantsListed = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onParticipantAdded = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onParticipantRemoved = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onIsTyping = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onPagePushUrl = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onFileTransferred = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onCustomerDownloadInitiated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onCustomerDownloadComplete = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onConnected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onDisconnected = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onLeft = new AvayaCustomerServices.Base.Callbacks();
    }

    InteractionMedia.prototype =
    /** @lends AvayaCustomerServices.Services.Work.InteractionMedia */
    {
        /**
         * Sends an interaction media message
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#send
         * @param {string} message Message data that is been sent
         * @param {string} sensitivity Sensitivity of message been sent
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        send: function (message, sensitivity) {
            return this._workService.sendMessage(this, message, sensitivity);
        },
        /**
         * Sends an interaction media whisper message
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#sendWhisper
         * @param {string} message Message data that is been sent
         * @param {string} sensitivity Sensitivity of message been sent
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendWhisper: function (message, sensitivity) {
            return this._workService.sendWhisperMessage(this, message, sensitivity);
        },
        /**
         * Sends an interaction rich media message
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#sendRichMedia
         * @param {string} media Media data that is been sent
         * @param {string} richMediaType Type of rich-media
         * @param {object} additionalRichMediaData Additional fields for rich-media messages
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendRichMedia: function (media, richMediaType, additionalRichMediaData) {
            return this._workService.sendRichMediaMessage(this, media, richMediaType, additionalRichMediaData);
        },
        /**
         * Sends an interaction media email message
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#sendEmail
         * @param {Object} data Email data
         * @param {string} data.subject Subject of email
         * @param {string} data.message Content of Email
         * @param {string[]} data.to Email address to send message to
         * @param {string} data.from Email address
         * @param {string[]} [data.cc] Optional list of cc recipients
         * @param {string[]} [data.bcc] Optional list of bcc recipients
         * @param {string} [data.type] Type of the email 
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendEmail: function (data) {
            return this._workService.sendEmailMessage(this, data);
        },
        /**
         * Sends an interaction media page push URL
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#sendPagePushUrl
         * @param {string} message Page push URL data to send
         * @param {string} sensitivity Sensitivity of message been sent
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendPagePushUrl: function (message, sensitivity) {
            return this._workService.sendPagePushUrl(this, message, sensitivity);
        },
        /**
         * Sends a CoBrowse session key
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#sendCoBrowseSessionKey
         * @param {string} key CoBrowse session key to send
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendCoBrowseSessionKey: function (key) {
            return this._workService.sendCoBrowseSessionKey(this, key);
        },
        /**
         * Sends an interaction media report typing message
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#reportTyping
         * @param {string} sensitivity Sensitivity of message been sent
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        reportTyping: function (sensitivity) {
            return this._workService.reportTyping(this, sensitivity);
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#setMessageImportance
         */
        setMessageImportance: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#setSensitivity
         */
        setSensitivity: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getFromParticipant
         */
        getFromParticipant: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getImportance
         */
        getImportance: function () {

        },
        /**
         * Get all the attachments belonging to this Interaction Media
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getAttachments
         * @returns {object[]} Array of Interaction Media Attachments
         */
        getAttachments: function () {
            return this.attachments;
        },
        /**
         * Get all the participants belonging to this Interaction Media
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getParticipants
         * @returns {object[]} Array of Interaction Media participants
         */
        getParticipants: function () {
            return this.participants;
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getBody
         */
        getBody: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getTranscript
         */
        getTranscript: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#getType
         */
        getType: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#markAsRead
         */
        markAsRead: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addAttachment
         */
        addAttachment: function () {

        },
        /**
         * @since 3.3.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#removeAttachments
         * @param {string} [attachmentId] ID of attachment to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeAttachments: function (attachmentId) {
            return this._workService.removeAttachments(this, attachmentId);
        },
        /**
         * @since 3.5.0.0
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#applyDraftAttachments
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyDraftAttachments: function () {
            return this._workService.applyDraftAttachments(this);
        },
        /**
         * @since 3.6.1.0
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#applyForwardAttachments
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyForwardAttachments: function () {
            return this._workService.applyForwardAttachments(this);
        },
        /**
         * @since 3.8.1.0
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#applyApprovalAttachments
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyApprovalAttachments: function () {
            return this._workService.applyApprovalAttachments(this);
        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#isRead
         * @returns {boolean}
         */
        isRead: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#isPrivate
         * @returns {boolean}
         */
        isPrivate: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#isDoNotForward
         * @returns {boolean}
         */
        isDoNotForward: function () {

        },
        /**
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#isFromMe
         * @returns {boolean}
         */
        isFromMe: function () {

        },
        /**
         * Set Agent data
         *
         * @private
         * @override
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#setData
         * @param {Object} data Data to set
         * @returns {object} Resultant Interaction Media data from merge
         */
        setData: function (data) {
            if (_.isUndefined(this.id) && !_.isUndefined(data[this._id])) {
                this.id = data[this._id];
            }
            _.assignSafe(this, {
                interactionId: data.interactionId,
                participants: data.participants,
                messages: data.messages,
                attachments: data.attachments
            });
            return _.assignIn(this.data, data);
        },
        /**
         * The event data that is passed back to onMessageReceivedCallback
         * @typedef {Object} InteractionMediaMessageCreatedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} message New message that has been added to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaMessageCreatedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onMessageReceivedCallback
         * @param {InteractionMediaMessageCreatedEvent} message The event that is fired when interaction media message has been created
         */
        /**
         * Adds a callback that is executed when interaction media message has been created
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addMessageReceivedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onMessageReceivedCallback} callback Function that handles on interaction media message added event response
         */
        addMessageReceivedCallback: function (callback) {
            this._onMessageAdded.add(callback);
        },
        /**
         * The event data that is passed back to onForwardSentCallback
         * @typedef {Object} InteractionMediaEmailForwardSentEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} message New message that has been added to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaEmailForwardSentEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onForwardSentCallback
         * @param {InteractionMediaEmailForwardSentEvent} message The event that is fired when forward email has been sent
         */
        /**
         * Adds a callback that is executed when forward email has been sent
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnForwardSentCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onForwardSentCallback} callback Function that handles on interaction media forward sent event response
         */
        addOnForwardSentCallback: function (callback) {
            this._onForwardSent.add(callback);
        },
        /**
         * The event data that is passed back to onReplySentCallback
         * @typedef {Object} InteractionMediaEmailReplySentEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} message New message that has been added to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaEmailReplySentEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onReplySentCallback
         * @param {InteractionMediaEmailReplySentEvent} message The event that is fired when reply email has been sent
         */
        /**
         * Adds a callback that is executed when reply email has been sent
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnReplySentCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onReplySentCallback} callback Function that handles on interaction media reply sent event response
         */
        addOnReplySentCallback: function (callback) {
            this._onReplySent.add(callback);
        },
        /**
         * The event data that is passed back to onMessagesReceivedCallback
         * @typedef {Object} InteractionMediaMessagesCreatedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} messages Customer history messages for async interactions
         */
        /**
         * This callback handles the InteractionMediaMessagesCreatedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onMessagesReceivedCallback
         * @param {InteractionMediaMessagesCreatedEvent} message The event that is fired when interaction media messages has been created
         */
        /**
         * Adds a callback that is executed when interaction media messages has been created
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnMessagesReceivedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onMessagesReceivedCallback} callback Function that handles on interaction media messages added event response
         */
        addOnMessagesReceivedCallback: function (callback) {
            this._onMessagesAdded.add(callback);
        },
        /**
         * The event data that is passed back to onEmailFileLimitExceededCallback 
         * @typedef {Object} InteractionMediaEmailFileLimitExceededEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} message New message that has been added to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaEmailFileLimitExceededEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onEmailFileLimitExceededCallback
         * @param {InteractionMediaEmailFileLimitExceededEvent} message The event that is fired when email's size limit has been exceeded
         */
        /**
         * Adds a callback that is executed when email's file size limit has been exceeded
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnEmailFileLimitExceededCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onEmailFileLimitExceededCallback} callback Function that handles on interaction media email file limit exceeded event response
         */
        addOnEmailFileLimitExceededCallback: function (callback) {
            this._onEmailFileLimitExceeded.add(callback);
        },
        /**
         * The event data that is passed back to onAttachmentAddedCallback
         * @typedef {Object} InteractionMediaAttachmentsEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} attachments New attachments that has been added to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaAttachmentsEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onAttachmentAddedCallback
         * @param {InteractionMediaAttachmentsEvent} message The event that is fired when interaction media attachment has been added
         */
        /**
         * Adds a callback that is executed when interaction media attachment has been added
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnAttachmentAddedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onAttachmentAddedCallback} callback Function that handles on interaction media attachment added event response
         */
        addOnAttachmentAddedCallback: function (callback) {
            this._onAttachmentAdded.add(callback);
        },
        /**
         * The event data that is passed back to onAttachmentRemovedCallback
         * @typedef {Object} InteractionMediaAttachmentsEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} attachments New attachments that has been removed to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaAttachmentEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onAttachmentRemovedCallback
         * @param {InteractionMediaAttachmentsEvent} message The event that is fired when interaction media attachment has been removed
         */
        /**
         * Adds a callback that is executed when interaction media attachment has been removed
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnAttachmentRemovedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onAttachmentRemovedCallback} callback Function that handles on interaction media attachment removed event response
         */
        addOnAttachmentRemovedCallback: function (callback) {
            this._onAttachmentRemoved.add(callback);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnDoNotForwardStatusChangedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~addOnDoNotForwardStatusChangedCallback} callback
         */
        addOnDoNotForwardStatusChangedCallback: function (callback) {

        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnHasAttachementStatusChangedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~addOnHasAttachmentStatusChangedCallback} callback
         */
        addOnHasAttachmentStatusChangedCallback: function (callback) {

        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnImportanceChangedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~addOnImportanceChangedCallback} callback
         */
        addOnImportanceChangedCallback: function (callback) {

        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnIsReadStatusChangedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~addOnIsReadStatusChangedCallback} callback
         */
        addOnIsReadStatusChangedCallback: function (callback) {

        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnSensitivityChangedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~addOnSensitivityChangedCallback} callback
         */
        addOnSensitivityChangedCallback: function (callback) {

        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnTypeChangedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~addOnTypeChangedCallback} callback
         */
        addOnTypeChangedCallback: function (callback) {

        },
        /**
         * The event data that is passed back to onParticipantsListedCallback
         * @typedef {Object} InteractionMediaParticipantsListedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object[]} participants Array of participants belonging to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaParticipantsListedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onParticipantsListedCallback
         * @param {InteractionMediaParticipantJoinedEvent} message The event that is fired when participants are retrieved from server
         */
        /**
         * Adds a callback that is executed when participants are retrieved from server
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnParticipantsListedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onParticipantsListedCallback} callback Function that handles on interaction media participants listed event response
         */
        addOnParticipantsListedCallback: function (callback) {
            this._onParticipantsListed.add(callback);
        },
        /**
         * The event data that is passed back to onParticipantAddedCallback
         * @typedef {Object} InteractionMediaParticipantJoinedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} participant New participant that has been added to Interaction Media
         * @property {Object[]} participants Array of participants belonging to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaParticipantJoinedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onParticipantAddedCallback
         * @param {InteractionMediaParticipantJoinedEvent} message The event that is fired when participant has joined interaction media
         */
        /**
         * Adds a callback that is executed when participant has joined interaction media
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnParticipantAddedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onParticipantAddedCallback} callback Function that handles on interaction media participant added event response
         */
        addOnParticipantAddedCallback: function (callback) {
            this._onParticipantAdded.add(callback);
        },
        /**
         * The event data that is passed back to onParticipantRemovedCallback
         * @typedef {Object} InteractionMediaParticipantLeftEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} participant New participant that has been removed from Interaction Media
         * @property {Object[]} participants Array of participants belonging to Interaction Media
         */
        /**
         * This callback handles the InteractionMediaParticipantLeftEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onParticipantRemovedCallback
         * @param {InteractionMediaParticipantLeftEvent} message The event that is fired when participant has left interaction media
         */
        /**
         * Adds a callback that is executed when participant has left interaction media
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnParticipantRemovedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onParticipantRemovedCallback} callback Function that handles on interaction media participant removed event response
         */
        addOnParticipantRemovedCallback: function (callback) {
            this._onParticipantRemoved.add(callback);
        },
        /**
         * The event data that is passed back to onIsTypingCallback
         * @typedef {Object} InteractionMediaMessageIsTypingEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} participant The participant who initiated the is typing notification
         * @property {string} type The media event type
         */
        /**
         * This callback handles the InteractionMediaMessageIsTypingEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onIsTypingCallback
         * @param {InteractionMediaMessageIsTypingEvent} message The event that is fired when participant begins to type a new message
         */
        /**
         * Adds a callback that is executed when participant begins to type a new message
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addIsTypingCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onIsTypingCallback} callback Function that handles on interaction media is typing event response
         */
        addOnIsTypingCallback: function (callback) {
            this._onIsTyping.add(callback);
        },
        /**
         * The event data that is passed back to onPagePushUrlCallback
         * @typedef {Object} InteractionMediaPagePushUrlEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} message Contains page push URL data
         */
        /**
         * This callback handles the InteractionMediaPagePushUrlEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onPagePushUrlCallback
         * @param {InteractionMediaPagePushUrlEvent} message The event that is fired when interaction media page push URL has been created
         */
        /**
         * Adds a callback that is executed when interaction media page push URL has been created
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnPagePushUrlCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onPagePushUrlCallback} callback Function that handles on interaction media page push URL event response
         */
        addOnPagePushUrlCallback: function (callback) {
            this._onPagePushUrl.add(callback);
        },
        /**
         * The event data that is passed back to onFileTransferredCallback
         * @typedef {Object} InteractionMediaTransferredFileEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object[]} attachments Array of uploaded files details
         * @property {Object} receivedFrom Details of who uploaded the file
         * @property {string} arrivalDate Timestamp of when file upload completed
         * @property {Object} message The full payload of the Transferred File Event
         */
        /**
         * This callback handles the InteractionMediaTransferredFileEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onFileTransferredCallback
         * @param {InteractionMediaTransferredFileEvent} message The event that is fired when a file has been uploaded for transfer
         */
        /**
         * Adds a callback that is executed when a file has been uploaded for transfer
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnFileTransferredCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onFileTransferredCallback} callback Function that handles on interaction media file transferred event response
         */
        addOnFileTransferredCallback: function (callback) {
            this._onFileTransferred.add(callback);
        },
        /**
         * The event data that is passed back to onCustomerDownloadInitiatedCallback
         * @typedef {Object} InteractionMediaCustomerDownloadInitiatedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {string} attachment File attachment that has been initiated for transfer (download)
         * @property {Object} receivedFrom Details of who initiated the file download
         * @property {string} arrivalDate Timestamp of when file download was initiated
         * @property {Object} message The full payload of the Customer Download Initiated Event
         */
        /**
         * This callback handles the InteractionMediaCustomerDownloadInitiatedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onCustomerDownloadInitiatedCallback
         * @param {InteractionMediaCustomerDownloadInitiatedEvent} message The event that is fired when a a customer initiates a file transfer (download)
         */
        /**
         * Adds a callback that is executed when a customer initiates a file transfer (download)
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnCustomerDownloadInitiatedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onCustomerDownloadInitiatedCallback} callback Function that handles on interaction media customer download initiated event response
         */
        addOnCustomerDownloadInitiatedCallback: function (callback) {
            this._onCustomerDownloadInitiated.add(callback);
        },
        /**
         * The event data that is passed back to onCustomerDownloadCompleteCallback
         * @typedef {Object} InteractionMediaCustomerDownloadCompleteEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {string} attachment File attachment that has completed downloading
         * @property {Object} receivedFrom Details of who downloaded the file download
         * @property {string} arrivalDate Timestamp of when file download was completed
         * @property {Object} message The full payload of the Customer Download Completed Event
         */
        /**
         * This callback handles the InteractionMediaCustomerDownloadCompleteEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onCustomerDownloadCompleteCallback
         * @param {InteractionMediaCustomerDownloadCompleteEvent} message The event that is fired when a a customer completes a file transfer (download)
         */
        /**
         * Adds a callback that is executed when a customer completes a file transfer (download)
         * @since 3.2.2
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnCustomerDownloadCompleteCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onCustomerDownloadCompleteCallback} callback Function that handles on interaction media customer download complete event response
         */
        addOnCustomerDownloadCompleteCallback: function (callback) {
            this._onCustomerDownloadComplete.add(callback);
        },
        /**
         * The event data that is passed back to onLeftCallback
         * @typedef {Object} InteractionMediaLeftEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} participant The participant who has left chat
         * @property {string} type The media event type
         */
        /**
         * This callback handles the InteractionMediaLeftEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onLeftCallback
         * @param {InteractionMediaLeftEvent} message The event that is fired when interaction media has been left
         */
        /**
         * Adds a callback that is executed when interaction media has been left
         * @since 3.8.1.1
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnLeftCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onLeftCallback} callback Function that handles on interaction media left event response
         */
         addOnLeftCallback: function (callback) {
            this._onLeft.add(callback);
        },
        /**
         * The event data that is passed back to onConnectedCallback
         * @typedef {Object} InteractionMediaConnectedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} participant The participant who has connected
         * @property {string} type The media event type
         */
        /**
         * This callback handles the InteractionMediaConnectedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onConnectedCallback
         * @param {InteractionMediaConnectedEvent} message The event that is fired when interaction media has been (re)connected
         */
        /**
         * Adds a callback that is executed when interaction media has been (re)connected
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnConnectedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onConnectedCallback} callback Function that handles on interaction media connected event response
         */
        addOnConnectedCallback: function (callback) {
            this._onConnected.add(callback);
        },
        /**
         * The event data that is passed back to onDisconnectedCallback
         * @typedef {Object} InteractionMediaDisconnectedEvent
         * @property {string} id Unique identifier for Interaction Media
         * @property {Object} participant The participant who has disconnected
         * @property {string} type The media event type
         */
        /**
         * This callback handles the InteractionMediaDisconnectedEvent response
         * @callback AvayaCustomerServices.Services.Work.InteractionMedia~onDisconnectedCallback
         * @param {InteractionMediaDisconnectedEvent} message The event that is fired when interaction media has been disconnected
         */
        /**
         * Adds a callback that is executed when interaction media has been disconnected
         * @public
         * @function AvayaCustomerServices.Services.Work.InteractionMedia#addOnDisconnectedCallback
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia~onDisconnectedCallback} callback Function that handles on interaction media disconnected event response
         */
        addOnDisconnectedCallback: function (callback) {
            this._onDisconnected.add(callback);
        }
    };

    _.defaults(InteractionMedia.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Work.InteractionMedia = InteractionMedia;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Work API
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Work
     * @define AvayaCustomerServices.Services.Work.Work
     *
     * @description Constructor function for Work API
     * @param {AvayaCustomerServices.Services.Work.WorkService} workService
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     */
    function Work(workService, workRequestCollection, interactionCollection) {
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.WorkService}
         */
        this._workService = workService;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.WorkRequestCollection}
         */
        this._workRequestCollection = workRequestCollection;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.InteractionCollection}
         */
        this._interactionCollection = interactionCollection;
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onCreated = new AvayaCustomerServices.Base.Callbacks();
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Callbacks}
         */
        this._onDeleted = new AvayaCustomerServices.Base.Callbacks();
    }

    Work.prototype =
    /** @lends AvayaCustomerServices.Services.Work.Work */
    {
        /**
         * Creates a new outgoing interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#createInteraction
         * @param {string} type Channel type of interaction
         * @param {string} [address] Destination address of interaction
         * @param {string} [subType] Additional param to indicate interaction specifics (e.g. voice mailbox)
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        createInteraction: function (type, address, subType) {
            return this._workService.start(type, address, subType);
        },
        /**
         * Retrieves a deferred interaction
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#retrieveDeferredInteraction
         * @param {object} deferredInteraction Deferred Interaction to retrieve
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        retrieveDeferredInteraction: function (deferredInteraction) {
            return this._workService.retrieveDeferredInteraction(deferredInteraction);
        },
        /**
         * Removes a deferred interaction from deferred list on retrieve confirmation
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#removeDeferredInteraction
         * @param {object} deferredInteraction Deferred Interaction to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeDeferredInteraction: function (deferredInteraction) {
            return this._workService.removeDeferredInteraction(deferredInteraction);
        },
        /**
         * Gets the current number of interactions.
         *
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#getInteractionCount
         * @returns {Number}
         */
        getInteractionCount: function () {
            //
        },
        /**
         * Is there an active interaction in progress?
         *
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#hasActiveInteraction
         * @returns {Boolean}
         */
        hasActiveInteraction: function () {
            //
        },
        /**
         * Is there an active local interaction in progress
         *
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#hasActiveLocalInteraction
         * @returns {Boolean}
         */
        hasActiveLocalInteraction: function () {
            //
        },
        /**
         * Is there an active interaction in held state
         *
         * @ignore
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#hasHeldInteraction
         * @returns {Boolean}
         */
        hasHeldInteraction: function () {
            //
        },
        /**
         * Is there a interaction being initiated.
         *
         * @public
         * @ignore
         * @function AvayaCustomerServices.Services.Work.Work#hasInitiatingInteraction
         * @returns {Boolean}
         */
        hasInitiatingInteraction: function () {
            //
        },
        /**
         *
         * @public
         * @ignore
         * @function AvayaCustomerServices.Services.Work.Work#isAutoAnswerAdministered
         * @returns {Boolean}
         */
        isAutoAnswerAdministered: function () {
            //
        },
        /**
         * Returns a collection of work requests
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#getWorkRequests
         * @returns {AvayaCustomerServices.Services.Work.WorkRequestCollection}
         */
        getWorkRequests: function () {
            return this._workRequestCollection;
        },
        /**
         * Returns a collection of interactions
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#getInteractions
         * @returns {AvayaCustomerServices.Services.Work.InteractionCollection}
         */
        getInteractions: function () {
            return this._interactionCollection;
        },
        /**
         * The event data that is passed back to onInteractionCreatedCallback
         * @typedef {Object} InteractionCreatedEvent
         * @property {string} id Unique identifier for Interaction
         * @property {string} contactId Contact ID for Interaction
         * @property {string} channel Resource channel type of Interaction
         * @property {string} state Current state of Interaction
         * @property {object} capabilities Contains list of interaction capabilities
         * @property {string} workRequestId Work Request ID
         * @property {string} originatingAddress Source address of Interaction
         * @property {string} destinationAddress Destination address of Interaction
         * @property {string} direction Is the call INCOMING or OUTGOING?
         * @property {boolean} isCustomerInteraction Flag to indicate if interaction originated from customer
         * @property {string} workCode Work Code for Interaction
         * @property {string} dispositionCode Disposition Code for Interaction
         * @property {Object[]} participants Array of participant involved in Interaction
         * @property {string} userToUserInfo Interaction data passed from one agent to another
         * @property {boolean} isWebRtcCall Flag to indicate if interaction is a WebRTC call
         * @property {boolean} isACWEnabled Flag to indicate if ACW is enabled
         * @property {boolean} isACWExtended Flag to indicate if Interaction is in ACW extended state
         * @property {boolean} isAutoAnswerEnabled Flag to indicate if Auto Answer is enabled for this Interaction
         * @property {boolean} isNailUpCall Flag to indicate if interaction is a Nailup outbound call
         * @property {Date} autoAnswerTimerExpireDT Datetime of when Auto Answer Timer expires
         * @property {string} topic Interaction topic
         * @property {string} topicId Interaction topic ID
         * @property {string} establishedTime Timestamp of when Interaction was established
         * @property {string} stateChangeTime Timestamp of when Interaction last changed state
         * @property {string} acwEstablishedTime Timestamp of when Interaction initiated ACW
         * @property {string} acwDuration Duration of ACW countdown
         * @property {string} externalInteractionId External Provider's Interaction ID
         * @property {string} interactionType Details of Interaction context
         * @property {string} stateReason Reason for Interaction going into a particular state
         * @property {boolean} isObserved Flag that indicates if interaction is being observed by supervisor
         * @property {boolean} isTransferredToService Flag that indicates if interaction has being transferred to service
         * @property {string} skill Skill associated with Interaction
         * @property {string} skillId Skill ID associated with Interaction
         */
        /**
         * This callback handles the InteractionCreatedEvent response
         * @callback AvayaCustomerServices.Services.Work.Work~onInteractionCreatedCallback
         * @param {InteractionCreatedEvent} message The event that is fired when an interaction has been created
         */
        /**
         * Adds a callback that is executed when an interaction has been created
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#addOnInteractionCreatedCallback
         * @param {AvayaCustomerServices.Services.Work.Work~onInteractionCreatedCallback} callback Function that handles on interaction created event response
         */
        addOnInteractionCreatedCallback: function (callback) {
            this._onCreated.add(callback);
        },
        /**
         * The event data that is passed back to onInteractionDeletedCallback
         * @typedef {Object} InteractionDeleteEvent
         * @property {string} id Unique identifier for Interaction
         */
        /**
         * This callback handles the InteractionDeleteEvent response
         * @callback AvayaCustomerServices.Services.Work.Work~onInteractionDeletedCallback
         * @param {InteractionDeleteEvent} message The event that is fired when an interaction has been removed
         */
        /**
         * Adds a callback that is executed when an interaction has been removed
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#addOnInteractionDeletedCallback
         * @param {AvayaCustomerServices.Services.Work.Work~onInteractionDeletedCallback} callback Function that handles on interaction delete event response
         */
        addOnInteractionDeletedCallback: function (callback) {
            this._onDeleted.add(callback);
        },
        /**
         * Remove callbacks and stop work service
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.Work#removeCallbacks
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeCallbacks: function () {
            this._onCreated.empty();
            this._onDeleted.empty();
            return this._workService.stop();
        }
    };

    AvayaCustomerServices.Services.Work.Work = Work;

})(AvayaCustomerServices);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Work Request API model
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * Constructor function for WorkRequest Model
     *
     * @class
     * @memberOf AvayaCustomerServices.Services.Work
     * @define AvayaCustomerServices.Services.Work.WorkRequest
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Work Request Model
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {{idAttribute}} options WorkRequest Model options
     */
    function WorkRequest(interactionCollection, options) {
        AvayaCustomerServices.Base.Collections.Model.call(this, options);
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.InteractionCollection}
         */
        this._interactionCollection = interactionCollection;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.WorkRequestContext}
         */
        this._workRequestContext = new AvayaCustomerServices.Services.Work.WorkRequestContext();
        /**
         * Array of interactions belonging to this Work Request
         *
         * @public
         * @type {AvayaCustomerServices.Services.Work.Interaction[]}
         */
        this.interactions = [];
    }

    WorkRequest.prototype =
    /** @lends AvayaCustomerServices.Services.Work.WorkRequest */
    {
        /**
         * Find all interactions attached to this WorkRequest Object
         *
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkRequest#getInteractions
         * @returns {AvayaCustomerServices.Services.Work.Interaction[]}
         */
        getInteractions: function () {
            return this._interactionCollection.findAll({data: {workRequestId: this.id}});
        },
        /**
         * Set Work Request model data
         *
         * @private
         * @override
         * @function AvayaCustomerServices.Services.Work.WorkRequest#setData
         * @param {Object} data Data to set
         * @returns {object} The resultant work request data from merge
         */
        setData: function (data) {
            if (_.isUndefined(this.id) && !_.isUndefined(data[this._id])) {
                this.id = data[this._id];
            }
            this.isNew = _.isEmpty(this.data);
            this.interactions = this.getInteractions();
            return _.assignIn(this.data, data);
        }
    };

    _.defaults(WorkRequest.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Services.Work.WorkRequest = WorkRequest;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Collection for managing an array of {@link WorkRequest} types.
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Constructor function for Work Request Collection
     *
     * @class
     * @define AvayaCustomerServices.Services.Work.WorkRequestCollection
     * @memberOf AvayaCustomerServices.Services.Work
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     */
    function WorkRequestCollection(interactionCollection) {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Services.Work.WorkRequest, {idAttribute: 'workRequestId'});
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Work.InteractionCollection}
         */
        this._interactionCollection = interactionCollection;
    }

    WorkRequestCollection.prototype =
    /** @lends AvayaCustomerServices.Services.Work.WorkRequestCollection */
    {
        /**
         * Create new WorkRequest instance and populate with param data
         *
         * @public
         * @override
         * @function AvayaCustomerServices.Services.Work.WorkRequestCollection#add
         * @param {Object} data - Data for populating new WorkRequest instance
         * @returns {AvayaCustomerServices.Services.Work.WorkRequest}
         */
        add: function (data) {
            var workRequest = this.find({id: data[this._modelId]});
            if (!workRequest) {
                workRequest = new this._model(this._interactionCollection, this._modelOptions);
                workRequest.setData(data);
                this._collection.push(workRequest);
            }
            return workRequest;
        },
        /**
         * Remove Model matching param data
         *
         * @public
         * @override
         * @function AvayaCustomerServices.Services.Work.WorkRequestCollection#remove
         * @param {Object} data Criteria used to find WorkRequest
         * @returns {AvayaCustomerServices.Services.Work.WorkRequest}
         */
        remove: function (data) {
            var index = this.findIndex({id: data[this._modelId]});
            if (index === -1) {
                throw new Error('Could not find Work Request Model with id: ' + data[this._modelId]);
            }

            // Only remove work request model if it has no interactions
            var workRequest = this._collection[index];
            if (_.size(workRequest.getInteractions()) === 0) {
                this._collection.splice(index, 1);
            }
            return workRequest;
        }
    };

    _.defaults(WorkRequestCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Services.Work.WorkRequestCollection = WorkRequestCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @classdesc Defines Work Request Context API model
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Work
     * @define AvayaCustomerServices.Services.Work.WorkRequestContext
     */
    function WorkRequestContext() {
    }

    WorkRequestContext.prototype =
    /** @lends AvayaCustomerServices.Services.Work.WorkRequestContext */
    {};

    AvayaCustomerServices.Services.Work.WorkRequestContext = WorkRequestContext;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Work Service
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @memberOf AvayaCustomerServices.Services.Work
     * @define AvayaCustomerServices.Services.Work.WorkService
     * @param {AvayaCustomerServices.Providers.UAC.Provider} interactionsProvider
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     */
    function WorkService(interactionsProvider, agent) {
        /**
         * @private
         * @type {boolean}
         */
        this._started = false;
        /**
         * @private
         * @type {AvayaCustomerServices.Providers.UAC.Provider}
         */
        this._interactionsProvider = interactionsProvider;
        /**
         * @private
         * @type {AvayaCustomerServices.Services.Agent.Agent}
         */
        this._agent = agent;
        /**
         * @private
         * @type {string[]}
         */
        this._callUcidList = [];
    }

    WorkService.prototype =
    /** @lends AvayaCustomerServices.Services.Interaction.WorkService */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#init
         * @param {AvayaCustomerServices.Services.Work.Work} work
         * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
         * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        init: function (work, workRequestCollection, interactionCollection) {
            this._started = true;

            this._interactionsProvider.on('interaction.created', _.bind(onInteractionCreated, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.active', _.bind(onInteractionActive, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.held', _.bind(onInteractionHeld, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.acw', _.bind(onInteractionACW, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.acw_pending', _.bind(onInteractionACWPending, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.passive', _.bind(onInteractionPassive, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.updated', _.bind(onInteractionUpdated, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.deleted', _.bind(onInteractionDeleted, null, work, workRequestCollection, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.unknown', _.bind(onInteractionUnknown, null, work, workRequestCollection, interactionCollection, this._agent));

            this._interactionsProvider.on('interaction.destination_participant_accepted', _.bind(onRemoteParticipantAccepted, null, interactionCollection, this._agent));

            this._interactionsProvider.on('interaction_media.created', _.bind(onInteractionMediaCreated, null, this, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.message.created', _.bind(onInteractionMediaMessageCreated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.message.is_typing', _.bind(onInteractionMediaMessageIsTyping, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.messages', _.bind(onInteractionMediaMessages, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.participant.joined', _.bind(onInteractionMediaParticipantJoined, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.participant.left', _.bind(onInteractionMediaParticipantLeft, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.participant.list', _.bind(onInteractionMediaParticipantList, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.page_push', _.bind(onInteractionMediaPagePush, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.email_message', _.bind(onInteractionMediaEmailMessage, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.forward_sent', _.bind(onInteractionMediaForwardSent, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.reply_sent', _.bind(onInteractionMediaReplySent, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.email_file_limit_exceeded', _.bind(onInteractionMediaEmailFileLimitExceeded, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.email_attachments_added', _.bind(onInteractionMediaEmailAttachmentsAdded, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.email_attachments_removed', _.bind(onInteractionMediaEmailAttachmentsRemoved, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.message.transferred_file', _.bind(onInteractionMediaTransferredFile, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.message.customer_download_initiated', _.bind(onInteractionMediaCustomerDownloadInitiated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.message.customer_download_complete', _.bind(onInteractionMediaCustomerDownloadComplete, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.connected', _.bind(onInteractionMediaConnected, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.disconnected', _.bind(onInteractionMediaDisconnected, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_media.left', _.bind(onInteractionMediaLeft, null, interactionCollection, this._agent));

            this._interactionsProvider.on('interaction_context.created', _.bind(onInteractionContextCreated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_context.updated', _.bind(onInteractionContextUpdated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction_context.deleted', _.bind(onInteractionContextDeleted, null, interactionCollection, this._agent));

            this._interactionsProvider.on('interaction.audio_updated', _.bind(onInteractionAudioUpdated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.speaker_updated', _.bind(onInteractionSpeakerUpdated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.video_updated', _.bind(onInteractionVideoUpdated, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.answer.requested', _.bind(onInteractionAnswerRequested, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.add_video.request', _.bind(onInteractionIncomingVideoAddRequest, null, interactionCollection, this._agent));
            this._interactionsProvider.on('interaction.error', _.bind(onInteractionError, null, this._interactionsProvider, interactionCollection, this._agent));

            this._interactionsProvider.on('webtrc_call.created', _.bind(onWebrtcCallCreated, null, this._callUcidList));
        },
        /**
         * Stops the interactions service
         *
         * @public
         */
        stop: function () {
            this._started = false;
            this._interactionsProvider.removeListeners('interaction');
            this._interactionsProvider.removeListeners('interaction_media');
            this._interactionsProvider.removeListeners('interaction_context');
        },
        /**
         * @public
         * @function
         * @param {string} type Channel type of interaction
         * @param {string} [address] Destination address of interaction
         * @param {string} [subType] Additional param to indicate interaction specifics (e.g. voice mailbox)
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        start: function (type, address, subType) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.initiate(handle, type, address, subType);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        end: function (interaction, options) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.end(handle, interaction, options);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        reject: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.reject(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} interval Interval to defer interaction for
         * @param {string} reason Defer reason
         * @param {object} payload Payload for defer
         * @param {object} [options] Options for defer
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        defer: function (interaction, interval, reason, payload, options) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.defer(handle, interaction, interval, reason, payload, options);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} interval Interval to defer forward interaction for
         * @param {string} reason Defer forward reason
         * @param {object} payload Payload for defer forward
         * @param {object} [options] Options for defer forward
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deferForward: function (interaction, interval, reason, payload, options) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.deferForward(handle, interaction, interval, reason, payload, options);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        hold: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.hold(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        unhold: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.unhold(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        accept: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.accept(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} address
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transfer: function (interaction, address) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.transfer(handle, interaction, address);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} serviceId
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transferToService: function (interaction, serviceId) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.transferToService(handle, interaction, serviceId);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} userId
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transferToUser: function (interaction, userId) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.transferToUser(handle, interaction, userId);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} serviceId
         * @param {string} [uui]
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultToService: function (interaction, serviceId, uui) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.consultToService(handle, interaction, serviceId, uui);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} userId
         * @param {string} [uui]
         * @returns {AvayaCustomerServices.Base.Promise}
         */
         consultToUser: function (interaction, userId, uui) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.consultToUser(handle, interaction, userId, uui);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getServices: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.getServices(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} searchText
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getUsers: function (interaction, searchText) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.getUsers(handle, interaction, searchText);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#getCall
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise|undefined}
         */
        getCall: function (interaction) {
            var call;
            if (_.isFunction(this._interactionsProvider.getCall)) {
                call = this._interactionsProvider.getCall(interaction);
            }
            return call;
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} deferredInteraction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        retrieveDeferredInteraction: function (deferredInteraction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.retrieveDeferredInteraction(handle, deferredInteraction.id);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeDeferredInteraction: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.removeDeferredInteraction(handle, interaction.workRequestId, interaction.id);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} address
         * @param {string} [uui]
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consult: function (interaction, address, uui) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.consult(handle, interaction, address, uui);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultCompleteAsTransfer: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.consultCompleteAsTransfer(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultCompleteAsConference: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.consultCompleteAsConference(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        extendACW: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.extendACW(handle, interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        completeACW: function (interaction) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.completeACW(handle, interaction);
        },
        /**
         * @public
         * @function
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendMessage: function (interactionMedia, message, sensitivity) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = JSON.stringify({
                subject: '',
                body: message,
                importance: interactionMedia.getImportance(),
                interactionMediaId: interactionMedia.id,
                eventType: 'MESSAGE',
                sensitivity: sensitivity
            });
            return this._interactionsProvider.sendMessage(handle, workRequestId, interactionId, channel, payload);
        },
        /**
         * @public
         * @function
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendWhisperMessage: function (interactionMedia, message, sensitivity) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = JSON.stringify({
                subject: '',
                body: message,
                importance: interactionMedia.getImportance(),
                interactionMediaId: interactionMedia.id,
                eventType: 'WHISPER',
                sensitivity: sensitivity
            });
            return this._interactionsProvider.sendMessage(handle, workRequestId, interactionId, channel, payload);
        },
        /**
         * @public
         * @function
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendRichMediaMessage: function (interactionMedia, media, richMediaType, additionalRichMediaData) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = {
                body: media,
                eventType: 'RICHMEDIA',
                interactionMediaId: interactionMedia.id,
                subject: '',
                richMediaType: richMediaType
            };

            payload = JSON.stringify(_.assignIn(payload, additionalRichMediaData));
            return this._interactionsProvider.sendMessage(handle, workRequestId, interactionId, channel, payload);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#sendEmailMessage
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @param {Object} data Email data
         * @param {string} data.subject Subject of email
         * @param {string} data.message Content of Email
         * @param {string[]} data.to Email address to send message to
         * @param {string} data.from Email address
         * @param {string[]} [data.cc] Optional list of cc recipients
         * @param {string[]} [data.bcc] Optional list of bcc recipients
         * @param {string} [data.type] Type of the email
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendEmailMessage: function (interactionMedia, data) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = JSON.stringify({
                subject: data.subject,
                body: data.message,
                to: data.to,
                from: data.from,
                cc: data.cc || [],
                bcc: data.bcc || [],
                importance: interactionMedia.getImportance(),
                interactionMediaId: interactionMedia.id
            });

            if (data.rejectedCode) {
                return this._interactionsProvider.rejectEmailMessage(handle, workRequestId, interactionId, channel, payload, data.rejectedCode);
            } else {
                return this._interactionsProvider.sendEmailMessage(handle, workRequestId, interactionId, channel, payload, data.type);
            }
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @param {string} sensitivity Report Typing sensitivity
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        reportTyping: function (interactionMedia, sensitivity) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = JSON.stringify({
                subject: '',
                body: '',
                importance: interactionMedia.getImportance(),
                interactionMediaId: interactionMedia.id,
                eventType: 'IS_TYPING',
                sensitivity: sensitivity
            });
            return this._interactionsProvider.sendMessage(handle, workRequestId, interactionId, channel, payload);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @param {string} pagePushUrl Page Push URL
         * @param {string} sensitivity Page Push sensitivity
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendPagePushUrl: function (interactionMedia, pagePushUrl, sensitivity) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = JSON.stringify({
                subject: '',
                body: pagePushUrl,
                importance: interactionMedia.getImportance(),
                interactionMediaId: interactionMedia.id,
                eventType: 'PAGE_PUSH',
                sensitivity: sensitivity
            });
            return this._interactionsProvider.sendMessage(handle, workRequestId, interactionId, channel, payload);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @param {string} coBrowseSessionKey CoBrowse Session Key
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendCoBrowseSessionKey: function (interactionMedia, coBrowseSessionKey) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            var channel = interactionMedia.data.channel;
            var payload = JSON.stringify({
                subject: '',
                body: coBrowseSessionKey,
                importance: interactionMedia.getImportance(),
                interactionMediaId: interactionMedia.id,
                eventType: 'COBROWSE_SESSION_KEY'
            });
            return this._interactionsProvider.sendMessage(handle, workRequestId, interactionId, channel, payload);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} workCode
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setWorkCode: function (interaction, workCode) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.setWorkCode(handle, interaction, workCode);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} dispositionCode
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setDispositionCode: function (interaction, dispositionCode) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.setDispositionCode(handle, interaction, dispositionCode);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#sendDTMF
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} dtmf DTMF character
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendDTMF: function (interaction, dtmf) {
            var handle = this._agent.getHandle();
            return this._interactionsProvider.sendDTMF(handle, interaction, dtmf);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#removeAttachments
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @param {string} [attachmentId] ID of attachment to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeAttachments: function (interactionMedia, attachmentId) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            return this._interactionsProvider.removeAttachments(handle, workRequestId, interactionId, attachmentId);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#applyDraftAttachments
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyDraftAttachments: function (interactionMedia) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            return this._interactionsProvider.applyDraftAttachments(handle, workRequestId, interactionId);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#applyForwardAttachments
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyForwardAttachments: function (interactionMedia) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            return this._interactionsProvider.applyForwardAttachments(handle, workRequestId, interactionId);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Services.Work.WorkService#applyApprovalAttachments
         * @param {AvayaCustomerServices.Services.Work.InteractionMedia} interactionMedia
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyApprovalAttachments: function (interactionMedia) {
            var handle = this._agent.getHandle();
            var workRequestId = interactionMedia.data.workRequestId;
            var interactionId = interactionMedia.data.interactionId;
            return this._interactionsProvider.applyApprovalAttachments(handle, workRequestId, interactionId);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        muteAudio: function (interaction) {
            return this._interactionsProvider.muteAudio(interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        unmuteAudio: function (interaction) {
            return this._interactionsProvider.unmuteAudio(interaction);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} mode Video mode to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setVideoMode: function (interaction, mode) {
            return this._interactionsProvider.setVideoMode(interaction, mode);
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        enableLocalVideo: function (interaction) {
            return this.setVideoMode(interaction, 'SEND_RECEIVE');
        },
        /**
         * @public
         * @function
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        disableLocalVideo: function (interaction) {
            return this.setVideoMode(interaction, 'RECEIVE_ONLY');
        }
    };

    /**
     * @private
     * @function onInteractionCreated
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionCreated(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionCreated',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionActive
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionActive(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }
        interaction._onActive.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionActive',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionUnknown
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionUnknown(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        interaction._onUnknown.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionUnknown',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionHeld
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionHeld(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }
        interaction._onHeld.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionHeld',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionACW
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionACW(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }
        interaction._onACW.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionACW',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionACWPending
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionACWPending(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }
        interaction._onACWPending.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionACWPending',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionPassive
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionPassive(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }
        interaction._onPassive.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionPassive',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionUpdated
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionUpdated(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.edit(message);
        if (interaction.isNew) {
            workRequestCollection.add(message);
            work._onCreated.fire(message);
        }
        interaction._onUpdated.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionUpdated',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionDeleted
     * @param {AvayaCustomerServices.Services.Work.Work} work
     * @param {AvayaCustomerServices.Services.Work.WorkRequestCollection} workRequestCollection
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionDeleted(work, workRequestCollection, interactionCollection, agent, message) {
        var interaction = interactionCollection.remove(message);
        if (!interaction) {
            throw new Error('Could not find Interaction with ID: ' + message.id);
        }
        workRequestCollection.remove({ workRequestId: interaction.workRequestId });
        interaction._onEnded.fire(interaction.data);
        work._onDeleted.fire(interaction.data);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionDeleted',
            message: interaction.data,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onRemoteParticipantAccepted
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onRemoteParticipantAccepted(interactionCollection, agent, message) {
        var interaction = interactionCollection.find({ id: message.id });
        if (!interaction) {
            throw new Error('Could not find Interaction with ID: ' + message.id);
        }
        interaction._onRemoteParticipantAccepted.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onRemoteParticipantAccepted',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaCreated
     * @param {AvayaCustomerServices.Services.Work.WorkService} workService
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaCreated(workService, interactionCollection, agent, message) {
        var interaction = interactionCollection.find({ id: message.interactionId });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaCreated',
                message: 'Could not find Interaction with ID: ' + message.interactionId
            });
            throw new Error('Could not find Interaction with ID: ' + message.interactionId);
        }

        var interactionMedia = new AvayaCustomerServices.Services.Work.InteractionMedia(workService);
        message.channel = interaction.data.channel;
        interactionMedia.setData(message);
        interaction._interactionMedia = interactionMedia;
        interaction._onMediaAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaCreated',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaMessageCreated
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaMessageCreated(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaMessageCreated',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;

        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onMessageAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaMessageCreated',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaMessageIsTyping
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaMessageIsTyping(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaMessageIsTyping',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onIsTyping.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaMessageIsTyping',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaMessages
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaMessages(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaMessageCreated',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;

        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages = interactionMedia.messages.concat(message.messages);
        interactionMedia._onMessagesAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaMessages',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaParticipantJoined
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaParticipantJoined(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaParticipantJoined',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onParticipantAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaParticipantJoined',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaParticipantLeft
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaParticipantLeft(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaParticipantLeft',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onParticipantRemoved.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaParticipantLeft',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaParticipantList
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaParticipantList(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaParticipantList',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onParticipantsListed.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaParticipantList',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionContextCreated
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionContextCreated(interactionCollection, agent, message) {
        var interaction = interactionCollection.find({ id: message.interactionId });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionContextCreated',
                message: 'Could not find Interaction with ID: ' + message.interactionId
            });
            throw new Error('Could not find Interaction with ID: ' + message.interactionId);
        }
        var interactionContext = interaction.getInteractionContext();
        if (!interactionContext) {
            interactionContext = new AvayaCustomerServices.Services.Work.InteractionContext();
            interactionContext.setData(message);
            interaction._interactionContext = interactionContext;
        } else {
            interactionContext.mergeData(message);
        }
        interaction._onContextAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionContextCreated',
            message: message,
            context: { interaction: interaction.data, interactionContext: interactionContext.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionContextUpdated
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionContextUpdated(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionContext && (model._interactionContext.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionContextUpdated',
                message: 'Could not find Interaction with ID: ' + message.interactionId
            });
            throw new Error('Could not find Interaction with an associated InteractionContext with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionContext = interaction.getInteractionContext();
        if (!interactionContext) {
            interactionContext = new AvayaCustomerServices.Services.Work.InteractionContext();
            interactionContext.setData(message);
            interaction._interactionContext = interactionContext;
        } else {
            interactionContext.mergeData(message);
        }
        interaction._onContextAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionContextUpdated',
            message: message,
            context: { interaction: interaction.data, interactionContext: interactionContext.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionContextDeleted
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionContextDeleted(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionContext && (model._interactionContext.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionContextDeleted',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionContext with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionContext = interaction.getInteractionContext();
        if (interactionContext) {
            interactionContext.removeData(message);
        }
        interaction._onContextRemoved.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionContextDeleted',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaPagePush
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaPagePush(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaPagePush',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onPagePushUrl.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaPagePush',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaForwardSent
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaForwardSent(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaForwardSent',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onForwardSent.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaForwardSent',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaReplySent
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaReplySent(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaReplySent',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onReplySent.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaReplySent',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaEmailFileLimitExceeded
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */

    function onInteractionMediaEmailFileLimitExceeded(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaEmailFileLimitExceeded',
                message: 'Could not find Interaction with an associated InteractionMedia with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onEmailFileLimitExceeded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaEmailFileLimitExceeded',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaEmailMessage
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaEmailMessage(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaEmailMessage',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onMessageAdded.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaEmailMessage',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaEmailAttachmentsAdded
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaEmailAttachmentsAdded(interactionCollection, agent, message) {
        if (message.attachments && message.attachments.length) {
            var interaction = interactionCollection.find(function (model) {
                return model._interactionMedia && (model._interactionMedia.id === message.id);
            });
            if (!interaction) {
                AvayaCustomerServices.Base.Logger.error('Work Service', {
                    scope: 'Work Service - onInteractionMediaEmailAttachmentsAdded',
                    message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
                });
                throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
            }
            message.interactionId = interaction.id;
            var interactionMedia = interaction.getInteractionMedia();
            _.forEach(message.attachments, function (attachment) {
                interactionMedia.attachments.push(attachment);
            });
            interactionMedia._onAttachmentAdded.fire(message);

            AvayaCustomerServices.Base.Logger.debug('Work Service', {
                scope: 'Work Service - onInteractionMediaEmailAttachmentsAdded',
                message: message,
                context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
            });
        }
    }

    /**
     * @private
     * @function onInteractionMediaEmailAttachmentsRemoved
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaEmailAttachmentsRemoved(interactionCollection, agent, message) {
        if (message.attachments && message.attachments.length) {
            var interaction = interactionCollection.find(function (model) {
                return model._interactionMedia && (model._interactionMedia.id === message.id);
            });
            if (!interaction) {
                AvayaCustomerServices.Base.Logger.error('Work Service', {
                    scope: 'Work Service - onInteractionMediaEmailAttachmentsRemoved',
                    message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
                });
                throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
            }
            message.interactionId = interaction.id;
            var interactionMedia = interaction.getInteractionMedia();
            _.forEach(message.attachments, function (attachment) {
                var found = _.find(interactionMedia.attachments, { partId: attachment.partId });
                if (found) {
                    var index = _.indexOf(interactionMedia.attachments, found);
                    interactionMedia.attachments.splice(index, 1);
                }
            });
            interactionMedia._onAttachmentRemoved.fire(message);

            AvayaCustomerServices.Base.Logger.debug('Work Service', {
                scope: 'Work Service - onInteractionMediaEmailAttachmentsRemoved',
                message: message,
                context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
            });
        }
    }

    /**
     * @private
     * @function onInteractionMediaTransferredFile
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaTransferredFile(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaTransferredFile',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        var interactionMedia = interaction.getInteractionMedia();
        _.forEach(message.attachments, function (attachment) {
            interactionMedia.attachments.push(attachment);
        });
        interactionMedia.messages.push(message.message);
        interactionMedia._onFileTransferred.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaTransferredFile',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaCustomerDownloadInitiated
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaCustomerDownloadInitiated(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaCustomerDownloadInitiated',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onCustomerDownloadInitiated.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaCustomerDownloadInitiated',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaCustomerDownloadComplete
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaCustomerDownloadComplete(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaCustomerDownloadComplete',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.messages.push(message.message);
        interactionMedia._onCustomerDownloadComplete.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaCustomerDownloadComplete',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaConnected
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaConnected(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaConnected',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onConnected.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaConnected',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaDisconnected
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaDisconnected(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaDisconnected',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onDisconnected.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaDisconnected',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionMediaLeft
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionMediaLeft(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model._interactionMedia && (model._interactionMedia.id === message.id);
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionMediaLeft',
                message: 'Could not find Interaction with an associated InteractionContext with ID: ' + message.id
            });
            throw new Error('Could not find Interaction with an associated InteractionMedia with ID: ' + message.id);
        }
        message.interactionId = interaction.id;
        var interactionMedia = interaction.getInteractionMedia();
        interactionMedia.notifications.push(message);
        interactionMedia._onLeft.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionMediaLeft',
            message: message,
            context: { interaction: interaction.data, interactionMedia: interactionMedia.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionAudioUpdated
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionAudioUpdated(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model.data.contactId === message.ucid;
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionAudioUpdated',
                message: 'Could not find Interaction with contact ID: ' + message.ucid
            });
            throw new Error('Could not find Interaction with contact ID: ' + message.ucid);
        }

        interaction.data.audioMuted = message.isMuted;
        interaction._onAudioUpdated.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionAudioUpdated',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionSpeakerUpdated
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionSpeakerUpdated(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model.data.contactId === message.ucid;
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionSpeakerUpdated',
                message: 'Could not find Interaction with contact ID: ' + message.ucid
            });
            throw new Error('Could not find Interaction with contact ID: ' + message.ucid);
        }

        interaction.data.speakerMuted = message.isMuted;
        interaction._onSpeakerUpdated.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionSpeakerUpdated',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionVideoUpdate
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionVideoUpdated(interactionCollection, agent, message) {
        if (_.isUndefined(message.stream) || _.isUndefined(message.ucid)) {
            return;
        }
        var interaction = interactionCollection.find(function (model) {
            return model.data.contactId === message.ucid;
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionVideoUpdated',
                message: 'Could not find Interaction with ID: ' + message.ucid
            });
            throw new Error('Could not find Interaction with ID: ' + message.ucid);
        }

        var stream = _.find(interaction._videoStreams, { id: message.id });
        if (stream) {
            _.assignIn(stream, message);
        } else {
            interaction._videoStreams.push(message);
        }

        interaction._onVideoUpdated.fire(message);

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionVideoUpdated',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionAnswerRequested
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionAnswerRequested(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model.data.contactId === message.ucid;
        });

        if (interaction && interaction.data.channel === 'VIDEO' && message.isVideoDeviceAvailable) {
            var videoMode = 'RECEIVE_ONLY';
            if (message.isVideoSupported) {
                videoMode = 'SEND_RECEIVE';
            }
            message.call.setVideoMode(videoMode);
        }

        message.call.accept();

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionIncomingVideoAddRequest',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionIncomingVideoAddRequest
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionIncomingVideoAddRequest(interactionCollection, agent, message) {
        var interaction = interactionCollection.find(function (model) {
            return model.data.contactId === message.ucid;
        });

        if (interaction && interaction.data.channel === 'VIDEO') {
            var videoMode = 'RECEIVE_ONLY';
            if (message.isVideoDeviceAvailable) {
                videoMode = 'SEND_RECEIVE';
            }
            message.call.acceptSendVideo(videoMode);
        } else {
            message.call.denySendVideo();
        }

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionIncomingVideoAddRequest',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });
    }

    /**
     * @private
     * @function onInteractionError
     * @param {AvayaCustomerServices.Providers.UAC.Provider} interactionProvider
     * @param {AvayaCustomerServices.Services.Work.InteractionCollection} interactionCollection
     * @param {AvayaCustomerServices.Services.Agent.Agent} agent
     * @param {Object} message
     */
    function onInteractionError(interactionProvider, interactionCollection, agent, message) {
        if (_.isUndefined(message.error) || _.isUndefined(message.ucid)) {
            return;
        }
        var interaction = interactionCollection.find(function (model) {
            return model.data.contactId === message.ucid;
        });
        if (!interaction) {
            AvayaCustomerServices.Base.Logger.error('Work Service', {
                scope: 'Work Service - onInteractionError',
                message: 'Could not find Interaction with ID: ' + message.ucid
            });
            throw new Error('Could not find Interaction with ID: ' + message.ucid);
        }

        AvayaCustomerServices.Base.Logger.debug('Work Service', {
            scope: 'Work Service - onInteractionError',
            message: message,
            context: { interaction: interaction.data, agent: agent.data }
        });

        interactionProvider.trigger('error', [message.error]);
    }

    /**
     * @private
     * @function onWebrtcCallCreated
     * @param {string[]} callList
     * @param {string} ucid
     */
    function onWebrtcCallCreated(callList, ucid) {
        if (ucid && callList.indexOf(ucid) === -1) {
            callList.push(ucid);
        }
    }

    AvayaCustomerServices.Services.Work.WorkService = WorkService;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Token Model
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @classdesc Token API defines a model for storing tokens
     * @memberOf AvayaCustomerServices.Base.Authentication
     * @define AvayaCustomerServices.Base.Authentication.Token
     * @requires AvayaCustomerServices.Base.Collections.Model
     * @extends AvayaCustomerServices.Base.Collections.Model
     *
     * @description Constructor function for Token Model
     */
    function Token() {
        AvayaCustomerServices.Base.Collections.Model.call(this, {idAttribute: 'header'});
    }

    Token.prototype =
    /** @lends AvayaCustomerServices.Base.Authentication.Token */
    {
        /**
         * Get token header.
         *
         * @public
         * @function AvayaCustomerServices.Base.Authentication.Token#getHeader
         * @returns {string} Token header
         */
        getHeader: function () {
            return this.data.header;
        },
        /**
         * Get token value.
         *
         * @public
         * @function AvayaCustomerServices.Base.Authentication.Token#getValue
         * @returns {string} Token value
         */
        getValue: function () {
            return this.data.value;
        }
    };

    _.defaults(Token.prototype, AvayaCustomerServices.Base.Collections.Model.prototype);

    AvayaCustomerServices.Base.Authentication.Token = Token;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Token Collection
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @classdesc Collection for managing an array of {@link Token} types.
     * @define AvayaCustomerServices.Base.Authentication.TokenCollection
     * @memberOf AvayaCustomerServices.Base.Authentication
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     *
     * @description Constructor function for Token Collection
     */
    function TokenCollection() {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Base.Authentication.Token, { idAttribute: 'header' });
    }

    TokenCollection.prototype =
    /** @lends AvayaCustomerServices.Base.Authentication.TokenCollection */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Base.Authentication.TokenCollection#findAllByTokenTypes
         * @param {string[]} types - Filter collections by token types
         * @returns {AvayaCustomerServices.Base.Authentication.Token[]}
         */
        findAllByTokenTypes: function (types) {
            var results = [];
            _.forEach(types, _.bind(function (type) {
                results.push(this.findAll({ id: type }));
            }, this));
            return _.flatten(results);
        }
    };

    _.defaults(TokenCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Base.Authentication.TokenCollection = TokenCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc REST Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _, Promise) {
    'use strict';
    /**
     * @class
     * @classdesc Rest Provider Class
     * @extends AvayaCustomerServices.Base.Observable
     * @requires AvayaCustomerServices.Base.Observable
     * @define AvayaCustomerServices.Base.Network.RESTProvider
     * @memberOf AvayaCustomerServices.Base.Network
     *
     * @description Rest Provider constructor function
     * @param {AvayaCustomerServices.Base.Authentication.TokenProvider} tokenProvider
     * @param {AvayaCustomerServices.Config.ServerInfo} config Server info for REST provider
     * @param {AvayaCustomerServices.Config.HTTPOptions} options HTTP options for REST provider
     */
    function RESTProvider(tokenProvider, config, options) {
        AvayaCustomerServices.Base.Observable.call(this);
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Authentication.TokenProvider}
         */
        this._tokenProvider = tokenProvider;
        /**
         * @private
         * @type {AvayaCustomerServices.Config.ServerInfo}
         */
        this._config = config;
        /**
         * @private
         * @type {AvayaCustomerServices.Config.HTTPOptions}
         */
        this._options = options;
        /**
         * @private
         * @type {AvayaCustomerServices.Base.Network.HTTPRequest[]}
         */
        this._xhrPool = [];
        /**
         * @public
         * @type {string}
         */
        this.name = config.name;
    }

    RESTProvider.prototype =
    /** @lends AvayaCustomerServices.Base.Network.RESTProvider */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.RESTProvider#send
         * @param {string} method HTTP request method (e.g. GET, POST, etc.)
         * @param {string} url URL of the HTTP request
         * @param {string|object} [data={}] Content to send
         * @param {{headers, async, timeout}} [options={}] Options for send request
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        send: function (method, url, data, options) {
            options = _.assignIn({}, this._options, options);
            options.headers = _.assignIn({}, this._options.headers, this._tokenProvider.getTokens(), options.headers);

            var config = {
                method: method,
                url: this._config.apiUrl + url,
                options: options,
                data: data
            };
            return new Promise(_.bind(sendXHR, null, this, config));
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.RESTProvider#get
         * @param {string} url URL of the HTTP request
         * @param {string|object} [data={}] Content to send
         * @param {{headers}} [options] Options for get request
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        get: function (url, data, options) {
            return this.send('GET', url, data, options);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.RESTProvider#post
         * @param {string} url URL of the HTTP request
         * @param {string|object} [data={}] Content to send
         * @param {{headers}} [options] Options for post request
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        post: function (url, data, options) {
            return this.send('POST', url, data, options);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.RESTProvider#put
         * @param {string} url URL of the HTTP request
         * @param {string|object} [data={}] Content to send
         * @param {{headers}} [options] Options for put request
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        put: function (url, data, options) {
            return this.send('PUT', url, data, options);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.RESTProvider#del
         * @param {string} url URL of the HTTP request
         * @param {string|object} [data={}] Content to send
         * @param {{headers}} [options] Options for delete request
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        del: function (url, data, options) {
            return this.send('DELETE', url, data, options);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Network.RESTProvider#close
         */
        close: function () {
            _.forEach(this._xhrPool, function (xhr) {
                xhr.abort();
            });
            this._xhrPool = [];
        }
    };

    /**
     * Helper function to send XHR Request
     *
     * @private
     * @function sendXHR
     * @param {AvayaCustomerServices.Base.Network.RESTProvider} provider REST Provider
     * @param {Object} config Configuration object for XHR Request
     * @param {function} resolve Callback function to execute on promise fulfillment
     * @param {function} reject Callback function to execute on promise rejection
     */
    function sendXHR(provider, config, resolve, reject) {
        var xhr = new AvayaCustomerServices.Base.Network.HTTPRequest({});
        var payload = xhr.encode(config.data);
        if (config.method === 'GET' && payload) {
            config.url += '?' + payload;
            payload = null;
        }
        xhr.open(config.method, config.url, config.options.async);
        xhr.setRequestHeaders(config.options.headers);
        xhr.addOnStateChangeCallback(_.bind(onStateChange, null, provider, xhr, resolve, reject));
        xhr.setTimeout(config.options.timeout || 90000);
        xhr.send(payload);
        provider._xhrPool.push(xhr);
    }

    /**
     * Helper function to manage XHR Request state changes
     *
     * @private
     * @function onStateChange
     * @param {AvayaCustomerServices.Base.Network.RESTProvider} provider REST Provider
     * @param {function} xhr
     * @param {function} resolve Callback function to execute on promise fulfillment
     * @param {function} reject Callback function to execute on promise rejection
     * @param {Object} event XHR Response event
     */
    function onStateChange(provider, xhr, resolve, reject, event) {
        var response = event && event.currentTarget ? event.currentTarget : xhr._xhr;
        if (response.readyState === 4) {
            if (!response.status || (response.status < 200 || response.status >= 300) && response.status !== 304) {
                AvayaCustomerServices.Base.Logger.error('Rest Provider', response);
                provider.trigger('xhr.error', [response && response.responseText ? response : { code: 500003 }]);
                reject(response);
            } else if (response.responseText.length > 0) {
                try {
                    var responseText = AvayaCustomerServices.Base.Utils.parseJSON(response.responseText);
                    AvayaCustomerServices.Base.Logger.debug('Rest Provider', response);
                    resolve(responseText, response);
                } catch (error) {
                    AvayaCustomerServices.Base.Logger.error('Rest Provider', _.assignIn({}, error, { code: 500003 }));
                    provider.trigger('xhr.error', [_.assignIn({}, error, { code: 500003 })]);
                    reject(response);
                }
            } else {
                AvayaCustomerServices.Base.Logger.debug('Rest Provider', response);
                resolve(null, response);
            }
            var index = provider._xhrPool.indexOf(xhr);
            if (index > -1) {
                provider._xhrPool.splice(index, 1);
            }
        }
    }

    _.defaults(RESTProvider.prototype, AvayaCustomerServices.Base.Observable.prototype);

    AvayaCustomerServices.Base.Network.RESTProvider = RESTProvider;

})(AvayaCustomerServices, _, RSVP.Promise);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Activate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentActivateEvent
     */
    function AgentActivateEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_ACTIVATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.userDetails.id;
        /**
         * @public
         * @type {string}
         */
        this.handle = response.newValue.userDetails.userHandle;
        /**
         * @public
         * @type {string}
         */
        this.role = response.newValue.userSession.role;
        /**
         * @public
         * @type {string}
         */
        this.firstName = response.newValue.userDetails.firstName;
        /**
         * @public
         * @type {string}
         */
        this.lastName = response.newValue.userDetails.lastName;
        /**
         * @public
         * @type {string}
         */
        this.displayName = response.newValue.userDetails.displayName;
        /**
         * @public
         * @type {string}
         */
        this.mailboxNumber = response.newValue.mailboxNumber;
        /**
         * @public
         * @type {string}
         */
        this.trunkAccessCode = response.newValue.trunkAccessCode;
        /**
         * @public
         * @type {Object[]}
         */
        this.reasonCodes = _.sortBy(response.newValue.reasonCodes, function(reason) { return parseInt(reason.code); });
        /**
         * @public
         * @type {Object[]}
         */
        this.userProfilePreferences = response.newValue.userProfilePreferences;
        /**
         * @public
         * @type {Object[]}
         */
        this.userProfileAccountPreferences = response.newValue.userProfileAccountPreferences;
        /**
         * @public
         * @type {boolean}
         */
        this.isActivated = true;
        /**
         * @public
         * @type {boolean}
         */
        this.isReserveActive = response.newValue.userSession.isReserveActive;
        /**
         * @public
         * @type {Object[]}
         */
        this.templateGroups = response.newValue.templateGroups;
        /**
         * @public
         * @type {boolean}
         */
        this.hideRetrieveEmailDraft = (!response.newValue.userSession.capabilities || typeof response.newValue.userSession.capabilities.hideRetrieveEmailDraft === 'undefined' || response.newValue.userSession.capabilities.hideRetrieveEmailDraft === false) ? false : true;
    }

    _.defaults(AgentActivateEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.AgentActivateEvent = AgentActivateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Deactivate Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentDeactivateEvent
     */
    function AgentDeactivateEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_DEACTIVATED);
        /**
         * @public
         * @type {boolean}
         */
        this.isActivated = false;
        /**
         * @public
         * @type {string}
         */
        this.reason = response.newValue.reason;
    }

    _.defaults(AgentDeactivateEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.AgentDeactivateEvent = AgentDeactivateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Agent State Message Interface
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentStateMessage
     *
     * @description Agent State Message constructor function
     * @param {string} name Event Name
     * @param {{resourceStates,currentState,previousState,capabilities}} message Message data
     */
    function AgentStateMessage(name, message) {
        AvayaCustomerServices.Providers.Common.Message.call(this, name);
        /**
         * @public
         * @type {Object}
         */
        this.resourceStates = parseResourceStates(message.resourceStates);
        /**
         * @public
         * @type {string}
         */
        this.currentState = AvayaCustomerServices.Providers.Common.MessageTypes.agentState[message.currentState];
        /**
         * @public
         * @type {string}
         */
        this.previousState = AvayaCustomerServices.Providers.Common.MessageTypes.agentState[message.previousState];
        /**
         * @public
         * @type {Object}
         */
        this.capabilities = message.capabilities;
        /**
         * @public
         * @type {boolean}
         */
        this.isReserveActive = message.isReserveActive;
        /**
         * @public
         * @type {string}
         */
        this.lastStateChangeTime = message.lastStateChangeTime;
    }

    /**
     * Helper function to parse resources into more manageable format
     *
     * @private
     * @function AvayaCustomerServices.Providers.Common.AgentStateMessage#parseResourceStates
     * @param {Object} resources
     * @returns {object}
     */
    function parseResourceStates(resources) {
        var states = {};
        _.forEach(resources, function (resource) {
            var index = AvayaCustomerServices.Providers.Common.MessageTypes.resourceTypes[resource.channelType];
            states[index] = {
                state: AvayaCustomerServices.Providers.Common.MessageTypes.resourceState[resource.state],
                stateReason: resource.stateReason,
                capabilities: resource.capabilities
            };
        });
        return states;
    }

    _.defaults(AgentStateMessage.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.AgentStateMessage = AgentStateMessage;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Unknown Agent State Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @requires AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentUnknownStateEvent
     */
    function AgentUnknownStateEvent(response) {
        AvayaCustomerServices.Providers.Common.AgentStateMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_STATE_UNKNOWN, response.newValue);
    }

    _.defaults(AgentUnknownStateEvent.prototype, AvayaCustomerServices.Providers.Common.AgentStateMessage.prototype);

    AvayaCustomerServices.Providers.Common.AgentUnknownStateEvent = AgentUnknownStateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Created Configuration Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @define AvayaCustomerServices.Providers.Common.ConfigurationCreatedEvent
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ConfigurationCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.CONFIGURATION_CREATED);
        /**
         * @public
         * @type {Object}
         */
        this.settings = response.newValue;
    }

    _.defaults(ConfigurationCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ConfigurationCreatedEvent = ConfigurationCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Deleted Configuration Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @define AvayaCustomerServices.Providers.Common.ConfigurationDeletedEvent
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ConfigurationDeletedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.CONFIGURATION_DELETED);
        /**
         * @public
         * @type {Object}
         */
        this.settings = response.newValue;
    }

    _.defaults(ConfigurationDeletedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ConfigurationDeletedEvent = ConfigurationDeletedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Updated Configuration Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @define AvayaCustomerServices.Providers.Common.ConfigurationUpdatedEvent
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function ConfigurationUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.CONFIGURATION_UPDATED);
        /**
         * @public
         * @type {Object}
         */
        this.settings = response.newValue;
    }

    _.defaults(ConfigurationUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.ConfigurationUpdatedEvent = ConfigurationUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Deferred Innteraction Event
 * @author Warren Reilly [reillyw@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.DeferredInteractionEvent
     */
    function DeferredInteractionEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.DEFERRED_INTERACTION);

        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.contactId = response.newValue.contactId;
        /**
         * @public
         * @type {string}
         */
        this.channel = AvayaCustomerServices.Providers.Common.Response.channelTypes[response.newValue.channelType];
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {object}
         */
        this.capabilities = response.newValue.capabilities;
        /**
         * @public
         * @type {Object[]}
         */
        this.customer = response.newValue.customer;
        /**
         * @public
         * @type {string}
         */
        this.externalInteractionId = response.newValue.externalInteractionId;
        /**
         * @public
         * @type {string}
         */
        this.userSessionId = response.newValue.userSessionId;
        /**
         * @public
         * @type {string}
         */
        this.service = response.newValue.service;
        /**
         * @public
         * @type {dateTime}
         */
        this.deferTime = response.newValue.deferTime;
        /**
         * @public
         * @type {dateTime}
         */
        this.deferCode = response.newValue.deferCode;
        /**
         * @public
         * @type {string}
         */
        this.routingId = response.newValue.routingId;
        /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
         * @public
         * @type {string}
         */
        this.resourceAddress = response.newValue.resourceAddress;
        /**
         * @public
         * @type {string}
         */
        this.deferInteractionState = AvayaCustomerServices.Providers.Common.Response.deferInteractionStates[response.newValue.deferInteractionState];

    }

    _.defaults(DeferredInteractionEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.DeferredInteractionEvent = DeferredInteractionEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Error Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.ErrorEvent
     *
     * @description Build error object for onError callbacks
     * @param {{newValue: {errorType, code, message, severity, scope}}} response
     */
    function ErrorEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.ERROR);
        /**
         * @public
         * @type {string}
         */
        this.code = response.newValue.code;
        /**
         * @public
         * @type {string}
         */
        this.message = response.newValue.message;
        /**
         * @public
         * @type {string}
         */
        this.reason = response.newValue.detail;
        /**
         * @public
         * @type {string}
         */
        this.scope = response.newValue.scope;
        /**
         * @public
         * @type {string}
         */
        this.scopeId = response.newValue.scopeId;
        /**
         * @public
         * @type {string}
         */
        this.severity = response.newValue.severity;
        /**
         * @public
         * @type {string}
         */
        this.source = response.newValue.source;
        /**
         * @public
         * @type {Object}
         */
        this.messagePlaceholders = response.newValue.messagePlaceholders;
        /**
         * @public
         * @type {string}
         */
        this.type = AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_AS_MESSAGE;
    }

    AvayaCustomerServices.Providers.Common.ErrorEvent = ErrorEvent;

})(AvayaCustomerServices);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Context Message
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionContextMessage
     *
     * @param {string} name
     * @param {Object} contexts
     */
    function InteractionContextMessage(name, contexts) {
        AvayaCustomerServices.Providers.Common.Message.call(this, name);
        /**
         * @public
         * @type {object[]}
         */
        this.pagePushUrl = _.filter(contexts, {type: 'PAGE_PUSH'});
        /**
         * @public
         * @type {object[]}
         */
        this.suggestedPhrase = _.filter(contexts, {type: 'SUGGESTED_PHRASE'});
        /**
         * @public
         * @type {object[]}
         */
        this.contextStore = _.filter(contexts, {type: 'CONTEXT_STORE'});
        /**
         * @public
         * @type {object[]}
         */
        this.screenPop = _.filter(contexts, {type: 'SCREEN_POP'});
        /**
         * @public
         * @type {object[]}
         */
        this.cobrowse = _.filter(contexts, {type: 'COBROWSE'});
        /**
         * @public
         * @type {object[]}
         */
        this.customerHistory = _.filter(contexts, {type: 'CUSTOMER_HISTORY'});
        /**
         * @public
         * @type {object[]}
         */
        this.customerDetails = _.filter(contexts, {type: 'CUSTOMER_DETAILS'});
        /**
         * @public
         * @type {object[]}
         */
        this.clientValidation = _.filter(contexts, {type: 'CLIENT_VALIDATION'});
        /**
         * @public
         * @type {object[]}
         */
        this.campaignScripts = _.filter(contexts, {type: 'CAMPAIGN_SCRIPT'});
        /**
         * @public
         * @type {object[]}
         */
        this.fromAddresses = _.filter(contexts, {type: 'ORIGINATOR'});
        /**
         * @public
         * @type {object[]}
         */
        this.textDir = _.filter(contexts, {type: 'TEXT_DIRECTION'});
        /**
         * @public
         * @type {object[]}
         */
        this.channelSrc = _.filter(contexts, {type: 'CHANNEL_SRC'});

    }

    _.defaults(InteractionContextMessage.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionContextMessage = InteractionContextMessage;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Update Interaction Context Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.InteractionContextMessage
     * @requires AvayaCustomerServices.Providers.Common.InteractionContextMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionContextUpdatedEvent
     *
     * @param {Object} response
     */
    function InteractionContextUpdatedEvent(response) {
        AvayaCustomerServices.Providers.Common.InteractionContextMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_CONTEXT_UPDATED, response.newValue);
        /**
         * @public
         * @type {string}
         */
        this.id = response.parentId;
    }

    _.defaults(InteractionContextUpdatedEvent.prototype, AvayaCustomerServices.Providers.Common.InteractionContextMessage.prototype);

    AvayaCustomerServices.Providers.Common.InteractionContextUpdatedEvent = InteractionContextUpdatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Delete Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionDeleteEvent
     */
    function InteractionDeleteEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_DELETE);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
    }

    _.defaults(InteractionDeleteEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionDeleteEvent = InteractionDeleteEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @private
     * @type {Object}
     */
    var allowedMessEventTypes = {
        MESSAGE: 'MESSAGE',
        WHISPER: 'WHISPER',
        PAGE_PUSH: 'PAGE_PUSH',
        TRANSFERRED_FILE: 'TRANSFERRED_FILE',
        CUSTOMER_DOWNLOAD_INITIATED: 'CUSTOMER_DOWNLOAD_INITIATED',
        CUSTOMER_DOWNLOAD_COMPLETE: 'CUSTOMER_DOWNLOAD_COMPLETE',
        QUERY_RESPONSE: 'QUERY_RESPONSE',
        WIDGET: 'WIDGET'
    };

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaChatCreatedEvent
     */
    function InteractionMediaChatCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {string}
         */
        this.interactionId = response.newValue.uamInteractionId;
        /**
         * @public
         * @type {Array}
         */
        this.participants = response.newValue.participants;
        /**
         * @public
         * @type {Array}
         */
        this.messages = _.filter(response.newValue.chatMessages, function (message) {
            var chatEventType = message && message.chatMessageEvent && message.chatMessageEvent.chatEventType;
            if (chatEventType === allowedMessEventTypes.MESSAGE || chatEventType === allowedMessEventTypes.WHISPER) {
                message = AvayaCustomerServices.Providers.Common.Utils.sanitize(message.body, message, null);
            }
            return !!allowedMessEventTypes[chatEventType];
        });
    }

    _.defaults(InteractionMediaChatCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaChatCreatedEvent = InteractionMediaChatCreatedEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Media Connected Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaConnectedEvent
     */
    function InteractionMediaConnectedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CONNECTED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.participant = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.type = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.CONNECTED;
    }

    _.defaults(InteractionMediaConnectedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaConnectedEvent = InteractionMediaConnectedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadCompleteEvent
     */
    function InteractionMediaCustomerDownloadCompleteEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CUSTOMER_DOWNLOAD_COMPLETE);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Object}
         */
        this.attachment = response.newValue.parts.length ? response.newValue.parts[0] : {};
        /**
         * @public
         * @type {Object}
         */
        this.receivedFrom = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.arrivalDate = response.newValue.arrivalDate;
        /**
         * @public
         * @type {Object}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaCustomerDownloadCompleteEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadCompleteEvent = InteractionMediaCustomerDownloadCompleteEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadInitiatedEvent
     */
    function InteractionMediaCustomerDownloadInitiatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CUSTOMER_DOWNLOAD_INITIATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Object}
         */
        this.attachment = response.newValue.parts.length ? response.newValue.parts[0] : {};
        /**
         * @public
         * @type {Object}
         */
        this.receivedFrom = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.arrivalDate = response.newValue.arrivalDate;
        /**
         * @public
         * @type {Object}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaCustomerDownloadInitiatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaCustomerDownloadInitiatedEvent = InteractionMediaCustomerDownloadInitiatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Delete Interaction Media Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaDeleteEvent
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionMediaDeleteEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_DELETED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
        /**
         * @public
         * @type {string}
         */
        this.type = AvayaCustomerServices.Providers.Common.Response.mediaUpdateTypes.DELETE;
    }

    _.defaults(InteractionMediaDeleteEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaDeleteEvent = InteractionMediaDeleteEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Media Disconnected Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaDisconnectedEvent
     */
    function InteractionMediaDisconnectedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_DISCONNECTED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.participant = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.type = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.DISCONNECTED;
    }

    _.defaults(InteractionMediaDisconnectedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaDisconnectedEvent = InteractionMediaDisconnectedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsAddedEvent
     */
    function InteractionMediaEmailAttachmentsAddedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_EMAIL_ATTACHMENTS_ADDED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.attachments = response.newValue.parts;
    }

    _.defaults(InteractionMediaEmailAttachmentsAddedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsAddedEvent = InteractionMediaEmailAttachmentsAddedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsRemovedEvent
     */
    function InteractionMediaEmailAttachmentsRemovedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_EMAIL_ATTACHMENTS_REMOVED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.attachments = response.newValue.parts;
    }

    _.defaults(InteractionMediaEmailAttachmentsRemovedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailAttachmentsRemovedEvent = InteractionMediaEmailAttachmentsRemovedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailCreatedEvent
     */
    function InteractionMediaEmailCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {string}
         */
        this.interactionId = response.newValue.uamInteractionId;
        /**
         * @public
         * @type {Array}
         */
        this.participants = response.newValue.participants;
        /**
         * @public
         * @type {Array}
         */
        this.messages = _.filter(response.newValue.emailMessages, function (message) {
            return message && message.emailMessageEvent && message.emailMessageEvent.emailEventType &&
                message.emailMessageEvent.emailEventType === 'MESSAGE';
        });
        /**
         * @public
         * @type {Array}
         */
        this.draftMessages = _.filter(response.newValue.emailMessages, function (message) {
            return message && message.emailMessageEvent && message.emailMessageEvent.emailEventType &&
                message.emailMessageEvent.emailEventType === 'DRAFT';
        });
    }

    _.defaults(InteractionMediaEmailCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailCreatedEvent = InteractionMediaEmailCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Email File Limit Exceeded Event
 * @author Andrei Blokhin [ablokhin@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailFileLimitExceededEvent
     */
    function InteractionMediaEmailFileLimitExceededEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_EMAIL_EMAIL_FILE_LIMIT_EXCEEDED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaEmailFileLimitExceededEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailFileLimitExceededEvent = InteractionMediaEmailFileLimitExceededEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Forward Email Sent Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailForwardSentEvent
     */
    function InteractionMediaEmailForwardSentEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_EMAIL_FORWARD_SENT);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaEmailForwardSentEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailForwardSentEvent = InteractionMediaEmailForwardSentEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Reply Email Sent Event
 * @author Oleg Labunin [olabunin@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailReplySentEvent
     */
    function InteractionMediaEmailReplySentEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_EMAIL_REPLY_SENT);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaEmailReplySentEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailReplySentEvent = InteractionMediaEmailReplySentEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageEvent
     */
    function InteractionMediaEmailMessageEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_EMAIL_MESSAGE);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaEmailMessageEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaEmailMessageEvent = InteractionMediaEmailMessageEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Media Left Event
 * @author Oleg Labunin [olabunin@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaLeftEvent
     */
    function InteractionMediaLeftEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_LEFT);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.participant = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.type = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.LEFT;
    }

    _.defaults(InteractionMediaLeftEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaLeftEvent = InteractionMediaLeftEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent
     */
    function InteractionMediaMessageCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_MESSAGE_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.message = AvayaCustomerServices.Providers.Common.Utils.sanitize(response.newValue.body, response.newValue, null);

        if (this.message.type === AvayaCustomerServices.Providers.Common.Response.channelTypes.MESSAGING) {
            if (this.message.chatMessageEvent.chatEventType === AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.ERROR) {
                this.message.errorDescription = this.message.body;
                delete this.message.body;
            }

            if (this.message.customData) {
                var customData = AvayaCustomerServices.Base.Utils.parseJSON(this.message.customData);

                if (customData && customData.asyncMessageInfo && customData.asyncMessageInfo.message) {
                    customData = customData.asyncMessageInfo.message;
                }

                if (customData) {
                    if (this.message.richMediaType === 'whatsapptemplate') {
                        this.message.textFallback = this.message.body;
                    }
                    this.message.body = customData;
                    if (this.message.richMediaType === "text" || this.message.richMediaType === "image" || this.message.richMediaType === "location") {
                        this.message = AvayaCustomerServices.Providers.Common.Utils.sanitize(this.message.body.text, this.message, ['body', 'text']);
                    }
                    delete this.message.customData;
                }
            }
        }
    }

    _.defaults(InteractionMediaMessageCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaMessageCreatedEvent = InteractionMediaMessageCreatedEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaMessageIsTypingEvent
     */
    function InteractionMediaMessageIsTypingEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_MESSAGE_IS_TYPING);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.participant = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.type = AvayaCustomerServices.Providers.Common.Response.mediaEventTypes.IS_TYPING;
    }

    _.defaults(InteractionMediaMessageIsTypingEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaMessageIsTypingEvent = InteractionMediaMessageIsTypingEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaPagePushUrlEvent
     */
    function InteractionMediaPagePushUrlEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_PAGE_PUSH);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaPagePushUrlEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaPagePushUrlEvent = InteractionMediaPagePushUrlEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaParticipantJoinedEvent
     */
    function InteractionMediaParticipantJoinedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_PARTICIPANT_JOINED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.participant = response.newValue.participant;
        /**
         * @public
         * @type {Array}
         */
        this.participants = response.newValue.interactionMedia.participants;
    }

    _.defaults(InteractionMediaParticipantJoinedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaParticipantJoinedEvent = InteractionMediaParticipantJoinedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaParticipantLeftEvent
     */
    function InteractionMediaParticipantLeftEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_PARTICIPANT_LEFT);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.participant = response.newValue.participant;
        /**
         * @public
         * @type {Array}
         */
        this.participants = response.newValue.interactionMedia.participants;
    }

    _.defaults(InteractionMediaParticipantLeftEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaParticipantLeftEvent = InteractionMediaParticipantLeftEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Media Participant List Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaParticipantListEvent
     */
    function InteractionMediaParticipantListEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_PARTICIPANT_LIST);
        /**
         * @public
         * @type {string}
         */
        this.id = response.parentId;
        /**
         * @public
         * @type {Array}
         */
        this.participants = _.toArray(response.newValue);
    }

    _.defaults(InteractionMediaParticipantListEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaParticipantListEvent = InteractionMediaParticipantListEvent;

})(AvayaCustomerServices, _);
/**
 * @classdesc Rich Media Created Event
 * @author Arina Tryaskova [atryaskova@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @private
     * @type {Object}
     */
    var allowedMessageEventTypes = {
        RICHMEDIA: 'RICHMEDIA',
        WHISPER: 'WHISPER',
        ERROR: 'ERROR',
        PAGE_PUSH: 'PAGE_PUSH',
        TRANSFERRED_FILE: 'TRANSFERRED_FILE',
        CUSTOMER_DOWNLOAD_INITIATED: 'CUSTOMER_DOWNLOAD_INITIATED',
        CUSTOMER_DOWNLOAD_COMPLETE: 'CUSTOMER_DOWNLOAD_COMPLETE',
        QUERY_RESPONSE: 'QUERY_RESPONSE',
        WIDGET: 'WIDGET'
    };

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaCreatedEvent
     */
    function InteractionMediaRichMediaCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {string}
         */
        this.interactionId = response.newValue.uamInteractionId;
        /**
         * @public
         * @type {Array}
         */
        this.participants = response.newValue.participants;
        /**
         * @public
         * @type {Array}
         */
        this.messages = _.filter(response.newValue.chatMessages, function (message) {
            var chatEventType = message && message.chatMessageEvent && message.chatMessageEvent.chatEventType;
            return !!allowedMessageEventTypes[chatEventType];
        });

        this.messages = _.forEach(this.messages, function (message) {
            if (message.chatMessageEvent.chatEventType === allowedMessageEventTypes.ERROR) {
                message.errorDescription = message.body;
                delete message.body;
            }

            if (message.customData) {
                var customData = AvayaCustomerServices.Base.Utils.parseJSON(message.customData);

                if (customData && customData.asyncMessageInfo && customData.asyncMessageInfo.message) {
                    customData = customData.asyncMessageInfo.message;
                }

                if (customData) {
                    if (message.richMediaType === 'whatsapptemplate') {
                        message.textFallback = message.body;
                    }
                    message.body = customData;
                    if (message.richMediaType === "text" || message.richMediaType === "image" || message.richMediaType === "location") {
                        message = AvayaCustomerServices.Providers.Common.Utils.sanitize(customData.text, message, ['body', 'text']);
                    }
                    delete message.customData;
                }
            }
        });
    }

    _.defaults(InteractionMediaRichMediaCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaRichMediaCreatedEvent = InteractionMediaRichMediaCreatedEvent;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @private
     * @type {Object}
     */
    var allowedMessEventTypes = {
        MESSAGE: 'MESSAGE',
        WHISPER: 'WHISPER',
        PAGE_PUSH: 'PAGE_PUSH',
        TRANSFERRED_FILE: 'TRANSFERRED_FILE',
        CUSTOMER_DOWNLOAD_INITIATED: 'CUSTOMER_DOWNLOAD_INITIATED',
        CUSTOMER_DOWNLOAD_COMPLETE: 'CUSTOMER_DOWNLOAD_COMPLETE'
    };

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaSocialCreatedEvent
     */
    function InteractionMediaSocialCreatedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_CREATED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {string}
         */
        this.interactionId = response.newValue.uamInteractionId;
        /**
         * @public
         * @type {Array}
         */
        this.participants = response.newValue.participants;
        /**
         * @public
         * @type {Array}
         */
        this.messages = _.filter(response.newValue.chatMessages, function (message) {
            var chatEventType = message && message.chatMessageEvent && message.chatMessageEvent.chatEventType;
            return !!allowedMessEventTypes[chatEventType];
        });
        /**
         * @public
         * @type {string}
         */
        this.type = response.newValue.type;
        /**
         * @public
         * @type {string}
         */
        this.source = response.newValue.source;
        /**
         * @public
         * @type {Object}
         */
        this.chatFlags = response.newValue.chatFlags;
    }

    _.defaults(InteractionMediaSocialCreatedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaSocialCreatedEvent = InteractionMediaSocialCreatedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Alerting Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMediaTransferredFileEvent
     */
    function InteractionMediaTransferredFileEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_MEDIA_TRANSFERRED_FILE);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.interactionMediaId;
        /**
         * @public
         * @type {Array}
         */
        this.attachments = response.newValue.parts;
        /**
         * @public
         * @type {Object}
         */
        this.receivedFrom = response.newValue.receivedFrom;
        /**
         * @public
         * @type {string}
         */
        this.arrivalDate = response.newValue.arrivalDate;
        /**
         * @public
         * @type {Object}
         */
        this.message = response.newValue;
    }

    _.defaults(InteractionMediaTransferredFileEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMediaTransferredFileEvent = InteractionMediaTransferredFileEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Message
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionMessage
     */
    function InteractionMessage(name, response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, name);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue.id;
        /**
         * @public
         * @type {string}
         */
        this.contactId = response.newValue.contactId;
        /**
         * @public
         * @type {string}
         */
        this.channel = AvayaCustomerServices.Providers.Common.Response.channelTypes[response.newValue.channelType];
        /**
         * @public
         * @type {string}
         */
        this.state = AvayaCustomerServices.Providers.Common.Response.interactionStates[response.newValue.currentState];
        /**
         * @public
         * @type {object}
         */
        this.capabilities = response.newValue.capabilities;
        /**
         * @public
         * @type {string}
         */
        this.workRequestId = response.newValue.workRequestId;
        /**
         * @public
         * @type {string}
         */
        this.originatingAddress = response.newValue.originatingAddress;
        /**
         * @public
         * @type {string}
         */
        this.destinationAddress = response.newValue.destinationAddress;
        /**
         * @public
         * @type {string}
         */
        this.direction = response.newValue.direction;
        /**
         * @public
         * @type {boolean}
         */
        this.isCustomerInteraction = response.newValue.isCustomerInteraction;
        /**
         * @public
         * @type {boolean}
         */
        this.isRoutingDefaulted = response.newValue.isRoutingDefaulted;
        /**
         * @public
         * @type {string}
         */
        this.workCode = response.newValue.workCode;
        /**
         * @public
         * @type {string}
         */
        this.dispositionCode = response.newValue.dispositionCode;
        /**
         * @public
         * @type {string}
         */
        this.deferCode = response.newValue.deferCode;
        /**
         * @public
         * @type {Object[]}
         */
        this.participants = response.newValue.participants;
        /**
         * @public
         * @type {string}
         */
        this.userToUserInfo = response.newValue.userToUserInfo;
        /**
         * @public
         * @type {boolean}
         */
        this.isNailUpCall = response.newValue.isNailUpCall;
        /**
         * @public
         * @type {boolean}
         */
        this.isWebRtcCall = response.newValue.isWebRtcCall;
        /**
         * @public
         * @type {boolean}
         */
        this.isACWEnabled = response.newValue.isACWEnabled;
        /**
         * @public
         * @type {boolean}
         */
        this.isACWExtended = response.newValue.isACWExtended;
        /**
         * @public
         * @type {boolean}
         */
        this.isAutoAnswerEnabled = response.newValue.isAutoAnswerEnabled;
        /**
         * @public
         * @type {Date}
         */
        this.autoAnswerTimerExpireDT = response.newValue.autoAnswerTimerExpireDT;
        /**
         * @public
         * @type {string}
         */
        this.topic = response.newValue.topic;
        /**
         * @public
         * @type {string}
         */
        this.topicId = response.newValue.topicId;
        /**
         * @public
         * @type {string}
         */
        this.establishedTime = response.newValue.establishedTime;
        /**
         * @public
         * @type {string}
         */
        this.stateChangeTime = response.newValue.lastStateChangeTime;
        /**
         * @public
         * @type {string}
         */
        this.acwEstablishedTime = response.newValue.acwEstablishedTime;
        /**
         * @public
         * @type {string}
         */
        this.acwDuration = response.newValue.acwDuration;
        /**
         * @public
         * @type {string}
         */
        this.externalInteractionId = response.newValue.externalInteractionId;
        /**
         * @public
         * @type {string}
         */
        this.interactionType = response.newValue.interactionType;
        /**
         * @public
         * @type {string}
         */
        this.observeAction = response.newValue.observeAction;
        /**
         * @public
         * @type {number}
         */
        this.priority = response.newValue.priority;
        /**
         * @public
         * @type {Array}
         */
        this.attributes = response.newValue.attributes;
        /**
         * @public
         * @type {string}
         */
        this.stateReason = response.newValue.stateReason;
        /**
         * @public
         * @type {string}
         */
        this.isObserved = response.newValue.isObserved;
        /**
         * @public
         * @type {string}
         */
        this.isTransferredToService = response.newValue.isTransferredToService;
        /**
         * @public
         * @type {string}
         */
        this.isTransferredToUser = response.newValue.isTransferredToUser;
        /**
         * @public
         * @type {string}
         */
        this.skill = response.newValue.skill;
        /**
         * @public
         * @type {string}
         */
        this.skillId = response.newValue.skillId;
         /**
         * @since 3.6.1.0
         * @public
         * @type {string}
         */
        this.intrinsics = response.newValue.intrinsics;
        /**
         * @public
         * @type {string}
         */
        this.isCallback = response.newValue.isCallback;
        /**
         * @public
         * @type {string}
         */
        this.tenantId = response.newValue.tenantId;
        /**
         * @public
         * @type {string}
         */
        this.tenantName = response.newValue.tenantName;
        /**
         * @public
         * @type {string}
         */
        this.workType = response.newValue.workType;
         /**
         * @public
         * @type {string}
         */
        this.providerId = response.newValue.providerId;
        /**
        * @public
        * @type {string}
        */
        this.resourceAddress = response.newValue.resourceAddress;
    }

    _.defaults(InteractionMessage.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionMessage = InteractionMessage;

})(AvayaCustomerServices, _);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Passive Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.2.2
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.InteractionMessage
     * @requires AvayaCustomerServices.Providers.Common.InteractionMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionPassiveEvent
     */
    function InteractionPassiveEvent(response) {
        AvayaCustomerServices.Providers.Common.InteractionMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_PASSIVE, response);
    }

    _.defaults(InteractionPassiveEvent.prototype, AvayaCustomerServices.Providers.Common.InteractionMessage.prototype);

    AvayaCustomerServices.Providers.Common.InteractionPassiveEvent = InteractionPassiveEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Remote Participant Accepted Interaction Event
 * @author Maria Yakovenya [myakovenya@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Message
     * @requires AvayaCustomerServices.Providers.Common.Message
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedEvent
     */
    function InteractionRemoteParticipantAcceptedEvent(response) {
        AvayaCustomerServices.Providers.Common.Message.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.DESTINATION_PARTICIPANT_ACCEPTED);
        /**
         * @public
         * @type {string}
         */
        this.id = response.newValue;
    }

    _.defaults(InteractionRemoteParticipantAcceptedEvent.prototype, AvayaCustomerServices.Providers.Common.Message.prototype);

    AvayaCustomerServices.Providers.Common.InteractionRemoteParticipantAcceptedEvent = InteractionRemoteParticipantAcceptedEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Interaction Unknown Event
 * @author Novikov Mikhail [mnovikov@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.InteractionMessage
     * @requires AvayaCustomerServices.Providers.Common.InteractionMessage
     * @define AvayaCustomerServices.Providers.Common.InteractionUnknownEvent
     * @memberOf AvayaCustomerServices.Providers.Common
     */
    function InteractionUnknownEvent(response) {
        AvayaCustomerServices.Providers.Common.InteractionMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_UNKNOWN, response);
    }

    _.defaults(InteractionUnknownEvent.prototype, AvayaCustomerServices.Providers.Common.InteractionMessage.prototype);

    AvayaCustomerServices.Providers.Common.InteractionUnknownEvent = InteractionUnknownEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Update Interaction Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.InteractionMessage
     * @requires AvayaCustomerServices.Providers.Common.InteractionMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.InteractionUpdateEvent
     */
    function InteractionUpdateEvent(response) {
        AvayaCustomerServices.Providers.Common.InteractionMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.INTERACTION_UPDATE, response);
    }

    _.defaults(InteractionUpdateEvent.prototype, AvayaCustomerServices.Providers.Common.InteractionMessage.prototype);

    AvayaCustomerServices.Providers.Common.InteractionUpdateEvent = InteractionUpdateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Common Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices, _, Promise) {
    'use strict';
    /**
     * @class
     * @define AvayaCustomerServices.Providers.Common.Provider
     * @memberOf AvayaCustomerServices.Providers.Common
     * @requires AvayaCustomerServices.Providers.Interfaces.AgentProvider
     * @requires AvayaCustomerServices.Providers.Interfaces.TeamProvider
     * @requires AvayaCustomerServices.Providers.Interfaces.WorkProvider
     * @extends AvayaCustomerServices.Providers.Interfaces.AgentProvider
     * @extends AvayaCustomerServices.Providers.Interfaces.TeamProvider
     * @extends AvayaCustomerServices.Providers.Interfaces.WorkProvider
     *
     * @param {AvayaCustomerServices.Base.Network.RESTProvider} requestProvider
     * @param {AvayaCustomerServices.Base.Network.AtmosphereProvider} notificationProvider
     * @param {AvayaCustomerServices.Providers.Common.MessageParser} notificationParser
     * @param {AvayaCustomerServices.Config.CommonConfiguration} config
     */
    function Provider(requestProvider, notificationProvider, notificationParser, config) {
        AvayaCustomerServices.Base.Observable.call(this);
        /**
         * @public
         * @type {string}
         */
        this.name = 'Common Provider';
        /**
         * @public
         * @type {string}
         */
        this.clientSessionId = null;
        /**
         * @type {AvayaCustomerServices.Base.Network.RESTProvider}
         * @private
         */
        this._requestProvider = requestProvider;
        /**
         * @type {AvayaCustomerServices.Base.Network.AtmosphereProvider}
         * @private
         */
        this._notificationProvider = notificationProvider;
        /**
         * @type {AvayaCustomerServices.Providers.Common.MessageParser}
         * @private
         */
        this._notificationParser = notificationParser;
        /**
         * @type {AvayaCustomerServices.Config.CommonConfiguration}
         * @private
         */
        this._config = config;
        /**
         * @type {AvayaCustomerServices.Providers.Common.UrlBuilder}
         * @private
         */
        this._urlProvider = new AvayaCustomerServices.Providers.Common.UrlBuilder(this);
        /**
         * @function
         * @protected
         */
        this._requestProvider.on('xhr.error', _.bind(onRequestProviderError, null, this));
        /**
         * @type {AvayaCustomerServices.Base.Promise}
         * @private
         */
        this._isActivated = new Promise(_.bind(onProviderActivated, null, this));
    }

    Provider.prototype =
    /** @lends AvayaCustomerServices.Providers.Common.Provider */
    {
        /**
         * Start provider
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#start
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        start: function () {
            return new Promise(_.bind(function (resolve, reject) {
                if (this._notificationProvider.start()) {
                    resolve();
                } else {
                    reject('There was an error starting notification provider session');
                }
            }, this));
        },
        /**
         * Stop provider
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#stop
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stop: function () {
            return this._notificationProviderStarted
                .then(_.bind(function () {
                    this.clientSessionId = null;
                    this.removeListeners('agent.activated');
                    return this._notificationProvider.close();
                }, this));
        },
        /**
         * @public 
         * @since 3.8.0.1
         * @function AvayaCustomerServices.Providers.Interfaces.AbstractProvider#isMethodEnabled
         * @param {string} name Name of the method to check if it is enabled
         * @returns {boolean}
         */
        isMethodEnabled: function (name) {
            return this._config.allMethodsEnabled || this._config.disabledMethods.indexOf(name) === -1;
        },
        /**
         * Activate agent with optional profile ID and extension number
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#activateProfile
         * @param {string} handle Agent's handle
         * @param {string} [profileId] Profile ID to activate
         * @param {string} [extension] Agent's extension
         * @param {string} [clientSessionId] preceding clientSessionId used for resyncing sessions on refresh
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        activate: function (handle, profileId, extension, clientSessionId) {
            return this._notificationProviderStarted
                .then(_.bind(function (cid) {
                    var url = this._urlProvider.getActivateUrl(handle, {
                        clientSessionId: cid,
                        profileId: profileId,
                        extensionAddress: extension,
                        sdkversion: AvayaCustomerServices.version,
                        clientid: this._config.clientInfo.id,
                        oldClientSessionId: clientSessionId
                    });
                    return this._requestProvider.post(url);
                }, this))
                .catch(_.bind(function (error) {
                    var parsedError = new AvayaCustomerServices.Base.Error({
                        message: error.stack || 'Notification Provider failed to connect',
                        reason: error.message,
                        scope: this.name + ' - activate',
                        severity: 'NORMAL',
                        context: error,
                        type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
                    });
                    AvayaCustomerServices.Base.Logger.error(this.name, parsedError);
                    this.trigger('error', [parsedError]);
                }, this));
        },
        /**
         * Report that activation timeout has expired with an optional parameter 'operation'
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#reportActivateTimeout
         * @param {string} handle Agent's handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        reportActivateTimeout: function (handle) {
            return this._notificationProviderStarted
                .then(_.bind(function (cid) {
                    var url = this._urlProvider.getActivateUrl(handle, {
                        clientSessionId: cid,
                        sdkversion: AvayaCustomerServices.version,
                        clientid: this._config.clientInfo.id,
                        operation: AvayaCustomerServices.Providers.Common.Constants.ACTIVATION_TIMEOUT
                    });
                    return this._requestProvider.post(url);
                }, this))
                .catch(_.bind(function (error) {
                    var parsedError = new AvayaCustomerServices.Base.Error({
                        message: error.stack || 'Notification Provider failed to connect',
                        reason: error.message,
                        scope: this.name + ' - reportActivateTimeout',
                        severity: 'NORMAL',
                        context: error,
                        type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
                    });
                    AvayaCustomerServices.Base.Logger.error(this.name, parsedError);
                    this.trigger('error', [parsedError]);
                }, this));
        },
        /**
         * Deactivate agent
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#deactivate
         * @param {string} handle Agent's handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deactivate: function (handle) {
            return this._isActivated
                .then(_.bind(function () {
                    var url = this._urlProvider.getUserUrl(handle);
                    return this._requestProvider.del(url);
                }, this))
                .catch(_.bind(function (error) {
                    var parsedError = new AvayaCustomerServices.Base.Error({
                        message: error.stack || 'Agent has not been activated',
                        reason: error.message,
                        scope: this.name + ' - deactivate',
                        severity: 'NORMAL',
                        context: error,
                        type: AvayaCustomerServices.Base.Constants.errorType.INTERNAL_SERVICE
                    });
                    AvayaCustomerServices.Base.Logger.error(this.name, parsedError);
                    this.trigger('error', [parsedError]);
                }, this));
        },
        /**
         * Login user and set state
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#login
         * @param {string} handle Agent's handle
         * @param {string} [loginState] Set agent to state on login
         * @param {string} [workMode] Agent's work mode
         * @param {string} [notReadyReason] Reason for going not ready
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        login: function (handle, loginState, workMode, notReadyReason) {
            return this._isActivated
                .then(_.bind(function () {
                    notReadyReason = notReadyReason || AvayaCustomerServices.Providers.Common.Constants.DEFAULT_REASON;
                    loginState = loginState && loginState.toLowerCase();
                    var url = this._urlProvider.getUserUrl(handle, {
                        operation: AvayaCustomerServices.Providers.Common.Constants.LOGIN,
                        state: loginState || AvayaCustomerServices.Providers.Common.Constants.READY,
                        workMode: workMode,
                        reason: loginState === AvayaCustomerServices.Providers.Common.Constants.NOT_READY ? notReadyReason : undefined
                    });
                    return this._requestProvider.post(url);
                }, this))
                .catch(_.bind(function (error) {
                    var parsedError = new AvayaCustomerServices.Base.Error({
                        message: error.stack || 'Agent has not been activated',
                        reason: error.message,
                        scope: this.name + ' - login',
                        severity: 'NORMAL',
                        context: error,
                        type: AvayaCustomerServices.Base.Constants.errorType.SERVER
                    });
                    AvayaCustomerServices.Base.Logger.error(this.name, parsedError);
                    this.trigger('error', [parsedError]);
                }, this));
        },
        /**
         * Logout user
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#logout
         * @param {string} handle Agent's handle
         * @param {string} [logoutReason] Reason for logging out
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        logout: function (handle, logoutReason) {
            var url = this._urlProvider.getUserUrl(handle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.LOGOUT,
                reason: logoutReason || AvayaCustomerServices.Providers.Common.Constants.DEFAULT_REASON
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set Agent's state to "Ready"
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#goReady
         * @param {string} handle Agent's handle
         * @param {string} [workMode] Agent's work mode
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goReady: function (handle, workMode) {
            var url = this._urlProvider.getUserUrl(handle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.STATE,
                state: AvayaCustomerServices.Providers.Common.Constants.READY,
                workMode: workMode
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set Agent's state to "Not Ready"
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#goNotReady
         * @param {string} handle Agent's handle
         * @param {string} [notReadyReason] Reason for going not ready
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goNotReady: function (handle, notReadyReason) {
            var url = this._urlProvider.getUserUrl(handle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.STATE,
                state: AvayaCustomerServices.Providers.Common.Constants.NOT_READY,
                reason: notReadyReason || AvayaCustomerServices.Providers.Common.Constants.DEFAULT_REASON
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set Agent's state to "After Contact Work"
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#goAfterContactWork
         * @param {string} handle Agent's handle
         * @param {string} [afterContactWorkReason] Reason for going after contact work
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goAfterContactWork: function (handle, afterContactWorkReason) {
            var url = this._urlProvider.getUserUrl(handle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.STATE,
                state: AvayaCustomerServices.Providers.Common.Constants.AFTER_CONTACT_WORK,
                reason: afterContactWorkReason || AvayaCustomerServices.Providers.Common.Constants.DEFAULT_REASON
            });
            return this._requestProvider.post(url);
        },
        /**
         * Create/update User Preference
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#setUserPreference
         * @param {string} handle Agent's handle
         * @param {string} payload JSON encoded payload
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @param {string} [clientSessionId] Client Session ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setUserPreference: function (handle, payload, profileId, accountId, clientSessionId) {
            var url = this._urlProvider.getUserPreferenceUrl(handle, profileId, accountId, clientSessionId);
            return this._requestProvider.post(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Remove User Preference
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#removeUserPreference
         * @param {string} handle Agent's handle
         * @param {string} payload JSON encoded payload
         * @param {string} [profileId] Profile ID to set User Preference for
         * @param {string} [accountId] Account ID to set User Preference for
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeUserPreference: function (handle, payload, profileId, accountId) {
            var url = this._urlProvider.getUserPreferenceUrl(handle, profileId, accountId);
            return this._requestProvider.del(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Create/update System Preference
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#setSystemPreference
         * @param {string} clientId Client ID
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setSystemPreference: function (clientId, payload) {
            var url = this._urlProvider.getSystemPreferenceUrl(clientId);
            return this._requestProvider.post(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Remove System Preference
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#removeSystemPreference
         * @param {string} clientId Client ID
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeSystemPreference: function (clientId, payload) {
            var url = this._urlProvider.getSystemPreferenceUrl(clientId);
            return this._requestProvider.del(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Get configuration settings for a user.
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#getConfiguration
         * @param {string} [authServerUser] Deprecated: User's ID used during authentication
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        getConfiguration: function (authServerUser) {
            var url = this._urlProvider.getConfigurationUrl(authServerUser, {
                sdkversion: AvayaCustomerServices.version,
                clientid: this._config.clientInfo.id
            });
            return this._requestProvider.get(url, '', { headers: { 'Cache-Control': 'no-cache, no-store, must-revalidate' } })
                .catch(_.bind(function (error) {
                    var errorData = AvayaCustomerServices.Base.Utils.toJSON(error.responseText);
                    AvayaCustomerServices.Base.Logger.error(this.name, errorData);
                    this.trigger('error', [errorData]);
                    throw errorData;
                }, this));
        },
        /**
         * Get client sessions for a user.
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#getClientSessions
         * @param {string} authServerUser User's ID used during authentication
         * @returns {AvayaCustomerServices.Base.Promise} Promise
         */
        getClientSessions: function (authServerUser) {
            return this._notificationProviderStarted
                .then(_.bind(function () {
                    var url = this._urlProvider.getActivateUrl(authServerUser, {
                        sdkversion: AvayaCustomerServices.version,
                        clientid: this._config.clientInfo.id
                    });

                    return this._requestProvider.get(url);
                }, this))
                .catch(_.bind(function (error) {
                    var errorData = AvayaCustomerServices.Base.Utils.toJSON(error.responseText);
                    AvayaCustomerServices.Base.Logger.error(this.name, errorData);
                    this.trigger('error', [errorData]);
                }, this));
        },
        /**
         * Initiate an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#initiate
         * @param {string} handle Agent's handle
         * @param {string} type Type of interaction to initiate
         * @param {string} [address] Remote address to connect with
         * @param {string} [subType] Additional param to indicate interaction specifics (e.g. voice mailbox)
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        initiate: function (handle, type, address, subType) {
            var url = this._urlProvider.getInteractionUrl(handle, null, null, {
                type: type,
                address: address,
                subType: subType
            });
            return this._requestProvider.post(url);
        },
        /**
         * Accept an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#accept
         * @param {string} handle Agent handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        accept: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.ACCEPT,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Put an interaction on hold
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#hold
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        hold: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.HOLD,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Unhold an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#unhold
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        unhold: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.UNHOLD,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * End an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#end
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {object} [options] Object of extra query params
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        end: function (handle, interaction, options) {
            var params = _.assignIn({}, options, {
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, params);
            return this._requestProvider.del(url);
        },
        /**
         * End team member interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#endMemberInteraction
         * @param {string} handle Agent's handle
         * @param {string} teamMemberUserHandle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {object} params Object of extra params
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        endMemberInteraction: function (handle, teamMemberUserHandle, interaction, params) {
            var url = this._urlProvider.getTeamMemberEndIntreactionUrl(handle, teamMemberUserHandle, interaction.workRequestId, interaction.id, params);
            return this._requestProvider.del(url);
        },
        /**
         * Reject an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#reject
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        reject: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.del(url);
        },
        /**
         * Defer an email interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#defer
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} interval Interval to defer interaction for
         * @param {string} reason Defer reason
         * @param {object} [payload] Payload for draft
         * @param {object} [options] Options for draft
         * @param {object} [options={}] Options to set content-type
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        defer: function (handle, interaction, interval, reason, payload, options) {
            var url;
            if (_.isUndefined(payload)) {
                url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                    operation: AvayaCustomerServices.Providers.Common.Constants.DEFER,
                    interval: interval,
                    reason: reason,
                    resourceAddress: interaction.data.resourceAddress,
                    providerId: interaction.data.providerId
                });
            }
            else {
                url = this._urlProvider.getMessageUrl(handle, interaction.workRequestId, interaction.id, {
                    operation: AvayaCustomerServices.Providers.Common.Constants.DEFER,
                    interval: interval,
                    reason: reason
                });
            }
            return this._requestProvider.post(url, payload, options);
        },
        /**
         * Defer forward email interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#defer
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} interval Interval to defer interaction for
         * @param {string} reason Defer reason
         * @param {object} payload Payload for draft
         * @param {object} [options] Options for draft
         * @param {object} [options={}] Options to set content-type
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deferForward: function (handle, interaction, interval, reason, payload, options) {
            var url = this._urlProvider.getMessageUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.DEFER_FORWARD,
                interval: interval,
                reason: reason
            });

            return this._requestProvider.post(url, payload, options);
        },
        /**
         * Perform a single step blind transfer on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#transfer
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} address Remote address to transfer interaction to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transfer: function (handle, interaction, address) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.TRANSFER,
                address: address,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Perform a single step blind transfer to service on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#transferToService
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} serviceId id to transfer interaction to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transferToService: function (handle, interaction, serviceId) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.TRANSFER,
                service: serviceId,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Perform a single step blind transfer to user on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#transferToUser
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} userId id to transfer interaction to
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        transferToUser: function (handle, interaction, userId) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.TRANSFER,
                user: userId,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Perform a consult to service on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#consultToService
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} serviceId id to consult interaction to
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultToService: function (handle, interaction, serviceId, uui) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.CONSULT,
                service: serviceId,
                uui: uui,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Perform a single step blind transfer to service on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#getServices
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getServices: function (handle, interaction) {
            var url = this._urlProvider.getServicesUrl(handle, interaction.workRequestId, interaction.id, {
                channelType: interaction.data.channel
            });
            return this._requestProvider.get(url)
                .catch(function () {
                    return [];
                });
        },
        /**
         * Performs a search for given users matching searchText
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#getServices
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} searchText search text
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getUsers: function (handle, interaction, searchText) {
            var url = this._urlProvider.getUsersUrl(handle, interaction.workRequestId, interaction.id, {
                userNameSearchString: searchText,
                channelType: interaction.data.channel
            });
            return this._requestProvider.get(url)
                .catch(function () {
                    return [];
                });
        },
        /**
         * Performs a retrieval of a deferred interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#retrieveDeferredInteraction
         * @param {string} handle Agent's handle
         * @param {string} deferredInteractionId Deferred Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        retrieveDeferredInteraction: function (handle, deferredInteractionId) {
            var url = this._urlProvider.getRetrieveDeferredInteractionUrl(handle, deferredInteractionId, {
                operation: AvayaCustomerServices.Providers.Common.Constants.RETRIEVE
            });
            return this._requestProvider.post(url);
        },
        /**
         * Perform a consult action on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#consult
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} address Remote address to consult
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consult: function (handle, interaction, address, uui) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.CONSULT,
                address: address,
                uui: uui,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Perform a consult to user on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#consultToUser
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} userId id of user to consult
         * @param {string} [uui] Optional User to User Information
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultToUser: function (handle, interaction, userId, uui) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.CONSULT,
                user: userId,
                uui: uui,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * End an interaction by transferring to consultative address
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#consultCompleteAsTransfer
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultCompleteAsTransfer: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.CONSULT_COMPLETE,
                reason: AvayaCustomerServices.Providers.Common.Constants.AS_TRANSFER_REASON,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Complete an interaction by conferencing with consultative address
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#consultCompleteAsConference
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        consultCompleteAsConference: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.CONSULT_COMPLETE,
                reason: AvayaCustomerServices.Providers.Common.Constants.AS_CONFERENCE_REASON,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set work code on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#setWorkCode
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} workCode Work Code to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setWorkCode: function (handle, interaction, workCode) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.WORK_CODE,
                reason: workCode,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set disposition code on an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#setDispositionCode
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} dispositionCode Disposition Code to set
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setDispositionCode: function (handle, interaction, dispositionCode) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.DISPOSITION_CODE,
                reason: dispositionCode,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Send DTMF digits to an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#sendDTMF
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @param {string} dtmf DTMF character
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendDTMF: function (handle, interaction, dtmf) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.DTMF,
                address: dtmf,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Remove interaction media file attachments
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#removeAttachments
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @param {string} [attachmentId] ID of attachment to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeAttachments: function (handle, workRequestId, interactionId, attachmentId) {
            var url = this._urlProvider.getAttachmentsUrl(handle, workRequestId, interactionId, attachmentId);
            return this._requestProvider.del(url);
        },
        /**
         * Apply draft interaction media file attachments
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#applyDraftAttachments
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyDraftAttachments: function (handle, workRequestId, interactionId) {
            var url = this._urlProvider.getAttachmentsUrl(handle, workRequestId, interactionId);
            return this._requestProvider.put(url);
        },
        /**
         * Apply outgoing forward attachments
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#applyForwardAttachments
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyForwardAttachments: function (handle, workRequestId, interactionId) {
            var url = this._urlProvider.getAttachmentsUrl(handle, workRequestId, interactionId, null, {
                operation: AvayaCustomerServices.Providers.Common.Constants.APPLY_FORWARD
            });
            return this._requestProvider.put(url);
        },
        /**
         * Apply outgoing approval attachments
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#applyApprovalAttachments
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        applyApprovalAttachments: function (handle, workRequestId, interactionId) {
            var url = this._urlProvider.getAttachmentsUrl(handle, workRequestId, interactionId, null, {
                operation: AvayaCustomerServices.Providers.Common.Constants.APPLY_APPROVAL
            });
            return this._requestProvider.put(url);
        },
        /**
         * Extend After Contact Work for an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#extendACW
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        extendACW: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.EXTEND_ACW,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Complete After Contact Work for an interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#completeACW
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        completeACW: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.COMPLETE_ACW,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Send a message to an interaction media provider
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#sendMessage
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @param {string} channel Interaction channel
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendMessage: function (handle, workRequestId, interactionId, channel, payload) {
            var url = this._urlProvider.getMessageUrl(handle, workRequestId, interactionId, { channelType: channel });
            return this._requestProvider.post(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Send an email message
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#sendEmailMessage
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @param {string} channel Interaction channel
         * @param {string} payload JSON encoded payload
         * @param {string} [data.type] Type of the email 
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        sendEmailMessage: function (handle, workRequestId, interactionId, channel, payload, type) {
            var url = this._urlProvider.getMessageUrl(handle, workRequestId, interactionId, {
                operation: type,
                channelType: channel
            });
            return this._requestProvider.post(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Reject an email message by the Approver
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#rejectEmailMessage
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @param {string} channel Interaction channel
         * @param {string} payload JSON encoded payload
         * @param {string} [data.rejectedCode] Rejected
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        rejectEmailMessage: function (handle, workRequestId, interactionId, channel, payload, rejectCode) {
            var url;
            url = this._urlProvider.getMessageUrl(handle, workRequestId, interactionId, {
                operation: AvayaCustomerServices.Providers.Common.Constants.REJECTED,
                reason: rejectCode,
                channelType: channel
            });
            return this._requestProvider.post(url, payload, { headers: { 'Content-Type': 'application/json' } });
        },
        /**
         * Add a participant to conversation
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#addParticipant
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @param {string} address Address of participant to add
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        addParticipant: function (handle, workRequestId, interactionId, address) {
            var url = this._urlProvider.getParticipantsUrl(handle, workRequestId, interactionId, {
                address: address
            });
            return this._requestProvider.post(url);
        },
        /**
         * Remove a participant from conversation
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#removeParticipant
         * @param {string} handle Agent's handle
         * @param {string} workRequestId Work Request ID
         * @param {string} interactionId Interaction ID
         * @param {string} participantId ID of participant to remove
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        removeParticipant: function (handle, workRequestId, interactionId, participantId) {
            var url = this._urlProvider.getParticipantsUrl(handle, workRequestId, interactionId, {
                participantId: participantId
            });
            return this._requestProvider.del(url);
        },
        /**
         * Add a participant to conversation
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#getTeamState
         * @param {string} handle Agent's handle
         * @param {string} role User's role
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getTeamState: function (handle, role) {
            var url = this._urlProvider.getTeamStateUrl(handle, null, { role: role, groupsEnabled: true });
            return this._requestProvider.get(url);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#getTeamMemberState
         * @param {string} handle User's handle
         * @param {string} role User's role
         * @param {string} teamMemberUserHandle Agent's user handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        getTeamMemberState: function (handle, role, teamMemberUserHandle) {
            var url = this._urlProvider.getTeamStateUrl(handle, teamMemberUserHandle, { role: role });
            return this._requestProvider.get(url);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#setTeamMonitoring
         * @param {string} handle User's handle
         * @param {string} role User's role
         * @param {string} monitor boolean (cast to string) to monitor team member updates
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setTeamMonitoring: function (handle, role, monitor) {
            var url = this._urlProvider.getTeamStateUrl(handle, null, { role: role, monitor: monitor });
            return this._requestProvider.post(url);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#setTeamMemberMonitoring
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @param {string} monitor boolean (cast to string) to monitor team member updates
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        setTeamMemberMonitoring: function (handle, teamMemberUserHandle, monitor) {
            var url = this._urlProvider.getTeamStateUrl(handle, teamMemberUserHandle, { monitor: monitor });
            return this._requestProvider.post(url);
        },
        /**
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#logoutTeamMember
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @param {string} [logoutReason] Reason for logging out team member
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        logoutTeamMember: function (handle, teamMemberUserHandle, logoutReason) {
            var url = this._urlProvider.getTeamStateUrl(handle, teamMemberUserHandle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.LOGOUT,
                reason: logoutReason
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set Agent's state to "Ready". In this state, agents are available to be routed new work requests.
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#goReadyTeamMember
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goReadyTeamMember: function (handle, teamMemberUserHandle) {
            var url = this._urlProvider.getTeamStateUrl(handle, teamMemberUserHandle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.STATE,
                state: AvayaCustomerServices.Providers.Common.Constants.READY
            });
            return this._requestProvider.post(url);
        },
        /**
         * Set Agent's state to "Not Ready". In this state, agents are not available to be routed new work requests.
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#goNotReadyTeamMember
         * @param {string} handle User's handle
         * @param {string} teamMemberUserHandle Agent's user handle
         * @param {string} [notReadyReason] Reason for setting team member into a "Not Ready" state
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        goNotReadyTeamMember: function (handle, teamMemberUserHandle, notReadyReason) {
            var url = this._urlProvider.getTeamStateUrl(handle, teamMemberUserHandle, {
                operation: AvayaCustomerServices.Providers.Common.Constants.STATE,
                state: AvayaCustomerServices.Providers.Common.Constants.NOT_READY,
                reason: notReadyReason
            });
            return this._requestProvider.post(url);
        },
        /**
         * Deactivate team member, freeing up any occupied stations used by that team member.
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#deactivateTeamMember
         * @param {string} teamMemberUserHandle Agent's user handle
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        deactivateTeamMember: function (teamMemberUserHandle) {
            var url = this._urlProvider.getUserUrl(teamMemberUserHandle);
            return this._requestProvider.del(url);
        },
        /**
         * Start observing team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#startObserving
         * @param {string} handle Agent's handle
         * @param {string} teamMemberUserHandle Team Member User Handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        startObserving: function (handle, teamMemberUserHandle, interaction) {
            var url = this._urlProvider.getObserveUrl(handle, teamMemberUserHandle, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.OBSERVE
            });
            return this._requestProvider.post(url);
        },
        /**
         * Stop observing team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#stopObserving
         * @param {string} handle Agent's handle
         * @param {string} teamMemberUserHandle Team Member User Handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stopObserving: function (handle, teamMemberUserHandle, interaction) {
            var url = this._urlProvider.getObserveUrl(handle, teamMemberUserHandle, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.STOP_OBSERVE
            });
            return this._requestProvider.post(url);
        },
        /**
         * Coach team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#coach
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        coach: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.COACH,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Barge in on team member's interaction
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#bargeIn
         * @param {string} handle Agent's handle
         * @param {AvayaCustomerServices.Services.Work.Interaction} interaction
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        bargeIn: function (handle, interaction) {
            var url = this._urlProvider.getInteractionUrl(handle, interaction.workRequestId, interaction.id, {
                operation: AvayaCustomerServices.Providers.Common.Constants.BARGE_IN,
                resourceAddress: interaction.data.resourceAddress,
                providerId: interaction.data.providerId
            });
            return this._requestProvider.post(url);
        },
        /**
         * Supervisor broadcast
         *
         * @public
         * @function AvayaCustomerServices.Providers.Common.Provider#broadcast
         * @param {string} handle Supervisor's handle
         * @param {string} payload JSON encoded payload
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        broadcast: function (handle, payload) {
            var url = this._urlProvider.getSupervisorBroadcastUrl(handle);
            return this._requestProvider.post(url, payload, { headers: { 'Content-Type': 'application/json' } });
        }
    };

    /**
     * Helper function to handle request provider's onError event
     *
     * @private
     * @function onRequestProviderError
     * @param {AvayaCustomerServices.Providers.Common.Provider} provider Common Provider
     * @param {Object} error Error received from request provider
     */
    function onRequestProviderError(provider, error) {
        error = error || {};
        var errorData = AvayaCustomerServices.Base.Utils.toJSON(error.responseText);
        var parsedError = new AvayaCustomerServices.Base.Error({
            message: errorData.message || errorData.errorMessage || errorData.type || 'Unspecified XHR error',
            reason: errorData.reason,
            status: errorData.status || error.status || 0,
            code: errorData.code || errorData.applicationErrorCode || error.code || 0,
            scope: provider.name,
            severity: 'CRITICAL',
            source: provider._requestProvider.name,
            type: AvayaCustomerServices.Base.Constants.errorType.REST_PROVIDER_XHR
        });
        provider.trigger('error', [parsedError]);
    }

    /**
     * Helper function to handle Common provider's onActivated event
     *
     * @private
     * @function onProviderActivated
     * @param {AvayaCustomerServices.Providers.Common.Provider} provider Common Provider
     * @param {function} resolve Callback function to execute on promise fulfillment
     */
    function onProviderActivated(provider, resolve) {
        provider.on('agent.activated', function () {
            resolve();
        });
    }

    _.defaults(
        Provider.prototype,
        AvayaCustomerServices.Providers.Interfaces.AgentProvider.prototype,
        AvayaCustomerServices.Providers.Interfaces.WorkProvider.prototype,
        AvayaCustomerServices.Providers.Interfaces.TeamProvider.prototype
    );

    AvayaCustomerServices.Providers.Common.Provider = Provider;

})(AvayaCustomerServices, _, RSVP.Promise);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc UAC Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _, Promise) {
    'use strict';
    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.Provider
     * @requires AvayaCustomerServices.Providers.Common.Provider
     * @memberOf AvayaCustomerServices.Providers.UAC
     * @define AvayaCustomerServices.Providers.UAC.Provider
     *
     * @param {AvayaCustomerServices.Base.Network.RESTProvider} requestProvider
     * @param {AvayaCustomerServices.Base.Network.AtmosphereProvider} notificationProvider
     * @param {AvayaCustomerServices.Providers.Common.MessageParser} notificationParser
     * @param {AvayaCustomerServices.Config.UACConfiguration} config
     */
    function Provider(requestProvider, notificationProvider, notificationParser, config) {
        AvayaCustomerServices.Providers.Common.Provider.call(this, requestProvider, notificationProvider, notificationParser, config);
        /**
         * @public
         * @type {string}
         */
        this.name = 'UAC Provider';
        /**
         * @private
         * @type {number}
         */
        this._reconnectAttempts = 0;
        /**
         * @type {AvayaCustomerServices.Base.Promise}
         * @private
         */
        this._notificationProviderStarted = new Promise(_.bind(onNotificationProviderOpen, null, this));
        /**
         * @function
         * @protected
         * @param {Object} message
         */
        this._notificationProvider.onMessage = _.bind(onNotificationProviderMessage, null, this);
        /**
         * @function
         * @protected
         * @param {Object} message
         */
        this._notificationProvider.onReopen = _.bind(onNotificationProviderReopen, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onClose = _.bind(onNotificationProviderClose, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onError = _.bind(onNotificationProviderError, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onClientTimeout = _.bind(onNotificationProviderClientTimeout, null, this);
    }

    Provider.prototype =
        /** @lends AvayaCustomerServices.Providers.UAC.Provider */
        {};

    /**
     * Helper function to handle notification provider's onOpen event
     *
     * @private
     * @function onNotificationProviderOpen
     * @param {AvayaCustomerServices.Providers.UAC.Provider} provider UAC Provider
     * @param {function} resolve Callback function to execute on promise fulfillment
     * @param {function} reject Callback function to execute on promise rejection
     */
    function onNotificationProviderOpen(provider, resolve, reject) {
        provider._notificationProvider.onOpen = function (data) {
            if (data && (provider.clientSessionId === null || provider.clientSessionId === '')) {
                provider.clientSessionId = data.request.uuid;
                provider._reconnectAttempts = 0;
                resolve(provider.clientSessionId);
                AvayaCustomerServices.Base.Logger.debug('UAC Provider', {
                    reason: 'clientsession.started',
                    clientSessionId: provider.clientSessionId,
                    epoch: Date.now(),
                    context: data
                });
                provider.trigger('clientsession.started', [provider.clientSessionId]);
            } else {
                reject('There was an error starting notification provider session');
            }
        };
    }

    /**
     * Helper function to handle notification provider's onMessage event
     *
     * @private
     * @function onNotificationProviderMessage
     * @param {AvayaCustomerServices.Providers.UAC.Provider} provider UAC Provider
     * @param {object} message JSON encoded string received from notification provider
     */
    function onNotificationProviderMessage(provider, message) {
        var parsedMessage = provider._notificationParser.parse(message);
        AvayaCustomerServices.Base.Logger.debug('UAC Provider', parsedMessage);
        var eventName = parsedMessage.eventName;
        delete parsedMessage.eventName;
        try {
            provider.trigger(eventName, [parsedMessage]);
        } catch (error) {
            var parsedError = new AvayaCustomerServices.Base.Error({
                message: error.message || "Could not parse JSON",
                reason: error.stack || eventName + " error",
                scope: 'UAC Provider - ' + eventName,
                severity: 'NORMAL',
                source: 'UAC Provider: onNotificationProviderMessage',
                context: error,
                type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_AS_MESSAGE
            });
            AvayaCustomerServices.Base.Logger.error('UAC Provider', parsedError);
            provider.trigger('error', [parsedError]);
        }
    }

    /**
     * Helper function to handle notification provider's onReopen event
     *
     * @private
     * @function onNotificationProviderReopen
     * @param {AvayaCustomerServices.Providers.UAC.Provider} provider UAC Provider
     * @param {object} message JSON encoded string received from notification provider
     */
    function onNotificationProviderReopen(provider, message) {
        if (message) { // && message.receivedUuidOnReopen) {
            provider.clientSessionId = message.uuid;
            provider._reconnectAttempts = 0;
            AvayaCustomerServices.Base.Logger.debug('UAC Provider', {
                reason: 'clientsession.restarted',
                clientSessionId: provider.clientSessionId,
                epoch: Date.now(),
                context: message
            });
            provider.trigger('clientsession.restarted', [provider.clientSessionId]);
        }
    }

    /**
     * Helper function to handle notification provider's onClose event
     *
     * @private
     * @function onNotificationProviderClose
     * @param {AvayaCustomerServices.Providers.UAC.Provider} provider UAC Provider
     * @param {Object} message Message received from notification provider
     */
    function onNotificationProviderClose(provider, message) {
        var closeMessage = new AvayaCustomerServices.Base.Error({
            message: message.responseBody || message.transport + ' ' + message.state,
            reason: message.reasonPhrase,
            status: message.status,
            scope: 'Notification Provider',
            severity: 'NORMAL',
            source: provider._notificationProvider.name,
            context: message,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        AvayaCustomerServices.Base.Logger.debug('UAC Provider', closeMessage);
        var notificationConfig = provider._notificationProvider.getConfig();
        notificationConfig._onClose.fire(closeMessage);
        provider.trigger('close', [closeMessage]);
    }

    /**
     * Helper function to handle notification provider's onError event
     *
     * @private
     * @function onNotificationProviderError
     * @param {AvayaCustomerServices.Providers.UAC.Provider} provider UAC Provider
     * @param {Object} error Error received from notification provider
     */
    function onNotificationProviderError(provider, error) {
        var data = error.reasonPhrase || {};
        var errorMessage = new AvayaCustomerServices.Base.Error({
            message: data.message || error.responseBody || error.transport + ' ' + error.state,
            reason: data.name || error.reasonPhrase,
            status: error.status,
            code: data.code || 0,
            scope: 'Notification Provider',
            severity: 'CRITICAL',
            source: provider._notificationProvider.name,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        provider.trigger('error', [errorMessage]);
    }

    /**
     * Helper function to handle notification provider's onError event
     *
     * @private
     * @function onNotificationProviderClientTimeout
     * @param {AvayaCustomerServices.Providers.UAC.Provider} provider UAC Provider
     * @param {Object} error Error received from notification provider
     */
    function onNotificationProviderClientTimeout(provider, error) {
        var data = error.reasonPhrase || {};
        var errorMessage = new AvayaCustomerServices.Base.Error({
            message: data.message || error.responseBody || error.transport + ' ' + error.state,
            reason: data.name || error.reasonPhrase,
            status: error.status,
            code: data.code || 0,
            scope: 'Notification Provider',
            severity: 'CRITICAL',
            source: provider._notificationProvider.name,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        provider.trigger('clientsession.closed', [errorMessage]);

        var notificationProviderConfig = provider._notificationProvider.getConfig();
        provider._notificationProvider.close();
        if (provider._reconnectAttempts++ < notificationProviderConfig.maxReconnectOnClose) {
            setTimeout(function () {
                provider._notificationProvider.start(provider.clientSessionId);
            }, notificationProviderConfig.reconnectInterval);
        }
    }

    _.defaults(Provider.prototype, AvayaCustomerServices.Providers.Common.Provider.prototype);

    AvayaCustomerServices.Providers.UAC.Provider = Provider;

})(AvayaCustomerServices, _, RSVP.Promise);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 * @since 3.4.0.0
 * @classdesc Collection for managing an array of {@link Provider} types.
 */
(function (AvayaCustomerServices, _) {
    'use strict';
    /**
     * Constructor function for Provider Collection
     *
     * @class
     * @define AvayaCustomerServices.Base.Mediator.ProviderCollection
     * @memberOf AvayaCustomerServices.Base.Mediator
     * @requires AvayaCustomerServices.Providers.UAC.Provider
     * @requires AvayaCustomerServices.Base.Collections.Collection
     * @extends AvayaCustomerServices.Base.Collections.Collection
     * 
     * @description Constructor function for ProviderCollection
     * @param {{idAttribute}} [options] Model options   
     */
    function ProviderCollection(options) {
        AvayaCustomerServices.Base.Collections.Collection.call(this, AvayaCustomerServices.Base.Mediator.Provider, options);
        /**
         * Mediator used for managing the link between services and providers
         *
         * @private
         * @type {AvayaCustomerServices.Base.Mediator}
         */
        this._mediator = new AvayaCustomerServices.Base.Mediator();
        /**
         * Used to override the default model id used in collections
         * 
         * @protected
         * @type {string}
         */
        this._modelId = 'configKey';
    }

    ProviderCollection.prototype =
    /** @lends AvayaCustomerServices.Base.Mediator.ProviderCollection */
    {
        /**
         * @public
         * @function AvayaCustomerServices.Base.Mediator.ProviderCollection#createProvider
         * @param {AvayaCustomerServices.Base.Mediator.PrerequisiteCollection} prerequisiteCollection
         * @param {Object} config
         * @param {string} configKey
         */
        createProvider: function (prerequisiteCollection, config, configKey) {
            var providerData = _.find(ProviderCollection.Types, { key: configKey });
            if (!providerData) {
                return;
            }
            var prerequisites = prerequisiteCollection.fetchByName(providerData.prerequisites);

            var provider = providerData.initialise(config, prerequisites);
            provider.configKey = configKey;
            this.add(provider);

            this._mediator.injectProvider(provider, providerData.provider);

            if (config.onInit && typeof config.onInit === 'function') {
                config.onInit(provider);
            }
        },
        /**
         * @public
         * @function AvayaCustomerServices.Base.Mediator.ProviderCollection#updateProvider
         * @param {Object} config
         * @param {string} configKey
         */
        updateProvider: function (config, configKey) {
            var provider = this.find({ id: configKey });
            if (!provider) {
                return;
            }
            _.assignIn(provider.data._config, config);
        },
        /**
        * @public
        * @function AvayaCustomerServices.Base.Mediator.ProviderCollection#removeProvider
        * @param {string} configKey
        */
        removeProvider: function (configKey) {
            var providerData = _.find(ProviderCollection.Types, { key: configKey });
            if (!providerData) {
                return;
            }

            var provider = providerData.destroy();
            this.remove(provider);

            this._mediator.removeProvider(providerData.provider);
        },
        /**
        * @public
        * @function AvayaCustomerServices.Base.Mediator.ProviderCollection#getMediator
        * @returns {AvayaCustomerServices.Base.Mediator}
        */
        getMediator: function () {
            return this._mediator;
        },
        /**
        * @public
        * @function AvayaCustomerServices.Base.Mediator.ProviderCollection#removeMediator
        * @returns {null}
        */
        removeMediator: function () {
            this._mediator = null;
            return this._mediator;
        }
    };

    /**
     * ProviderCollection types used for bootstrapping providers and their dependencies
     *
     * @private
     * @type {Object[]}
     */
    ProviderCollection.Types = [{
        provider: 'UAC',
        key: 'uacConfiguration',
        prerequisites: ['tokenCollection'],
        model: AvayaCustomerServices.Providers.UAC.Provider,
        initialise: function (config, prerequisites) {
            var uacProviderFactory = new AvayaCustomerServices.Providers.UAC.ProviderFactory(prerequisites.tokenCollection);
            return uacProviderFactory.init(config);
        },
        destroy: function () { }
    }, {
        provider: 'ADF',
        key: 'adfConfiguration',  
        prerequisites: ['tokenCollection'],
        model: AvayaCustomerServices.Providers.ADF.Provider,
        initialise: function (config, prerequisites) {
            var adfProviderFactory = new AvayaCustomerServices.Providers.ADF.ProviderFactory(prerequisites.tokenCollection);
            return adfProviderFactory.init(config);
        },
        destroy: function () { }
    }, {
        provider: 'CP',
        key: 'cpConfiguration',
        model: AvayaCustomerServices.Providers.CP.Provider,
        initialise: function (config) {
            var cpProviderFactory = new AvayaCustomerServices.Providers.CP.ProviderFactory();
            return cpProviderFactory.init(config);
        },
        destroy: function () { }
    }, {
        provider: 'Kazoo',
        key: 'kazooConfiguration',
        model: AvayaCustomerServices.Providers.Kazoo.Provider,
        initialise: function (config) {
            var kazooProviderFactory = new AvayaCustomerServices.Providers.Kazoo.ProviderFactory();
            return kazooProviderFactory.init(config);
        },
        destroy: function () { }
    }, {
        provider: 'Spoken',
        key: 'spokenConfiguration',
        model: AvayaCustomerServices.Providers.Spoken.Provider,
        initialise: function (config) {
            var spokenProviderFactory = new AvayaCustomerServices.Providers.Spoken.ProviderFactory();
            return spokenProviderFactory.init(config);
        },
        destroy: function () { }
    }];

    _.defaults(ProviderCollection.prototype, AvayaCustomerServices.Base.Collections.Collection.prototype);

    AvayaCustomerServices.Base.Mediator.ProviderCollection = ProviderCollection;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc ADF Provider
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.1.0
 */
(function (AvayaCustomerServices, _, Promise) {
    'use strict';
    /**
     * @class     
     * @extends AvayaCustomerServices.Providers.Common.Provider
     * @requires AvayaCustomerServices.Providers.Common.Provider
     * @memberOf AvayaCustomerServices.Providers.ADF
     * @define AvayaCustomerServices.Providers.ADF.Provider
     *
     * @param {AvayaCustomerServices.Base.Network.RESTProvider} requestProvider
     * @param {AvayaCustomerServices.Base.Network.WebSocketProvider} webSocketProvider
     * @param {AvayaCustomerServices.Providers.Common.MessageParser} notificationParser
     * @param {AvayaCustomerServices.Config.ADFConfiguration} config
     */
    function Provider(requestProvider, webSocketProvider, notificationParser, config) {
        AvayaCustomerServices.Providers.Common.Provider.call(this, requestProvider, webSocketProvider, notificationParser, config);
        /**
         * @public
         * @type {string}
         */
        this.name = 'ADF Provider';
        /**
         * @function
         * @protected
         */
        this._isActivated = null;
        /**
         * @function
         * @protected
         */
        this._notificationProviderStarted = null;
        /**
         * @function
         * @protected
         * @param {Object} message
         */
        this._notificationProvider.onFirstMessage = _.bind(onNotificationProviderFirstMessage, null, this);
        /**
         * @function
         * @protected
         * @param {Object} message
         */
        this._notificationProvider.onMessage = _.bind(onNotificationProviderMessage, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onClose = _.bind(onNotificationProviderClose, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onError = _.bind(onNotificationProviderError, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onClientTimeout = _.bind(onNotificationProviderClientTimeout, null, this);
        /**
         * @function
         * @protected
         */
        this._notificationProvider.onMaxReconnects = _.bind(onNotificationProviderMaxReconnects, null, this);
    }

    Provider.prototype =
    /** @lends AvayaCustomerServices.Providers.ADF.Provider */
    {
        /**
         * Start provider
         *
         * @public
         * @function AvayaCustomerServices.Providers.ADF.Provider#start
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        start: function () {
            this._notificationProviderStarted = onNotificationProviderConnected(this);
            this._isActivated = onProviderActivated(this);

            return new Promise(_.bind(function (resolve, reject) {
                if (this._notificationProvider.start()) {
                    resolve();
                } else {
                    reject('There was an error starting notification provider session');
                }
            }, this));
        },
        /**
         * Stop provider
         *
         * @public
         * @function AvayaCustomerServices.Providers.ADF.Provider#stop
         * @returns {AvayaCustomerServices.Base.Promise}
         */
        stop: function () {
            return this._notificationProviderStarted
                .then(_.bind(function () {
                    this.clientSessionId = null;
                    this.removeListeners('agent.activated');
                    return this._notificationProvider.close();
                }, this));
        },
    };

    /**
     * Helper function to handle notification provider's onOpen event
     *
     * @private
     * @function onNotificationProviderConnected
     * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
     * @param {function} resolve Callback function to execute on promise fulfillment
     * @param {function} reject Callback function to execute on promise rejection
     */
    function onNotificationProviderConnected(provider) {
        return new Promise(function (resolve, reject) {
            provider.on('clientsession.started', function (clientSessionId) {
                resolve(clientSessionId);
            });
            provider.on('clientsession.restarted', function (clientSessionId) {
                resolve(clientSessionId);
            });
            provider.on('close', function (message) {
                reject(message);
            });
            provider.on('error', function (error) {
                reject(error);
            });
            provider.on('clientsession.closed', function (error) {
                reject(error);
            });
        });
    }

    /**
    * Helper function to handle notification provider's onFirstMessage event
    *
    * @private
    * @function onNotificationProviderFirstMessage
    * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
    * @param {object} message JSON encoded string received from notification provider
    * @param {boolean} isReOpen Is this event fired as a result of a reconnect attempt?
    */
    function onNotificationProviderFirstMessage(provider, message, isReOpen) {
        if (message && message.clientSession) {
            provider.clientSessionId = message.clientSession;
            var eventName = isReOpen ? 'clientsession.restarted' : 'clientsession.started';
            AvayaCustomerServices.Base.Logger.debug('ADF Provider', {
                reason: eventName,
                clientSessionId: provider.clientSessionId,
                epoch: Date.now(),
                context: { message: message, isReOpen: isReOpen }
            });
            provider.trigger(eventName, [provider.clientSessionId]);
        } else {
            var parsedError = new AvayaCustomerServices.Base.Error({
                message: 'There was an error starting notification provider session',
                reason: 'ClientSessionId = ' + message.clientSessionId,
                scope: 'ADF Provider',
                severity: 'NORMAL',
                source: 'ADF Provider: onNotificationProviderMessage',
                context: message,
                type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_AS_MESSAGE
            });
            AvayaCustomerServices.Base.Logger.error('ADF Provider', parsedError);
            provider.trigger('error', [parsedError]);
        }
    }

    /**
     * Helper function to handle notification provider's onMessage event
     *
     * @private
     * @function onNotificationProviderMessage
     * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
     * @param {object} message JSON encoded string received from notification provider
     */
    function onNotificationProviderMessage(provider, message) {
        var parsedMessage = provider._notificationParser.parse({ responseBody: message });
        AvayaCustomerServices.Base.Logger.debug('ADF Provider', parsedMessage);
        var eventName = parsedMessage.eventName;
        delete parsedMessage.eventName;
        try {
            provider.trigger(eventName, [parsedMessage]);
        } catch (error) {
            var parsedError = new AvayaCustomerServices.Base.Error({
                message: error.message || "Could not parse JSON",
                reason: error.stack || eventName + " error",
                scope: 'ADF Provider - ' + eventName,
                severity: 'NORMAL',
                source: 'ADF Provider: onNotificationProviderMessage',
                context: error,
                type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_AS_MESSAGE
            });
            AvayaCustomerServices.Base.Logger.error('ADF Provider', parsedError);
            provider.trigger('error', [parsedError]);
        }
    }

    /**
     * Helper function to handle notification provider's onClose event
     *
     * @private
     * @function onNotificationProviderClose
     * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
     * @param {Object} message Message received from notification provider
     */
    function onNotificationProviderClose(provider, message) {
        var closeMessage = new AvayaCustomerServices.Base.Error({
            message: message.responseBody || message.transport + ' ' + message.state,
            reason: message.reasonPhrase,
            status: message.status,
            scope: 'Notification Provider',
            severity: 'NORMAL',
            source: provider._notificationProvider.name,
            context: message,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        AvayaCustomerServices.Base.Logger.debug('ADF Provider', closeMessage);
        var notificationConfig = provider._notificationProvider.getConfig();
        notificationConfig._onClose.fire(closeMessage);
        provider.trigger('close', [closeMessage]);
    }

    /**
     * Helper function to handle notification provider's onError event
     *
     * @private
     * @function onNotificationProviderError
     * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
     * @param {Object} error Error received from notification provider
     */
    function onNotificationProviderError(provider, error) {
        var data = error.reasonPhrase || {};
        var errorMessage = new AvayaCustomerServices.Base.Error({
            message: data.message || error.responseBody || error.transport + ' ' + error.state,
            reason: data.name || error.reasonPhrase,
            status: error.status,
            code: data.code || 0,
            scope: 'Notification Provider',
            severity: 'CRITICAL',
            source: provider._notificationProvider.name,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        provider.trigger('error', [errorMessage]);
    }

    /**
     * Helper function to handle notification provider's onError event
     *
     * @private
     * @function onNotificationProviderClientTimeout
     * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
     * @param {Object} data Error received from notification provider
     */
    function onNotificationProviderClientTimeout(provider, data) {
        var errorMessage = new AvayaCustomerServices.Base.Error({
            message: data.message,
            reason: data.reason,
            code: data.code || 0,
            scope: 'Notification Provider',
            severity: 'CRITICAL',
            source: provider._notificationProvider.name,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        provider.trigger('clientsession.closed', [errorMessage]);
    }

    /**
     * Helper function to handle notification provider's onError event
     *
     * @private
     * @function onNotificationProviderClientTimeout
     * @param {AvayaCustomerServices.Providers.ADF.Provider} provider ADF Provider
     * @param {Object} error Error received from notification provider
     */
    function onNotificationProviderMaxReconnects(provider) {
        var errorMessage = new AvayaCustomerServices.Base.Error({
            message: 'Maximum WebSocket reconnect attempts reached',
            reason: 'Maximum number of WebSocket reconnect attempts reached - ' + provider._notificationProvider._maxReconnectAttempts,
            scope: 'Notification Provider',
            severity: 'CRITICAL',
            source: provider._notificationProvider.name,
            type: AvayaCustomerServices.Base.Constants.errorType.NOTIFICATION_PROVIDER_CONNECTION
        });
        provider.trigger('clientsession.max_reconnects', [errorMessage]);
    }

    /**
     * Helper function to handle Common provider's onActivated event
     *
     * @private
     * @function onProviderActivated
     * @param {AvayaCustomerServices.Providers.Common.Provider} provider Common Provider
     * @param {function} resolve Callback function to execute on promise fulfillment
     */
    function onProviderActivated(provider) {
        return new Promise(function (resolve, reject) {
            provider.on('agent.activated', function () {
                resolve();
            });
        });
    }

    _.defaults(Provider.prototype, AvayaCustomerServices.Providers.Common.Provider.prototype);

    AvayaCustomerServices.Providers.ADF.Provider = Provider;

})(AvayaCustomerServices, _, RSVP.Promise);

/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc After Contact Work Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @requires AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentAfterContactWorkPendingStateEvent
     */
    function AgentAfterContactWorkPendingStateEvent(response) {
        AvayaCustomerServices.Providers.Common.AgentStateMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_STATE_AFTER_CONTACT_WORK_PENDING, response.newValue);
        /**
         * @public
         * @type {string}
         */
        this.reasonCode = response.newValue.stateReason;
    }

    _.defaults(AgentAfterContactWorkPendingStateEvent.prototype, AvayaCustomerServices.Providers.Common.AgentStateMessage.prototype);

    AvayaCustomerServices.Providers.Common.AgentAfterContactWorkPendingStateEvent = AgentAfterContactWorkPendingStateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc After Contact Work Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @requires AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentAfterContactWorkStateEvent
     */
    function AgentAfterContactWorkStateEvent(response) {
        AvayaCustomerServices.Providers.Common.AgentStateMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_STATE_AFTER_CONTACT_WORK, response.newValue);
        /**
         * @public
         * @type {string}
         */
        this.reasonCode = response.newValue.stateReason;
    }

    _.defaults(AgentAfterContactWorkStateEvent.prototype, AvayaCustomerServices.Providers.Common.AgentStateMessage.prototype);

    AvayaCustomerServices.Providers.Common.AgentAfterContactWorkStateEvent = AgentAfterContactWorkStateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Not Ready Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @requires AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentCompleteStateEvent
     */
    function AgentCompleteStateEvent(response) {
        AvayaCustomerServices.Providers.Common.AgentStateMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_STATE_COMPLETE, response.newValue);
    }

    _.defaults(AgentCompleteStateEvent.prototype, AvayaCustomerServices.Providers.Common.AgentStateMessage.prototype);

    AvayaCustomerServices.Providers.Common.AgentCompleteStateEvent = AgentCompleteStateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Logged Out Agent State Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @requires AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Providers.Common.AgentLoggedOutStateEvent
     */
    function AgentLoggedOutStateEvent(response) {
        AvayaCustomerServices.Providers.Common.AgentStateMessage.call(this, AvayaCustomerServices.Providers.Common.MessageTypes.eventName.AGENT_STATE_LOGGED_OUT, response.newValue);
        /**
         * @public
         * @type {string}
         */
        this.reasonCode = response.newValue.stateReason;
    }

    _.defaults(AgentLoggedOutStateEvent.prototype, AvayaCustomerServices.Providers.Common.AgentStateMessage.prototype);

    AvayaCustomerServices.Providers.Common.AgentLoggedOutStateEvent = AgentLoggedOutStateEvent;

})(AvayaCustomerServices, _);
/*
 * Copyright Avaya Inc., All Rights Reserved. THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya.
 * The modifications are Copyright Avaya Inc., All Rights Reserved. Avaya - Confidential & Restricted.
 * May not be distributed further without written permission of the Avaya owner.
 */
/**
 * @classdesc Not Ready Agent Event
 * @author John Brennan [brennan5@avaya.com]
 * @version 3.8.2.0
 */
(function (AvayaCustomerServices, _) {
    'use strict';

    /**
     * @class
     * @extends AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @requires AvayaCustomerServices.Providers.Common.AgentStateMessage
     * @memberOf AvayaCustomerServices.Providers.Common
     * @define AvayaCustomerServices.Pr