(function (window, $) {
    'use strict';

    function ContactsView(handlers) {
        BaseView.apply(this);

        this.searchContactInput = $("#searchContactInput");
        this.searchBtn = $("#searchBtn");
        this.searchResults = $("#searchResults");
        this.searchResultsFor = $("#searchResultsFor");

        this.searchBtn.on('click', function () {
            handlers.handleStartSearch(this.searchContactInput.val());
        }.bind(this));

        this.searchResults.on('click', '.detailsContactBtn', function (event) {
            handlers.handleShowDetails($(event.target).attr('data-id'));
        });
    }

    ContactsView.prototype = Object.create(BaseView.prototype);

    /**
     * Function set search title.
     *
     * @param {String} searchString
     */
     ContactsView.prototype.setSearchTitle = function (searchString) {
        this.searchResultsFor.text('For "' + searchString + '"');
    };

    /**
     * Add contacts to the search results.
     *
     * @param {string} id
     * @param {string} name
     * @param {string} surname
     */
    ContactsView.prototype.addContact = function (id, name, surname) {
        var entry = `
            <div id="${id}" class="col-xs-4 no-padding-left">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <span class="lead detailsContactBtn" data-id="${id}">
                            ${surname}, ${name} (${name})
                        </span>
                    </div>
                </div>
            </div>
        `;

        this.searchResults.append(entry);
    };

    /**
     * Remove contact from search results.
     * 
     * @param {string} id
     */
    ContactsView.prototype.removeContact = function (id) {
        this.searchResults.find($("#" + id)).remove();
    };

    window.ContactsView = ContactsView;

})(window, jQuery);
