(function (window, $) {
    'use strict';

    function ContactView() {
        this.contactModal = $('#contactModal');
        this.contactForm = $("#contactForm");

        this.phoneNumbersContainer = $("#phoneNumbersContainer");
        this.emailAddressesContainer = $("#emailAddressesContainer");
        this.IMAddressesContainer = $("#IMAddressesContainer");

        this.contactModalTitle = $("#contactModalTitle");

        this.contactFirstName = $("#contactFirstName");
        this.contactFirstNameASCII = $("#contactFirstNameASCII");
        this.contactAlias = $("#contactAlias");
        this.contactCompany = $("#contactCompany");

        this.contactLastName = $("#contactLastName");
        this.contactLastNameASCII = $("#contactLastNameASCII");
        this.contactLocation = $("#contactLocation");
        this.contactManager = $("#contactManager");

        this.contactDisplayName = $("#contactDisplayName");
        this.contactDisplayNameASCII = $("#contactDisplayNameASCII");
        this.contactWorkRoomNumber = $("#contactWorkRoomNumber");
        this.contactDepartment = $("#contactDepartment");

        this.contactStreetAddress = $("#contactStreetAddress");
        this.contactCity = $("#contactCity");

        this.contactState = $("#contactState");
        this.contactNotes = $("#contactNotes");
        this.contactTerminalName = $("#contactTerminalName");

        this.contactCountry = $("#contactCountry");
        this.contactScopiaUserId = $("#contactScopiaUserID");

        this.contactPostalCode = $("#contactPostalCode");
        this.contactTerminalId = $("#contactTerminalID");

        this.contactModal.modal({
            show: false
        });
    }


    ContactView.prototype = {
        /**
         * Function set detail modal title.
         *
         * @param {String} displayName
         */
        setContactModalTitle: function (displayName) {
            if (displayName) {
                this.contactModalTitle.text('Contact ' + displayName);
            } else {
                this.contactModalTitle.text('Unmarked Contact');
            }
        },

        /**
         * Function set all contacts data in form inputs.
         *
         * @param {Object} contactData
         */
        setAllContactData: function (contactData) {
            this.contactFirstName.val(contactData.contactFirstName);
            this.contactFirstNameASCII.val(contactData.contactFirstNameASCII);
            this.contactAlias.val(contactData.contactAlias);
            this.contactCompany.val(contactData.contactCompany);

            this.contactLastName.val(contactData.contactLastName);
            this.contactLastNameASCII.val(contactData.contactLastNameASCII);
            this.contactLocation.val(contactData.contactLocation);
            this.contactManager.val(contactData.contactManager);

            this.contactDisplayName.val(contactData.contactDisplayName);
            this.contactDisplayNameASCII.val(contactData.contactDisplayNameASCII);
            this.contactWorkRoomNumber.val(contactData.contactWorkRoomNumber);
            this.contactDepartment.val(contactData.contactDepartment);

            this.contactStreetAddress.val(contactData.contactStreetAddress);
            this.contactCity.val(contactData.contactCity);

            this.contactState.val(contactData.contactState);
            this.contactNotes.val(contactData.contactNotes);
            this.contactTerminalName.val(contactData.contactTerminalName);
            this.contactCountry.val(contactData.contactCountry);
            this.contactScopiaUserId.val(contactData.contactScopiaUserId);

            this.contactPostalCode.val(contactData.contactPostalCode);
            this.contactTerminalId.val(contactData.contactTerminalId);
        },
        
        /**
         * Function clear contact details modal.
         */
        resetContactForm: function () {
            this.contactForm.trigger('reset');

            this.phoneNumbersContainer.empty();
            this.emailAddressesContainer.empty();
            this.IMAddressesContainer.empty();
        },
        /**
         * Function show contact modal.
         */
        showContactModal: function () {
            this.contactModal.modal('show');
        },

        /**
         * Function hide contact modal.
         */
        hideContactModal: function () {
            this.contactModal.modal('hide');
        },

        /**
         * Add phone numbers HTML container to contact details.
         *
         * @param {Object} phoneNumberData
         */
        addPhoneNumber: function (phoneNumberData) {
            var phoneNumber = '<div class="row"><hr>' +
                                  '<div class="col-md-4">' +
                                      '<div class="form-group">' +
                                          '<label for="phoneNumber' + phoneNumberData.index + '">Phone Number</label>' +
                                          '<input type="text" class="form-control" id="phoneNumber' + phoneNumberData.index + '" value="' + phoneNumberData.phoneNumber + '" />' +
                                      '</div>' +
                                      '<div class="form-group">' +
                                          '<label for="phoneNumberType' + phoneNumberData.index + '">Phone Number Type</label>' +
                                          '<input type="text" class="form-control" id="phoneNumberType' + phoneNumberData.index + '" value="' + phoneNumberData.phoneNumberType + '" />' +
                                      '</div>' +
                                  '</div>' +
                                  '<div class="col-md-4">' +
                                      '<div class="form-group">' +
                                          '<label for="label1_' + phoneNumberData.index + '">Label 1</label>' +
                                          '<input type="text" class="form-control" id="label1_' + phoneNumberData.index + '" value="' + (phoneNumberData.label1 || '') + '" />' +
                                      '</div>' +
                                      '<div class="form-group">' +
                                          '<div class="checkbox">' +
                                              '<label for="speedDialEnabled' + phoneNumberData.index + '">' +
                                                  '<input id="speedDialEnabled' + phoneNumberData.index + '" type="checkbox" ' + (phoneNumberData.speedDialEnabled ? 'checked' : '') + ' />' +
                                                  'Speed Dial Enabled' +
                                              '</label>' +
                                          '</div>' +
                                      '</div>' +
                                      '<div class="form-group">' +
                                          '<div class="checkbox">' +
                                              '<label for="phoneNumberDefault' + phoneNumberData.index + '">' +
                                                  '<input id="phoneNumberDefault' + phoneNumberData.index + '" type="checkbox" ' + (phoneNumberData.default ? 'checked' : '') + ' />' +
                                                  'Default Phone Number' +
                                              '</label>' +
                                          '</div>' +
                                      '</div>' +  
                                  '</div>' +
                                  '<div class="col-md-4">' +
                                      '<div class="form-group">' +
                                          '<label for="label2_' + phoneNumberData.index + '">Label 2</label>' +
                                          '<input type="text" class="form-control" id="label2_' + phoneNumberData.index + '" value="' + (phoneNumberData.label2 || '') + '" />' +
                                      '</div>' +
                                  '</div>' +
                              '</div>';
            this.phoneNumbersContainer.append(phoneNumber);
        },

        /**
         * Add email addresses HTML container to contact details.
         *
         * @param {Object} emailAddressData
         */
        addEmailAddress: function (emailAddressData) {
            var emailAddress = '<div class="row"><hr>' +
                                   '<div class="col-md-4">' +
                                        '<div class="form-group">' +
                                            '<label for="emailAddress' + emailAddressData.index + '">Email Address</label>' +
                                            '<input type="text" class="form-control" id="emailAddress' + emailAddressData.index + '" value="' + emailAddressData.emailAddress + '" />' +
                                        '</div>' +
                                    '</div>' +
                                    '<div class="col-md-4">' +
                                        '<div class="form-group">' +
                                            '<label for="emailAddressType' + emailAddressData.index + '">Email Address Type</label>' +
                                            '<input type="text" class="form-control" id="emailAddressType' + emailAddressData.index + '" value="' + emailAddressData.emailAddressType + '" />' +
                                        '</div>' +
                                        '<div class="form-group">' +
                                            '<div class="checkbox">' +
                                                '<label for="emailAddressDefault' + emailAddressData.index + '">' +
                                                    '<input id="emailAddressDefault' + emailAddressData.index + '" type="checkbox" ' + (emailAddressData.default ? 'checked' : '') + ' />' +
                                                    'Default Email Address' +
                                                '</label>' +
                                            '</div>' +
                                        '</div>' +
                                    '</div>' +
                               '</div>';
            this.emailAddressesContainer.append(emailAddress);
        },

        /**
         * Add IM addresses HTML container to contact details.
         *
         * @param {Object} IMAddressData
         */
        addIMAddress: function (IMAddressData) {
            var IMAddress = '<div class="row"><hr>' +
                                '<div class="col-md-4">' +
                                    '<div class="form-group">' +
                                        '<label for="IMAddress' + IMAddressData.index + '">IM Address</label>' +
                                        '<input type="text" class="form-control" id="IMAddress' + IMAddressData.index + '" value="' + IMAddressData.IMAddress + '" />' +
                                    '</div>' +
                                '</div>' +
                                '<div class="col-md-4">' +
                                    '<div class="form-group">' +
                                        '<label for="IMAddressType' + IMAddressData.index + '">IM Address Type</label>' +
                                        '<input type="text" class="form-control" id="IMAddressType' + IMAddressData.index + '" value="' + IMAddressData.IMAddressType + '" />' +
                                    '</div>' +
                                '</div>' +
                            '</div>';
            this.IMAddressesContainer.append(IMAddress);
        },
    };

    window.ContactView = ContactView;

})(window, jQuery);
