(function (window, $) {
    'use strict';

    function SettingsView(handlers) {
        BaseView.apply(this);

        this.hostname = $('#hostname');
        this.port = $('#port');
        this.login = $('#login');
        this.password = $('#password');

        this.callsServiceTab = $('#callsServiceTab');
        this.callService = $('#callService');
        this.contactsServiceTab = $('#contactsServiceTab');
        this.contactsService = $('#contactsService');

        this.save = $('#saveSettings');
        this.save.on('click', function () {
            this.lock();

            handlers.save({
                hostname: this.hostname.val(),
                port: this.port.val(),
                login: this.login.val(),
                password: this.password.val(),
            })
        }.bind(this));

        this.SDKVersion = $('#SDKVersion');
        this.serviceTitle = $('#servicesTitle');

        this.SDKVersion.text(handlers.clientVersion);
    }

    SettingsView.prototype = Object.create(BaseView.prototype);

    /**
     * Clear error list when registration has succeed.
     */
    SettingsView.prototype.clientRegistrationSuccessful = function () {
        this.clearErrors();
    };

    /**
     * Print error and reset form if registration has failed.
     *
     * @param {string} [message]
     */
    SettingsView.prototype.clientRegistrationFailed = function (message) {
        this.unlock();
        
        var error = 'Login failed';
        if (message) {
            error += ': ' + message;
        }

        this.printError(error);
    };

    /**
     * Reveal Contacts tab.
     */
    SettingsView.prototype.showContactsTab = function () {
        this.contactsServiceTab.removeClass('hide');
        this.contactsService.removeClass('hide');
    };

    /**
     * Disable form.
     */
    SettingsView.prototype.lock = function () {
        this._toggleLock(true);
    };

    /**
     * Reset form.
     */
    SettingsView.prototype.unlock = function () {
        this._toggleLock(false);
    };

    /**
     * Set form enabled or disabled.
     *
     * @param {boolean} disabled
     */
    SettingsView.prototype._toggleLock = function (disabled) {
        this.hostname.prop('disabled', disabled);
        this.port.prop('disabled', disabled);
        this.login.prop('disabled', disabled);
        this.password.prop('disabled', disabled);
        this.save.prop('disabled', disabled);
    };

    window.SettingsView = SettingsView;

})
(window, jQuery);
