(function (window, $) {
    'use strict';

    function CallsView (handlers, isRegistered) {
        BaseView.apply(this);

        this.isRegistered = isRegistered;
        
        this.displayName = $('#displayName');
        this.roomId = $('#roomId');
        this.makeAudioCallBtn = $("#audioCallBtn");
        this.makeVideoCallBtn = $("#videoCallBtn");

        this.makeAudioCallBtn.off('click').on('click', function () {
            this.lock();

            handlers.makeCall(
                this.roomId.val(),
                false,
                this.displayName.val()
            );
        }.bind(this));

        this.makeVideoCallBtn.off('click').on('click', function () {
            this.lock();

            handlers.makeCall(
                this.roomId.val(),
                true,
                this.displayName.val()
            );
        }.bind(this));

        this._init();
    }

    CallsView.prototype = Object.create(BaseView.prototype);

    CallsView.prototype._init = function () {
        this.unlock();
    };

    CallsView.prototype.lock = function () {
        this._toggleLock(true);
    };

    CallsView.prototype.unlock = function () {
        this._toggleLock(false);
    };

    CallsView.prototype._toggleLock = function (disabled) {
        this.displayName.prop('disabled', this.isRegistered === true ? true : disabled);
        this.roomId.prop('disabled', disabled);
        this.makeAudioCallBtn.prop('disabled', disabled);
        this.makeVideoCallBtn.prop('disabled', disabled);
    };

    CallsView.prototype.createCallTemplate = function () {
        return $('#templates .callView').clone(true, true);
    };

    CallsView.prototype.addCallTemplate = function (template) {
        $('#calls').prepend(template);
    };

    CallsView.prototype.removeTemplate = function (template) {
        template.remove();
    };

    window.CallsView = CallsView;

})(window, jQuery);
