////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// Controller  - Sample Client //////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

var _iframeId = 'iframeDiv';
var _csinstance = null;
var _useSecure = false;


function contextStoreInit() {

    console.info('Load Complete ' + '[jQuery]: ' + $().jquery);
    console.info('Successfully Initilized');

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /////////////////////////// Validate URL parameters and fork the code workflow  ////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    registerCallbacksUI();

}

function authorizationSettings() {
    if ($("#enableAuthorization").is(':checked')) {
        $("#Authorization").show();
    } else {
        $("#Authorization").hide();
    }
}

function toggleUseSecure() {
    if ($("#useSecure").is(':checked')) {
        _useSecure = true;
    } else {
        _useSecure = false;
    }
}

function createInstance() {
    var clusterIP = $('#clusterIP').val();
    var guestUsage = ($("#enableAuthorization").is(':checked') ? false : true);
    resetResponse();

    _csconfig = new AvayaDataStoreClient.Config.CsConfiguration();
    console.info('Context Store Engine Load Complete');
    console.info('[jQuery]: ' + $().jquery);
    _csconfig.isGuest = guestUsage;
    if (!guestUsage) {
        var token = $('#token').val();
        _csconfig.serverInfo.token = token;
    }
    _csconfig.serverInfo.hostName = clusterIP;
    _csconfig.serverInfo.isSecure = _useSecure;
    _csconfig.enabled = true;
    var _contextStoreClient = new AvayaDataStoreClient(_csconfig);
    _contextStoreClient.registerlogger(window.console);
    _csinstance = _contextStoreClient.createDataStoreService(_csconfig);
}

function createInstanceWithoutAuthorization() {
    var clusterIP = $('#clusterIP').val();
    resetResponse();

    _csconfig = new AvayaDataStoreClient.Config.CsConfiguration();
    console.info('Context Store Engine Load Complete');
    console.info('[jQuery]: ' + $().jquery);
    _csconfig.isGuest = true;
    _csconfig.serverInfo.hostName = clusterIP;
    _csconfig.serverInfo.isSecure = _useSecure;
    _csconfig.enabled = true;
    var _contextStoreClient = new AvayaDataStoreClient(_csconfig);
    _contextStoreClient.registerlogger(window.console);
    _csinstance = _contextStoreClient.createDataStoreService(_csconfig);
}

function buildContextData(data, contextId, alias1, alias2, alias3, groupId, tenantId) {
    if (groupId !== "") {
        var newData = data.replace(/^\{/gi, "");
        data = "{\"groupId\":\"" + groupId + "\"," + newData;
    }
    if (tenantId !== "") {
        var newData = data.replace(/^\{/gi, "");
        data = "{\"tenantId\":\"" + tenantId + "\"," + newData;
    }
    if (contextId !== "") {
        var newData = data.replace(/^\{/gi, "");
        data = "{\"contextId\":\"" + contextId + "\"," + newData;
    }
    if (alias1 !== "" || alias2 !== "" || alias3 !== "") {
        var newData = data.replace(/^\{/gi, "");
        var aliases = [];
        if (alias1 !== "") {
            aliases.push(alias1);
        }
        if (alias2 !== "") {
            aliases.push(alias2);
        }
        if (alias3 !== "") {
            aliases.push(alias3);
        }
        data = "{\"alias\":" + JSON.stringify(aliases) + "," + newData;

    }
    return data;

}

function resetRequestDetails() {
    $('#requestMethodName').text('');
    $('#requestBody').text('');

    if (document.getElementById('requestDetail')) {
        document.getElementById('requestDetail').style.display = 'none';
    }
    document.getElementById('progressDiv').style.display = 'none';
}

function resetResponse() {
    $('#responseMessageSuccess').text('');
    $('#responseMessageError').text('');
    $('#responseMessageErrorCode').text('');
    if (document.getElementById('responseAlertSuccess')) {
        document.getElementById('responseAlertSuccess').style.display = 'none';
    }
    if (document.getElementById('responseAlertError')) {
        document.getElementById('responseAlertError').style.display = 'none';
    }
}

function requestDetails(methodName, requestBody) {
    resetRequestDetails();
    $('#requestMethodName').text(methodName);
    document.getElementById('requestBodyLabel').style.display = 'block';
    if (requestBody === "") {
        document.getElementById('requestBodyLabel').style.display = 'none';
    }
    $('#requestBody').text(requestBody);
    document.getElementById('requestDetail').style.display = 'block';
    $('#progressMessage').text('Processing...');
    document.getElementById('progressBar').className = 'progress-bar progress-bar-info progress-bar-striped active';
    document.getElementById('progressDiv').style.display = 'block';
}

function onSuccess(response) {
    $('#response').val(JSON.stringify(response));
    $('#responseMessageSuccess').text(JSON.stringify(response));
    document.getElementById('responseAlertSuccess').style.display = 'block';
    $('#progressMessage').text('Complete');
    document.getElementById('progressBar').className = 'progress-bar progress-bar-success';
}

function onFailure(error) {
    var err = error._reason.responseText;
    var requestType = "Request";
    console.error(requestType + ' FAILED: ' + err);
    if (err === "") {
        err = "Connection to Context Store Failed. Please ensure IP has been set or check connection";
    } else {
        $('#responseMessageErrorCode').text(error._reason.status);
    }
    $('#responseMessageError').text(err);
    document.getElementById('responseAlertError').style.display = 'block';
    $('#progressMessage').text('Failed');
    document.getElementById('progressBar').className = 'progress-bar progress-bar-danger';
}


function generateToken() {
    var scope = $('#scope').val();
    var username = $('#username').val();
    var password = $('#password').val();

    this.createInstanceWithoutAuthorization();

    var onTokenSuccess = function (response) {
        var generatedToken = response.token;
        $('#token').val(generatedToken);
        $('#responseMessageSuccess').text(generatedToken);
        document.getElementById('responseAlertSuccess').style.display = 'block';
    };

    var onTokenFailure = function (error) {
        var err = error._reason.responseText;
        console.error('Token Generatation FAILED: ' + err);
        $('#token').val(err);
        $('#responseMessageError').text(err);
        $('#responseMessageErrorCode').text(error._reason.status);
        document.getElementById('responseAlertError').style.display = 'block';
    };

    _csinstance.generateToken(scope, username, password).then(onTokenSuccess, onTokenFailure);

}

function verifyContextStore() {
    requestDetails('verifyContextStore', "");
    this.createInstance();
    _csinstance.getContextStoreStatus().then(onSuccess, onFailure);
}

function createContext() {
    var contextId = $('#contextId-Create-input').text().trim();
    var aliasId = $('#alias1-Create-input').text().trim();
    var aliasId2 = $('#alias2-Create-input').text().trim();
    var aliasId3 = $('#alias3-Create-input').text().trim();
    var sid = $('#sid-Create-input').text().trim();
    var rid = $('#rid-Create-input').text().trim();
    var touchpoint = $('#touchpoint-Create-input').text().trim();
    var lease = $('#lease-Create-input').text().trim();
    var rules = $('#rules-Create-input').text().trim();
    var shortId = $('#shortId-Create-input').text().trim();
    var groupId = $('#groupId-Create-input').text().trim();
    var tenantId = $('#tenantId-Create-input').text().trim();
    var data = $('#contextData').val();
    data = buildContextData(data, contextId, aliasId, aliasId2, aliasId3, groupId, tenantId);

    requestDetails('createContext', data);
    this.createInstance();
    _csinstance.createContext(data, sid, rid, touchpoint, lease, rules, shortId).then(onSuccess, onFailure);
}

function upsertContext() {
    var contextId = $('#upsertContextId').val();
    var sid = $('#sid-Upsert-input').text().trim();
    var rid = $('#rid-Upsert-input').text().trim();
    var touchpoint = $('#touchpoint-Upsert-input').text().trim();
    var lease = $('#lease-Upsert-input').text().trim();
    var rules = $('#rules-Upsert-input').text().trim();
    var aliasId = $('#alias1-Upsert-input').text().trim();
    var aliasId2 = $('#alias2-Upsert-input').text().trim();
    var aliasId3 = $('#alias3-Upsert-input').text().trim();
    var data = $('#upsertContextData').val();
    data = buildContextData(data, "", aliasId, aliasId2, aliasId3, "", "");

    requestDetails('upsertContext', data);
    this.createInstance();
    _csinstance.upsertContext(contextId, data, sid, rid, touchpoint, lease, rules).then(onSuccess, onFailure);
}

function upsertContextByAliasId() {
    var aliasId = $('#upsertByAliasId').val();
    var contextId = $('#contextId-UpsertByAliasId-input').text().trim();
    var sid = $('#sid-UpsertByAliasId-input').text().trim();
    var rid = $('#rid-UpsertByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-UpsertByAliasId-input').text().trim();
    var lease = $('#lease-UpsertByAliasId-input').text().trim();
    var rules = $('#rules-UpsertByAliasId-input').text().trim();
    var aliasId1 = $('#alias1-UpsertByAliasId-input').text().trim();
    var aliasId2 = $('#alias2-UpsertByAliasId-input').text().trim();
    var aliasId3 = $('#alias3-UpsertByAliasId-input').text().trim();
    var data = $('#upsertContextDataByAliasId').val();
    data = buildContextData(data, "", aliasId1, aliasId2, aliasId3, "", "");

    requestDetails('upsertContextByAliasId', data);
    this.createInstance();
    _csinstance.upsertContextByAliasId(aliasId, data, sid, rid, touchpoint, lease, rules).then(onSuccess, onFailure);
}

function getContext() {
    var contextId = $('#getContextId').val();
    var sid = $('#sid-GetContext-input').text().trim();
    var rid = $('#rid-GetContext-input').text().trim();
    var touchpoint = $('#touchpoint-GetContext-input').text().trim();

    requestDetails('getContext', "");
    this.createInstance();
    _csinstance.getContext(contextId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getContextMeta() {
    var contextId = $('#getContextMeta').val();
    var sid = $('#sid-GetContextMeta-input').text().trim();
    var rid = $('#rid-GetContextMeta-input').text().trim();
    var touchpoint = $('#touchpoint-GetContextMeta-input').text().trim();

    requestDetails('getContextWithMetaData', "");
    this.createInstance();
    _csinstance.getContextWithMetaData(contextId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getValueByContextId() {
    var key = $('#getValueKeyByContextId').val();
    var contextId = $('#getValueByContextId').val();
    var sid = $('#sid-GetValueByContextId-input').text().trim();
    var rid = $('#rid-GetValueByContextId-input').text().trim();
    var touchpoint = $('#touchpoint-GetValueByContextId-input').text().trim();

    requestDetails('getValueByContextId', "");
    this.createInstance();
    _csinstance.getValueByContextId(contextId, key, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getContextByAliasId() {
    var aliasId = $('#getContextByAliasId').val();
    var sid = $('#sid-GetContextByAliasId-input').text().trim();
    var rid = $('#rid-GetContextByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-GetContextByAliasId-input').text().trim();

    requestDetails('getContextByAliasId', "");
    this.createInstance();
    _csinstance.getContextByAliasId(aliasId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getContextByAliasIdMeta() {
    var aliasId = $('#getContextByAliasIdMeta').val();
    var sid = $('#sid-GetContextByAliasIdMeta-input').text().trim();
    var rid = $('#rid-GetContextByAliasIdMeta-input').text().trim();
    var touchpoint = $('#touchpoint-GetContextByAliasIdMeta-input').text().trim();

    requestDetails('getContextByAliasIdWithMetaData', "");
    this.createInstance();
    _csinstance.getContextByAliasIdWithMetaData(aliasId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getValueByAliasId() {
    var key = $('#getValueKeyByAliasId').val();
    var aliasId = $('#getValueByAliasId').val();
    var sid = $('#sid-GetValueByAliasId-input').text().trim();
    var rid = $('#rid-GetValueByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-GetValueByAliasId-input').text().trim();

    requestDetails('getValueByAliasId', "");
    this.createInstance();
    _csinstance.getValueByAliasId(aliasId, key, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getGroup() {
    var groupId = $('#getGroupId').val();
    var sid = $('#sid-GetGroup-input').text().trim();
    var rid = $('#rid-GetGroup-input').text().trim();

    requestDetails('getGroup', "");
    this.createInstance();
    _csinstance.getGroup(groupId, sid, rid).then(onSuccess, onFailure);
}

function getGroupByAliasId() {
    var aliasId = $('#getGroupByAliasId').val();
    var sid = $('#sid-GetGroupByAliasId-input').text().trim();
    var rid = $('#rid-GetGroupByAliasId-input').text().trim();

    requestDetails('getGroupByAliasId', "");
    this.createInstance();
    _csinstance.getGroupByAliasId(aliasId, sid, rid).then(onSuccess, onFailure);
}


function getContextIdByAliasId() {
    var aliasId = $('#getContextIdByAliasId').val();
    var sid = $('#sid-GetContextIdByAliasId-input').text().trim();
    var rid = $('#rid-GetContextIdByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-GetContextIdByAliasId-input').text().trim();

    requestDetails('getContextIdByAliasId', "");
    this.createInstance();
    _csinstance.getContextIdByAliasId(aliasId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getAliasesByContextId() {
    var contextId = $('#getAliasesByContextId').val();
    var sid = $('#sid-GetAliasesByContextId-input').text().trim();
    var rid = $('#rid-GetAliasesByContextId-input').text().trim();
    var touchpoint = $('#touchpoint-GetAliasesByContextId-input').text().trim();

    requestDetails('getAliasesByContextId', "");
    this.createInstance();
    _csinstance.getAliasesByContextId(contextId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function updateContext() {
    var contextId = $('#updateContextId').val();
    var sid = $('#sid-Update-input').text().trim();
    var rid = $('#rid-Update-input').text().trim();
    var touchpoint = $('#touchpoint-Update-input').text().trim();
    var lease = $('#lease-Update-input').text().trim();
    var rules = $('#rules-Update-input').text().trim();
    var groupId = $('#groupId-Update-input').text().trim();
    var data = $('#updateContextData').val();
    data = buildContextData(data, "", "", "", "", "", "");

    requestDetails('updateContext', data);
    this.createInstance();
    _csinstance.updateContext(contextId, data, sid, rid, touchpoint, lease, rules, groupId).then(onSuccess, onFailure);
}

function updateValueByContextId() {
    var key = $('#updateValueKeyByContextId').val();
    var contextId = $('#updateValueByContextId').val();
    var value = $('#updateContextDataValue').val();
    var sid = $('#sid-UpdateValueByContextId-input').text().trim();
    var rid = $('#rid-UpdateValueByContextId-input').text().trim();
    var touchpoint = $('#touchpoint-UpdateValueByContextId-input').text().trim();
    var lease = $('#lease-UpdateValueByContextId-input').text().trim();

    requestDetails('updateValueByContextId', value);
    this.createInstance();
    _csinstance.updateValueByContextId(contextId, key, value, sid, rid, touchpoint, lease).then(onSuccess, onFailure);
}

function updateContextByAliasId() {
    var aliasId = $('#updateByAliasId').val();
    var sid = $('#sid-UpdateByAliasId-input').text().trim();
    var rid = $('#rid-UpdateByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-UpdateByAliasId-input').text().trim();
    var lease = $('#lease-UpdateByAliasId-input').text().trim();
    var rules = $('#rules-UpdateByAliasId-input').text().trim();
    var groupId = $('#groupId-UpdateByAliasId-input').text().trim();
    var data = $('#updateContextDataByAliasId').val();
    data = buildContextData(data, "", "", "", "", "", "");

    requestDetails('updateContextByAliasId', data);
    this.createInstance();
    _csinstance.updateContextByAliasId(aliasId, data, sid, rid, touchpoint, lease, rules, groupId).then(onSuccess, onFailure);
}

function updateValueByAliasId() {
    var key = $('#updateValueKeyByAliasId').val();
    var aliasId = $('#updateValueByAliasId').val();
    var value = $('#updateValueDataByAliasId').val();
    var sid = $('#sid-UpdateValueByAliasId-input').text().trim();
    var rid = $('#rid-UpdateValueByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-UpdateValueByAliasId-input').text().trim();
    var lease = $('#lease-UpdateValueByAliasId-input').text().trim();

    requestDetails('updateValueByAliasId', value);
    this.createInstance();
    _csinstance.updateValueByAliasId(aliasId, key, value, sid, rid, touchpoint, lease).then(onSuccess, onFailure);
}

function updateAliasesByContextId() {
    var contextId = $('#updateAliasesContextIdByContextId').val();
    var sid = $('#sid-UpdateAliasesByContextId-input').text().trim();
    var rid = $('#rid-UpdateAliasesByContextId-input').text().trim();
    var touchpoint = $('#touchpoint-UpdateAliasesByContextId-input').text().trim();
    var lease = $('#lease-UpdateAliasesByContextId-input').text().trim();
    var data = $('#updateAliasesByContextId').val();

    requestDetails('updateAliasesByContextId', data);
    this.createInstance();
    _csinstance.updateAliasesByContextId(contextId, data, sid, rid, touchpoint, lease).then(onSuccess, onFailure);
}

function updateAliasesByAliasId() {
    var aliasId = $('#updateAliasesAliasIdByAliasId').val();
    var sid = $('#sid-UpdateAliasesByAliasId-input').text().trim();
    var rid = $('#rid-UpdateAliasesByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-UpdateAliasesByAliasId-input').text().trim();
    var lease = $('#lease-UpdateAliasesByAliasId-input').text().trim();
    var data = $('#updateAliasesByAliasId').val();

    requestDetails('updateAliasesByAliasId', data);
    this.createInstance();
    _csinstance.updateAliasesByAliasId(aliasId, data, sid, rid, touchpoint, lease).then(onSuccess, onFailure);
}

function deleteContext() {
    var contextId = $('#deleteContextId').val();
    var sid = $('#sid-Delete-input').text().trim();
    var rid = $('#rid-Delete-input').text().trim();

    requestDetails('deleteContext', "");
    this.createInstance();
    _csinstance.deleteContext(contextId, sid, rid).then(onSuccess, onFailure);
}

function deleteValueByContextId() {
    var key = $('#deleteValueKeyByContextId').val();
    var contextId = $('#deleteValueByContextId').val();
    var sid = $('#sid-DeleteValueByContextId-input').text().trim();
    var rid = $('#rid-DeleteValueByContextId-input').text().trim();
    var touchpoint = $('#touchpoint-DeleteValueByContextId-input').text().trim();

    requestDetails('deleteValueByContextId', "");
    this.createInstance();
    _csinstance.deleteValueByContextId(contextId, key, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function deleteContextByAliasId() {
    var aliasId = $('#deleteContextByAliasId').val();
    var sid = $('#sid-DeleteByAliasId-input').text().trim();
    var rid = $('#rid-DeleteByAliasId-input').text().trim();

    requestDetails('deleteContextByAliasId', "");
    this.createInstance();
    _csinstance.deleteContextByAliasId(aliasId, sid, rid).then(onSuccess, onFailure);
}

function deleteValueByAliasId() {
    var key = $('#deleteValueKeyByAliasId').val();
    var aliasId = $('#deleteValueByAliasId').val();
    var sid = $('#sid-DeleteValueByAliasId-input').text().trim();
    var rid = $('#rid-DeleteValueByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-DeleteValueByAliasId-input').text().trim();

    requestDetails('deleteValueByAliasId', "");
    this.createInstance();
    _csinstance.deleteValueByAliasId(aliasId, key, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function deleteAliasByAliasId() {
    var aliasId = $('#deleteAliasByAliasId').val();
    var sid = $('#sid-DeleteAliasByAliasId-input').text().trim();
    var rid = $('#rid-DeleteAliasByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-DeleteAliasByAliasId-input').text().trim();

    requestDetails('deleteAliasByAliasId', "");
    this.createInstance();
    _csinstance.deleteAliasByAliasId(aliasId, sid, rid, touchpoint).then(onSuccess, onFailure);
}


function getAuditByContextId() {
    var contextId = $('#getAuditByContextId').val();
    var sid = $('#sid-GetAuditByContextId-input').text().trim();
    var rid = $('#rid-GetAuditByContextId-input').text().trim();
    var touchpoint = $('#touchpoint-GetAuditByContextId-input').text().trim();

    requestDetails('getAuditByContextId', "");
    this.createInstance();
    _csinstance.getAuditByContextId(contextId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getAuditByAliasId() {
    var aliasId = $('#getAuditByAliasId').val();
    var sid = $('#sid-GetAuditByAliasId-input').text().trim();
    var rid = $('#rid-GetAuditByAliasId-input').text().trim();
    var touchpoint = $('#touchpoint-GetAuditByAliasId-input').text().trim();

    requestDetails('getAuditByAliasId', "");
    this.createInstance();
    _csinstance.getAuditByAliasId(aliasId, sid, rid, touchpoint).then(onSuccess, onFailure);
}

function getEDMEntry() {
    var contextId = $('#getEDMEntry').val();
    var diff = '';
    var data = '';
    var metadata = '';
    var schema = '';

    if ($("#diff-GetEDMEntry").is(':checked')) {
        diff = 'true';
    }
    if ($("#data-GetEDMEntry").is(':checked')) {
        data = 'true';
    }
    if ($("#metadata-GetEDMEntry").is(':checked')) {
        metadata = 'true';
    }

    if ($("#schema-GetEDMEntry").is(':checked')) {
        schema = 'true';
    }
    requestDetails('getEDMEntry', "");
    this.createInstance();
    _csinstance.getEDMEntry(contextId, diff, data, metadata, schema).then(onSuccess, onFailure);
}

function getEDMEntryAudit() {
    var contextId = $('#getEDMEntryAudit').val();
    var diff = '';
    var data = '';
    var metadata = '';
    var schema = '';

    if ($("#diff-GetEDMEntryAudit").is(':checked')) {
        diff = 'true';
    }
    if ($("#data-GetEDMEntryAudit").is(':checked')) {
        data = 'true';
    }
    if ($("#metadata-GetEDMEntryAudit").is(':checked')) {
        metadata = 'true';
    }

    if ($("#schema-GetEDMEntryAudit").is(':checked')) {
        schema = 'true';
    }
    requestDetails('getEDMEntryAudit', "");
    this.createInstance();
    _csinstance.getEDMEntryAudit(contextId, diff, data, metadata, schema).then(onSuccess, onFailure);
}

function getEDMGroupAudit() {
    var groupId = $('#getEDMGroupAudit').val();
    var diff = '';
    var data = '';
    var metadata = '';
    var schema = '';

    if ($("#diff-GetEDMGroupAudit").is(':checked')) {
        diff = 'true';
    }
    if ($("#data-GetEDMGroupAudit").is(':checked')) {
        data = 'true';
    }
    if ($("#metadata-GetEDMGroupAudit").is(':checked')) {
        metadata = 'true';
    }

    if ($("#schema-GetEDMGroupAudit").is(':checked')) {
        schema = 'true';
    }
    requestDetails('getEDMGroupAudit', "");
    this.createInstance();
    _csinstance.getEDMGroupAudit(groupId, diff, data, metadata, schema).then(onSuccess, onFailure);
}


function registerCallbacksUI() {

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////// Callbacks from GUI //////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    var key = null;

    //Request new context creation
    $("#avCreateBtn").click(function () {
        this.createContext();

    });
}

function cleanup() {
    $('#contextData').val('');
}

function openRequest(evt, reqName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(reqName).style.display = "block";
    evt.currentTarget.className += " active";
}


/* Set the width of the side navigation to 250px */
function openNav() {
    document.getElementById("mySidenav").style.width = "250px";
}

/* Set the width of the side navigation to 0 */
function closeNav() {
    document.getElementById("mySidenav").style.width = "0";
}

function editLabel(element) {
    var txt = $("#" + element).text();
    if (txt === '') {
        txt = $("#" + element).val();
    }
    $("#" + element).replaceWith("<input id='" + element + "' maxlength='30' type='text' />");
    $("#" + element).val(txt);
}

function saveLabel(element) {
    var txt = $(this).val();
    $(this).replaceWith("<span id='" + element + "' class='" + element.class + "' ></span>");
    if (txt !== '') {
        $("#" + element).text(txt);
    } else {
        $("#" + element).text('"+element.default+"');
    }
}

$(document).on("click", "span.queryParams", function () {
    var clickedID = $(this).attr('id');
    var txt = $("#" + clickedID).text();
    var pl = $(this).attr('title');
    if (txt === '') {
        txt = $("#" + clickedID).val();
    }
    $("#clearField").hide();
    $("#" + clickedID).replaceWith("<input class='queryParams queryInput' id='" + clickedID + "' maxlength='30' type='text' /><span id='" + clickedID + "_clearField' class='glyphicon glyphicon-remove queryInput' onClick='clearLabel(this);' ></span></span>");
    $("#" + clickedID).attr("placeholder", pl);
    $("#" + clickedID).val(txt);
});

function clearLabel(self) {
    var str = $(self).attr('id');
    var objId = str.slice(0, -"_clearField".length);
    var selfId = self.id;
    $("#" + objId).val('');
    $("#" + selfId).remove();
    $("#" + objId).blur();
}

$(document).on("blur", "input.queryInput", function () {

    var blurredID = this.id;
    var txt = $(this).val();
    var pl = $(this).attr('placeholder');
    if (txt !== '' && txt !== pl) {
        if (!(blurredID.includes('input'))) {
            $(this).replaceWith("<span class='label label-success queryParams' id='" + blurredID + "-input' ><span class='glyphicon glyphicon-ok' > " + txt + " </span></span>");
        } else {
            $(this).replaceWith("<span class='label label-success queryParams' id='" + blurredID + "' ><span class='glyphicon glyphicon-ok' > " + txt + " </span></span>");
        }

        $("#" + blurredID + "-input").attr("title", pl);
    } else {
        $(this).replaceWith("<span class='label label-default queryParams' id='" + blurredID + "' ></span>");
        $("#" + blurredID).text(pl);
        $("#" + blurredID).attr("title", pl);
    }
    $("#" + blurredID + "_clearField").remove();
});

