/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (window) {
    'use strict';

    /**
    *
    * Initializes AvayaDataStoreClient
    *
    * @class
    * @memberOf window
    * @define AvayaDataStoreClient
    */
    function AvayaDataStoreClient() {
        /**
        * @private
        * @type {Object}
        */        
        this.dataStoreService = null;
    }	

    AvayaDataStoreClient.prototype =
    /** @lends AvayaDataStoreClient.prototype **/
    {
       
        /**
         * Register a JavaScript logger
         * @public
         * @param logger Javascript logger utility, default window.console
         */
        registerlogger: function (logger) {
            AvayaDataStoreClient.Base.Logger.addlogger(logger);
        },       

        /**
         * Create an object of context store session
         * @public
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfiguration Required for Context Store Session
         * @returns {Object}
         */
        createDataStoreService: function (csConfiguration, serviceType) {

            if (!csConfiguration) {
                throw "Context Store configuration is not defined.";
            }
            if (!this.dataStoreService && csConfiguration.enabled) {
                if (!serviceType || serviceType === 'ContextStore') {
                    this.dataStoreService = new AvayaDataStoreClient.Services.ContextStore.ContextStore(csConfiguration);
                } else if (serviceType === 'CustomerManagement') {
                    this.dataStoreService = new AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement(csConfiguration);
                } else if (serviceType === 'CustomerJourney') {
                    this.dataStoreService = new AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney(csConfiguration);
                } else {
                    throw "Please specify which service your require ('ContextStore' service or 'CustomerManagement' service)";
                }

            }
            return this.dataStoreService;
        }
    };

    window.AvayaDataStoreClient = AvayaDataStoreClient;

})(window);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * AvayaDataStoreClient.Base contains all classes that are common to all AvayaDataStoreClient SDK modules.
     * @namespace AvayaDataStoreClient.Base
     * @define AvayaDataStoreClient.Base
     */
    (function(AvayaDataStoreClient){
        AvayaDataStoreClient.Base = AvayaDataStoreClient.Base || {};
    })(AvayaDataStoreClient);
	
    /**
     * AvayaDataStoreClient.Config contains prototypes of config objects which are necessary to provide connection with various servers used by AvayaDataStoreClient SDK.
     * @namespace AvayaDataStoreClient.Config
     * @define AvayaDataStoreClient.Config
     */
    (function(AvayaDataStoreClient){
        AvayaDataStoreClient.Config = AvayaDataStoreClient.Config || {};
    })(AvayaDataStoreClient);
	
    /**
     * @namespace AvayaDataStoreClient.Services
     * @define AvayaDataStoreClient.Services
     */
    (function(AvayaDataStoreClient){
        AvayaDataStoreClient.Services = AvayaDataStoreClient.Services || {};
    })(AvayaDataStoreClient);
	
    /**
     * @namespace AvayaDataStoreClient.Services.ContextStore
     * @define AvayaDataStoreClient.Services.ContextStore
     */
    (function(AvayaDataStoreClient){
        AvayaDataStoreClient.Services.ContextStore = AvayaDataStoreClient.Services.ContextStore || {};
    })(AvayaDataStoreClient);

    /**
     * @namespace AvayaDataStoreClient.Services.CustomerManagement
     * @define AvayaDataStoreClient.Services.CustomerManagement
     */
    (function(AvayaDataStoreClient) {
        AvayaDataStoreClient.Services.CustomerManagement = AvayaDataStoreClient.Services.CustomerManagement || {};
    })(AvayaDataStoreClient);

    /**
     * @namespace AvayaDataStoreClient.Services.CustomerJourney
     * @define AvayaDataStoreClient.Services.CustomerJourney
     */
    (function(AvayaDataStoreClient) {
        AvayaDataStoreClient.Services.CustomerJourney = AvayaDataStoreClient.Services.CustomerJourney || {};
    })(AvayaDataStoreClient);

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
(function (AvayaDataStoreClient) {
    'use strict';
	
    /**
     * @namespace AvayaDataStoreClient.Providers
     */
    (function(AvayaDataStoreClient){
        AvayaDataStoreClient.Providers = AvayaDataStoreClient.Providers || {};
    })(AvayaDataStoreClient);
	
    /**
     * @namespace AvayaDataStoreClient.Providers.ContextStore
     */
    (function(AvayaDataStoreClient){
        AvayaDataStoreClient.Providers.ContextStore = AvayaDataStoreClient.Providers.ContextStore || {};
    })(AvayaDataStoreClient);

    /**
     * @namespace AvayaDataStoreClient.Providers.CustomerManagement
     */
    (function(AvayaDataStoreClient) {
        AvayaDataStoreClient.Providers.CustomerManagement = AvayaDataStoreClient.Providers.CustomerManagement || {};
    })(AvayaDataStoreClient);

    /**
     * @namespace AvayaDataStoreClient.Providers.CustomerJourney
     */
    (function(AvayaDataStoreClient) {
        AvayaDataStoreClient.Providers.CustomerJourney = AvayaDataStoreClient.Providers.CustomerJourney || {};
    })(AvayaDataStoreClient);

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient, $) {
    'use strict';

    /**
     * Capability object.
     *
     * //@class
     * //@memberOf AvayaDataStoreClient.Base
     * //@define AvayaDataStoreClient.Base.Capability
     * //@param {AvayaDataStoreClient.Base.CapabilityDenialReason} reason
     */
    function Capability(reason) {

        /**
         * Determines whether the action is allowed or not.
         *
         * @public
         * @type {Boolean}
         */
        this.isAllowed = reason === AvayaDataStoreClient.Base.CapabilityDenialReason.CAPABILITY_NOT_DENIED;

        /**
         * If action is denied, contains the reason of denial.
         *
         * @public
         * @type {String}
         */
        this.denialReason = reason;

        /**
         * @private
         */
        this._onChangedCallbacks = $.Callbacks();
    }

    Capability.prototype = {
        /**
         * Interface for callback function to be invoked when capability changed.
         *
         * @callback AvayaDataStoreClient.Base.Capability~onChangedCallbacks
         * @returns {void}
         */
        /**
         * Add new onChangedCallback.
         *
         * @public
         * @group Managing callbacks
         * @param {AvayaDataStoreClient.Base.Capability~onChangedCallbacks} callback
         * @returns {void}
         */
        addOnChangedCallback: function (callback) {
            this._onChangedCallbacks.add(callback);
        },
        /**
         * Remove onChangedCallback.
         *
         * @public
         * @group Managing callbacks
         * @param {AvayaDataStoreClient.Base.Capability~onChangedCallbacks} callback
         * @returns {void}
         */
        removeOnChangedCallback: function (callback) {
            this._onChangedCallbacks.remove(callback);
        },
        /**
         * If necessary, update capability and fire callbacks.
         * @param {Boolean} isAllowed
         * @param {AvayaDataStoreClient.Base.CapabilityDenialReason} denialReason
         * @private
         */
        _updateIfChanged: function (isAllowed, denialReason) {
            if ((this.isAllowed !== isAllowed) || (this.denialReason !== denialReason)) {
                this.isAllowed = isAllowed;
                this.denialReason = denialReason;
                this._onChangedCallbacks.fire(this);
            }
        }
    };

    AvayaDataStoreClient.Base.Capability = Capability;

})(AvayaDataStoreClient, jQuery);


/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */


(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * Denial reasons for capabilities.
     *
     * //@readonly
     * //@enum {String}
     * //@memberOf AvayaDataStoreClient.Base
     * //@define AvayaDataStoreClient.Base.CapabilityDenialReason
     */
    var CapabilityDenialReason = {
        CAPABILITY_NOT_DENIED: 'CAPABILITY_NOT_DENIED',
        CAPABILITY_INVALID_STATE: 'CAPABILITY_INVALID_STATE',
        CAPABILITY_NOT_SUPPORTED: 'CAPABILITY_NOT_SUPPORTED',
        CAPABILITY_CALL_IS_REMOTE: 'CAPABILITY_CALL_IS_REMOTE',
        CAPABILITY_CALL_IS_NOT_REMOTE: 'CAPABILITY_CALL_IS_NOT_REMOTE',
        CAPABILITY_CALL_HAS_NO_AUDIO: 'CAPABILITY_CALL_HAS_NO_AUDIO',
        CAPABILITY_CALL_HAS_NO_VIDEO: 'CAPABILITY_CALL_HAS_NO_VIDEO',
        CAPABILITY_NOT_ALLOWED: 'CAPABILITY_NOT_ALLOWED',
        CAPABILITY_NEED_SIGNIN: 'CAPABILITY_NEED_SIGNIN',
        CAPABILITY_NEED_MODERATOR: 'CAPABILITY_NEED_MODERATOR',
        CAPABILITY_NEED_SIGNIN_OR_MODERATOR: 'CAPABILITY_NEED_SIGNIN_OR_MODERATOR'
    };

    AvayaDataStoreClient.Base.CapabilityDenialReason = CapabilityDenialReason;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';
    /**
    * Class extending JavaScript Error object.
    * @group Constructor
    * @function AvayaDataStoreClient.Base.ContextStoreError
    * @define AvayaDataStoreClient.Base.ContextStoreError
    * @extends Error
    * @memberOf AvayaDataStoreClient.Base
    * @param {string} errorCode
    * @param {string} reason
    * @param {string} message
    * @constructor
    */
     
    function ContextStoreError(errorCode, reason, message) {
        Error.call(this, message);

       
        this._errorCode=errorCode;
        this._reason = reason;
        this._message = message;
    }
    
    ContextStoreError.prototype = Object.create(Error.prototype);

    /**
    * Returns Error Code related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.ContextStoreError#getErrorCode
    * @memberOf AvayaDataStoreClient.Base.ContextStoreError
    * @returns {string}
    */
    ContextStoreError.prototype.getErrorCode = function () {
        return this._errorCode;
    };
    /**
    * Returns Error Reason related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.ContextStoreError#getReason
    * @memberOf AvayaDataStoreClient.Base.ContextStoreError
    * @returns {string}
    */
    ContextStoreError.prototype.getReason = function () {
        return this._reason;
    };

    /**
    * Returns message related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.ContextStoreError#getMessage
    * @memberOf AvayaDataStoreClient.Base.ContextStoreError
    * @returns {string}
    */
    ContextStoreError.prototype.getMessage = function () {
        return this._message;
    };

    AvayaDataStoreClient.Base.ContextStoreError = ContextStoreError;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * NOTE: This class does nothing!
 * It is only use to document jQuery ContextStorePromise object in order to provide syntax completion.
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * jQuery promise, created from jQuery.Deferred object. See jQuery docs for more detailed information.
     * ContextStorePromised are used to resolve server responses to requests performed by AvayaDataStoreClient.
     *
     * See {@tutorial async} for more information.
     *
     * Note that since all ContextStorePromise methods return themselves, the methods can be easily chained.
     *
     * @example <caption>Adding participants to a conversation</caption>
     * var successCallback = function(){
     *      AvayaDataStoreClient.Base.Logger.log("Something happened!");
     * };
     * var failCallback = function(){
     *      AvayaDataStoreClient.Base.Logger.log("Error");
     * };
     * ContextStore.doSomething(arguments).then(successCallback, failCallback);
     * // do something else...
     * // when the ContextStorePromise is resolved, AvayaDataStoreClient.Base.Logger will print "Something happened!"
     *
     * @example <caption>Chaining methods</caption>
     * ContextStore.doSomething(arguments).done(doOneThing).done(doOther).done(doAnother).fail(onError);
     *
     *
     * @class
     * @memberOf AvayaDataStoreClient.Base
     * @define AvayaDataStoreClient.Base.ContextStorePromise
     */
    function ContextStorePromise() {
        /**
         * NOTE: This class does nothing!
         * It is only use to document jQuery ContextStorePromise object in order to provide syntax completion.
         */
    }

    ContextStorePromise.prototype =
    /** @lends AvayaDataStoreClient.Base.ContextStorePromise.prototype **/
    {
        /**
         * Determine the current state of a Deferred object.
         *
         * @public
         * @returns {String}
         */
        state: function(){},

        /**
         * Add handlers to be called when the Deferred object is either resolved or rejected.
         *
         * @param {function} alwaysCallback A function, or array of functions, that is called when the Deferred is resolved or rejected.
         * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
         */
        always : function(alwaysCallback){
            if (typeof alwaysCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("alwaysCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is resolved.
         *
         * @example
         * ContextStore.doSomething(arguments).done(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * });
         *
         * @param {function} doneCallback A function, or array of functions, that are called when the Deferred is resolved.
         * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
         */
        done: function(doneCallback){
            if (typeof doneCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("doneCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is rejected.
         *
         * @example
         * ContextStore.doSomething(arguments).fail(function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * });
         *
         * @public
         * @param {function} failCallback A function, or array of functions, that are called when the Deferred is rejected.
         * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
         */
        fail: function(failCallback){
            if (typeof failCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("failCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object generates progress notifications. Please note that not every ContextStorePromise
         * creates progress notifications.
         *
         * @example
         * ContextStore.doSomething(arguments).progress(function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} progressCallback A function, or array of functions, to be called when the Deferred generates progress notifications.
         * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
         */
        progress: function(progressCallback){
             if (typeof progressCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("progressCallback is not a function");
            }
        },

        /**
         * Add handlers to be called for the Deferred object. Combines functionality of .done(), .fail() and .progress().
         *
         * @example
         * ContextStore.doSomething(arguments).then(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * }, function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * }, function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} doneCallback A function that is called when the Deferred is resolved.
         * @param {function} [failCallback] A function that is called when the Deferred is rejected.
         * @param {function} [progressCallback] A function that is called when the Deferred generates progress notifications.
         * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
         */
        then: function(doneCallback, failCallback, progressCallback){
             if (typeof doneCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("doneCallback is not a function");
            }
            else if(typeof failCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("failCallback is not a function");
            }
            else if(typeof progressCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("progressCallback is not a function");
            }
        }
    };

    AvayaDataStoreClient.Base.ContextStorePromise = ContextStorePromise;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';
    /**
    * Class extending JavaScript Error object.
    * @group Constructor
    * @function AvayaDataStoreClient.Base.CustomerJourneyError
    * @define AvayaDataStoreClient.Base.CustomerJourneyError
    * @extends Error
    * @memberOf AvayaDataStoreClient.Base
    * @param {string} errorCode
    * @param {string} reason
    * @param {string} message
    * @constructor
    */
     
    function CustomerJourneyError(errorCode, reason, message) {
        Error.call(this, message);

       
        this._errorCode=errorCode;
        this._reason = reason;
        this._message = message;
    }
    
    CustomerJourneyError.prototype = Object.create(Error.prototype);

    /**
    * Returns Error Code related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.CustomerJourneyError#getErrorCode
    * @memberOf AvayaDataStoreClient.Base.CustomerJourneyError
    * @returns {string}
    */
    CustomerJourneyError.prototype.getErrorCode = function() {
        return this._errorCode;
    };
    /**
    * Returns Error Reason related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.CustomerJourneyError#getReason
    * @memberOf AvayaDataStoreClient.Base.CustomerJourneyError
    * @returns {string}
    */
    CustomerJourneyError.prototype.getReason = function() {
        return this._reason;
    };

    /**
    * Returns message related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.CustomerJourneyError#getMessage
    * @memberOf AvayaDataStoreClient.Base.CustomerJourneyError
    * @returns {string}
    */
    CustomerJourneyError.prototype.getMessage = function() {
        return this._message;
    };

    AvayaDataStoreClient.Base.CustomerJourneyError = CustomerJourneyError;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * NOTE: This class does nothing!
 * It is only use to document jQuery CustomerJourneyPromise object in order to provide syntax completion.
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * jQuery promise, created from jQuery.Deferred object. See jQuery docs for more detailed information.
     * CustomerJourneyPromised are used to resolve server responses to requests performed by AvayaDataStoreClient.
     *
     * See {@tutorial async} for more information.
     *
     * Note that since all CustomerJourneyPromise methods return themselves, the methods can be easily chained.
     *
     * @example <caption>Adding participants to a conversation</caption>
     * var successCallback = function(){
     *      AvayaDataStoreClient.Base.Logger.log("Something happened!");
     * };
     * var failCallback = function(){
     *      AvayaDataStoreClient.Base.Logger.log("Error");
     * };
     * CustomerJourney.doSomething(arguments).then(successCallback, failCallback);
     * // do something else...
     * // when the CustomerJourneyPromise is resolved, AvayaDataStoreClient.Base.Logger will print "Something happened!"
     *
     * @example <caption>Chaining methods</caption>
     * CustomerJourney.doSomething(arguments).done(doOneThing).done(doOther).done(doAnother).fail(onError);
     *
     *
     * @class
     * @memberOf AvayaDataStoreClient.Base
     * @define AvayaDataStoreClient.Base.CustomerJourneyPromise
     */
    function CustomerJourneyPromise() {
        /**
         * NOTE: This class does nothing!
         * It is only use to document jQuery CustomerJourneyPromise object in order to provide syntax completion.
         */
    }

    CustomerJourneyPromise.prototype =
            /** @lends AvayaDataStoreClient.Base.CustomerJourneyPromise.prototype **/
    {
        /**
         * Determine the current state of a Deferred object.
         *
         * @public
         * @returns {String}
         */
        state: function(){},

        /**
         * Add handlers to be called when the Deferred object is either resolved or rejected.
         *
         * @param {function} alwaysCallback A function, or array of functions, that is called when the Deferred is resolved or rejected.
         * @returns {AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        always : function(alwaysCallback){
            if (typeof alwaysCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("alwaysCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is resolved.
         *
         * @example
         * CustomerJourney.doSomething(arguments).done(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * });
         *
         * @param {function} doneCallback A function, or array of functions, that are called when the Deferred is resolved.
         * @returns {AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        done: function(doneCallback){
            if (typeof doneCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("doneCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is rejected.
         *
         * @example
         * CustomerManagemen.doSomething(arguments).fail(function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * });
         *
         * @public
         * @param {function} failCallback A function, or array of functions, that are called when the Deferred is rejected.
         * @returns {AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        fail: function(failCallback){
            if (typeof failCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("failCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object generates progress notifications. Please note that not every CustomerJourneyPromise
         * creates progress notifications.
         *
         * @example
         * CustomerManagemen.doSomething(arguments).progress(function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} progressCallback A function, or array of functions, to be called when the Deferred generates progress notifications.
         * @returns {AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        progress: function(progressCallback){
             if (typeof progressCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("progressCallback is not a function");
            }
        },

        /**
         * Add handlers to be called for the Deferred object. Combines functionality of .done(), .fail() and .progress().
         *
         * @example
         * CustomerManagemen.doSomething(arguments).then(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * }, function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * }, function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} doneCallback A function that is called when the Deferred is resolved.
         * @param {function} [failCallback] A function that is called when the Deferred is rejected.
         * @param {function} [progressCallback] A function that is called when the Deferred generates progress notifications.
         * @returns {AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        then: function(doneCallback, failCallback, progressCallback){
             if (typeof doneCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("doneCallback is not a function");
            }
            else if(typeof failCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("failCallback is not a function");
            }
            else if(typeof progressCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("progressCallback is not a function");
            }
        }
    };

            AvayaDataStoreClient.Base.CustomerJourneyPromise = CustomerJourneyPromise;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';
    /**
    * Class extending JavaScript Error object.
    * @group Constructor
    * @function AvayaDataStoreClient.Base.CustomerManagementError
    * @define AvayaDataStoreClient.Base.CustomerManagementError
    * @extends Error
    * @memberOf AvayaDataStoreClient.Base
    * @param {string} errorCode
    * @param {string} reason
    * @param {string} message
    * @constructor
    */
     
    function CustomerManagementError(errorCode, reason, message) {
        Error.call(this, message);

       
        this._errorCode=errorCode;
        this._reason = reason;
        this._message = message;
    }
    
    CustomerManagementError.prototype = Object.create(Error.prototype);

    /**
    * Returns Error Code related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.CustomerManagementError#getErrorCode
    * @memberOf AvayaDataStoreClient.Base.CustomerManagementError
    * @returns {string}
    */
    CustomerManagementError.prototype.getErrorCode = function() {
        return this._errorCode;
    };
    /**
    * Returns Error Reason related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.CustomerManagementError#getReason
    * @memberOf AvayaDataStoreClient.Base.CustomerManagementError
    * @returns {string}
    */
    CustomerManagementError.prototype.getReason = function() {
        return this._reason;
    };

    /**
    * Returns message related with error.    
    *
    * @public
    * @function AvayaDataStoreClient.Base.CustomerManagementError#getMessage
    * @memberOf AvayaDataStoreClient.Base.CustomerManagementError
    * @returns {string}
    */
    CustomerManagementError.prototype.getMessage = function() {
        return this._message;
    };

    AvayaDataStoreClient.Base.CustomerManagementError = CustomerManagementError;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * NOTE: This class does nothing!
 * It is only use to document jQuery CustomerManagementPromise object in order to provide syntax completion.
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * jQuery promise, created from jQuery.Deferred object. See jQuery docs for more detailed information.
     * CustomerManagementPromised are used to resolve server responses to requests performed by AvayaDataStoreClient.
     *
     * See {@tutorial async} for more information.
     *
     * Note that since all CustomerManagementPromise methods return themselves, the methods can be easily chained.
     *
     * @example <caption>Adding participants to a conversation</caption>
     * var successCallback = function(){
     *      AvayaDataStoreClient.Base.Logger.log("Something happened!");
     * };
     * var failCallback = function(){
     *      AvayaDataStoreClient.Base.Logger.log("Error");
     * };
     * CustomerManagemen.doSomething(arguments).then(successCallback, failCallback);
     * // do something else...
     * // when the CustomerManagementPromise is resolved, AvayaDataStoreClient.Base.Logger will print "Something happened!"
     *
     * @example <caption>Chaining methods</caption>
     * CustomerManagemen.doSomething(arguments).done(doOneThing).done(doOther).done(doAnother).fail(onError);
     *
     *
     * @class
     * @memberOf AvayaDataStoreClient.Base
     * @define AvayaDataStoreClient.Base.CustomerManagementPromise
     */
    function CustomerManagementPromise() {
        /**
         * NOTE: This class does nothing!
         * It is only use to document jQuery CustomerManagementPromise object in order to provide syntax completion.
         */
    }

    CustomerManagementPromise.prototype =
            /** @lends AvayaDataStoreClient.Base.CustomerManagementPromise.prototype **/
    {
        /**
         * Determine the current state of a Deferred object.
         *
         * @public
         * @returns {String}
         */
        state: function(){},

        /**
         * Add handlers to be called when the Deferred object is either resolved or rejected.
         *
         * @param {function} alwaysCallback A function, or array of functions, that is called when the Deferred is resolved or rejected.
         * @returns {AvayaDataStoreClient.Base.CustomerManagementPromise}
         */
        always : function(alwaysCallback){
            if (typeof alwaysCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("alwaysCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is resolved.
         *
         * @example
         * CustomerManagemen.doSomething(arguments).done(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * });
         *
         * @param {function} doneCallback A function, or array of functions, that are called when the Deferred is resolved.
         * @returns {AvayaDataStoreClient.Base.CustomerManagementPromise}
         */
        done: function(doneCallback){
            if (typeof doneCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("doneCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object is rejected.
         *
         * @example
         * CustomerManagemen.doSomething(arguments).fail(function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * });
         *
         * @public
         * @param {function} failCallback A function, or array of functions, that are called when the Deferred is rejected.
         * @returns {AvayaDataStoreClient.Base.CustomerManagementPromise}
         */
        fail: function(failCallback){
            if (typeof failCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("failCallback is not a function");
            }
        },

        /**
         * Add handlers to be called when the Deferred object generates progress notifications. Please note that not every CustomerManagementPromise
         * creates progress notifications.
         *
         * @example
         * CustomerManagemen.doSomething(arguments).progress(function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} progressCallback A function, or array of functions, to be called when the Deferred generates progress notifications.
         * @returns {AvayaDataStoreClient.Base.CustomerManagementPromise}
         */
        progress: function(progressCallback){
             if (typeof progressCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("progressCallback is not a function");
            }
        },

        /**
         * Add handlers to be called for the Deferred object. Combines functionality of .done(), .fail() and .progress().
         *
         * @example
         * CustomerManagemen.doSomething(arguments).then(function(data){
         *      //invoked on success
         *      //e.g. refresh the UI
         * }, function(error){
         *      //invoked on failure
         *      //e.g. show error in UI
         * }, function(progressObject){
         *      //invoked on progress
         *      //e.g. refresh progress bar
         * });
         *
         * @public
         * @param {function} doneCallback A function that is called when the Deferred is resolved.
         * @param {function} [failCallback] A function that is called when the Deferred is rejected.
         * @param {function} [progressCallback] A function that is called when the Deferred generates progress notifications.
         * @returns {AvayaDataStoreClient.Base.CustomerManagementPromise}
         */
        then: function(doneCallback, failCallback, progressCallback){
             if (typeof doneCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("doneCallback is not a function");
            }
            else if(typeof failCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("failCallback is not a function");
            }
            else if(typeof progressCallback !== 'function'){
                AvayaDataStoreClient.Base.Logger.warn("progressCallback is not a function");
            }
        }
    };

            AvayaDataStoreClient.Base.CustomerManagementPromise = CustomerManagementPromise;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Data set object
 *
 * @author Pawel Mazur
 *   AvayaDataStoreClient.Base
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * //@description
     *
     * Description is mandatory
     * //@todo implement! document!
     * //@class
     * //@memberOf AvayaDataStoreClient.Base
     * //@define AvayaDataStoreClient.Base.DataRetrieval
     * //@param {AvayaDataStoreClient.Base.DataSet} newDataSet
     */
    function DataRetrieval(newDataSet) {
        /**
         * @private
         * @type {AvayaDataStoreClient.Base.DataSet}
         */
        this.dataSet = newDataSet;
        /**
         * @public
         */
        this.dataRetrievalProgress = $.Callbacks();

        /**
         * @public
         */
        this.dataRetrievalDone = $.Callbacks();

        /**
         * @public
         */
        this.dataRetrievalFailed = $.Callbacks();

    }

    DataRetrieval.prototype =
    /** @lends AvayaDataStoreClient.Base.DataRetrieval.prototype **/
    {
        /**
         * @function
         * @public
         * @return {AvayaDataStoreClient.Base.DataSet}
         */
        getDataSet: function () {
            return this.dataSet;
        },

        //Progress
        /**
         * @function
         * @public
         * @param {function} callback
         */
        addOnDataRetrievalProgressCallback: function (callback) {
            this.dataRetrievalProgress.add(callback);
        },

        /**
         * @function
         * @public
         * @param {function} callback
         */
        removeOnDataRetrievalProgressCallback: function (callback) {
            this.dataRetrievalProgress.remove(callback);
        },

        /**
         * @function
         * @public
         * @param determinateness
         * @param {Number} progress
         * @param {Number} total
         */
        onDataRetrievalProgress: function (determinateness, progress, total) {
            this.dataRetrievalProgress.fire(this, arguments);
        },

        //Done
        /**
         * @function
         * @public
         * @param {function} callback
         */
        addOnDataRetrievalDoneCallback: function (callback) {
            this.dataRetrievalDone.add(callback);
        },

        /**
         * @function
         * @public
         * @param {function} callback
         */
        removeOnDataRetrievalDoneCallback: function (callback) {
            this.dataRetrievalDone.remove(callback);
        },

        /**
         * @function
         * @public
         */
        onDataRetrievalDone: function () {
            this.dataRetrievalDone.fire(this, arguments);
        },

        // Failed
        /**
         * @function
         * @public
         * @param {function} callback
         */
        addOnDataRetrievalFailedCallback: function (callback) {
            this.dataRetrievalFailed.add(callback);
        },

        /**
         * @function
         * @public
         * @param {function} callback
         */
        removeOnDataRetrievalFailedCallback: function (callback) {
            this.dataRetrievalFailed.remove(callback);
        },

        /**
         * @function
         * @public
         * @param {String} failureReason
         */
        onDataRetrievalFailed: function (failureReason) {
            this.dataRetrievalFailed.fireWith(this, arguments);
        }
    };

    AvayaDataStoreClient.Base.DataRetrieval = DataRetrieval;

})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient, $) {
    'use strict';

    /**
     * DataSet object. For more information, see {@tutorial dataSet}.
     *
     *
     * //@class
     * //@define AvayaDataStoreClient.Base.DataSet
     * //@extends Array
     * //@memberOf AvayaDataStoreClient.Base
     */
    function DataSet() {
        /**
         * @private
         */
        this.dataSetChangeCallbacks = $.Callbacks();

        /**
         * @private
         */
        this.dataSetInvalidatedCallbacks = $.Callbacks();
    }

    DataSet.prototype = Object.create(Array.prototype);

    /**
     * Add new onDataSetChangedCallback.
     *
     * @public
     * @function AvayaDataStoreClient.Base.DataSet#addOnDataSetChangedCallback
     * @memberOf AvayaDataStoreClient.Base.DataSet
     * @param {AvayaDataStoreClient.Base.DataSet~onDataSetChangedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.addOnDataSetChangedCallback = function (callback) {
        this.dataSetChangeCallbacks.add(callback);
    };
    /**
     * Remove existing onDataSetChangedCallback.
     *
     * @public
     * @function AvayaDataStoreClient.Base.DataSet#removeOnDataSetChangedCallback
     * @memberOf AvayaDataStoreClient.Base.DataSet
     * @param {AvayaDataStoreClient.Base.DataSet~onDataSetChangedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.removeOnDataSetChangedCallback = function (callback) {
        this.dataSetChangeCallbacks.remove(callback);
    };

    /**
     * @private
     * @function AvayaDataStoreClient.Base.DataSet#onDataSetChanged
     * @memberOf AvayaDataStoreClient.Base.DataSet
     * @returns {void}
     */
    DataSet.prototype.onDataSetChanged = function () {
        this.dataSetChangeCallbacks.fire(this);
    };

    /**
     * Add new onDataSetChangedCallback.
     *
     * @public
     * @function AvayaDataStoreClient.Base.DataSet#addOnDataSetInvalidatedCallback
     * @memberOf AvayaDataStoreClient.Base.DataSet
     * @param {AvayaDataStoreClient.Base.DataSet~onDataSetInvalidatedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.addOnDataSetInvalidatedCallback = function (callback) {
        this.dataSetInvalidatedCallbacks.add(callback);
    };

    /**
     * @public
     * @function AvayaDataStoreClient.Base.DataSet#removeOnDataSetInvalidatedCallback
     * @memberOf AvayaDataStoreClient.Base.DataSet
     * @param {AvayaDataStoreClient.Base.DataSet~onDataSetInvalidatedCallback} callback
     * @returns {void}
     */
    DataSet.prototype.removeOnDataSetInvalidatedCallback = function (callback) {
        this.dataSetInvalidatedCallbacks.remove(callback);
    };
    /**
     * @private
     * @function AvayaDataStoreClient.Base.DataSet#onDataSetInvalidated
     * @memberOf AvayaDataStoreClient.Base.DataSet
     * @returns {void}
     */
    DataSet.prototype.onDataSetInvalidated = function () {
        this.dataSetInvalidatedCallbacks.fire(this);
    };

    /**
     * Interface for callback function to be invoked when DataSet changes.
     *
     * @callback AvayaDataStoreClient.Base.DataSet~onDataSetChangedCallback
     * @param {AvayaDataStoreClient.Base.DataSet} dataSet - instance of DataSet that has changed
     * @returns {void}
     */

    /**
     * Interface for callback function to be invoked when DataSet is invalidated.
     *
     * @callback AvayaDataStoreClient.Base.DataSet~onDataSetInvalidatedCallback
     * @param {AvayaDataStoreClient.Base.DataSet} dataSet - instance of DataSet that has been invalidated
     * @returns {void}
     */


    AvayaDataStoreClient.Base.DataSet = DataSet;

})(AvayaDataStoreClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function () {
    'use strict';

    var loggers = [];

    function standardLog(logger, level, message, meta) {
        if (typeof meta !== 'undefined') {
            logger[level](message, meta);
        } else {
            logger[level](message);
        }
    }

    function externalLog(logger, level, message, meta) {
        if (typeof meta !== 'undefined') {
            logger.log(level, message, meta);
        } else {
            logger.log(level, message);
        }
    }


    /**
     * @class
     * @memberOf AvayaDataStoreClient.Base
     * @define AvayaDataStoreClient.Base.logger
     */
    AvayaDataStoreClient.Base.Logger = {

        /**
         * @public
         * @function
         * @param {string} level
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        log: function (level, message, meta) {
            loggers.forEach(function (logger) {
                externalLog(logger, level, message, meta);
            });
        },

        /**
         *
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        info: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.info === 'function') {
                    standardLog(logger, 'info', message, meta);
                } else {
                    externalLog(logger, 'info', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        error: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.error === 'function') {
                    standardLog(logger, 'error', message, meta);
                } else {
                    externalLog(logger, 'error', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        fatal: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.fatal === 'function') {
                    standardLog(logger, 'fatal', message, meta);
                } else {
                    externalLog(logger, 'fatal', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        debug: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.debug === 'function') {
                    standardLog(logger, 'debug', message, meta);
                } else {
                    externalLog(logger, 'debug', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        trace: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.trace === 'function') {
                    standardLog(logger, 'trace', message, meta);
                } else {
                    externalLog(logger, 'trace', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {string} message
         * @param {undefined | Object} [meta]
         * @returns {void}
         */
        warn: function (message, meta) {
            loggers.forEach(function (logger) {
                if (typeof logger.warn === 'function') {
                    standardLog(logger, 'warn', message, meta);
                } else {
                    externalLog(logger, 'warn', message, meta);
                }
            });
        },

        /**
         * @public
         * @function
         * @param {Object} logger
         * @returns {void}
         */
        addlogger: function (logger) {
            if (!logger || typeof logger.log === 'undefined') {
                throw new TypeError('logger should implement log method.');
            }
            loggers.push(logger);
        },

        /**
         * @public
         * @function
         * @param {Object} logger
         * @returns {void}
         */
        removelogger: function (logger) {
            var index = loggers.indexOf(logger);
            if (index === -1) {
                throw new Error('Specified error does not exist.');
            }
            loggers.splice(index, 1);
        }

    };
})();

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @abstract
     * @class
     * @memberOf AvayaDataStoreClient.Base
     * @define AvayaDataStoreClient.Base.AbstractNetworkProvider
     */
    function AbstractNetworkProvider() {
        /**
         * @protected
         * @type {AvayaDataStoreClient.Config.ServerInfo}
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         */
        this._config = {};
        /**
         * @protected
         * @type {AvayaDataStoreClient.Config.CredentialProvider}
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         */
        this._credentialProvider = {};
    }

    AbstractNetworkProvider.prototype =
    /**
     * @lends AvayaDataStoreClient.Base.AbstractNetworkProvider.prototype
     */
    {
        /**
         * @public
         * @function AvayaDataStoreClient.Base.AbstractNetworkProvider#send
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         * @param {JSON} message
         * @param {JSON} options
         * @returns {AvayaDataStoreClient.Base.CobrowsePromise}
         */
        send: function (message, options) {
            if(options){
                 AvayaDataStoreClient.Base.Logger.info(options);
            }
            if(message){
                 AvayaDataStoreClient.Base.Logger.info(message);
            }
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Base.AbstractNetworkProvider#_onCredentialsRequired
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         * @param {JSON} data
         */
        _onCredentialsRequired: function (data) {
            if(data){
                 AvayaDataStoreClient.Base.Logger.info(data);
            }
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Base.AbstractNetworkProvider#onClose
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         */
        onClose: function () {
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Base.AbstractNetworkProvider#onMessage
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         * @param {JSON|String[]} message
         */
        onMessage: function (message) {
            if(message){
                 AvayaDataStoreClient.Base.Logger.info(message);
            }
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Base.AbstractNetworkProvider#onError
         * @memberOf AvayaDataStoreClient.Base.AbstractNetworkProvider#
         * @param {JSON|String[]} error
         */
        onError: function (error) {
                 AvayaDataStoreClient.Base.Logger.error(error); 
        }
    };

    AvayaDataStoreClient.Base.AbstractNetworkProvider = AbstractNetworkProvider;
})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient, $) {
    'use strict';
	
    /**
     * @requires AvayaDataStoreClient.Base.AbstractNetworkProvider
     * @extends AvayaDataStoreClient.Base.AbstractNetworkProvider
     * @define AvayaDataStoreClient.Base.RESTProvider
     * @memberOf AvayaDataStoreClient.Base
     * @constructor
     */
    function RESTProvider() {
        AvayaDataStoreClient.Base.AbstractNetworkProvider.apply(this);
        /**
         * @private
         * @type {Array}
         * @memberOf AvayaDataStoreClient.Base.RESTProvider#
         */
        this._xhrPool = [];
    }

    RESTProvider.prototype = Object.create(AvayaDataStoreClient.Base.AbstractNetworkProvider.prototype);
	
    /**
     * @public
     * @property AvayaDataStoreClient.Base.RESTProvider#defaultOptions
     * @memberOf AvayaDataStoreClient.Base.RESTProvider#
     */
    RESTProvider.prototype.defaultOptions = {
        url: undefined,
        processData: true,
    };
	
    /**
     * @public
     * @function AvayaDataStoreClient.Base.RESTProvider#generateToken
     * @memberOf AvayaDataStoreClient.Base.RESTProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions} options
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    RESTProvider.prototype.generateToken = function (options) {

        var opts = $.extend({}, this.defaultOptions, options);
        var url = this._getServerURL(opts);
        var finalOptions = {
            url: url,
            type: opts.sendType,
            dataType: opts.dataType,
            headers: opts.headers,
            processData: opts.processData,	
			  success: function( response ) {			
				AvayaDataStoreClient.Base.Logger.log("token request successful");  
				return response;
			  },
			  error: function( req, status, err ) {
				AvayaDataStoreClient.Base.Logger.error('Error! token could not be generated', err );
				return err;
			  },			
            beforeSend: function (jqXHR) {
                this._xhrPool.push(jqXHR);
            }.bind(this)
        };
        if (opts.crossDomain && opts.crossDomain === true) {
            finalOptions.xhrFields = {
                withCredentials: true
            };
            finalOptions.crossDomain = true;
        }

		return $.ajax(finalOptions);
    };

    function setStatus(id, csResponse, message) {
        if (csResponse.status === 200) {
            $("#" + id).removeClass("waiting failure").addClass("success");
            $("#data-" + id).text(message);
        } else {
            $("#" + id).removeClass("waiting failure").addClass("failure");
            $("#data-" + id).text(csResponse.responseMessage + "\n" + csResponse.responseText);
        }
    }

    function callbackHandler(response) {
					var contextId = response.contextId;
					setStatus("create", response, contextId);
	}
	
    /**
     * @public
     * @function AvayaDataStoreClient.Base.RESTProvider#send
     * @memberOf AvayaDataStoreClient.Base.RESTProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions} opts
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    RESTProvider.prototype.send = function (data, opts, isGuest) {
        var url = this._getServerURL(opts);
        var finalOptions = {
            url: url,
            type: opts.sendType,
            headers: opts.headers,
            dataType: opts.dataType,
            processData: opts.processData,
            beforeSend: function (jqXHR) {
                this._xhrPool.push(jqXHR);
            }.bind(this)
        };	
		
        if (data) {
            finalOptions.data = data;
        }
        if (opts.crossDomain && opts.crossDomain === true) {
            finalOptions.xhrFields = {
                withCredentials: true
            };         
			finalOptions.crossDomain = true;
        }

        return $.ajax(isGuest === true ? finalOptions : this.buildAuthorizationHeader(finalOptions))
		.then(function (data, textStatus, jqXHR) {
            this._xhrPool.splice(this._xhrPool.indexOf(jqXHR), 1);
            this.onMessage(data.responseText, jqXHR);
            return data;
        }.bind(this), function (error) {
            this.onError(error.responseText);
            return error;
        }.bind(this));
    };	

    /**
     * @function AvayaDataStoreClient.Base.Providers.RESTProvider#buildAuthorizationHeader
     * @memberOf AvayaDataStoreClient.Base.Providers.RESTProvider
     * @desc Build specified headers for HTTP request
     * @private
     * @param {Object} opts - jQuery ajax options object
     * @returns {Object}
     */
    RESTProvider.prototype.buildAuthorizationHeader = function(opts) {
		var bearer = this._config.token;	
        opts.headers.Authorization = 'Bearer ' + bearer;
        return opts;
    };
	
    /**
     * @private
     * @function AvayaDataStoreClient.Base.RESTProvider#_getServerURL
     * @memberOf AvayaDataStoreClient.Base.RESTProvider#
     * @param {AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions} options
     * @returns string
     */
    RESTProvider.prototype._getServerURL = function (options) {
        var url = '';
        if (typeof options.url !== 'undefined') {
            url = options.url;
        } else {
            url += this._config.isSecure ? 'https://' : 'http://';
            url += this._config.hostName ;
            url += options.urlSuffix;
        }
        return url;
    };
	
	
    AvayaDataStoreClient.Base.RESTProvider = RESTProvider;
})(AvayaDataStoreClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @define AvayaDataStoreClient.Config.CsConfiguration
     * @memberOf AvayaDataStoreClient.Config
     * @description Configuration information for Context Store. This class provides the configuration data that allows a connection and access to be made to a  Context Store Server
     * @constructor
     */
    function CsConfiguration() {
        /**
         * @description A Boolean value indicating whether the  Context Store Provider is enabled.
         * @public
         * @type {boolean}       
         */
        this.enabled = false;
		
        /**
         * @description A Boolean value indicating whether the user Context Store is a Guest and thus, authorization isn't required
         * @public
         * @type {boolean}       
         */
        this.isGuest = true;
		
        /**
         * @public
         * @description A ServerInfo value indicating the server to connect with for  Context Store Service.
         * @type {AvayaDataStoreClient.Config.ServerInfo}       
         */
        this.serverInfo = new AvayaDataStoreClient.Config.ServerInfo();
        /**
         * @public
         * @description Value of sockjs connection retry with  Context Store server.
         * @type {number}        
         */
        this.maxConnectionErrorCount=5;
       
    }

    CsConfiguration.prototype = {};

    AvayaDataStoreClient.Config.CsConfiguration = CsConfiguration;
})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * Context Store server information
     * @define AvayaDataStoreClient.Config.ServerInfo
     * @memberOf AvayaDataStoreClient.Config
     * @constructor
     */
    function ServerInfo() {
        /**
         * @public
         * @description The server's host name. This may by a fully qualified domain name or an IP address.
         * @type {string}
        
         */
        this.hostName = '';
        /**
         * @public
         * @description Used to determine if security is to be used for the connection to the server. Returns true is the connection is secured, otherwise false.
         * @type {boolean}
        
         */
        this.isSecure = false;
    }

    ServerInfo.prototype = {};

    AvayaDataStoreClient.Config.ServerInfo = ServerInfo;
	
})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Providers.ContextStore
     * @define AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions
     * @property AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions#
     */
    var ContextStoreNetworkOptions =  {
        url: undefined,
        sendType: undefined,
        urlSuffix: '/services/ContextStoreRest/cs/contexts',
		contentType: "application/json; charset=UTF-8",
        dataType: undefined,
        timeout: 2000,
        processData: true
    };	
    AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions = ContextStoreNetworkOptions;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @memberOf AvayaDataStoreClient.Providers.ContextStore
     * @define AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider
     * @param {AvayaDataStoreClient.Base.SockJSNetworkProvider} restProvider
     * @constructor
     */

    function ContextStoreNetworkProvider(restProvider) {
		
        /**
         * @private
         * @type {AvayaDataStoreClient.Base.RESTProvider}
         * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#
         */
        this._restProvider = restProvider;

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.serverInfo}
         * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#
         */
        this._config = undefined;

    }

    /**
     * @public
     * @function AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#init
     * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#
     * @param {AvayaDataStoreClient.Config.ServerInfo} serverConfig
     * @returns {void}
     */
    ContextStoreNetworkProvider.prototype.init = function (serverConfig) {
        this._config = serverConfig;
        if (!this._restProvider) {
            this._restProvider = new AvayaDataStoreClient.Base.RESTProvider();
        }

        this._restProvider._config = this._config;
    };
     
    /**
     * @public
     * @function AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#send
     * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions} options
     * @returns {*|AvayaDataStoreClient.Base.ContextStorePromise}
     */ 
    ContextStoreNetworkProvider.prototype.send = function (data, options, isGuest) {
        return this._restProvider.send(data, options, isGuest).then(
            function (response) {
                AvayaDataStoreClient.Base.Logger.log("successfully processed request for:"+options.urlSuffix);
                return response;
            }, function (error) {
                AvayaDataStoreClient.Base.Logger.log("error in processing request for:"+options.urlSuffix);
                return this._handleError(error);
            }.bind(this));
    };	
	
    /**
     * @public
     * @function AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#generateToken
     * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions} options
     * @returns {*|AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreNetworkProvider.prototype.generateToken = function (options) {
        return this._restProvider.generateToken(options).then(
            function (token) {
                AvayaDataStoreClient.Base.Logger.log("token generated");   
                return token;             			
            }, function (error) {
                AvayaDataStoreClient.Base.Logger.log("error in rest sending");
                return this._handleError(error);
            }.bind(this));
    };

    /**
     * Converts ContextStore JSON error response to {@link AvayaDataStoreClient.Base.ContextStoreError} and returns it.
     *
     * @private
     * @function AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#_handleError
     * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider#
     * @param {{errorCode:string, reason:string, message:string}} json
     * @returns {AvayaDataStoreClient.Base.ContextStoreError}
     */
    ContextStoreNetworkProvider.prototype._handleError = function (error) {
        var errorCode=error.status;
        var reason = error.statusText;
        var message = error.responseText;
        if (! error) {
            return new AvayaDataStoreClient.Base.ContextStoreError(errorCode,reason, message);
        }else{
            reason=error;
        }        
        if (error.errorMessage) {
            message=error.errorMessage;
            if(error.errorCode){
                errorCode = error.errorCode;
            }            
        } else if (error.data) {  
            var  eData  = error.data.split("::");
            if(eData.length > 1){
                message = eData[1];
                errorCode = eData[0];
            }
        }
        AvayaDataStoreClient.Base.Logger.warn(JSON.stringify(error));
        return new AvayaDataStoreClient.Base.ContextStoreError(errorCode,reason, message);
    };

    AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider = ContextStoreNetworkProvider;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @description
     * Context Store Provider to connect from service to network layer
     * @define AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider
     * @memberOf AvayaDataStoreClient.Providers.ContextStore
     * @constructor
     */
    function ContextStoreProvider() {
        /**
         * @private
         * @type {AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider}
         * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider#
         */
        this._csNetworkProvider = new AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkProvider();
        /**
         *
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider#
         */
        this.csConfig = null;
    }

    function isEmpty(arg) {
       if(arg === undefined) {
         return true;
       }

       if(arg.length  === undefined || arg.length === 0) {
         return true;
       }

       return false;
    }

    ContextStoreProvider.prototype =
    /** @lends AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider.prototype **/
    {
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#generateToken
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        generateToken: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
            var scope = requestData.scope;
            var username = requestData.username;
            var password = requestData.password;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.GENERATETOKENURL;
            var USERNAMESUFFIX = AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.USERNAMESUFFIX;
            var SCOPESUFFIX = AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.SCOPESUFFIX;
            if (!isEmpty(scope) && !isEmpty(username)){
              options.urlSuffix+=USERNAMESUFFIX+SCOPESUFFIX;
              options.headers = {'scope':scope, 'username':username, 'password':password};
            }else if (!isEmpty(scope)){
              options.urlSuffix+=SCOPESUFFIX;
              options.headers = {'scope':scope};
            }else if (!isEmpty(username)){
              options.urlSuffix+=USERNAMESUFFIX;
              options.headers = {'username':username, 'password':password};
            }
            options.sendType='GET';
            options.crossDomain='TRUE';
                  return this._csNetworkProvider.generateToken(options);
              },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getContextStoreStatus
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getContextStoreStatus: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.STATUSCHECKURL;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='text';
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },


        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#createContext
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        createContext: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var rules = requestData.rules;
			var shortId = requestData.shortId;
			var requestObj = $.parseJSON(requestData.requestBody );
			var aliasList = requestObj.alias;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL;
			if (typeof aliasList !== 'undefined' && aliasList !== ''){
				var i =0;
				aliasList.forEach(function(aliasItem) {
					if (i === 0){
						options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.ALIASPARAM+aliasItem;
					}else {
						options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.EXTRAALIASPARAM+aliasItem;
					}
					i++;
				});
				requestObj = findAndRemove(requestObj,"alias");
			}
			options.sendType='POST';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
			if (!(requestData.requestBody.includes('contextId'))){
				options.dataType='json';
			}
                            options = addQueryParamsWithRulesAndShortId(requestData, options, rules, shortId, '');
            return this._csNetworkProvider.send(JSON.stringify(requestObj),options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getContext
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getContext: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getContextMeta
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getContextMeta: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
	         var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.METAURL+contextId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getValueByContextId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getValueByContextId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
			var key = requestData.key;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId+
							  AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.KEYSSUFFIX+key;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getContextByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getContextByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
                "/alias/data/" + aliasId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getContextByAliasIdMeta
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getContextByAliasIdMeta: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
	         var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.METAURL+
							  AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.ALIASSUFFIX+aliasId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getValueByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getValueByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
			var key = requestData.key;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
							  "/alias/"+ aliasId + "/keys/" + key;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getGroup
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getGroup: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var groupId = requestData.groupId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.GROUPSCONTEXTURL+groupId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getGroupByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getGroupByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
            var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL + "/groupId/alias/" + aliasId;
            options.sendType='GET';
            options.headers = {'Content-Type':'application/text'};
            options.dataType='text';
            options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getContextIdByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getContextIdByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL + "/contextid/alias/" + aliasId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getAliasesByContextId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getAliasesByContextId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL +
							  "/aliasid/" +contextId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#upsertContext
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */

        upsertContext: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
                            var rules = requestData.rules;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.UPSERTCONTEXTURL+contextId;
			options.sendType='PUT';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
                            options = addQueryParamsWithRulesAndShortId(requestData, options, rules, '', '');
            return this._csNetworkProvider.send(requestData.requestBody,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#upsertContext
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */

        upsertContextByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
                            var rules = requestData.rules;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
                "/upsert/alias/" + aliasId;
			options.sendType='PUT';
			options.headers = {'Content-Type':'application/json'};
                            options.dataType = 'json';
                            options = addQueryParamsWithRulesAndShortId(requestData, options, rules, '', '');
            return this._csNetworkProvider.send(requestData.requestBody,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateContext
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */

        updateContext: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
			var rules = requestData.rules;
			var groupId = requestData.groupId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId;
			options.sendType='PUT';
			options.headers = {'Content-Type':'application/json'};
			options.dataType = 'text';
			options = addQueryParamsWithRulesAndShortId(requestData, options, rules, '', groupId);
            return this._csNetworkProvider.send(requestData.requestBody,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateValueByContextId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        updateValueByContextId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
			var key = requestData.key;
			var value = requestData.value;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId+
							  AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.KEYSSUFFIX+key;
			options.sendType='PUT';
			options.headers = {'Content-Type':'text/plain; charset=utf-8'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send(value,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateContextByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */

        updateContextByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
                            var aliasId = requestData.aliasId;
                            var rules = requestData.rules;
                            var groupId = requestData.groupId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
							  "/alias/" + aliasId;
			options.sendType='PUT';
			options.headers = {'Content-Type':'application/json'};
                            options.dataType = 'text';
                            options = addQueryParamsWithRulesAndShortId(requestData, options, rules, '', groupId);
            return this._csNetworkProvider.send(requestData.requestBody,options,this.csConfig.isGuest);
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateValueByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        updateValueByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
			var key = requestData.key;
			var value = requestData.value;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
                "/alias/" + aliasId + "/keys/" + key;
			options.sendType='PUT';
			options.headers = {'Content-Type':'text/plain; charset=utf-8'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send(value,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateAliasesByContextId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */

        updateAliasesByContextId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId+
							  AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.ALIASESSUFFIX;
			options.sendType='PUT';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send(requestData.requestBody,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateAliasesByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */

        updateAliasesByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL +
							  "/aliases/" + aliasId;
			options.sendType='PUT';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send(requestData.requestBody,options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#deleteContext
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        deleteContext: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId;
			options.sendType='DELETE';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#deleteValueByContextId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        deleteValueByContextId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
			var key = requestData.key;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCONTEXTURL+contextId+
							  AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.KEYSSUFFIX+key;
			options.sendType='DELETE';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#deleteContextByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        deleteContextByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
							  "/alias/" + aliasId;
			options.sendType='DELETE';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#deleteValueByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        deleteValueByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
			var key = requestData.key;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
                "/alias/" + aliasId + "/keys/" + key;
			options.sendType='DELETE';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#deleteAliasByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        deleteAliasByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL+
							  "/aliases/" +aliasId;
			options.sendType='DELETE';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='text';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getAuditByContextId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getAuditByContextId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.AUDITCONTEXTURL+contextId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getAuditByAliasId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getAuditByAliasId: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var aliasId = requestData.aliasId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.BASECONTEXTURL +
							  "/audit/alias/" + aliasId;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },
		
		//CS Query API


        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getEDMEntry
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getEDMEntry: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCSQUERYURL+contextId;			
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addEDMQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },	


        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getEDMEntryAudit
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getEDMEntryAudit: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var contextId = requestData.contextId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCSQUERYAUDITURL+contextId;			
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addEDMQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },	


        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getEDMGroupAudit
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.ContextStorePromise}
         */
        getEDMGroupAudit: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
			var groupId = requestData.groupId;
            var options=AvayaDataStoreClient.Providers.ContextStore.ContextStoreNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.FULLCSQUERYAUDITGRPURL+groupId;			
			options.sendType='GET';
			options.headers = {'Content-Type':'application/json'};
			options.dataType='json';
			options = addEDMQueryParams(requestData,options);
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        }
    };


    function addQueryParams(requestData, options) {
		return addQueryParamsWithRulesAndShortId(requestData, options, '', '');
    }

    function addQueryParamsWithRules(requestData, options, rules) {
		return addQueryParamsWithRulesAndShortId(requestData, options, rules, '', '');
    }

            function addQueryParamsWithRulesAndShortId(requestData, options, rules, shortId, groupId) {
		if (requestData.sid !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.SIDPARAM+requestData.sid;
		}
		if (typeof requestData.rid !== "undefined" && requestData.rid !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.RIDPARAM+requestData.rid;
		}
		if (typeof requestData.touchpoint !== "undefined" && requestData.touchpoint !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.TOUCHPOINTPARAM+requestData.touchpoint;
		}
		if (typeof requestData.lease !== "undefined" && requestData.lease !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.LEASEPARAM+requestData.lease;
		}
		if (rules !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.RULESPARAM+requestData.rules;
		}
		if (shortId !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.SHORTIDPARAM+requestData.shortId;
		}
                if (groupId !== '') {
                    options.urlSuffix += AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.GROUPIDPARAM + requestData.groupId;
                }

		options.urlSuffix = checkQueryParamsFormat(options.urlSuffix);

		return options;
    }

	
    function addEDMQueryParams(requestData, options) {
		if (typeof requestData.diff !== "undefined" && requestData.diff !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.DIFFPARAM+requestData.diff;
		}
		if (typeof requestData.data !== "undefined" && requestData.data !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.DATAPARAM+requestData.data;
		}
		if (typeof requestData.metadata !== "undefined" && requestData.metadata !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.METADATAPARAM+requestData.metadata;
		}
		if (typeof requestData.schema !== "undefined" && requestData.schema !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.SCHEMAPARAM+requestData.schema;
		}
		if (typeof requestData.topic !== "undefined" && requestData.topic !== ''){
			options.urlSuffix+=AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL.TOPICPARAM+requestData.topic;
		}
		options.urlSuffix = checkQueryParamsFormat(options.urlSuffix);

		return options;
    }

	
	function checkQueryParamsFormat(urlSuffix){
		if (!(urlSuffix.includes('?'))){
			urlSuffix = urlSuffix.replace(/\&+?/, "\/?");
		}
		return urlSuffix;
	}

	function findAndRemove(Obj, property) {
		for(var prop in Obj){
		   if(Obj.hasOwnProperty(prop) && prop === property){
			delete Obj[prop];
		   }
		}
		return Obj;
	}

    AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider = ContextStoreProvider;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Providers.ContextStore
     * @define AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL
     * @property AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL#
     */
    var ContextStoreProviderURL =  {
        BASECONTEXTURL : "/services/ContextStoreRest/cs/contexts",
        FULLCONTEXTURL : "/services/ContextStoreRest/cs/contexts/",
        ALIASCONTEXTURL : "/services/ContextStoreRest/cs/contexts/alias/",
		METAURL : "/services/ContextStoreRest/cs/contexts/meta/",
		IDURL : "/services/ContextStoreRest/cs/contexts/id/",
        GROUPSCONTEXTURL : "/services/ContextStoreRest/cs/contexts/groups/",
        UPSERTCONTEXTURL : "/services/ContextStoreRest/cs/contexts/upsert/",
        AUDITCONTEXTURL : "/services/ContextStoreRest/cs/contexts/audit/",
        GENERATETOKENURL : "/services/ContextStoreRest/cs/contexts/token",
		STATUSCHECKURL: "/services/ContextStoreRest/cs/contexts/cs_status_check/",
        KEYSSUFFIX : "/keys/",
        ALIASESSUFFIX : "/aliases",
        ALIASSUFFIX : "/alias/",
        SCOPESUFFIX : "/scope",
        USERNAMESUFFIX : "/username",
        ALIASPARAM : "/?alias=",
        EXTRAALIASPARAM : "&alias=",
		SIDPARAM : "&sid=",
		RIDPARAM : "&rid=",
		TOUCHPOINTPARAM : "&touchpoint=",	
		LEASEPARAM : "&lease=",
		RULESPARAM : "&rules=",
        SHORTIDPARAM: "&shortid=",
        GROUPIDPARAM: "&group=",
        BASECSQUERYURL : "/services/ContextStoreQuery/edm/contexts",
        FULLCSQUERYURL : "/services/ContextStoreQuery/edm/contexts/",
        FULLCSQUERYAUDITURL : "/services/ContextStoreQuery/edm/contexts/audit/",
        FULLCSQUERYAUDITGRPURL : "/services/ContextStoreQuery/edm/contexts/audit/groups/",
        FULLCSQUERYAUDITGRPBYCIDURL : "/services/ContextStoreQuery/edm/contexts/audit/groups/context/",
        TOPICSUFFIX : "/topic/",
        DIFFPARAM: "&diff=",
        DATAPARAM: "&data=",
        METADATAPARAM: "&metadata=",
        SCHEMAPARAM: "&schema=",
        TOPICPARAM: "&topic="
    };

    AvayaDataStoreClient.Providers.ContextStore.ContextStoreProviderURL = ContextStoreProviderURL;


})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney
     * @define AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions
     * @property AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions#
     */
    var CustomerJourneyNetworkOptions = {
        url: undefined,
        sendType: undefined,
        urlSuffix: '/services/CustomerJourney/rest/customer',
		contentType: "application/json; charset=UTF-8",
        dataType: undefined,
        timeout: 2000,
        processData: true
    };	
    AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions = CustomerJourneyNetworkOptions;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney
     * @define AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider
     * @param {AvayaDataStoreClient.Base.SockJSNetworkProvider} restProvider
     * @constructor
     */

    function CustomerJourneyNetworkProvider(restProvider) {
		
        /**
         * @private
         * @type {AvayaDataStoreClient.Base.RESTProvider}
         * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#
         */
        this._restProvider = restProvider;

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.serverInfo}
         * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#
         */
        this._config = undefined;

    }

    /**
     * @public
     * @function AvayaDataStoreClient.Providers.CustomerJourneyCustomerJourneyNetworkProvider#init
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#
     * @param {AvayaDataStoreClient.Config.ServerInfo} serverConfig
     * @returns {void}
     */
    CustomerJourneyNetworkProvider.prototype.init = function(serverConfig) {
        this._config = serverConfig;
        if (!this._restProvider) {
            this._restProvider = new AvayaDataStoreClient.Base.RESTProvider();
        }

        this._restProvider._config = this._config;
    };
     
    /**
     * @public
     * @function AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#send
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions} options
     * @returns {*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
     */ 
    CustomerJourneyNetworkProvider.prototype.send = function(data, options, isGuest) {
        return this._restProvider.send(data, options, isGuest).then(
            function (response) {
                AvayaDataStoreClient.Base.Logger.log("successfully processed request for:"+options.urlSuffix);
                return response;
            }, function (error) {
                AvayaDataStoreClient.Base.Logger.log("error in processing request for:"+options.urlSuffix);
                return this._handleError(error);
            }.bind(this));
    };	
	
    /**
     * @public
     * @function AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#generateToken
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions} options
     * @returns {*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
     */
    CustomerJourneyNetworkProvider.prototype.generateToken = function(options) {
        return this._restProvider.generateToken(options).then(
            function (token) {
                AvayaDataStoreClient.Base.Logger.log("token generated");   
                return token;             			
            }, function (error) {
                AvayaDataStoreClient.Base.Logger.log("error in rest sending");
                return this._handleError(error);
            }.bind(this));
    };

    /**
     * Converts Customer Journey JSON error response to {@link AvayaDataStoreClient.Base.CustomerJourneyError} and returns it.
     *
     * @private
     * @function AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#_handleError
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider#
     * @param {{errorCode:string, reason:string, message:string}} json
     * @returns {AvayaDataStoreClient.Base.CustomerJourneyError}
     */
    CustomerJourneyNetworkProvider.prototype._handleError = function(error) {
        var errorCode=error.status;
        var reason = error.statusText;
        var message = error.responseText;
        if (! error) {
            return new AvayaDataStoreClient.Base.CustomerJourneyError(errorCode, reason, message);
        }else{
            reason=error;
        }        
        if (error.errorMessage) {
            message=error.errorMessage;
            if(error.errorCode){
                errorCode = error.errorCode;
            }            
        } else if (error.data) {  
            var  eData  = error.data.split("::");
            if(eData.length > 1){
                message = eData[1];
                errorCode = eData[0];
            }
        }
        AvayaDataStoreClient.Base.Logger.warn(JSON.stringify(error));
        return new AvayaDataStoreClient.Base.CustomerJourneyError(errorCode, reason, message);
    };

    AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider = CustomerJourneyNetworkProvider;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @description
     * Context Store Provider to connect from service to network layer
     * @define AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney
     * @constructor
     */
    function CustomerJourneyProvider() {
        /**
         * @private
         * @type {AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider}
         * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider#
         */
        this._csNetworkProvider = new AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkProvider();

        /**
         *
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider#
         */
        this.cmConfig = null;
    }

    function isEmpty(arg) {
       if(arg === undefined) {
         return true;
       }

       if(arg.length  === undefined || arg.length === 0) {
         return true;
       }

       return false;
    }

    function checkQueryParamsFormat(urlSuffix){
        if (!(urlSuffix.includes('?'))){
            urlSuffix = urlSuffix.replace(/\&+?/, "\/?");
        }
        return urlSuffix;
    }

    function addQueryParams(requestData, options) {
        if (typeof requestData.topic !== "undefined" && requestData.topic !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.TOPIC_PARAM + requestData.topic;
        }
        if (typeof requestData.before !== "undefined" && requestData.before !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.BEFORE_PARAM + requestData.before;
        }
        options.urlSuffix = checkQueryParamsFormat(options.urlSuffix);

        return options;
    }

    CustomerJourneyProvider.prototype =
            /** @lends AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider.prototype **/
    {
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerJourney
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        getCustomerJourney: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var customerId = requestData.customerId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.GET_CUST_JOURNEY_URL + customerId;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerJourneyViaElementId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        getCustomerJourneyViaElementId: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var elementId = requestData.elementId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.GET_CUST_JOURNEY_BY_ELEMENT_URL + elementId;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerJourneyWithAdminDataViaElementId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        getCustomerJourneyWithAdminDataViaElementId: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var elementId = requestData.elementId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.GET_CUST_JOURNEY_BY_ELEMENT_URL + elementId;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/vnd.journey.v3.8+json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getLastJourneyElement
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        getLastJourneyElement: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var elementId = requestData.elementId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.ELEMENT_URL + elementId;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerJourneyViaAccountId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        getCustomerJourneyViaAccountId: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var accountId = requestData.accountId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.GET_CUST_JOURNEY_BY_ELEMENT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.ACCOUNT_URL + accountId;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#createJourneyElement
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
		createJourneyElement: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.ELEMENT_URL;
            options.sendType = 'POST';
			options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'text';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send(requestData.body, options, this.cmConfig.isGuest);
        },
		
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateJourneyElement
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
		updateJourneyElement: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var elementId = requestData.elementId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.ELEMENT_URL + elementId;
            options.sendType = 'PUT';
			options.headers = {'Content-Type': 'application/json'};
			options.dataType = 'text';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send(requestData.body, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateAgentNote
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        updateAgentNote: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var interactionId = requestData.interactionId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.JOURNEY_INTERACTION_URL + interactionId +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.NOTE_URL;
            options.sendType = 'PUT';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'text';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send(requestData.body, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateIdentifiers
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerJourneyPromise}
         */
        updateIdentifiers: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var elementId = requestData.elementId;
            var options = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.FULL_CONTEXT_URL +
                AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL.ELEMENT_IDENTIFIERS_URL + elementId;
            options.sendType = 'PUT';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'text';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send(requestData.body, options, this.cmConfig.isGuest);
        }
    };

	function findAndRemove(Obj, property) {
		for(var prop in Obj){
		   if(Obj.hasOwnProperty(prop) && prop === property){
			delete Obj[prop];
		   }
		}
		return Obj;
	}

        AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider = CustomerJourneyProvider;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Providers.CustomerJourney
     * @define AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL
     * @property AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL#
     */
    var CustomerJourneyProviderURL = {
        FULL_CONTEXT_URL: "/services/CustomerJourneyService/rest/customer/",
        GET_CUST_JOURNEY_URL: "journeys/",
        GET_CUST_JOURNEY_BY_ELEMENT_URL: "journeys/currentElement/",
        JOURNEY_INTERACTION_URL: "journeys/interaction/",
        ELEMENT_IDENTIFIERS_URL: "element/identifiers/",
        ELEMENT_URL: "element/",
        ACCOUNT_URL: "account/",
        NOTE_URL: "/note/",
		WORKREQID: "workRequestId",
        TOPIC_PARAM: "&topic=",
        BEFORE_PARAM: "&before="
    };

    AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProviderURL = CustomerJourneyProviderURL;


})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement
     * @define AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions
     * @property AvayaDataStoreClient.Providers.CustomerManagemente.CustomerManagementNetworkOptions#
     */
    var CustomerManagementNetworkOptions = {
        url: undefined,
        sendType: undefined,
        urlSuffix: '/services/CustomerManagement/rest/customers',
		contentType: "application/json; charset=UTF-8",
        dataType: undefined,
        timeout: 2000,
        processData: true
    };	
    AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions = CustomerManagementNetworkOptions;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement
     * @define AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider
     * @param {AvayaDataStoreClient.Base.SockJSNetworkProvider} restProvider
     * @constructor
     */

    function CustomerManagementNetworkProvider(restProvider) {
		
        /**
         * @private
         * @type {AvayaDataStoreClient.Base.RESTProvider}
         * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#
         */
        this._restProvider = restProvider;

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.serverInfo}
         * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#
         */
        this._config = undefined;

    }

    /**
     * @public
     * @function AvayaDataStoreClient.Providers.CustomerManagementCustomerManagementNetworkProvider#init
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementeNetworkProvider#
     * @param {AvayaDataStoreClient.Config.ServerInfo} serverConfig
     * @returns {void}
     */
    CustomerManagementNetworkProvider.prototype.init = function(serverConfig) {
        this._config = serverConfig;
        if (!this._restProvider) {
            this._restProvider = new AvayaDataStoreClient.Base.RESTProvider();
        }

        this._restProvider._config = this._config;
    };
     
    /**
     * @public
     * @function AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#send
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions} options
     * @returns {*|AvayaDataStoreClient.Base.CustomerManagementPromise}
     */ 
    CustomerManagementNetworkProvider.prototype.send = function(data, options, isGuest) {
        return this._restProvider.send(data, options, isGuest).then(
            function (response) {
                AvayaDataStoreClient.Base.Logger.log("successfully processed request for:"+options.urlSuffix);
                return response;
            }, function (error) {
                AvayaDataStoreClient.Base.Logger.log("error in processing request for:"+options.urlSuffix);
                return this._handleError(error);
            }.bind(this));
    };	
	
    /**
     * @public
     * @function AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#generateToken
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#
     * @param {JSON} data
     * @param {AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions} options
     * @returns {*|AvayaDataStoreClient.Base.CustomerManagementPromise}
     */
    CustomerManagementNetworkProvider.prototype.generateToken = function(options) {
        return this._restProvider.generateToken(options).then(
            function (token) {
                AvayaDataStoreClient.Base.Logger.log("token generated");   
                return token;             			
            }, function (error) {
                AvayaDataStoreClient.Base.Logger.log("error in rest sending");
                return this._handleError(error);
            }.bind(this));
    };

    /**
     * Converts Customer Management JSON error response to {@link AvayaDataStoreClient.Base.CustomerManagementError} and returns it.
     *
     * @private
     * @function AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#_handleError
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider#
     * @param {{errorCode:string, reason:string, message:string}} json
     * @returns {AvayaDataStoreClient.Base.CustomerManagementError}
     */
    CustomerManagementNetworkProvider.prototype._handleError = function(error) {
        var errorCode=error.status;
        var reason = error.statusText;
        var message = error.responseText;
        if (! error) {
            return new AvayaDataStoreClient.Base.CustomerManagementError(errorCode, reason, message);
        }else{
            reason=error;
        }        
        if (error.errorMessage) {
            message=error.errorMessage;
            if(error.errorCode){
                errorCode = error.errorCode;
            }            
        } else if (error.data) {  
            var  eData  = error.data.split("::");
            if(eData.length > 1){
                message = eData[1];
                errorCode = eData[0];
            }
        }
        AvayaDataStoreClient.Base.Logger.warn(JSON.stringify(error));
        return new AvayaDataStoreClient.Base.CustomerManagementError(errorCode, reason, message);
    };

    AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider = CustomerManagementNetworkProvider;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @description
     * Context Store Provider to connect from service to network layer
     * @define AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement
     * @constructor
     */
    function CustomerManagementProvider() {
        /**
         * @private
         * @type {AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider}
         * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider#
         */
        this._csNetworkProvider = new AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkProvider();

        /**
         *
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider#
         */
        this.cmConfig = null;
    }

    function isEmpty(arg) {
       if(arg === undefined) {
         return true;
       }

       if(arg.length  === undefined || arg.length === 0) {
         return true;
       }

       return false;
    }

    function checkQueryParamsFormat(urlSuffix){
        if (!(urlSuffix.includes('?'))){
            urlSuffix = urlSuffix.replace(/\&+?/, "\/?");
        }
        return urlSuffix;
    }

    function addQueryParams(requestData, options) {
        if (typeof requestData.custId !== "undefined" && requestData.custId !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.CUSTIDPARAM + requestData.custId;
        }
        if (typeof requestData.crmId !== "undefined" && requestData.crmId !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.CRMIDPARAM + requestData.crmId;
        }
        if (typeof requestData.email !== "undefined" && requestData.email !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.EMAILPARAM + requestData.email;
        }
        if (typeof requestData.phone !== "undefined" && requestData.phone !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.PHONEPARAM + requestData.phone;
        }
        if (typeof requestData.social !== "undefined" && requestData.social !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.SOCIALPARAM + requestData.social;
        }
        if (typeof requestData.platform !== "undefined" && requestData.platform !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.PLATFORMPARAM + requestData.platform;
        }
        if (typeof requestData.accountId !== "undefined" && requestData.accountId !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.ACCOUNTIDPARAM + requestData.accountId;
        }
        if (typeof requestData.accountType !== "undefined" && requestData.accountType !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.ACCOUNTTYPEPARAM + requestData.accountType;
        }
        if (typeof requestData.summaryDataOnly !== "undefined" && requestData.summaryDataOnly !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.SUMMARYPARAM + requestData.summaryDataOnly;
        }
        if (typeof requestData.topic !== "undefined" && requestData.topic !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.TOPICPARAM + requestData.topic;
        }
        if (typeof requestData.customerId !== "undefined" && requestData.customerId !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.CUSTIDKEYPARAM + requestData.customerId;
        }
        if (typeof requestData.workrequestId !== "undefined" && requestData.workrequestId !== '') {
            options.urlSuffix += AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.WORKREQIDPARAM + requestData.workrequestId;
        }
        options.urlSuffix = checkQueryParamsFormat(options.urlSuffix);

        return options;
    }

    CustomerManagementProvider.prototype =
            /** @lends AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider.prototype **/
    {
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#generateToken
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
//        generateToken: function (cmConfig, requestData) {
//            this.cmConfig=cmConfig;
//            this._csNetworkProvider.init(this.cmConfig.serverInfo);
//            var scope = requestData.scope;
//            var username = requestData.username;
//            var password = requestData.password;
//                            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
//                            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GENERATETOKENURL;
//                            var USERNAMESUFFIX = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.USERNAMESUFFIX;
//                            var SCOPESUFFIX = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.SCOPESUFFIX;
//            if (!isEmpty(scope) && !isEmpty(username)){
//              options.urlSuffix+=USERNAMESUFFIX+SCOPESUFFIX;
//              options.headers = {'scope':scope, 'username':username, 'password':password};
//            }else if (!isEmpty(scope)){
//              options.urlSuffix+=SCOPESUFFIX;
//              options.headers = {'scope':scope};
//            }else if (!isEmpty(username)){
//              options.urlSuffix+=USERNAMESUFFIX;
//              options.headers = {'username':username, 'password':password};
//            }
//            options.sendType='GET';
//            options.crossDomain='TRUE';
//                  return this._csNetworkProvider.generateToken(options);
//              },



        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerManagementStatus
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @param {Object} requestData
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagementPromise}
         */
        getCustomerManagementStatus: function (csConfig, requestData) {
            this.csConfig=csConfig;
            this._csNetworkProvider.init(this.csConfig.serverInfo);
            var options=AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix=AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.STATUSCHECKURL;
			options.sendType='GET';
			options.headers = {'Content-Type':'application/text'};
			options.dataType='text';
            return this._csNetworkProvider.send({},options,this.csConfig.isGuest);
        },
		
		
		
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerRecord
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
		getCustomerRecord: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCRMRECORDURL;
            options.sendType = 'GET';
			if (typeof requestData.authorization !== "undefined" && requestData.authorization !== '') {
				var authorization = requestData.authorization;
				options.headers = {'Content-Type': 'application/json', 'Authorization': '$authorization'};
			}else{
				options.headers = {'Content-Type': 'application/json'};
			}			
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
                            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerId
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
		getCustomerId: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCUSTOMERIDURL;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
                            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerJourney
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
		getCustomerJourney: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var workrequestId = requestData.workrequestId;
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCUSTJOURNEYURL + workrequestId;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
                            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerJourneyOnCustomer
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
        getCustomerJourneyOnCustomer: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL + "journeys";
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerDetails
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
        getCustomerDetails: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCUSTDETAILURL;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },
		
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerHistory
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
		getCustomerHistory: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCUSTHISTORYURL;
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
             return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#getCustomerHistoryOnCustomer
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
        getCustomerHistoryOnCustomer: function(cmConfig, requestData) {
            this.cmConfig = cmConfig;
            this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL + "history";
            options.sendType = 'GET';
            options.headers = {'Content-Type': 'application/json'};
            options.dataType = 'json';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send({}, options, this.cmConfig.isGuest);
        },

        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#createJourneyElement
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
		createJourneyElement: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCUSTJOURNEYURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.ELEMENTURL;
            options.sendType = 'POST';
			if (typeof requestData.authHeader !== "undefined" && requestData.authHeader !== '') {
				var authHeader = requestData.authHeader;
				options.headers = {'Content-Type': 'application/json', 'Authorization': '$authHeader'};
			}else{
				options.headers = {'Content-Type': 'application/json'};
			}
            options.dataType = 'text';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send(requestData.body,options, this.cmConfig.isGuest);
        },
		
        /**
         * @public
         * @function AvayaDataStoreClient.Config.CsConfiguration#updateJourneyElement
         * @memberOf AvayaDataStoreClient.Config.CsConfiguration#
         * @param {AvayaDataStoreClient.Config.CsConfiguration} cmConfig
         * @returns {AvayaDataStoreClient.Base.Promise|*|*|AvayaDataStoreClient.Base.CustomerManagmentPromise}
         */
		updateJourneyElement: function(cmConfig, requestData) {
			this.cmConfig = cmConfig;
			this._csNetworkProvider.init(this.cmConfig.serverInfo);
            var elementId = requestData.elementId;
            var options = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementNetworkOptions;
            options.urlSuffix = AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.FULLCONTEXTURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.GETCUSTJOURNEYURL +
                                AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL.ELEMENTURL + elementId;
            options.sendType = 'PUT';
			if (typeof requestData.authHeader !== "undefined" && requestData.authHeader !== '') {
				var authHeader = requestData.authHeader;
				options.headers = {'Content-Type': 'application/json', 'Authorization': '$authHeader'};
			}else{
				options.headers = {'Content-Type': 'application/json'};
			}
			options.dataType = 'text';
            options = addQueryParams(requestData, options);
            return this._csNetworkProvider.send(requestData.body, options, this.cmConfig.isGuest);
        }
    };

	function findAndRemove(Obj, property) {
		for(var prop in Obj){
		   if(Obj.hasOwnProperty(prop) && prop === property){
			delete Obj[prop];
		   }
		}
		return Obj;
	}

        AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider = CustomerManagementProvider;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */
 
/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Providers.CustomerManagement
     * @define AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL
     * @property AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL#
     */
    var CustomerManagementProviderURL = {
        BASECONTEXTURL: "/services/CustomerManagement/rest/customers",
        FULLCONTEXTURL: "/services/CustomerManagement/rest/customers/",
		STATUSCHECKURL: "/services/CustomerManagement/rest/customers/status_check",
        GETCRMRECORDURL: "records/",
        GETCUSTOMERIDURL: "customerId/",
        GETCUSTJOURNEYURL: "journeys/",
		GETCUSTDETAILURL: "details/",
		GETCUSTHISTORYURL: "history/",
		ELEMENTURL: "element/",
		WORKREQID: "workRequestId",
        CUSTIDPARAM: "&custid=",
        CRMIDPARAM: "&crmid=",
        EMAILPARAM: "&email=",
        PHONEPARAM: "&phone=",
        SOCIALPARAM: "&social=",
		PLATFORMPARAM: "&platform=",
        SUMMARYPARAM: "&summarydataonly=",
        AUTHHEADERPARAM: "&authorization=",
        CUSTIDKEYPARAM: "&customerId=",
        TOPICPARAM: "&topic=",
		WORKREQIDPARAM: "&workRequestId=",
        ACCOUNTIDPARAM: "&accountId=",
        ACCOUNTTYPEPARAM: "&accountType="
    };

    AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProviderURL = CustomerManagementProviderURL;


})(AvayaDataStoreClient);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description Context Store api prototype
 *
 */
(function (AvayaDataStoreClient, $) {
    'use strict';

    /**
     *   ContextStore API
     * @class
     * @define AvayaDataStoreClient.Services.ContextStore.ContextStore
     * @memberOf AvayaDataStoreClient.Services.ContextStore
     * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
     * @constructor
     */
    function ContextStore(csConfig) {

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
         */
        this._csConfig = csConfig;

        /**
         *  Object of Context Store
         * @private
         * @type {AvayaDataStoreClient.Services.ContextStore.ContextStoreService}
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         */
        this._contextStoreService = new AvayaDataStoreClient.Services.ContextStore.ContextStoreService(this);

    }

    ContextStore.prototype =
    /** @lends AvayaDataStoreClient.Services.ContextStore.ContextStore.prototype **/
    {
        /**
         *  request to generate Token
         *  
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#generateToken
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @returns {String} token value
         */
        generateToken: function (scope,username,password) {
            if (!this._csConfig) {
                var dfd = $.Deferred();
                dfd.reject("Context Store configuration is not defined.");
                return dfd.promise();
            }            
            return this._contextStoreService.generateToken(this._csConfig, {scope:scope,username:username,password:password}).then(function (token) {   
                AvayaDataStoreClient.Base.Logger.info('Successfully Generated Token');
                return token;
            }.bind(this), function (error) {
                AvayaDataStoreClient.Base.Logger.error(error);
                return error;
            });
        },
		
        /**
         * Get Context Store Status
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getContextStoreStatus
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
		 * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @returns {String} response with String 
         */ 
		 
        getContextStoreStatus: function () {		
			return this._contextStoreService.getContextStoreStatus(this._csConfig, {})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Store Status could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Store Status: %o:', response);
			});
        },		

		
        /**
         *  request to create Context
         *  
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#createContext
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail
		 * @param {Integer} lease Context will be stored for period specified in lease 
		 * @param {Boolean} rules set flag to enable rules 
		 * @param {Boolean} shortId set flag to request short auto generated contextId (less than 12 characters) 
         * @returns {Object} response with empty string "" or JSON Object containing contextId (if it was not specified in request)

         */
        createContext: function (requestBody, sid, rid, touchpoint, lease, rules, shortId) {
            if (!this._csConfig) {
                var dfd = $.Deferred();
                dfd.reject("Context Store configuration is not defined.");
                return dfd.promise();
            }            
            return this._contextStoreService.createContext(this._csConfig, {requestBody:requestBody, sid:sid, rid:rid, touchpoint:touchpoint, lease:lease, rules:rules, shortId:shortId}).fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Created: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Created: %o:', response);
			});
        },

        /**
         * Get Context from Context Store via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getContext
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail 
         * @returns {Object} response with JSON Object 
         */ 
		 
        getContext: function (contextId, sid, rid, touchpoint) {		
			return this._contextStoreService.getContext(this._csConfig, {contextId:contextId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },		

        /**
         * Get Context from Context Store via Context Id with Meta Data
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getContextWithMetaData
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail 
         * @returns {Object} response with JSON Object 
         */ 
		 
        getContextWithMetaData: function (contextId, sid, rid, touchpoint) {		
			return this._contextStoreService.getContextMeta(this._csConfig, {contextId:contextId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },	
		
        /**
         * Get Context Value from Context Store via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getValueByContextId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail  
         * @returns {String} value 
         */ 
		 
        getValueByContextId: function (contextId, key, sid, rid, touchpoint) {			
			return this._contextStoreService.getValueByContextId(this._csConfig, {contextId:contextId, key:key, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },

        /**
         * Get Context from Context Store via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getContextByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only) 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail   
         * @returns {Object} response with JSON Object 
         */ 
		 
        getContextByAliasId: function (aliasId, sid, rid, touchpoint ) {
			return this._contextStoreService.getContextByAliasId(this._csConfig, {aliasId:aliasId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },		

        /**
         * Get Context from Context Store via Alias Id With Meta Data
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getContextByAliasIdWithMetaData
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)  
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail   
         * @returns {Object} response with JSON Object 
         */ 
		 
        getContextByAliasIdWithMetaData: function (aliasId, sid, rid, touchpoint ) {
			return this._contextStoreService.getContextByAliasIdMeta(this._csConfig, {aliasId:aliasId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },	
		
        /**
         * Get Context Value from Context Store via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getValueByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)    
         * @param {String} key key name to retrieve   
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
         * @param {String} touchpoint User/application identifier for Audit Trail
         * @returns {String} value 
         */ 
		 
        getValueByAliasId: function (aliasId, key, sid, rid, touchpoint) {			
			return this._contextStoreService.getValueByAliasId(this._csConfig, {aliasId:aliasId, key:key, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },
		
        /**
         * Get Context from Context Store via Group Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getGroup
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} groupId Group Id 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
         * @returns {Object} response with JSON Object 
         */ 
		 
        getGroup: function (groupId, sid, rid) {			
			return this._contextStoreService.getGroup(this._csConfig, {groupId:groupId, sid:sid, rid:rid})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },

        /**
         * Get Group from Context Store via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getGroupByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId Alias Id
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
         * @returns {String} value
         */

        getGroupByAliasId: function (aliasId, sid, rid) {
            return this._contextStoreService.getGroupByAliasId(this._csConfig, {aliasId:aliasId, sid:sid, rid:rid})
                .fail(function (response) {
                    AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
                }).done(function (response) {
                    AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
                });
        },

        /**
         * Get ContextId from Context Store via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getContextIdByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only) 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail 
         * @returns {Object} response with JSON Object 
         */ 
		 
        getContextIdByAliasId: function (aliasId, sid, rid, touchpoint) {			
			return this._contextStoreService.getContextIdByAliasId(this._csConfig, {aliasId:aliasId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },
		
        /**
         * Get Alias(es) from Context Store via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getAliasesByContextId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail 
         * @returns {Object} response with JSON Object 
         */ 
		 
        getAliasesByContextId: function (contextId, sid, rid, touchpoint) {			
			return this._contextStoreService.getAliasesByContextId(this._csConfig, {contextId:contextId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },
		
        /**
         *  request to update Context or create it if it does not exist
         *  
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#upsertContext
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
         * @param {JSON} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 	 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail 
		 * @param {Integer} lease Context will be stored for period specified in lease 
		 * @param {Boolean} rules set flag to enable rules 
         * @returns {Object} response with JSON Object
         */
        upsertContext: function (contextId, requestBody, sid, rid, touchpoint, lease, rules) {
            if (!this._csConfig) {
                var dfd = $.Deferred();
                dfd.reject("Context Store configuration is not defined.");
                return dfd.promise();
            }            
            return this._contextStoreService.upsertContext(this._csConfig, {contextId:contextId, requestBody:requestBody, sid:sid, rid:rid, touchpoint:touchpoint, lease:lease, rules:rules}).fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Upserted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Upserted: %o:', response);
			});
        },
		
        /**
         *  request to update Context or create it if it does not exist
         *  
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#upsertContextByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only) 
         * @param {JSON} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 	 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail 
		 * @param {Integer} lease Context will be stored for period specified in lease 
		 * @param {Boolean} rules set flag to enable rules
         * @returns {Object} response with empty string "" or JSON Object containing contextId (if it was not specified in request)
         */
        upsertContextByAliasId: function (aliasId, requestBody, sid, rid, touchpoint, lease, rules) {
            if (!this._csConfig) {
                var dfd = $.Deferred();
                dfd.reject("Context Store configuration is not defined.");
                return dfd.promise();
            }            
            return this._contextStoreService.upsertContextByAliasId(this._csConfig, {aliasId:aliasId, requestBody:requestBody, sid:sid, rid:rid, touchpoint:touchpoint, lease:lease, rules:rules}).fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Upserted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Upserted: %o:', response);
			});
        },
		
        /**
         *  request to update Context
         *  
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateContext
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
         * @param {JSON} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 	 
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
         * @param {String} touchpoint User/application identifier for Audit Trail
         * @param {Integer} lease Context will be stored for period specified in lease
         * @param {Boolean} rules set flag to enable rules
	 * @param {String} groupId Group Id
         * @returns {String} empty string
         */
         updateContext: function(contextId, requestBody, sid, rid, touchpoint, lease, rules, groupId) {
            if (!this._csConfig) {
                var dfd = $.Deferred();
                dfd.reject("Context Store configuration is not defined.");
                return dfd.promise();
            }            
                            return this._contextStoreService.updateContext(this._csConfig, {contextId: contextId, requestBody: requestBody, sid: sid, rid: rid, touchpoint: touchpoint, lease: lease, rules: rules, groupId: groupId}).fail(function(response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Updated: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Updated: %o:', response);
			});
        },	
		
        /**
         * Updates Context Value in Context via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateValueByContextId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object   
         * @param {String} key key name to retrieve  
         * @param {String} value updated Value  
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
         * @param {String} touchpoint User/application identifier for Audit Trail
         * @param {Integer} lease Context will be stored for period specified in lease
         * @returns {String} empty string 
         */ 
		 
        updateValueByContextId: function (contextId, key, value, sid, rid, touchpoint, lease) {			
			return this._contextStoreService.updateValueByContextId(this._csConfig, {contextId:contextId, key:key, value:value, sid:sid, rid:rid, touchpoint:touchpoint, lease:lease})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be Updated: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Value Updated: %o:', response);
			});
        },	
		
        /**
         *  request to update Context By Alias Id
         *  
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateContextByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only) 
         * @param {JSON} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 	 
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
         * @param {String} touchpoint User/application identifier for Audit Trail
         * @param {Integer} lease Context will be stored for period specified in lease
         * @param {Boolean} rules set flag to enable rules
         * @param {String} groupId Group Id
         * @returns {String} empty string
         */
         updateContextByAliasId: function(aliasId, requestBody, sid, rid, touchpoint, lease, rules, groupId) {
            if (!this._csConfig) {
                var dfd = $.Deferred();
                dfd.reject("Context Store configuration is not defined.");
                return dfd.promise();
            }            
                            return this._contextStoreService.updateContextByAliasId(this._csConfig, {aliasId: aliasId, requestBody: requestBody, sid: sid, rid: rid, touchpoint: touchpoint, lease: lease, rules: rules, groupId: groupId}).fail(function(response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Updated: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Updated: %o:', response);
			});
        },	
		
        /**
         * Updates Context Value in Context via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateValueByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)   
         * @param {String} key key name to retrieve 
         * @param {String} value updated Value  
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
         * @param {String} touchpoint User/application identifier for Audit Trail
         * @param {Integer} lease Context will be stored for period specified in lease
         * @returns {String} empty string 
         */ 
		 
        updateValueByAliasId: function (aliasId, key, value, sid, rid, touchpoint, lease) {			
			return this._contextStoreService.updateValueByAliasId(this._csConfig, {aliasId:aliasId, key:key, value:value, sid:sid, rid:rid, touchpoint:touchpoint, lease:lease})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be Updated: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Value Updated: %o:', response);
			});
        },	
		
        /**
         * Updates Alias(es) in Context via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateAliasesByContextId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object  
         * @param {JSON} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail    
		 * @param {Integer} lease Context will be stored for period specified in lease 
         * @returns {Object} response 
         */ 
		 
        updateAliasesByContextId: function (contextId, requestBody, sid, rid, touchpoint, lease) {			
			return this._contextStoreService.updateAliasesByContextId(this._csConfig, {contextId:contextId, requestBody:requestBody, sid:sid, rid:rid, touchpoint:touchpoint,lease:lease})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be Updated: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Value Updated: %o:', response);
			});
        },
		
        /**
         * Updates Alias(es) in Context via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateAliasesByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)  
         * @param {JSON} requestBody Context data object containing required key/value pairs (required) The same optional fields are available as in ContextStoreRest (contextId, groupId, tenantId etc.) 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail    
		 * @param {Integer} lease Context will be stored for period specified in lease 
         * @returns {String} empty string
         */ 
		 
        updateAliasesByAliasId: function (aliasId, requestBody, sid, rid, touchpoint, lease) {			
			return this._contextStoreService.updateAliasesByAliasId(this._csConfig, {aliasId:aliasId, requestBody:requestBody, sid:sid, rid:rid, touchpoint:touchpoint, lease:lease})
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context Aliases could not be Updated: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Aliases Updated: %o:', response);
			});
        },

        /**
         * Deletes Context from Context Store via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#deleteContext
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
         * @returns {String} empty string
         */ 
		 
        deleteContext: function (contextId, sid, rid) {	
			return this._contextStoreService.deleteContext(this._csConfig, {contextId:contextId, sid:sid, rid:rid})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Deleted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Deleted: %o:', response);
			});
        },				
		
        /**
         * Deletes Context Value from Context via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#deleteValueByContextId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object  
         * @param {String} key key name to retrieve   
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail   
         * @returns {String} empty string
         */ 
		 
        deleteValueByContextId: function (contextId, key, sid, rid, touchpoint ) {			
			return this._contextStoreService.deleteValueByContextId(this._csConfig, {contextId:contextId, key:key, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be Deleted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Value Deleted: %o:', response);
			});
        },	

        /**
         * Deletes Context from Context Store via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#deleteContextByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)  
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
         * @returns {String} empty string
         */ 
		 
        deleteContextByAliasId: function (aliasId, sid, rid) {	
			return this._contextStoreService.deleteContextByAliasId(this._csConfig, {aliasId:aliasId, sid:sid, rid:rid})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be Deleted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Deleted: %o:', response);
			});
        },				
		
        /**
         * Deletes Context Value from Context via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#deleteValueByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)  
         * @param {String} key key name to retrieve     
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail    
         * @returns {String} empty string
         */ 
		 
        deleteValueByAliasId: function (aliasId, key, sid, rid, touchpoint) {			
			return this._contextStoreService.deleteValueByAliasId(this._csConfig, {aliasId:aliasId, key:key, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Context Value could not be Deleted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Value Deleted: %o:', response);
			});
        },			
		
        /**
         * Deletes Alias from Context via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#deleteAliasByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)   
		 * @param {String} sid session id associated with a Context entry 
		 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment 
		 * @param {String} touchpoint User/application identifier for Audit Trail    
         * @returns {String} empty string
         */ 
		 
        deleteAliasByAliasId: function (aliasId, sid, rid, touchpoint) {			
			return this._contextStoreService.deleteAliasByAliasId(this._csConfig, {aliasId:aliasId, sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context Alias could not be Deleted: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Alias Deleted: %o:', response);
			});
        },



        /**
         * Get Audit Trail from Context via Context Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getAuditByContextId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object  
         * @param {String} sid session id associated with a Context entry
         * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
	 * @param {String} touchpoint User/application identifier for Audit Trail
         * @returns {Object} response with JSON Object
         */ 
		 
                        getAuditByContextId: function(contextId, sid, rid, touchpoint) {
                            return this._contextStoreService.getAuditByContextId(this._csConfig, {contextId: contextId, sid: sid, rid: rid, touchpoint: touchpoint})
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context Audit Trail could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context Audit Trail: %o:', response);
			});
        },	

        /**
         * Get Audit Trail from Context via Alias Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getAuditByAliasId
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} aliasId additional, indexable identifier(s) for the Context (for requests "by AliasId" only)  
	 * @param {String} sid session id associated with a Context entry
	 * @param {String} rid routing identifier which is used to distinguish between Contexts in geo-redundant deployment
	 * @param {String} touchpoint User/application identifier for Audit Trail
         * @returns {Object} response with JSON Object
         */ 
		 
        getAuditByAliasId: function (aliasId, sid, rid, touchpoint) {
			return this._contextStoreService.getAuditByAliasId(this._csConfig, {aliasId:aliasId , sid:sid, rid:rid, touchpoint:touchpoint})
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context Audit Trail could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },		

		/********************************
		/*** Context Store Query APIs ***
		/********************************
		
        /**
         * Get EDM Context Entry
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getEDMEntry
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
         * @param {Boolean} diff enable to show differences for context entries 
		 * @param {Boolean} data enable to show context data 
		 * @param {Boolean} metadata enable to show context metadata
		 * @param {Boolean} schema enable to show schema related to the context
         * @returns {Object} response with JSON Object
         */ 
        getEDMEntry: function (contextId, diff, data, metadata, schema) {
			return this._contextStoreService.getEDMEntry(this._csConfig, {contextId:contextId, diff:diff , data:data, metadata:metadata, schema:schema})	
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context Entry could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },		

        /**
         * Get EDM Context Entry Audit Trail
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getEDMEntryAudit
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} contextId contextId of Context data object 
         * @param {Boolean} diff enable to show differences for context entries 
		 * @param {Boolean} data enable to show context data 
		 * @param {Boolean} metadata enable to show context metadata
		 * @param {Boolean} schema enable to show schema related to the context
         * @returns {Object} response with JSON Object
         */ 
        getEDMEntryAudit: function (contextId, diff, data, metadata, schema) {
			return this._contextStoreService.getEDMEntryAudit(this._csConfig, {contextId:contextId, diff:diff , data:data, metadata:metadata, schema:schema})	
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context Audit Trail could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        },	

        /**
         * Get EDM Context Group Audit Trail
         *
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getEDMGroupAudit
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore
         * @param {String} groupId Group Id 
         * @param {Boolean} diff enable to show differences for context entries 
		 * @param {Boolean} data enable to show context data 
		 * @param {Boolean} metadata enable to show context metadata
		 * @param {Boolean} schema enable to show schema related to the context
         * @returns {Object} response with JSON Object
         */ 
        getEDMGroupAudit: function (groupId, diff, data, metadata, schema) {
			return this._contextStoreService.getEDMGroupAudit(this._csConfig, {groupId:groupId, diff:diff , data:data, metadata:metadata, schema:schema})
			.fail(function (response) {
                                        AvayaDataStoreClient.Base.Logger.log('ERROR! Group Context Audit Trail could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
			});
        }
		
   };
    AvayaDataStoreClient.Services.ContextStore.ContextStore = ContextStore;

})(AvayaDataStoreClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';
    /**
     * @class
     * @memberOf AvayaDataStoreClient.Services.ContextStore
     * @define AvayaDataStoreClient.Services.ContextStore.ContextStoreConstants
     * @property AvayaDataStoreClient.Services.ContextStore.ContextStoreConstants#
     */
    var ContextStoreConstants =  {
        SUCCESSSTATUSCODE : "200",
        NOTFOUNDSTATUSCODE : "404",
        FAILSTATUSCODE : "500",
        BADREQUESTSTATUSCODE : "400",
        REDIRECTSTATUSCODE : "302",
        SUCCESSRESULT: "success"
    };

    AvayaDataStoreClient.Services.ContextStore.ContextStoreConstants = ContextStoreConstants;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient, $) {
    'use strict';

    var contextStoreRequestBuilder = {
        /** @requires AvayaDataStoreClient.Services.ContextStore.ContextStore
         /** @lends AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder.prototype **/

        /**
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#createAgentRequestSessionArguments
         * @memberof AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#
         * @description
         * Creates agent request session argument object with default options
         * @returns {{apikey: string, extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
         */
        createRequestSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent request session.
             * @type {{apikey: string,extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
             * @private
             */
            var _defaultAgentRequestSessionArguments = {
                apikey: 'defaultapikey',
                extkey: undefined,
                name: undefined,
                autoJoin: false,
                locale: 'en_US',
                emailid: undefined
            };
            return _defaultAgentRequestSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#createJoinSessionArguments
         * @memberof AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#
         * @description
         * Creates join session argument object with default options
         * @returns {{acstoken: undefined, useragent: undefined}}
         */
        createJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins session
             * @type {{acstoken: undefined, useragent: undefined}}
             * @private
             */
            var _defaultAgentJoinSessionArguments = {
                acstoken: undefined,
                useragent: undefined
            };
            return _defaultAgentJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#createLiveJoinSessionArguments
         * @memberof AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#
         * @description
         * Creates join live (created by customer) session argument object with default options
         * @returns {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
         */
        createLiveJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins Live session.
             * @type {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
             * @private
             */
            var _defaultAgentLiveJoinSessionArguments = {
                sessionkey: undefined,
                name: undefined,
                clientname: undefined,
                emailid: undefined,
                extkey: undefined
            };
            return _defaultAgentLiveJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#createStatusArguments
         * @memberof AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#
         * @description
         * Creates status session argument object with default options
         * @returns {{acstoken: undefined}|*}
         */
        createStatusArguments: function () {
            /**
             * @description
             * Default arguments for status Agent session.
             * @type {{acstoken: undefined}}
             * @private
             */
            var _defaultAgentStatusArguments = {
                acstoken: undefined
            };
            return _defaultAgentStatusArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#createLogoutSessionArgs
         * @memberof AvayaDataStoreClient.Services.ContextStore.ContextStoreRequestBuilder#
         * @description
         * Creates logout session argument object with default options
         * @returns {{acstoken: undefined, reason: string}}
         */
        createLogoutSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent logout session.
             * @type {{acstoken: undefined, reason: 'logout',eurl: undefined}}
             * @private
             */
            var _defaultAgentLogoutSessionArguments = {
                acstoken: undefined,
                reason: 'logout',
                eurl: undefined
            };
            return _defaultAgentLogoutSessionArguments;
        }
    };

    $.extend(AvayaDataStoreClient.Services.ContextStore.ContextStore.prototype, contextStoreRequestBuilder);

})(AvayaDataStoreClient, jQuery);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @description
     *
     * Service class to connect the ContextStore api to ContextStore provider
     * @class
     * @define AvayaDataStoreClient.Services.ContextStore.ContextStoreService
     * @memberOf AvayaDataStoreClient.Services.ContextStore
     * @constructor
     */
    function ContextStoreService(contextStore) {

        /**
         * @private
         * @type {AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider}
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
         */
        this._contextStoreProvider = new AvayaDataStoreClient.Providers.ContextStore.ContextStoreProvider();

        this._contextStore = contextStore;

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
         */
        this._csConfig = null;

        /**
         * @private
         * @type {AvayaDataStoreClient.Base.DataSet}
         * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
         */
        this._csDataSet = new AvayaDataStoreClient.Base.DataSet();
    }

    /**
     * @description
     *
     * Generate Token
     * @public
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#generateToken
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.generateToken = function (csConfig, requestData) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.generateToken(this._csConfig, requestData);
    };

    /**
     * @description To get dataset
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#getDataSet
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getDataSet = function () {
        return this._csDataSet;
    };

    /**
     * @description To get Context Store Service Status
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getContextStoreStatus
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getContextStoreStatus = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getContextStoreStatus(this._csConfig, requestdata);
    };

    /**
     * @description
     *
     * Create Context
     * @public
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#createContext
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.createContext = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.createContext(this._csConfig, requestdata);
    };

    /**
     * @description To get Context dataset
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getContext
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getContext = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getContext(this._csConfig, requestdata);
    };

    /**
     * @description To get Context dataset with meta data
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getContextMeta
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getContextMeta = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getContextMeta(this._csConfig, requestdata);
    };

    /**
     * @description To get Context dataset
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getContextByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getContextByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getContextByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description To get Context dataset with meta data
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getContextByAliasIdMeta
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getContextByAliasIdMeta = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getContextByAliasIdMeta(this._csConfig, requestdata);
    };

    /**
     * @description To get Context value
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getValueByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getValueByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getValueByContextId(this._csConfig, requestdata);
    };

    /**
     * @description To get Context value By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getValueByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getValueByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getValueByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description To get Context dataset via Group Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getGroup
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getGroup = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getGroup(this._csConfig, requestdata);
    };

    /**
     * @description To get Group via Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getGroupByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getGroupByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getGroupByAliasId(this._csConfig, requestdata);
    };


    /**
     * @description To get Context Context Id via Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getContextIdByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getContextIdByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getContextIdByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description To get Context Alias(es) via Context Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getAliasesByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getAliasesByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getAliasesByContextId(this._csConfig, requestdata);
    };

    /**
     * @description Upsert Context
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#upsertContext
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.upsertContext = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.upsertContext(this._csConfig, requestdata);
    };

    /**
     * @description Upsert Context By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#upsertContextByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.upsertContextByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.upsertContextByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description Update Context
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateContext
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.updateContext = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.updateContext(this._csConfig, requestdata);
    };

    /**
     * @description Update Value in Context
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#updateValueByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.updateValueByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.updateValueByContextId(this._csConfig, requestdata);
    };

    /**
     * @description Update Context By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateContextByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.updateContextByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.updateContextByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description Update Value in Context By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#updateValueByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.updateValueByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.updateValueByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description Update Alias(es) By Context Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateAliasesByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.updateAliasesByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.updateAliasesByContextId(this._csConfig, requestdata);
    };

    /**
     * @description Update Alias(es) By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStore#updateAliasesByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStore#
     * @returns {||AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.updateAliasesByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.updateAliasesByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description Delete Context
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#deleteContext
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.deleteContext = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.deleteContext(this._csConfig, requestdata);
    };

    /**
     * @description Delete Value from Context
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#deleteValueByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.deleteValueByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.deleteValueByContextId(this._csConfig, requestdata);
    };

    /**
     * @description Delete Context By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#deleteContextByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.deleteContextByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.deleteContextByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description Delete Value from Context By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#deleteValueByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.deleteValueByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.deleteValueByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description Delete Alias from Context By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#deleteAliasByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.ContextStorePromise}
     */
    ContextStoreService.prototype.deleteAliasByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.deleteAliasByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description To get Audit Trail By Context Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getAuditByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getAuditByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getAuditByContextId(this._csConfig, requestdata);
    };

    /**
     * @description To get Audit Trail By Alias Id
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getAuditByAliasId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getAuditByAliasId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getAuditByAliasId(this._csConfig, requestdata);
    };

    /**
     * @description To get EDM Entry
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getEDMEntry
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getEDMEntry = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getEDMEntry(this._csConfig, requestdata);
    };	

    /**
     * @description To get EDM Entry Audit
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getEDMEntryAudit
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getEDMEntryAudit = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getEDMEntryAudit(this._csConfig, requestdata);
    };	

    /**
     * @description Get EDM Context Group Audit Trail
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getEDMGroupAudit
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getEDMGroupAudit = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getEDMGroupAudit(this._csConfig, requestdata);
    };	

    /**
     * @description Get EDM Context Group Audit Trail by Context ID
     * @function AvayaDataStoreClient.Services.ContextStore.ContextStoreService#getEDMGroupAuditByContextId
     * @memberOf AvayaDataStoreClient.Services.ContextStore.ContextStoreService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    ContextStoreService.prototype.getEDMGroupAuditByContextId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._contextStoreProvider.getEDMGroupAuditByContextId(this._csConfig, requestdata);
    };	

    ContextStoreService.prototype.onFailure = function (error, dfd) {
        var message = error.getMessage();
        AvayaDataStoreClient.Base.Logger.error(error.getReason(), message);
        dfd.reject(new AvayaDataStoreClient.Base.ContextStoreError(error.getErrorCode(),error.getReason(), message));
    };

    AvayaDataStoreClient.Services.ContextStore.ContextStoreService = ContextStoreService;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description Context Store api prototype
 *
 */
(function (AvayaDataStoreClient, $) {
    'use strict';

    /**
     * Customer Journey API
     * @class
     * @define AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney
     * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
     * @constructor
     */
    function CustomerJourney(csConfig) {

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#
         */
        this._csConfig = csConfig;

        /**
         *  Object of Context Store
         * @private
         * @type {AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService}
         * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
         */
        this._customerJourneyService = new AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService(this);

    }

    CustomerJourney.prototype =
        /** @lends AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney.prototype **/
        {

            /**
             * Get Customer Journey via Customer Id
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#getCustomerJourney
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} customerId customerId of data object
             * @param {String} topic topic associated with the customer journey
             * @returns {Object} response with JSON Object
             */
            getCustomerJourney: function (customerId, topic) {
                return this._customerJourneyService.getCustomerJourney(this._csConfig, {
                    customerId: customerId,
                    topic: topic
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey could not be returned: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
                    });
            },

            /**
             * Get Customer Journey via Element Id
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#getCustomerJourneyViaElementId
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} elementId elementId of data object
             * @param {String} topic topic associated with the customer journey
             * @param {String} before only entries earlier than this time will be returned
             * @returns {Object} response with JSON Object
             */
            getCustomerJourneyViaElementId: function (elementId, topic, before) {
                return this._customerJourneyService.getCustomerJourneyViaElementId(this._csConfig, {
                    elementId: elementId,
                    topic: topic,
                    before: before
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey could not be returned: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
                    });
            },

            /**
             * Get Customer Journey with Admin data via Element Id
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#getCustomerJourneyWithAdminDataViaElementId
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} elementId elementId of data object
             * @param {String} topic topic associated with the customer journey
             * @param {String} before only entries earlier than this time will be returned
             * @returns {Object} response with JSON Object
             */
            getCustomerJourneyWithAdminDataViaElementId: function (elementId, topic, before) {
                return this._customerJourneyService.getCustomerJourneyWithAdminDataViaElementId(this._csConfig, {
                    elementId: elementId,
                    topic: topic,
                    before: before
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey could not be returned: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
                    });
            },

            /**
             * Get Last Journey Element via Element Id
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#getLastJourneyElement
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} elementId elementId of data object
             * @param {String} topic topic associated with the customer journey
             * @param {String} before only entries earlier than this time will be returned
             * @returns {Object} response with JSON Object
             */
            getLastJourneyElement: function (elementId, topic, before) {
                return this._customerJourneyService.getLastJourneyElement(this._csConfig, {
                    elementId: elementId,
                    topic: topic,
                    before: before
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Journey Element could not be returned: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
                    });
            },

            /**
             * Get Customer Journey via Account Id
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#getCustomerJourneyViaAccountId
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} accountId accountId of data object
             * @param {String} topic topic associated with the customer journey
             * @returns {Object} response with JSON Object
             */
            getCustomerJourneyViaAccountId: function (accountId, topic) {
                return this._customerJourneyService.getCustomerJourneyViaAccountId(this._csConfig, {
                    accountId: accountId,
                    topic: topic
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey could not be returned: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
                    });
            },

            /**
             * Create Journey Element
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#createJourneyElement
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {Object} body Customer Journey data object containing key/value pairs
             * @returns {Object} response with JSON Object
             */
            createJourneyElement: function (body) {
                return this._customerJourneyService.createJourneyElement(this._csConfig, {
                    body: body
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey Element could not be created: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Customer Journey Element creation: %o:', response);
                    });
            },

            /**
             * Update Journey Element
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#updateJourneyElement
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} elementId Journey Element Id
             * @param {Object} body Customer Journey data object containing key/value pairs
             * @returns {Object} response with JSON Object
             */
            updateJourneyElement: function (elementId, body) {
                return this._customerJourneyService.updateJourneyElement(this._csConfig, {
                    elementId: elementId,
                    body: body
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey Element could not be updated: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Customer Journey Element update: %o:', response);
                    });
            },

            /**
             * Update Agent Note
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#updateAgentNote
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} interactionId Interaction Id
             * @param {Object} agentNote new value of Agent Note
             * @returns {Object} response with JSON Object
             */
            updateAgentNote: function (interactionId, agentNote) {
                return this._customerJourneyService.updateAgentNote(this._csConfig, {
                    interactionId: interactionId,
                    body: agentNote
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Agent Note could not be updated: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Agent Note update: %o:', response);
                    });
            },

            /**
             * Update Identifiers
             *
             * @public
             * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#updateIdentifiers
             * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
             * @param {String} elementId Element Id
             * @param {Object} body identifiers: customerId, externalId, accountId
             * @returns {Object} response with JSON Object
             */
            updateIdentifiers: function (elementId, body) {
                return this._customerJourneyService.updateIdentifiers(this._csConfig, {
                    elementId: elementId,
                    body: body
                })
                    .fail(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Identifiers could not be updated: %o:', response);
                    }).done(function (response) {
                        AvayaDataStoreClient.Base.Logger.log('Identifiers update: %o:', response);
                    });
            }

        };

    AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney = CustomerJourney;

})(AvayaDataStoreClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient, $) {
    'use strict';

    var contextStoreRequestBuilder = {
        /** @requires AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney
         /** @lends AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder.prototype **/

        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#createAgentRequestSessionArguments
         * @memberof AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#
         * @description
         * Creates agent request session argument object with default options
         * @returns {{apikey: string, extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
         */
        createRequestSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent request session.
             * @type {{apikey: string,extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
             * @private
             */
            var _defaultAgentRequestSessionArguments = {
                apikey: 'defaultapikey',
                extkey: undefined,
                name: undefined,
                autoJoin: false,
                locale: 'en_US',
                emailid: undefined
            };
            return _defaultAgentRequestSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#createJoinSessionArguments
         * @memberof AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#
         * @description
         * Creates join session argument object with default options
         * @returns {{acstoken: undefined, useragent: undefined}}
         */
        createJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins session
             * @type {{acstoken: undefined, useragent: undefined}}
             * @private
             */
            var _defaultAgentJoinSessionArguments = {
                acstoken: undefined,
                useragent: undefined
            };
            return _defaultAgentJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#createLiveJoinSessionArguments
         * @memberof AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#
         * @description
         * Creates join live (created by customer) session argument object with default options
         * @returns {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
         */
        createLiveJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins Live session.
             * @type {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
             * @private
             */
            var _defaultAgentLiveJoinSessionArguments = {
                sessionkey: undefined,
                name: undefined,
                clientname: undefined,
                emailid: undefined,
                extkey: undefined
            };
            return _defaultAgentLiveJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#createStatusArguments
         * @memberof AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#
         * @description
         * Creates status session argument object with default options
         * @returns {{acstoken: undefined}|*}
         */
        createStatusArguments: function () {
            /**
             * @description
             * Default arguments for status Agent session.
             * @type {{acstoken: undefined}}
             * @private
             */
            var _defaultAgentStatusArguments = {
                acstoken: undefined
            };
            return _defaultAgentStatusArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#createLogoutSessionArgs
         * @memberof AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyRequestBuilder#
         * @description
         * Creates logout session argument object with default options
         * @returns {{acstoken: undefined, reason: string}}
         */
        createLogoutSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent logout session.
             * @type {{acstoken: undefined, reason: 'logout',eurl: undefined}}
             * @private
             */
            var _defaultAgentLogoutSessionArguments = {
                acstoken: undefined,
                reason: 'logout',
                eurl: undefined
            };
            return _defaultAgentLogoutSessionArguments;
        }
    };

    $.extend(AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney.prototype, contextStoreRequestBuilder);

})(AvayaDataStoreClient, jQuery);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @description
     *
     * Service class to connect the CustomerJourney api to CustomerJourney provider
     * @class
     * @define AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney
     * @constructor
     */
    function CustomerJourneyService() {

        /**
         * @private
         * @type {AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider}
         * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
         */
        this._customerJourneyProvider = new AvayaDataStoreClient.Providers.CustomerJourney.CustomerJourneyProvider();

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
         */
        this._csConfig = null;

        /**
         * @private
         * @type {AvayaDataStoreClient.Base.DataSet}
         * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
         */
        this._csDataSet = new AvayaDataStoreClient.Base.DataSet();
    }

    /**
     * @description
     *
     * Generate Token
     * @public
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#generateToken
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#
     * @returns {||AvayaDataStoreClient.Base.CustomerJourneyPromise}
     */
    CustomerJourneyService.prototype.generateToken = function (csConfig, requestData) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.generateToken(this._csConfig, requestData);
    };

    /**
     * @description To get dataset
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#getDataSet
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourney#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.getDataSet = function () {
        return this._csDataSet;
    };

    /**
     * @description To get Customer Journey via customerId
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#getCustomerJourney
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.getCustomerJourney = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.getCustomerJourney(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer Journey via elementId
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#getCustomerJourneyViaElementId
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.getCustomerJourneyViaElementId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.getCustomerJourneyViaElementId(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer Journey with admin data via elementId
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#getCustomerJourneyWithAdminDataViaElementId
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.getCustomerJourneyWithAdminDataViaElementId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.getCustomerJourneyWithAdminDataViaElementId(this._csConfig, requestdata);
    };

    /**
     * @description To get last Journey Element
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#getLastJourneyElement
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.getLastJourneyElement = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.getLastJourneyElement(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer Journey via elementId
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#getCustomerJourneyViaAccountId
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.getCustomerJourneyViaAccountId = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.getCustomerJourneyViaAccountId(this._csConfig, requestdata);
    };

    /**
     * @description To create Journey Element
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#createJourneyElement
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.createJourneyElement = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.createJourneyElement(this._csConfig, requestdata);
    };

    /**
     * @description To update Journey Element
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#updateJourneyElement
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.updateJourneyElement = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.updateJourneyElement(this._csConfig, requestdata);
    };

    /**
     * @description To update Agent Note
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#updateAgentNote
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.updateAgentNote = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.updateAgentNote(this._csConfig, requestdata);
    };

    /**
     * @description To update Identifiers
     * @function AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#updateIdentifiers
     * @memberOf AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerJourneyService.prototype.updateIdentifiers = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerJourneyProvider.updateIdentifiers(this._csConfig, requestdata);
    };

    CustomerJourneyService.prototype.onFailure = function (error, dfd) {
        var message = error.getMessage();
        AvayaDataStoreClient.Base.Logger.error(error.getReason(), message);
        dfd.reject(new AvayaDataStoreClient.Base.CustomerJourneyError(error.getErrorCode(), error.getReason(), message));
    };

    AvayaDataStoreClient.Services.CustomerJourney.CustomerJourneyService = CustomerJourneyService;

})(AvayaDataStoreClient);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description Context Store api prototype
 *
 */
(function (AvayaDataStoreClient, $) {
    'use strict';

    /**
     * Customer Management API
     * @class
     * @define AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement
     * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
     * @constructor
     */
    function CustomerManagement(csConfig) {

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#
         */
        this._csConfig = csConfig;

        /**
         *  Object of Context Store
         * @private
         * @type {AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService}
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         */
        this._customerManagementService = new AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService(this);

    }

    CustomerManagement.prototype =
            /** @lends AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement.prototype **/
    {
        // /**
         // *  request to generate Token
         // *  
         // * @public
         // * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#generateToken
         // * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         // * @returns {String} token value
         // */
        // generateToken: function (scope,username,password) {
            // if (!this._csConfig) {
                // var dfd = $.Deferred();
                // dfd.reject("Customer Management configuration is not defined.");
                // return dfd.promise();
            // }            
            // return this._customerManagementService.generateToken(this._csConfig, {scope:scope,username:username,password:password}).then(function (token) {   
                // AvayaDataStoreClient.Base.Logger.info('Successfully Generated Token');
                // return token;
            // }.bind(this), function (error) {
                // AvayaDataStoreClient.Base.Logger.error(error);
                // return error;
            // });
        // },
		
        /**
         * Get Customer Management Status
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerManagementStatus
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
		 * @param {AvayaDataStoreClient.Config.CsConfiguration} csConfig
         * @returns {String} response with String 
         */ 
		 
        getCustomerManagementStatus: function () {		
			return this._customerManagementService.getCustomerManagementStatus(this._csConfig, {})
			.fail(function (response) {
				AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Management Status could not be returned: %o:', response);
			}).done(function (response) {
				AvayaDataStoreClient.Base.Logger.log('Customer Management Status: %o:', response);
			});
        },	
		
        /**
         * Get Customer Record from Customer Management via Customer Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerRecord
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} custId Customer ID
         * @param {String} crmId Customer Record ID
         * @param {String} phone phone of Customer
         * @param {String} email email of Customer
         * @param {String} social social media details of Customer
         * @param {String} platform social media platform associated with the social media details of Customer
         * @param {String} accountId account id
         * @param {String} accountType account type
         * @param {Boolean} summaryDataOnly When set to true, only a data summary is shown
         * @param {String} authorization Authorization
         * @returns {Object} response with JSON Object 
         */ 		 
         getCustomerRecord: function(custId, crmId, phone, email, social, platform, accountId, accountType, summaryDataOnly, authorization) {
                            return this._customerManagementService.getCustomerRecord(this._csConfig, {custId: custId, crmId: crmId, phone: phone, email:email, social:social, platform:platform, accountId:accountId, accountType:accountType, summaryDataOnly:summaryDataOnly, authorization:authorization})
                    .fail(function(response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Context could not be returned: %o:', response);
                    }).done(function(response) {
                AvayaDataStoreClient.Base.Logger.log('Context: %o:', response);
            });
        },
        /**
         * Get Customer Id  from Customer Management via email or phone
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerId
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} crmId Customer Record ID
         * @param {String} phone phone of Customer 
         * @param {String} email email of Customer 
         * @param {String} social social media details of Customer
         * @param {String} platform social media platform associated with the social media details of Customer
         * @param {String} accountId account id
         * @param {String} accountType account type
         * @returns {Object} response with JSON Object 
         */
         getCustomerId: function(crmId, phone, email, social, platform, accountId, accountType) {
            return this._customerManagementService.getCustomerId(this._csConfig, {crmId: crmId, phone: phone, email: email, social: social, platform:platform, accountId:accountId, accountType:accountType})
                    .fail(function(response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Id could not be returned: %o:', response);
                    }).done(function(response) {
                AvayaDataStoreClient.Base.Logger.log('Customer Id: %o:', response);
            });
         },

                        /**
         * Get Customer Journey from Customer Management via work Request Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerJourney
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} workrequestId workrequestId of data object
		 * @param {String} topic topic associated with the customer journey
         * @returns {Object} response with JSON Object
         */
        getCustomerJourney: function(workrequestId, topic) {
            return this._customerManagementService.getCustomerJourney(this._csConfig, {workrequestId: workrequestId, topic:topic})
                    .fail(function(response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey could not be returned: %o:', response);
                    }).done(function(response) {
                AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
            });
        },

        /**
         * Get Customer Journey from Customer Management via customer Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerJourneyOnCustomer
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} customerId customerId of data object
         * @param {String} topic topic associated with the customer journey
         * @returns {Object} response with JSON Object
         */
        getCustomerJourneyOnCustomer: function(customerId, topic) {
            return this._customerManagementService.getCustomerJourneyOnCustomer(this._csConfig, {customerId: customerId, topic:topic})
                .fail(function(response) {
                    AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey could not be returned: %o:', response);
                }).done(function(response) {
                    AvayaDataStoreClient.Base.Logger.log('Context Journey: %o:', response);
                });
        },

        /**
         * Get Customer Details from Customer Management via work Request Id or Customer ID
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerDetails
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} workrequestId workrequestId of data object
         * @param {String} customerId Customer ID
         * @returns {Object} response with JSON Object
        */
        getCustomerDetails: function(workrequestId, customerId) {
            return this._customerManagementService.getCustomerDetails(this._csConfig, {workrequestId: workrequestId, customerId: customerId})
                .fail(function(response) {
                    AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Details could not be returned: %o:', response);
                }).done(function(response) {
                    AvayaDataStoreClient.Base.Logger.log('Context Details: %o:', response);
                });
		},

        /**
         * Get Customer History from Customer Management via work Request Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerHistory
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} workrequestId workrequestId of data object
         * @returns {Object} response with JSON Object
        */
		getCustomerHistory: function(workrequestId) {
            return this._customerManagementService.getCustomerHistory(this._csConfig, {workrequestId: workrequestId})
                    .fail(function(response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer History could not be returned: %o:', response);
                    }).done(function(response) {
                AvayaDataStoreClient.Base.Logger.log('Context History: %o:', response);
            });
		},

        /**
         * Get Customer History from Customer Management via customer Id
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerHistoryOnCustomer
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} customerId customerId of data object
         * @returns {Object} response with JSON Object
         */
        getCustomerHistoryOnCustomer: function(customerId) {
            return this._customerManagementService.getCustomerHistoryOnCustomer(this._csConfig, {customerId: customerId})
                .fail(function(response) {
                    AvayaDataStoreClient.Base.Logger.log('ERROR! Customer History could not be returned: %o:', response);
                }).done(function(response) {
                    AvayaDataStoreClient.Base.Logger.log('Context History: %o:', response);
                });
        },

        /**
         * Create Journey Element
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#createJourneyElement
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {Object} body 
         * @param {String} authorization Authorization Header
         * @returns {Object} response with JSON Object
        */
		createJourneyElement: function(body, authHeader) {
            return this._customerManagementService.createJourneyElement(this._csConfig, {body:body, authHeader:authorization})
                    .fail(function(response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey Element could not be created: %o:', response);
                    }).done(function(response) {
                AvayaDataStoreClient.Base.Logger.log('Customer Journey Element creation: %o:', response);
            });
		},

        /**
         * Update Journey Element
         *
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#updateJourneyElement
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         * @param {String} elementId Journey Element Id
         * @param {Object} body 
         * @param {String} authorization Authorization Header
         * @returns {Object} response with JSON Object
        */
		updateJourneyElement: function(elementId, body, authorization) {
            return this._customerManagementService.updateJourneyElement(this._csConfig, {elementId:elementId, body:body, authHeader:authorization})
                    .fail(function(response) {
                        AvayaDataStoreClient.Base.Logger.log('ERROR! Customer Journey Element could not be updated: %o:', response);
                    }).done(function(response) {
                AvayaDataStoreClient.Base.Logger.log('Customer Journey Element update: %o:', response);
            });
		}
		
   };
   
   AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement = CustomerManagement;

})(AvayaDataStoreClient, jQuery);
/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient, $) {
    'use strict';

    var contextStoreRequestBuilder = {
        /** @requires AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement
         /** @lends AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder.prototype **/

        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#createAgentRequestSessionArguments
         * @memberof AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#
         * @description
         * Creates agent request session argument object with default options
         * @returns {{apikey: string, extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
         */
        createRequestSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent request session.
             * @type {{apikey: string,extkey: unefined, name: undefined, autoJoin: boolean, locale: string, emailid: undefined}}
             * @private
             */
            var _defaultAgentRequestSessionArguments = {
                apikey: 'defaultapikey',
                extkey: undefined,
                name: undefined,
                autoJoin: false,
                locale: 'en_US',
                emailid: undefined
            };
            return _defaultAgentRequestSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#createJoinSessionArguments
         * @memberof AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#
         * @description
         * Creates join session argument object with default options
         * @returns {{acstoken: undefined, useragent: undefined}}
         */
        createJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins session
             * @type {{acstoken: undefined, useragent: undefined}}
             * @private
             */
            var _defaultAgentJoinSessionArguments = {
                acstoken: undefined,
                useragent: undefined
            };
            return _defaultAgentJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#createLiveJoinSessionArguments
         * @memberof AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#
         * @description
         * Creates join live (created by customer) session argument object with default options
         * @returns {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
         */
        createLiveJoinSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent joins Live session.
             * @type {{sessionkey: undefined, name: undefined, clientname: string, emailid: undefined, extkey: undefined}}
             * @private
             */
            var _defaultAgentLiveJoinSessionArguments = {
                sessionkey: undefined,
                name: undefined,
                clientname: undefined,
                emailid: undefined,
                extkey: undefined
            };
            return _defaultAgentLiveJoinSessionArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#createStatusArguments
         * @memberof AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#
         * @description
         * Creates status session argument object with default options
         * @returns {{acstoken: undefined}|*}
         */
        createStatusArguments: function () {
            /**
             * @description
             * Default arguments for status Agent session.
             * @type {{acstoken: undefined}}
             * @private
             */
            var _defaultAgentStatusArguments = {
                acstoken: undefined
            };
            return _defaultAgentStatusArguments;
        },
        /**
         * @public
         * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#createLogoutSessionArgs
         * @memberof AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementRequestBuilder#
         * @description
         * Creates logout session argument object with default options
         * @returns {{acstoken: undefined, reason: string}}
         */
        createLogoutSessionArguments: function () {
            /**
             * @description
             * Default arguments for Agent logout session.
             * @type {{acstoken: undefined, reason: 'logout',eurl: undefined}}
             * @private
             */
            var _defaultAgentLogoutSessionArguments = {
                acstoken: undefined,
                reason: 'logout',
                eurl: undefined
            };
            return _defaultAgentLogoutSessionArguments;
        }
    };

    $.extend(AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement.prototype, contextStoreRequestBuilder);

})(AvayaDataStoreClient, jQuery);

/*
 *
 * Copyright Avaya Inc., All Rights Reserved.
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * The copyright notice above does not evidence any actual or intended
 * publication of such source code.
 *
 * Some third-party source code components may have  been modified from their
 * original versions by Avaya Inc.
 *
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 */

/**
 * Description
 *
 */
(function (AvayaDataStoreClient) {
    'use strict';

    /**
     * @description
     *
     * Service class to connect the CustomerManagement api to CustomerManagement provider
     * @class
     * @define AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement
     * @constructor
     */
    function CustomerManagementService() {

        /**
         * @private
         * @type {AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider}
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
         */
        this._customerManagementProvider = new AvayaDataStoreClient.Providers.CustomerManagement.CustomerManagementProvider();

        /**
         * @private
         * @type {AvayaDataStoreClient.Config.CsConfiguration}
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
         */
        this._csConfig = null;

        /**
         * @private
         * @type {AvayaDataStoreClient.Base.DataSet}
         * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
         */
        this._csDataSet = new AvayaDataStoreClient.Base.DataSet();
    }

    /**
     * @description
     *
     * Generate Token
     * @public
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#generateToken
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#
     * @returns {||AvayaDataStoreClient.Base.CustomerManagementPromise}
     */
    CustomerManagementService.prototype.generateToken = function (csConfig, requestData) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.generateToken(this._csConfig, requestData);
    };

    /**
     * @description To get dataset
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getDataSet
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getDataSet = function() {
        return this._csDataSet;
    };

    /**
     * @description To get Customer Management Service Status
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#getCustomerManagementStatus
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagement#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerManagementStatus = function (csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerManagementStatus(this._csConfig, requestdata);
    };


    /**
     * @description To get Customer Record dataset
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerRecord
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerRecord = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerRecord(this._csConfig, requestdata);
    };


    /**
     * @description To get Customer Id
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerId
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerId = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerId(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer Journey
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerJourney
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerJourney = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerJourney(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer Journey
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerJourneyOnCustomer
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerJourneyOnCustomer = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerJourneyOnCustomer(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer Details
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerDetails
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerDetails = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerDetails(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer History
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerHistory
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerHistory = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerHistory(this._csConfig, requestdata);
    };

    /**
     * @description To get Customer History on Customer
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#getCustomerHistoryOnCustomer
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.getCustomerHistoryOnCustomer = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.getCustomerHistoryOnCustomer(this._csConfig, requestdata);
    };

    /**
     * @description To create Journey Element
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#createJourneyElement
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.createJourneyElement = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.createJourneyElement(this._csConfig, requestdata);
    };

    /**
     * @description To update Journey Element
     * @function AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#updateJourneyElement
     * @memberOf AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService#
     * @returns {AvayaDataStoreClient.Base.DataSet}
     */
    CustomerManagementService.prototype.updateJourneyElement = function(csConfig, requestdata) {
        this._csConfig = csConfig;
        return this._customerManagementProvider.updateJourneyElement(this._csConfig, requestdata);
    };
	
    CustomerManagementService.prototype.onFailure = function(error, dfd) {
        var message = error.getMessage();
        AvayaDataStoreClient.Base.Logger.error(error.getReason(), message);
        dfd.reject(new AvayaDataStoreClient.Base.CustomerManagementError(error.getErrorCode(), error.getReason(), message));
    };

    AvayaDataStoreClient.Services.CustomerManagement.CustomerManagementService = CustomerManagementService;

})(AvayaDataStoreClient);
