// source=contentLTR.js
// Load frame if necessary.

if (window.parent == self) {
    //get the location
    var hrefTarget = document.location.pathname;
    var needFrames = true;
    
    if (document.location.search) {
        //URL has a "?" followed by a string at its end. Currently,
        //"suppressframes" is the only thing that should be passed, so
        //assume that's what follows and set needFrames to false.
        needFrames = false;
    }
    
    if (needFrames) {
        if (hrefTarget.lastIndexOf("/") != 0) {
            hrefTarget = hrefTarget.substring(hrefTarget.lastIndexOf("/") + 1);
        }
        document.location.replace("index.html?" + hrefTarget + "&1");
    }
}

function expandTocId(idToExpand) {
    bodyOnload(); //See note on this function's definition.
    var navdoc = parent.frames[1].window.document;
    var targetNode = navdoc.getElementById(idToExpand);
    var browserName = navigator.appName;
    if (targetNode != null) {
        targetNode.style.color = "#cc0000";
        var thisParent = targetNode.parentNode;
        while (thisParent.nodeType != 9) {
            if (thisParent.className == "subList") {
                thisParent.style.display = 'block';
                if (browserName == "Microsoft Internet Explorer") {
                    thisParent.parentNode.style.setAttribute('cssText', 'list-style-image: url(expanded.gif)', 0);
                } else {
                    thisParent.parentNode.setAttribute('style', 'list-style-image: url(expanded.gif)');
                }
            }
            thisParent = thisParent.parentNode;
        }
    } else {
        //alert("null element");
    }
    return;
}

function removeTocHiglight(idToClear) {
    var navdoc = parent.navwin.window.document;
    var targetNode = navdoc.getElementById(idToClear);
    if (targetNode != null) {
        targetNode.style.color = "#777777";
    } else {
        //alert("null element");
    }
    return;
}

function syncToc(tocFile) {
  parent.navwin.location.href = tocFile; //Change nav tab to toc
  parent.contentwin.location.reload(); //Reload content to expand toc
}

function pops(url) {
    hostPlusPathname = url.split("#")[0]
    popwindow = window.open(hostPlusPathname + '?suppressframes', 'avayapopup', 'height=400,width=650,scrollbars=yes,location=no');
    if (window.focus) {
        popwindow.focus()
    }
    return false;
}

/*START Engagement Designer only. Not for general use. All DITA-OT generated image tags
  are lowercase <img>, so this code has no effect on projects other than Engagement Designer.
*/ 
function bodyOnload() {
  var imgTag = document.getElementsByTagName('IMG');
  for (var j = 0; j < imgTag.length; j++) {
    imgTag[j].setAttribute('src', imgTag[j].getAttribute('src') + window.location.search);
  }
}; //END Engagement Designer only