﻿//////////////////////////////////////////////////////////////////////////////
// AgentChangeConferenceOwnerNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentChangeConferenceOwnerNotificationTest
    {
        [TestMethod]
        public void AgentChangeConferenceOwnerNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""changeConferenceOwner"",
                                        ""guid"" : 12345,
                                        ""newOwner"" : ""123456""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentChangeConferenceOwnerNotification note = (AgentChangeConferenceOwnerNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "changeConferenceOwner");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.AreEqual(note.body.newOwner, "123456");


        }

    }


}

