﻿//////////////////////////////////////////////////////////////////////////////
// AgentCompleteConferenceNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentCompleteConferenceNotificationTest
    {
        [TestMethod]
        public void AgentCompleteConferenceNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""completeConference"",
                                        ""guid"" : 432333
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentCompleteConferenceNotification note = (AgentCompleteConferenceNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "completeConference");
            Assert.AreEqual(note.body.guid, 432333);

        }

    }


}

