﻿//////////////////////////////////////////////////////////////////////////////
// AgentWhisperMessageNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentWhisperMessageNotificationTest
    {
        [TestMethod]
        public void AgentWhisperMessageNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newWhisperMessage"",
                                        ""guid"" : 432555,
                                        ""originatingAgentId"" : ""123456"",
                                        ""message"" : ""whisper message""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentWhisperMessageNotification note = (AgentWhisperMessageNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "newWhisperMessage");
            Assert.AreEqual(note.body.guid, 432555);
            Assert.AreEqual(note.body.originatingAgentId, "123456");
            Assert.AreEqual(note.body.message, "whisper message");
        }

    }


}

