﻿//////////////////////////////////////////////////////////////////////////////
// AgentActiveNotification.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using Newtonsoft.Json;

namespace EncoderDecoder.Notifications
{
    public class AgentActiveNotification : IBaseNotification
    {
        public AgentActiveNotification()
        {
            this.body = new Body();
        }

        public string apiVersion { get; set; }
        public string type { get; set; }
        public Body body { get; set; }

        public class Body
        {
            public string method { get; set; }
            public long guid { get; set; }
            public string agentId { get; set; }
            public string userType { get; set; }
        }

        /// <summary>
        /// Decodes this notifications and returns object representation.
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        public IBaseNotification Decode(string json)
        {
            return JsonConvert.DeserializeObject<AgentActiveNotification>(json);
        }
        
    }
}
