﻿//////////////////////////////////////////////////////////////////////////////
// NewPagePushNotification.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using Newtonsoft.Json;
using System;

namespace EncoderDecoder.Notifications
{
    public class NewPagePushNotification : IBaseNotification
    {
        public NewPagePushNotification()
        {
            this.body = new Body();
        }

        public string apiVersion { get; set; }
        public string type { get; set; }
        public Body body { get; set; }

        public class Body
        {
            public Body()
            {
                sender = new Sender();
            }

            public string method { get; set; }
            public long guid { get; set; }
            public Sender sender { get; set; }
            public string displayName { get; set; }
            public string url { get; set; }
            public string destination { get; set; }
            public long timestamp { get; set; }
        }

        public class Sender
        {
            public string type { get; set; }
            public string agentId { get; set; }
        }

        /// <summary>
        /// Decodes this notifications and returns object representation.
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        public IBaseNotification Decode(string json)
        {
            return JsonConvert.DeserializeObject<NewPagePushNotification>(json);
        }

    }
}
