﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;

namespace EncoderDecoder.Requests
{
    /// <summary>
    /// Request sent that allows agent to get observed intrinsics details.
    /// </summary>
    public class AgentGetObservedIntrinsicsRequest : BaseRequest
    {
        public AgentGetObservedIntrinsicsRequest()
        {
            this.body = new Body();
        }

        [JsonProperty(Order = 1)]
        public JSapiVersion apiVersion { get; set; }

        [JsonProperty(Order = 2)]
        public readonly JStype type = JStype.request;

        [JsonProperty(Order = 3)]
        public Body body { get; set; }

        public class Body
        {
            public Body()
            {
                this.agents = new List<Agent>();
            }
            public readonly JSmethod method = JSmethod.observedIntrinsicsRequest;
            public List<Agent> agents { get; set; }
        }

        public class Agent
        {
            public string agentId { get; set; }
        }

        /// <summary>
        /// Encodes this object to JSON string.
        /// </summary>
        /// <returns>json encoded string.</returns>
        public override String Encode()
        {
            //Sort list of agents
            body.agents = body.agents.OrderBy(o => o.agentId).ToList();
            return JsonConvert.SerializeObject(this, Formatting.None);
        }

    }
}