﻿//////////////////////////////////////////////////////////////////////////////
// EncoderDecoderUnitTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////


using EncoderDecoder;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class JEncoderTest
    {
        [TestMethod]
        public void FormatString()
        {
            String json = @"{""apiVersion"":""1.0"",""type"":""request"",
""body"":{""method"":""isTyping"",""guid"":123456,""messageType"":""normal"",""isTyping"":true}}";
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""isTyping"",""guid"":123456,""messageType"":""normal"",""isTyping"":true}}";

            JEncoder e = new JEncoder();
            String formatted = e.FormatJSON(json);

            Assert.AreEqual(formatted, jsonExpected);

        }

        [TestMethod]
        public void ConvertTime()
        {
            DateTime time = new DateTime(2015, 06, 28, 23, 52, 55);
            long toEpoch = JEncoder.ConvertToUnixTime(time);

        }

    }
}

