﻿//////////////////////////////////////////////////////////////////////////////
// GetDestinationsRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class GetDestinationsRequestTest
    {
        [TestMethod]
        public void GetDestinationsRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""getDestinations"",""guid"":62445}}";

            GetDestinationsRequest temp = new GetDestinationsRequest();
            temp.apiVersion = GetDestinationsRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 62445;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);

            Assert.AreEqual(response, jsonExpected);

        }
    }
}
