﻿//////////////////////////////////////////////////////////////////////////////
// ResultCode.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CustomDesktop
{
    public class ResultCode
    {
        public enum ResultCodeType
        {
            GENERAL_ERROR,
            CCT_NO_AGENT_FOUND,
            CCT_AGENT_ALREADY_LOGGED_IN,
            CCT_MULTIPLE_AGENTS_REGISTERED,
            CCT_NOT_REACHABLE,
            CCT_CREDENTIALS_ERROR,
            CCT_EXCEPTION,
            CCT_SUCCESS,
            SMF_SUCCESS,
            SMF_EXCEPTION,
            SMF_FAILURE,
            SMF_WEB_ERROR,
            SMF_AGENT_ALREADY_LOGGED_IN,
            SMF_NOT_REACHABLE,
            SMF_INVALID_CONVERSATION_ID,
            MM_SUCCESS,
            MM_FAILURE,
            MM_COULD_NOT_OPEN_WEBSOCKET,
            MM_LOGIN_ERROR
        }

        public ResultCodeType ResultType;

        public String Message { get; set; }

        public ResultCode()
        {
            Message = string.Empty;
            ResultType = ResultCodeType.GENERAL_ERROR;
        }
    }
}
