﻿using Newtonsoft.Json;
using System;

namespace EncoderDecoder.Requests
{
    /// <summary>
    /// Request sent that allows agent to set closed reason code at end of chat.
    /// </summary>
    public class AgentSetClosedReasonRequest : BaseRequest
    {
        public AgentSetClosedReasonRequest()
        {
            this.body = new Body();
        }

        [JsonProperty(Order = 1)]
        public JSapiVersion apiVersion { get; set; }

        [JsonProperty(Order = 2)]
        public readonly JStype type = JStype.request;

        [JsonProperty(Order = 3)]
        public Body body { get; set; }

        public class Body
        {
            public readonly JSmethod method = JSmethod.agentSetClosedReason;
            public long guid { get; set; }

            [JsonProperty(NullValueHandling = NullValueHandling.Ignore)]
            public long? closedReasonCode { get; set; }

            [JsonProperty(NullValueHandling = NullValueHandling.Ignore)]
            public string agentNote { get; set; }

            public bool sendTranscript { get; set; }
        }

        /// <summary>
        /// Encodes this object to JSON string.
        /// </summary>
        /// <returns>json encoded string.</returns>
        public override String Encode()
        {
            return JsonConvert.SerializeObject(this, Formatting.None);
        }

    }
}