﻿//////////////////////////////////////////////////////////////////////////////
// CustomerDisconnectNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class CustomerDisconnectNotificationTest
    {
        [TestMethod]
        public void CustomerDisconnectNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                ""apiVersion"" : ""1.0"",
                                ""type"" : ""notification"",
                                ""body"" :
                                {
                                    ""method"" : ""customerDisconnect"",
                                    ""guid"" : 332233,
                                    ""timestamp"" : 1427294421123,
                                    ""closedReasonCodes"" : {
                                        ""defaultReasonCode"": 2,
                                            ""codes"": [
                                                {
                                                    ""id"" : 1,
                                                    ""closedReason"" : ""problem solved""
                                                },
                                                {
                                                    ""id"" : 2,
                                                    ""closedReason"" : ""could not fix""
                                                }
                                        ]
                                    }
                                }
                            }";


            JDecoder jdecode = new JDecoder();
            CustomerDisconnectNotification note = (CustomerDisconnectNotification)jdecode.Decode(jsonResponse);
            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "customerDisconnect");
            Assert.AreEqual(note.body.guid, 332233);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].id, 1);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].closedReason, "problem solved");
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].id, 2);
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].closedReason, "could not fix");
        }

        [TestMethod]
        public void CustomerDisconnectNotificationTest_SimpleDecode2()
        {
            String jsonResponse = @"{
                                ""apiVersion"" : ""1.1"",
                                ""type"" : ""notification"",
                                ""body"" :
                                {
                                    ""method"" : ""customerDisconnect"",
                                    ""guid"" : 333333,
                                    ""timestamp"" : 1427294421123,
                                    ""closedReasonCodes"" : {
                                        ""defaultReasonCode"": 2,
                                            ""codes"": [
                                                {
                                                    ""id"" : 111,
                                                    ""closedReason"" : ""problem2solved12""
                                                },
                                                {
                                                    ""id"" : 222,
                                                    ""closedReason"" : ""could2not2fix12""
                                                }
                                        ]
                                    }
                                }
                            }";


            JDecoder jdecode = new JDecoder();
            CustomerDisconnectNotification note = (CustomerDisconnectNotification)jdecode.Decode(jsonResponse);
            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.1");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "customerDisconnect");
            Assert.AreEqual(note.body.guid, 333333);
            Assert.AreEqual(note.body.closedReasonCodes.defaultReasonCode, 2);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].id, 111);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].closedReason, "problem2solved12");
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].id, 222);
            Assert.AreEqual(note.body.closedReasonCodes.codes[1].closedReason, "could2not2fix12");
        }

        [TestMethod]
        public void CustomerDisconnectNotificationTest_SimpleDecode3()
        {
            String jsonResponse = @"{
                                ""apiVersion"" : ""1.1"",
                                ""type"" : ""notification"",
                                ""body"" :
                                {
                                    ""method"" : ""customerDisconnect"",
                                    ""guid"" : 333333,
                                    ""timestamp"" : 1427294421123,
                                    ""closedReasonCodes"" : {
                                            ""codes"": [
                                                {
                                                    ""id"" : 1,
                                                    ""closedReason"" : ""problem2solved""
                                                }
                                        ]
                                    }
                                }
                            }";


            JDecoder jdecode = new JDecoder();
            CustomerDisconnectNotification note = (CustomerDisconnectNotification)jdecode.Decode(jsonResponse);
            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.1");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "customerDisconnect");
            Assert.AreEqual(note.body.guid, 333333);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].id, 1);
            Assert.AreEqual(note.body.closedReasonCodes.codes[0].closedReason, "problem2solved");
        }
    }
}
